/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.URLs;

import com.shapesecurity.salvation2.Constants;
import com.shapesecurity.salvation2.URLs.URLWithScheme;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;

public class URI
extends URLWithScheme {
    public URI(@Nonnull String scheme, @Nonnull String host, int port, @Nonnull String path) {
        super(scheme, host, port, path);
    }

    @Nonnull
    public static Optional<URI> parseURI(@Nonnull String uri) {
        Matcher matcher = Constants.hostSourcePattern.matcher(uri);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String scheme = matcher.group("scheme");
        if (scheme == null) {
            return Optional.empty();
        }
        scheme = scheme.substring(0, scheme.length() - 3);
        String portString = matcher.group("port");
        int port = portString == null ? URI.defaultPortForProtocol(scheme.toLowerCase(Locale.ENGLISH)) : (portString.equals(":*") ? -200 : Integer.parseInt(portString.substring(1)));
        String host = matcher.group("host");
        String path = matcher.group("path");
        if (path == null) {
            path = "";
        }
        return Optional.of(new URI(scheme, host, port, path));
    }

    public static int defaultPortForProtocol(@Nonnull String scheme) {
        switch (scheme) {
            case "ftp": {
                return 21;
            }
            case "file": {
                return -1;
            }
            case "gopher": {
                return 70;
            }
            case "http": {
                return 80;
            }
            case "https": {
                return 443;
            }
            case "ws": {
                return 80;
            }
            case "wss": {
                return 443;
            }
        }
        return -1;
    }
}

