/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.archive.url.AggressiveIACanonicalizerRules;
import org.archive.url.BasicURLCanonicalizer;
import org.archive.url.HandyURL;
import org.archive.url.IAURLCanonicalizer;
import org.archive.url.URLParser;
import org.archive.url.URLRegexTransformer;
import org.archive.util.ArchiveUtils;

public class UrlSurtRangeComputer {
    public static final BasicURLCanonicalizer basicCanon = new BasicURLCanonicalizer();
    public static final IAURLCanonicalizer iaNoSlashCanon = new IAURLCanonicalizer(new AggressiveIACanonicalizerRules(true));
    public static final IAURLCanonicalizer iaKeepSlashCanon = new IAURLCanonicalizer(new AggressiveIACanonicalizerRules(false));
    public final boolean returnSurt;

    public UrlSurtRangeComputer(boolean returnSurt) {
        this.returnSurt = returnSurt;
    }

    public String[] determineRange(String url, MatchType match, String from, String to) throws UnsupportedEncodingException, URISyntaxException {
        String startKey = null;
        String endKey = null;
        if (url.indexOf(46) == 0) {
            url = url.substring(1);
        }
        HandyURL hURL = URLParser.parse(url);
        basicCanon.canonicalize(hURL);
        if (match == MatchType.prefix) {
            iaKeepSlashCanon.canonicalize(hURL);
        } else {
            iaNoSlashCanon.canonicalize(hURL);
        }
        String host = hURL.getHost();
        if (hURL.getPath().isEmpty()) {
            hURL.setPath("/");
        }
        if (match == MatchType.prefix && hURL.getPath().equals("/")) {
            match = MatchType.host;
        }
        switch (match.ordinal()) {
            case 0: {
                startKey = hURL.getURLString(this.returnSurt, false, false);
                if (!to.isEmpty()) {
                    to = ArchiveUtils.dateToTimestamp(to);
                    endKey = startKey + " " + to;
                } else {
                    endKey = startKey + "!";
                }
                if (from.isEmpty()) break;
                from = ArchiveUtils.dateToTimestamp(from);
                startKey = startKey + " " + from;
                break;
            }
            case 1: {
                startKey = hURL.getURLString(this.returnSurt, false, false);
                endKey = UrlSurtRangeComputer.incLastChar(startKey);
                break;
            }
            case 2: {
                if (this.returnSurt) {
                    String hostSURT = URLRegexTransformer.hostToSURT(host);
                    startKey = hostSURT + ")/";
                    endKey = hostSURT + "*";
                    break;
                }
                startKey = host + "/";
                endKey = host + "0";
                break;
            }
            case 3: {
                if (this.returnSurt) {
                    String hostSURT;
                    startKey = hostSURT = URLRegexTransformer.hostToSURT(host);
                    startKey = hostSURT.contains(",") ? startKey + ")/" : startKey + ",";
                    endKey = hostSURT + "-";
                    break;
                }
                return null;
            }
        }
        return new String[]{startKey, endKey, host};
    }

    public static String incLastChar(String input) {
        StringBuilder sb = new StringBuilder(input);
        sb.setCharAt(sb.length() - 1, (char)(sb.charAt(sb.length() - 1) + '\u0001'));
        return sb.toString();
    }

    public static enum MatchType {
        exact,
        prefix,
        host,
        domain;

    }
}

