/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nutch.indexer.IndexWriterParams;
import org.apache.nutch.indexer.MappingReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IndexWriterConfig {
    private String id;
    private String clazz;
    private IndexWriterParams params;
    private Map<MappingReader.Actions, Map<String, List<String>>> mapping;

    private IndexWriterConfig(String id, String clazz, Map<String, String> params, Map<MappingReader.Actions, Map<String, List<String>>> mapping) {
        this.id = id;
        this.clazz = clazz;
        this.params = new IndexWriterParams((Map<? extends String, ? extends String>)params);
        this.mapping = mapping;
    }

    static IndexWriterConfig getInstanceFromElement(Element rootElement) {
        String id = rootElement.getAttribute("id");
        String clazz = rootElement.getAttribute("class");
        NodeList parametersList = rootElement.getElementsByTagName("param");
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parametersList.getLength(); ++i) {
            Element parameterNode = (Element)parametersList.item(i);
            parameters.put(parameterNode.getAttribute("name"), parameterNode.getAttribute("value"));
        }
        return new IndexWriterConfig(id, clazz, parameters, MappingReader.parseMapping((Element)rootElement.getElementsByTagName("mapping").item(0)));
    }

    String getId() {
        return this.id;
    }

    String getClazz() {
        return this.clazz;
    }

    IndexWriterParams getParams() {
        return this.params;
    }

    Map<MappingReader.Actions, Map<String, List<String>>> getMapping() {
        return this.mapping;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID: ");
        sb.append(this.id);
        sb.append("\n");
        sb.append("Class: ");
        sb.append(this.clazz);
        sb.append("\n");
        sb.append("Params {\n");
        for (Map.Entry entry : this.params.entrySet()) {
            sb.append("\t");
            sb.append((String)entry.getKey());
            sb.append(":\t");
            sb.append((String)entry.getValue());
            sb.append("\n");
        }
        sb.append("}\n");
        sb.append("Mapping {\n");
        for (Map.Entry<Object, Object> entry : this.mapping.entrySet()) {
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(" {\n");
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                sb.append("\t\t");
                sb.append((String)entry1.getKey());
                sb.append(":\t");
                sb.append(String.join((CharSequence)",", (Iterable)entry1.getValue()));
                sb.append("\n");
            }
            sb.append("\t}\n");
        }
        sb.append("}\n");
        return sb.toString();
    }
}

