/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class Outlink
implements Writable {
    private String toUrl;
    private String anchor;
    private MapWritable md;

    public Outlink() {
    }

    public Outlink(String toUrl, String anchor) throws MalformedURLException {
        this.toUrl = toUrl;
        if (anchor == null) {
            anchor = "";
        }
        this.anchor = anchor;
        this.md = null;
    }

    public void readFields(DataInput in) throws IOException {
        this.toUrl = Text.readString((DataInput)in);
        this.anchor = Text.readString((DataInput)in);
        boolean hasMD = in.readBoolean();
        if (hasMD) {
            this.md = new MapWritable();
            this.md.readFields(in);
        } else {
            this.md = null;
        }
    }

    public static void skip(DataInput in) throws IOException {
        Text.skip((DataInput)in);
        Text.skip((DataInput)in);
        boolean hasMD = in.readBoolean();
        if (hasMD) {
            MapWritable metadata = new MapWritable();
            metadata.readFields(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.toUrl);
        Text.writeString((DataOutput)out, (String)this.anchor);
        if (this.md != null && this.md.size() > 0) {
            out.writeBoolean(true);
            this.md.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public static Outlink read(DataInput in) throws IOException {
        Outlink outlink = new Outlink();
        outlink.readFields(in);
        return outlink;
    }

    public String getToUrl() {
        return this.toUrl;
    }

    public void setUrl(String toUrl) {
        this.toUrl = toUrl;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public MapWritable getMetadata() {
        return this.md;
    }

    public void setMetadata(MapWritable md) {
        this.md = md;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Outlink)) {
            return false;
        }
        Outlink other = (Outlink)o;
        return this.toUrl.equals(other.toUrl) && this.anchor.equals(other.anchor);
    }

    public String toString() {
        StringBuffer repr = new StringBuffer("toUrl: ");
        repr.append(this.toUrl);
        repr.append(" anchor: ");
        repr.append(this.anchor);
        if (this.md != null && !this.md.isEmpty()) {
            for (Map.Entry e : this.md.entrySet()) {
                repr.append(" ");
                repr.append(e.getKey());
                repr.append(": ");
                repr.append(e.getValue());
            }
        }
        return repr.toString();
    }

    public int hashCode() {
        return this.toUrl.hashCode() ^ this.anchor.hashCode();
    }
}

