/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class LongCache {
    private static final int[] EMPTY_INTS = new int[0];
    private static final long[] EMPTY_LONGS = new long[0];
    public long[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public LongCache() {
        this.threshold = 0;
        this.keyTable = EMPTY_LONGS;
        this.valueTable = EMPTY_INTS;
    }

    private LongCache(int initialCapacity) {
        this.threshold = initialCapacity * 2 / 3;
        this.keyTable = new long[initialCapacity];
        this.valueTable = new int[initialCapacity];
    }

    public void clear() {
        this.elementSize = 0;
        this.threshold = 0;
        this.keyTable = EMPTY_LONGS;
        this.valueTable = EMPTY_INTS;
    }

    public boolean containsKey(long key) {
        int length = this.keyTable.length;
        if (length == 0) {
            return false;
        }
        int index = this.hash(key);
        while (this.keyTable[index] != 0L || this.keyTable[index] == 0L && this.valueTable[index] != 0) {
            if (this.keyTable[index] == key) {
                return true;
            }
            if (++index != length) continue;
            index = 0;
        }
        return false;
    }

    private int hash(long key) {
        return ((int)key & Integer.MAX_VALUE) % this.keyTable.length;
    }

    private int put(long key, int value) {
        int length = this.keyTable.length;
        int index = this.hash(key);
        while (this.keyTable[index] != 0L || this.keyTable[index] == 0L && this.valueTable[index] != 0) {
            if (this.keyTable[index] == key) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        return value;
    }

    public int putIfAbsent(long key, int value) {
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        int index = this.hash(key);
        int length = this.keyTable.length;
        while (this.keyTable[index] != 0L || this.keyTable[index] == 0L && this.valueTable[index] != 0) {
            if (this.keyTable[index] == key) {
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        return -value;
    }

    private void rehash() {
        LongCache newHashtable = new LongCache(Math.max(13, this.keyTable.length * 2));
        int i = this.keyTable.length;
        while (--i >= 0) {
            long key = this.keyTable[i];
            int value = this.valueTable[i];
            if (key == 0L && (key != 0L || value == 0)) continue;
            newHashtable.put(key, value);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int max = this.size();
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int i = 0;
        while (i < max) {
            if (this.keyTable[i] != 0L || this.keyTable[i] == 0L && this.valueTable[i] != 0) {
                buf.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

