/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.web.AbstractWidgetAction;
import org.wicketstuff.dashboard.web.DashboardEvent;
import org.wicketstuff.dashboard.web.WidgetPanel;
import org.wicketstuff.dashboard.web.WidgetView;
import org.wicketstuff.dashboard.web.util.AjaxConfirmLink;

public class DefaultWidgetActions {

    public static class Settings
    extends AbstractWidgetAction {
        private static final long serialVersionUID = 1L;

        public Settings(Widget widget) {
            super(widget);
            this.tooltip = new ResourceModel("settings");
            this.setCssClass("icon edit");
        }

        @Override
        public AbstractLink getLink(String id) {
            return new AjaxLink<Void>(id){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    if (widget.hasSettings()) {
                        WidgetPanel widgetPanel = (WidgetPanel)((Object)this.findParent(WidgetPanel.class));
                        Panel settingsPanel = widgetPanel.getSettingsPanel();
                        settingsPanel.setVisible(true);
                        target.add(new Component[]{settingsPanel});
                    }
                }
            };
        }
    }

    public static class Delete
    extends AbstractWidgetAction {
        private static final long serialVersionUID = 1L;

        public Delete(Widget widget) {
            super(widget);
            this.tooltip = new ResourceModel("delete");
            this.setCssClass("icon delete");
        }

        @Override
        public AbstractLink getLink(String id) {
            AjaxConfirmLink<Void> deleteLink = new AjaxConfirmLink<Void>(id){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new DashboardEvent(target, DashboardEvent.EventType.WIDGET_REMOVED, widget));
                }

                @Override
                protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                    super.updateAjaxAttributes(attributes);
                    attributes.getAjaxCallListeners().add(new AjaxCallListener(){
                        private static final long serialVersionUID = 1L;

                        public CharSequence getSuccessHandler(Component component) {
                            return "$('#widget-" + widget.getId() + "').remove();";
                        }
                    });
                }

                protected void onInitialize() {
                    super.onInitialize();
                    StringResourceModel resourceModel = new StringResourceModel("deleteAsk", (Component)this, (IModel)Model.of((Serializable)((Object)widget.getTitle())));
                    this.setConfirmMessage((String)resourceModel.getObject());
                }
            };
            return deleteLink;
        }
    }

    public static class Refresh
    extends AbstractWidgetAction {
        private static final long serialVersionUID = 1L;

        public Refresh(Widget widget) {
            super(widget);
            this.tooltip = new ResourceModel("refresh");
            this.setCssClass("icon refresh");
        }

        @Override
        public AbstractLink getLink(String id) {
            return new AjaxLink<Void>(id){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    WidgetView widgetView = ((WidgetPanel)((Object)this.findParent(WidgetPanel.class))).getWidgetView();
                    target.add(new Component[]{widgetView});
                }
            };
        }
    }
}

