/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.SubBlockHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacInfoHeader
extends SubBlockHeader {
    private static final Logger logger = LoggerFactory.getLogger(MacInfoHeader.class);
    public static final short MacInfoHeaderSize = 8;
    private int fileType;
    private int fileCreator;

    public MacInfoHeader(SubBlockHeader sb, byte[] macHeader) {
        super(sb);
        int pos = 0;
        this.fileType = Raw.readIntLittleEndian(macHeader, pos);
        this.fileCreator = Raw.readIntLittleEndian(macHeader, pos += 4);
    }

    public int getFileCreator() {
        return this.fileCreator;
    }

    public void setFileCreator(int fileCreator) {
        this.fileCreator = fileCreator;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    @Override
    public void print() {
        super.print();
        if (logger.isInfoEnabled()) {
            logger.info("filetype: {}", (Object)this.fileType);
            logger.info("creator: {}", (Object)this.fileCreator);
        }
    }
}

