/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.security.AuthenticationConfig;
import com.hazelcast.internal.util.StringUtil;
import java.util.Objects;
import java.util.Properties;

public abstract class AbstractClusterLoginConfig<T extends AbstractClusterLoginConfig<T>>
implements AuthenticationConfig {
    private Boolean skipIdentity;
    private Boolean skipEndpoint;
    private Boolean skipRole;

    public Boolean getSkipIdentity() {
        return this.skipIdentity;
    }

    public T setSkipIdentity(Boolean skipIdentity) {
        this.skipIdentity = skipIdentity;
        return this.self();
    }

    public Boolean getSkipEndpoint() {
        return this.skipEndpoint;
    }

    public T setSkipEndpoint(Boolean skipEndpoint) {
        this.skipEndpoint = skipEndpoint;
        return this.self();
    }

    public Boolean getSkipRole() {
        return this.skipRole;
    }

    public T setSkipRole(Boolean skipRole) {
        this.skipRole = skipRole;
        return this.self();
    }

    protected Properties initLoginModuleProperties() {
        Properties props = new Properties();
        this.setIfConfigured(props, "skipIdentity", this.skipIdentity);
        this.setIfConfigured(props, "skipEndpoint", this.skipEndpoint);
        this.setIfConfigured(props, "skipRole", this.skipRole);
        return props;
    }

    protected void setIfConfigured(Properties props, String propertyName, String value) {
        if (!StringUtil.isNullOrEmpty(value)) {
            props.setProperty(propertyName, value);
        }
    }

    protected void setIfConfigured(Properties props, String propertyName, Object value) {
        if (value != null) {
            props.setProperty(propertyName, value.toString());
        }
    }

    protected void setIfConfigured(Properties props, String propertyName, Enum<?> value) {
        if (value != null) {
            props.setProperty(propertyName, value.toString());
        }
    }

    protected abstract T self();

    public int hashCode() {
        return Objects.hash(this.skipEndpoint, this.skipIdentity, this.skipRole);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractClusterLoginConfig other = (AbstractClusterLoginConfig)obj;
        return Objects.equals(this.skipEndpoint, other.skipEndpoint) && Objects.equals(this.skipIdentity, other.skipIdentity) && Objects.equals(this.skipRole, other.skipRole);
    }
}

