/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.jet.impl.util.Util;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class KeyedWindowResult<K, R>
extends WindowResult<R>
implements Map.Entry<K, R> {
    @Nonnull
    private final K key;

    public KeyedWindowResult(long start, long end, @Nonnull K key, @Nonnull R result, boolean isEarly) {
        super(start, end, result, isEarly);
        this.key = key;
    }

    public KeyedWindowResult(long start, long end, @Nonnull K key, @Nonnull R result) {
        this(start, end, key, result, false);
    }

    @Nonnull
    public K key() {
        return this.key;
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public R getValue() {
        return this.result();
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeyedWindowResult that = (KeyedWindowResult)obj;
        return this.start() == that.start() && this.end() == that.end() && this.isEarly() == that.isEarly() && Objects.equals(this.result(), that.result()) && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode() ^ this.getValue().hashCode();
    }

    @Override
    public String toString() {
        return String.format("KeyedWindowResult{start=%s, end=%s, key='%s', value='%s', isEarly=%s}", Util.toLocalTime(this.start()), Util.toLocalTime(this.end()), this.key, this.result(), this.isEarly());
    }
}

