/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv;

import org.apache.directory.api.i18n.I18n;

public enum VirtualListViewResultCode {
    SUCCESS(0, "Success"),
    OPERATIONSERROR(1, "Server internal failure"),
    TIMELIMITEXCEEDED(3, "Timelimit exceeded"),
    ADMINLIMITEXCEEDED(11, "Admin limit exceeded"),
    INAPPROPRIATEMATCHING(18, "Unrecognized or inappropriate matching rule"),
    INSUFFICIENTACCESSRIGHTS(50, "Insufficient access rights"),
    UNWILLINGTOPERFORM(53, "Unwilling to perform"),
    SORTCONTROLMISSING(60, "Sort control missing"),
    OFFSETRANGEERROR(61, "Offset range error"),
    OPENLDAP_SSSMISSING(76, "SSS missing"),
    OPENLDAP_RANGEERRROR(77, "Range error"),
    OTHER(80, "Other");

    private int value;
    private String desc;

    private VirtualListViewResultCode(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static VirtualListViewResultCode get(int code) {
        switch (code) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OPERATIONSERROR;
            }
            case 3: {
                return TIMELIMITEXCEEDED;
            }
            case 11: {
                return ADMINLIMITEXCEEDED;
            }
            case 18: {
                return INAPPROPRIATEMATCHING;
            }
            case 50: {
                return INSUFFICIENTACCESSRIGHTS;
            }
            case 53: {
                return UNWILLINGTOPERFORM;
            }
            case 60: {
                return SORTCONTROLMISSING;
            }
            case 61: {
                return OFFSETRANGEERROR;
            }
            case 76: {
                return OPENLDAP_SSSMISSING;
            }
            case 77: {
                return OPENLDAP_RANGEERRROR;
            }
            case 80: {
                return OTHER;
            }
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_9102_UNKNOWN_VLV_RESPONSE, code));
    }
}

