/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.extractor.impl.ResourceMap;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarLdifSchemaLoader
extends AbstractSchemaLoader {
    private static final String SEPARATOR_PATTERN = "[/\\Q\\\\E]";
    private static final String LDIF_EXT = "ldif";
    private static final Logger LOG = LoggerFactory.getLogger(JarLdifSchemaLoader.class);
    private static final Map<String, Boolean> RESOURCE_MAP = ResourceMap.getResources(Pattern.compile("schema[/\\Q\\\\E]ou=schema.*"));
    private final boolean allowDuplicateResources;

    public JarLdifSchemaLoader() throws IOException, LdapException {
        this.allowDuplicateResources = false;
        this.initializeSchemas();
    }

    public JarLdifSchemaLoader(boolean allowDuplicateResources) throws IOException, LdapException {
        this.allowDuplicateResources = allowDuplicateResources;
        this.initializeSchemas();
    }

    public boolean isAllowDuplicateResources() {
        return this.allowDuplicateResources;
    }

    private URL getResource(String resource, String msg) throws IOException {
        if (RESOURCE_MAP.get(resource).booleanValue()) {
            if (this.allowDuplicateResources) {
                return DefaultSchemaLdifExtractor.getAnyResource(resource, msg);
            }
            return DefaultSchemaLdifExtractor.getUniqueResource(resource, msg);
        }
        return new File(resource).toURI().toURL();
    }

    private void initializeSchemas() throws IOException, LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_16006_INITIALIZING_SCHEMA, new Object[0]));
        }
        Pattern pat = Pattern.compile("schema[/\\Q\\\\E]ou=schema[/\\Q\\\\E]cn=[a-z0-9-_]*\\.ldif");
        for (String file : RESOURCE_MAP.keySet()) {
            if (!pat.matcher(file).matches()) continue;
            URL resource = this.getResource(file, "schema LDIF file");
            try {
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    Schema schema = this.getSchema(entry.getEntry());
                    this.schemaMap.put(schema.getSchemaName(), schema);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(I18n.msg(I18n.MSG_16007_SCHEMA_INITIALIZED, schema));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (LdapException le) {
                LOG.error(I18n.err(I18n.ERR_16009_LDIF_LOAD_FAIL, file), (Throwable)le);
                throw le;
            }
        }
    }

    private String getSchemaDirectoryString(Schema schema) {
        return "schema/ou=schema/cn=" + Strings.lowerCase(schema.getSchemaName()) + "/";
    }

    @Override
    public List<Entry> loadComparators(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> comparatorList = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=comparators" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "comparator LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    comparatorList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return comparatorList;
    }

    @Override
    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxCheckerList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=syntaxcheckers" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "syntaxChecker LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    syntaxCheckerList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return syntaxCheckerList;
    }

    @Override
    public List<Entry> loadNormalizers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> normalizerList = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=normalizers" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "normalizer LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    normalizerList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return normalizerList;
    }

    @Override
    public List<Entry> loadMatchingRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=matchingrules" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "matchingRules LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    matchingRuleList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return matchingRuleList;
    }

    @Override
    public List<Entry> loadSyntaxes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=syntaxes" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "syntax LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    syntaxList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return syntaxList;
    }

    @Override
    public List<Entry> loadAttributeTypes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        if (schemas == null) {
            return attributeTypeList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=attributetypes" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "attributeType LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    attributeTypeList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return attributeTypeList;
    }

    @Override
    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleUseList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleUseList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=matchingruleuse" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "matchingRuleUse LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    matchingRuleUseList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return matchingRuleUseList;
    }

    @Override
    public List<Entry> loadNameForms(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> nameFormList = new ArrayList<Entry>();
        if (schemas == null) {
            return nameFormList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=nameforms" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "nameForm LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    nameFormList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return nameFormList;
    }

    @Override
    public List<Entry> loadDitContentRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditContentRulesList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditContentRulesList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=ditcontentrules" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "ditContentRule LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    ditContentRulesList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return ditContentRulesList;
    }

    @Override
    public List<Entry> loadDitStructureRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditStructureRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditStructureRuleList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=ditstructurerules" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "ditStructureRule LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    ditStructureRuleList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return ditStructureRuleList;
    }

    @Override
    public List<Entry> loadObjectClasses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassList;
        }
        for (Schema schema : schemas) {
            String start = this.getSchemaDirectoryString(schema) + "ou=objectclasses" + "/m-oid=";
            String end = ".ldif";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                if (!resourcePath.startsWith(start) || !resourcePath.endsWith(end)) continue;
                URL resource = this.getResource(resourcePath, "objectClass LDIF file");
                InputStream in = resource.openStream();
                try (LdifReader reader = new LdifReader(in);){
                    LdifEntry entry = reader.next();
                    objectClassList.add(entry.getEntry());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return objectClassList;
    }
}

