/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.parser;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.Format;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;

public class PreflightParser
extends PDFParser {
    public static final Charset encoding = Charset.forName("ISO-8859-1");
    protected DataSource dataSource;
    protected ValidationResult validationResult;
    protected PreflightDocument preflightDocument;
    protected PreflightContext ctx;

    public PreflightParser(File file) throws IOException {
        super(new RandomAccessBufferedFileInputStream(file));
        this.setLenient(false);
        this.dataSource = new FileDataSource(file);
    }

    public PreflightParser(File file, ScratchFile scratch) throws IOException {
        super((RandomAccessRead)new RandomAccessBufferedFileInputStream(file), scratch);
        this.setLenient(false);
        this.dataSource = new FileDataSource(file);
    }

    public PreflightParser(String filename) throws IOException {
        this(new File(filename));
    }

    public PreflightParser(String filename, ScratchFile scratch) throws IOException {
        this(new File(filename), scratch);
    }

    public PreflightParser(DataSource dataSource) throws IOException {
        super(new RandomAccessBufferedFileInputStream(dataSource.getInputStream()));
        this.setLenient(false);
        this.dataSource = dataSource;
    }

    public PreflightParser(DataSource dataSource, ScratchFile scratch) throws IOException {
        super((RandomAccessRead)new RandomAccessBufferedFileInputStream(dataSource.getInputStream()), scratch);
        this.setLenient(false);
        this.dataSource = dataSource;
    }

    protected static ValidationResult createUnknownErrorResult() {
        ValidationResult.ValidationError error = new ValidationResult.ValidationError("-1");
        return new ValidationResult(error);
    }

    protected void addValidationError(ValidationResult.ValidationError error) {
        if (this.validationResult == null) {
            this.validationResult = new ValidationResult(error.isWarning());
        }
        this.validationResult.addError(error);
    }

    protected void addValidationErrors(List<ValidationResult.ValidationError> errors) {
        for (ValidationResult.ValidationError error : errors) {
            this.addValidationError(error);
        }
    }

    @Override
    public void parse() throws IOException {
        this.parse(Format.PDF_A1B);
    }

    public void parse(Format format) throws IOException {
        this.parse(format, null);
    }

    public void parse(Format format, PreflightConfiguration config) throws IOException {
        this.checkPdfHeader();
        try {
            super.parse();
        }
        catch (IOException e) {
            this.addValidationError(new ValidationResult.ValidationError("1.0", e.getMessage()));
            throw new SyntaxValidationException(e, this.validationResult);
        }
        finally {
            IOUtils.closeQuietly(this.source);
        }
        Format formatToUse = format == null ? Format.PDF_A1B : format;
        this.createPdfADocument(formatToUse, config);
        this.createContext();
    }

    protected void createPdfADocument(Format format, PreflightConfiguration config) throws IOException {
        COSDocument cosDocument = this.getDocument();
        this.preflightDocument = new PreflightDocument(cosDocument, format, config);
    }

    protected void createContext() {
        this.ctx = new PreflightContext(this.dataSource);
        this.ctx.setDocument(this.preflightDocument);
        this.preflightDocument.setContext(this.ctx);
        this.ctx.setXrefTrailerResolver(this.xrefTrailerResolver);
        this.ctx.setFileLen(this.fileLen);
    }

    @Override
    public PDDocument getPDDocument() throws IOException {
        this.preflightDocument.setResult(this.validationResult);
        return this.preflightDocument;
    }

    public PreflightDocument getPreflightDocument() throws IOException {
        return (PreflightDocument)this.getPDDocument();
    }

    @Override
    protected void initialParse() throws IOException {
        super.initialParse();
        Map<COSObjectKey, Long> xrefTable = this.document.getXrefTable();
        for (Map.Entry<COSObjectKey, Long> entry : xrefTable.entrySet()) {
            COSObject co = this.document.getObjectFromPool(entry.getKey());
            if (co.getObject() != null) continue;
            this.parseObjectDynamically(co, true);
        }
    }

    protected void checkPdfHeader() {
        try {
            String secondLine;
            this.source.seek(0L);
            String firstLine = this.readLine();
            if (firstLine == null || !firstLine.matches("%PDF-1\\.[1-9]")) {
                this.addValidationError(new ValidationResult.ValidationError("1.1", "First line must match %PDF-1.\\d"));
            }
            if ((secondLine = this.readLine()) != null) {
                byte[] secondLineAsBytes = secondLine.getBytes(encoding.name());
                if (secondLineAsBytes.length >= 5) {
                    if (secondLineAsBytes[0] != 37) {
                        this.addValidationError(new ValidationResult.ValidationError("1.1", "Second line must begin with '%' followed by at least 4 bytes greater than 127"));
                    } else {
                        for (int i = 1; i < 5; ++i) {
                            byte b = secondLineAsBytes[i];
                            if ((b & 0xFF) >= 128) continue;
                            this.addValidationError(new ValidationResult.ValidationError("1.1", "Second line must begin with '%' followed by at least 4 bytes greater than 127"));
                            break;
                        }
                    }
                } else {
                    this.addValidationError(new ValidationResult.ValidationError("1.1", "Second line must begin with '%' followed by at least 4 bytes greater than 127"));
                }
            }
            this.source.seek(0L);
        }
        catch (IOException e) {
            this.addValidationError(new ValidationResult.ValidationError("1.1", "Unable to read the PDF file : " + e.getMessage(), e));
        }
    }

    @Override
    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        if (this.source.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.equals("xref")) {
            this.addValidationError(new ValidationResult.ValidationError("1.3", "xref must be followed by a EOL character"));
            return false;
        }
        if (!this.nextIsEOL()) {
            this.addValidationError(new ValidationResult.ValidationError("1.3", "xref must be followed by EOL"));
        }
        this.xrefTrailerResolver.nextXrefObj(startByteOffset, XrefTrailerResolver.XRefType.TABLE);
        Pattern pattern = Pattern.compile("(\\d+)\\s(\\d+)(\\s*)");
        do {
            int count;
            long currObjID;
            long offset = this.source.getPosition();
            String line = this.readLine();
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                currObjID = Long.parseLong(matcher.group(1));
                count = Integer.parseInt(matcher.group(2));
            } else {
                this.addValidationError(new ValidationResult.ValidationError("1.3", "Cross reference subsection header is invalid: '" + line + "' at position " + this.source.getPosition()));
                this.source.seek(offset);
                currObjID = this.readObjectNumber();
                count = this.readInt();
            }
            this.skipSpaces();
            for (int i = 0; i < count && !this.source.isEOF() && !this.isEndOfName((char)this.source.peek()); ++i) {
                if (this.source.peek() == 116) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "Expected xref line but 't' found"));
                    break;
                }
                String currentLine = this.readLine();
                String[] splitString = currentLine.split(" ");
                if (splitString.length < 3) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        long currOffset = Long.parseLong(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        this.addValidationError(new ValidationResult.ValidationError("1.3", "offset or genid can't be read as number " + e.getMessage(), e));
                    }
                } else if (!splitString[2].equals("f")) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "Corrupt XRefTable Entry - ObjID:" + currObjID));
                }
                ++currObjID;
                this.skipSpaces();
            }
            this.skipSpaces();
        } while (this.isDigit());
        return true;
    }

    @Override
    protected COSStream parseCOSStream(COSDictionary dic) throws IOException {
        this.checkStreamKeyWord();
        COSStream result = super.parseCOSStream(dic);
        this.checkEndstreamKeyWord();
        return result;
    }

    protected void checkStreamKeyWord() throws IOException {
        int nextChar;
        String streamV = this.readString();
        if (!streamV.equals("stream")) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'stream' keyword but found '" + streamV + "' at offset " + this.source.getPosition()));
        }
        if (((nextChar = this.source.read()) != 13 || this.source.peek() != 10) && nextChar != 10) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'EOL' after the stream keyword at offset " + this.source.getPosition()));
        }
        this.source.seek(this.source.getPosition() - 7L);
    }

    protected void checkEndstreamKeyWord() throws IOException {
        String endstreamV;
        this.source.seek(this.source.getPosition() - 10L);
        if (!this.nextIsEOL()) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'EOL' before the endstream keyword at offset " + this.source.getPosition() + " but found '" + this.source.peek() + "'"));
        }
        if (!(endstreamV = this.readString()).equals("endstream")) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'endstream' keyword at offset " + this.source.getPosition() + " but found '" + endstreamV + "'"));
        }
    }

    private boolean nextIsEOL() throws IOException {
        boolean succeed = false;
        int nextChar = this.source.read();
        if (13 == nextChar && 10 == this.source.peek()) {
            this.source.read();
            succeed = true;
        } else if (13 == nextChar || 10 == nextChar) {
            succeed = true;
        }
        return succeed;
    }

    @Override
    protected COSArray parseCOSArray() throws IOException {
        COSArray result = super.parseCOSArray();
        if (result != null && result.size() > 8191) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.2", "Array too long : " + result.size()));
        }
        return result;
    }

    @Override
    protected COSName parseCOSName() throws IOException {
        COSName result = super.parseCOSName();
        if (result != null && result.getName().getBytes().length > 127) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.3", "Name too long: " + result.getName()));
        }
        return result;
    }

    @Override
    protected COSString parseCOSString() throws IOException {
        long offset = this.source.getPosition();
        char nextChar = (char)this.source.read();
        int count = 0;
        if (nextChar == '<') {
            do {
                if ((nextChar = (char)this.source.read()) == '>' || this.isWhitespace(nextChar)) continue;
                if (Character.digit(nextChar, 16) >= 0) {
                    ++count;
                    continue;
                }
                this.addValidationError(new ValidationResult.ValidationError("1.0.12", "Hexa String must have only Hexadecimal Characters (found '" + nextChar + "') at offset " + this.source.getPosition()));
                break;
            } while (nextChar != '>');
        }
        if (count % 2 != 0) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.11", "Hexa string shall contain even number of non white space char at offset " + this.source.getPosition()));
        }
        this.source.seek(offset);
        COSString result = super.parseCOSString();
        if (result.getString().length() > 65535) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.5", "Hexa string is too long at offset " + this.source.getPosition()));
        }
        return result;
    }

    @Override
    protected COSBase parseDirObject() throws IOException {
        COSDictionary dic;
        COSBase result = super.parseDirObject();
        if (result instanceof COSNumber) {
            COSNumber number = (COSNumber)result;
            if (number instanceof COSFloat) {
                Float real = Float.valueOf(number.floatValue());
                if (real.floatValue() > 32767.0f || real.floatValue() < -32767.0f) {
                    this.addValidationError(new ValidationResult.ValidationError("1.0.6", "Float is too long or too small: " + real + "  at offset " + this.source.getPosition()));
                }
            } else {
                long numAsLong = number.longValue();
                if (numAsLong > Integer.MAX_VALUE || numAsLong < Integer.MIN_VALUE) {
                    this.addValidationError(new ValidationResult.ValidationError("1.0.6", "Numeric is too long or too small: " + numAsLong + "  at offset " + this.source.getPosition()));
                }
            }
        }
        if (result instanceof COSDictionary && (dic = (COSDictionary)result).size() > 4095) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.1", "Too Many Entries In Dictionary at offset " + this.source.getPosition()));
        }
        return result;
    }

    @Override
    protected COSBase parseObjectDynamically(long objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            if (requireExistingNotCompressedObj && offsetOrObjstmObNr == null) {
                this.addValidationError(new ValidationResult.ValidationError("1.0.13", "Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration()));
                throw new SyntaxValidationException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration(), this.validationResult);
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(COSNull.NULL);
            } else if (offsetOrObjstmObNr == 0L) {
                this.addValidationError(new ValidationResult.ValidationError("1.0.14", "Object {" + objKey.getNumber() + ":" + objKey.getGeneration() + "} has an offset of 0"));
            } else if (offsetOrObjstmObNr > 0L) {
                int readObjGen;
                long readObjNr;
                this.source.seek(offsetOrObjstmObNr);
                long offset = this.source.getPosition();
                String line = this.readLine();
                Pattern pattern = Pattern.compile("(\\d+)\\s(\\d+)\\sobj");
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    readObjNr = Long.parseLong(matcher.group(1));
                    readObjGen = Integer.parseInt(matcher.group(2));
                } else {
                    this.addValidationError(new ValidationResult.ValidationError("1.2.1", "Single space expected [offset=" + offset + "; key=" + offsetOrObjstmObNr.toString() + "; line=" + line + "; object=" + pdfObject.toString() + "]"));
                    this.source.seek(offset);
                    readObjNr = this.readObjectNumber();
                    readObjGen = this.readGenerationNumber();
                    this.skipSpaces();
                    for (char c : OBJ_MARKER) {
                        if (this.source.read() == c) continue;
                        this.addValidationError(new ValidationResult.ValidationError("1.2.1", "Expected pattern '" + new String(OBJ_MARKER) + " but missed at character '" + c + "'"));
                        throw new SyntaxValidationException("Expected pattern '" + new String(OBJ_MARKER) + " but missed at character '" + c + "'", this.validationResult);
                    }
                }
                if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
                    throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                this.skipSpaces();
                long endObjectOffset = this.source.getPosition();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    COSStream stream;
                    this.source.seek(endObjectOffset);
                    if (pb instanceof COSDictionary) {
                        stream = this.parseCOSStream((COSDictionary)pb);
                        if (this.securityHandler != null) {
                            this.securityHandler.decryptStream(stream, objNr, objGenNr);
                        }
                    } else {
                        throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
                    }
                    pb = stream;
                    this.skipSpaces();
                    endObjectOffset = this.source.getPosition();
                    endObjectKey = this.readString();
                    if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                        endObjectKey = this.readString();
                    }
                } else if (this.securityHandler != null) {
                    this.securityHandler.decrypt(pb, objNr, objGenNr);
                }
                pdfObject.setObject(pb);
                if (!endObjectKey.startsWith("endobj")) {
                    throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj'.");
                }
                offset = this.source.getPosition();
                this.source.seek(endObjectOffset - 1L);
                if (!this.nextIsEOL()) {
                    this.addValidationError(new ValidationResult.ValidationError("1.2.1", "EOL expected before the 'endobj' keyword at offset " + this.source.getPosition()));
                }
                this.source.seek(offset);
                if (!this.nextIsEOL()) {
                    this.addValidationError(new ValidationResult.ValidationError("1.2.1", "EOL expected after the 'endobj' keyword at offset " + this.source.getPosition()));
                }
            } else {
                int objstmObjNr = (int)(-offsetOrObjstmObNr.longValue());
                COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
                if (objstmBaseObj instanceof COSStream) {
                    PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document);
                    parser.parse();
                    for (COSObject next : parser.getObjects()) {
                        COSObjectKey stmObjKey = new COSObjectKey(next);
                        Long offset = this.xrefTrailerResolver.getXrefTable().get(stmObjKey);
                        if (offset == null || offset != (long)(-objstmObjNr)) continue;
                        COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                        stmObj.setObject(next.getObject());
                    }
                }
            }
        }
        return pdfObject.getObject();
    }

    @Override
    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int tmpOffset;
        int offset = super.lastIndexOf(pattern, buf, endOff);
        if (offset > 0 && Arrays.equals(pattern, EOF_MARKER) && (tmpOffset = offset + pattern.length) != buf.length && (buf.length - tmpOffset > 2 || buf.length - tmpOffset == 2 && (buf[tmpOffset] != 13 || buf[tmpOffset + 1] != 10) || buf.length - tmpOffset == 1 && buf[tmpOffset] != 13 && buf[tmpOffset] != 10)) {
            long position;
            try {
                position = this.source.getPosition();
            }
            catch (IOException ex) {
                position = Long.MIN_VALUE;
            }
            this.addValidationError(new ValidationResult.ValidationError("1.4.10", "File contains data after the last %%EOF sequence at offset " + position));
        }
        return offset;
    }
}

