/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCarDriveStatus is the corresponding interface of BACnetConstructedDataCarDriveStatus
type BACnetConstructedDataCarDriveStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCarDriveStatus returns CarDriveStatus (property field)
	GetCarDriveStatus() BACnetLiftCarDriveStatusTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetLiftCarDriveStatusTagged
	// IsBACnetConstructedDataCarDriveStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCarDriveStatus()
	// CreateBuilder creates a BACnetConstructedDataCarDriveStatusBuilder
	CreateBACnetConstructedDataCarDriveStatusBuilder() BACnetConstructedDataCarDriveStatusBuilder
}

// _BACnetConstructedDataCarDriveStatus is the data-structure of this message
type _BACnetConstructedDataCarDriveStatus struct {
	BACnetConstructedDataContract
	CarDriveStatus BACnetLiftCarDriveStatusTagged
}

var _ BACnetConstructedDataCarDriveStatus = (*_BACnetConstructedDataCarDriveStatus)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCarDriveStatus)(nil)

// NewBACnetConstructedDataCarDriveStatus factory function for _BACnetConstructedDataCarDriveStatus
func NewBACnetConstructedDataCarDriveStatus(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, carDriveStatus BACnetLiftCarDriveStatusTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCarDriveStatus {
	if carDriveStatus == nil {
		panic("carDriveStatus of type BACnetLiftCarDriveStatusTagged for BACnetConstructedDataCarDriveStatus must not be nil")
	}
	_result := &_BACnetConstructedDataCarDriveStatus{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		CarDriveStatus:                carDriveStatus,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCarDriveStatusBuilder is a builder for BACnetConstructedDataCarDriveStatus
type BACnetConstructedDataCarDriveStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(carDriveStatus BACnetLiftCarDriveStatusTagged) BACnetConstructedDataCarDriveStatusBuilder
	// WithCarDriveStatus adds CarDriveStatus (property field)
	WithCarDriveStatus(BACnetLiftCarDriveStatusTagged) BACnetConstructedDataCarDriveStatusBuilder
	// WithCarDriveStatusBuilder adds CarDriveStatus (property field) which is build by the builder
	WithCarDriveStatusBuilder(func(BACnetLiftCarDriveStatusTaggedBuilder) BACnetLiftCarDriveStatusTaggedBuilder) BACnetConstructedDataCarDriveStatusBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCarDriveStatus or returns an error if something is wrong
	Build() (BACnetConstructedDataCarDriveStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCarDriveStatus
}

// NewBACnetConstructedDataCarDriveStatusBuilder() creates a BACnetConstructedDataCarDriveStatusBuilder
func NewBACnetConstructedDataCarDriveStatusBuilder() BACnetConstructedDataCarDriveStatusBuilder {
	return &_BACnetConstructedDataCarDriveStatusBuilder{_BACnetConstructedDataCarDriveStatus: new(_BACnetConstructedDataCarDriveStatus)}
}

type _BACnetConstructedDataCarDriveStatusBuilder struct {
	*_BACnetConstructedDataCarDriveStatus

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataCarDriveStatusBuilder) = (*_BACnetConstructedDataCarDriveStatusBuilder)(nil)

func (b *_BACnetConstructedDataCarDriveStatusBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCarDriveStatus
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) WithMandatoryFields(carDriveStatus BACnetLiftCarDriveStatusTagged) BACnetConstructedDataCarDriveStatusBuilder {
	return b.WithCarDriveStatus(carDriveStatus)
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) WithCarDriveStatus(carDriveStatus BACnetLiftCarDriveStatusTagged) BACnetConstructedDataCarDriveStatusBuilder {
	b.CarDriveStatus = carDriveStatus
	return b
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) WithCarDriveStatusBuilder(builderSupplier func(BACnetLiftCarDriveStatusTaggedBuilder) BACnetLiftCarDriveStatusTaggedBuilder) BACnetConstructedDataCarDriveStatusBuilder {
	builder := builderSupplier(b.CarDriveStatus.CreateBACnetLiftCarDriveStatusTaggedBuilder())
	var err error
	b.CarDriveStatus, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetLiftCarDriveStatusTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) Build() (BACnetConstructedDataCarDriveStatus, error) {
	if b.CarDriveStatus == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'carDriveStatus' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataCarDriveStatus.deepCopy(), nil
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) MustBuild() BACnetConstructedDataCarDriveStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCarDriveStatusBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCarDriveStatusBuilder().(*_BACnetConstructedDataCarDriveStatusBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataCarDriveStatusBuilder creates a BACnetConstructedDataCarDriveStatusBuilder
func (b *_BACnetConstructedDataCarDriveStatus) CreateBACnetConstructedDataCarDriveStatusBuilder() BACnetConstructedDataCarDriveStatusBuilder {
	if b == nil {
		return NewBACnetConstructedDataCarDriveStatusBuilder()
	}
	return &_BACnetConstructedDataCarDriveStatusBuilder{_BACnetConstructedDataCarDriveStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCarDriveStatus) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCarDriveStatus) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_CAR_DRIVE_STATUS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCarDriveStatus) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCarDriveStatus) GetCarDriveStatus() BACnetLiftCarDriveStatusTagged {
	return m.CarDriveStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataCarDriveStatus) GetActualValue() BACnetLiftCarDriveStatusTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetLiftCarDriveStatusTagged(m.GetCarDriveStatus())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCarDriveStatus(structType any) BACnetConstructedDataCarDriveStatus {
	if casted, ok := structType.(BACnetConstructedDataCarDriveStatus); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCarDriveStatus); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCarDriveStatus) GetTypeName() string {
	return "BACnetConstructedDataCarDriveStatus"
}

func (m *_BACnetConstructedDataCarDriveStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (carDriveStatus)
	lengthInBits += m.CarDriveStatus.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataCarDriveStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCarDriveStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCarDriveStatus BACnetConstructedDataCarDriveStatus, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCarDriveStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCarDriveStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	carDriveStatus, err := ReadSimpleField[BACnetLiftCarDriveStatusTagged](ctx, "carDriveStatus", ReadComplex[BACnetLiftCarDriveStatusTagged](BACnetLiftCarDriveStatusTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'carDriveStatus' field"))
	}
	m.CarDriveStatus = carDriveStatus

	actualValue, err := ReadVirtualField[BACnetLiftCarDriveStatusTagged](ctx, "actualValue", (*BACnetLiftCarDriveStatusTagged)(nil), carDriveStatus)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCarDriveStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCarDriveStatus")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCarDriveStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCarDriveStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCarDriveStatus"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCarDriveStatus")
		}

		if err := WriteSimpleField[BACnetLiftCarDriveStatusTagged](ctx, "carDriveStatus", m.GetCarDriveStatus(), WriteComplex[BACnetLiftCarDriveStatusTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'carDriveStatus' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCarDriveStatus"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCarDriveStatus")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCarDriveStatus) IsBACnetConstructedDataCarDriveStatus() {}

func (m *_BACnetConstructedDataCarDriveStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCarDriveStatus) deepCopy() *_BACnetConstructedDataCarDriveStatus {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCarDriveStatusCopy := &_BACnetConstructedDataCarDriveStatus{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetLiftCarDriveStatusTagged](m.CarDriveStatus),
	}
	_BACnetConstructedDataCarDriveStatusCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCarDriveStatusCopy
}

func (m *_BACnetConstructedDataCarDriveStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
