/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PortIdSubtype is an enum
type PortIdSubtype uint32

type IPortIdSubtype interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	PortIdSubtype_portIdSubtypeInterfaceAlias PortIdSubtype = 1
	PortIdSubtype_portIdSubtypePortComponent  PortIdSubtype = 2
	PortIdSubtype_portIdSubtypeMacAddress     PortIdSubtype = 3
	PortIdSubtype_portIdSubtypeNetworkAddress PortIdSubtype = 4
	PortIdSubtype_portIdSubtypeInterfaceName  PortIdSubtype = 5
	PortIdSubtype_portIdSubtypeAgentCircuitId PortIdSubtype = 6
	PortIdSubtype_portIdSubtypeLocal          PortIdSubtype = 7
)

var PortIdSubtypeValues []PortIdSubtype

func init() {
	_ = errors.New
	PortIdSubtypeValues = []PortIdSubtype{
		PortIdSubtype_portIdSubtypeInterfaceAlias,
		PortIdSubtype_portIdSubtypePortComponent,
		PortIdSubtype_portIdSubtypeMacAddress,
		PortIdSubtype_portIdSubtypeNetworkAddress,
		PortIdSubtype_portIdSubtypeInterfaceName,
		PortIdSubtype_portIdSubtypeAgentCircuitId,
		PortIdSubtype_portIdSubtypeLocal,
	}
}

func PortIdSubtypeByValue(value uint32) (enum PortIdSubtype, ok bool) {
	switch value {
	case 1:
		return PortIdSubtype_portIdSubtypeInterfaceAlias, true
	case 2:
		return PortIdSubtype_portIdSubtypePortComponent, true
	case 3:
		return PortIdSubtype_portIdSubtypeMacAddress, true
	case 4:
		return PortIdSubtype_portIdSubtypeNetworkAddress, true
	case 5:
		return PortIdSubtype_portIdSubtypeInterfaceName, true
	case 6:
		return PortIdSubtype_portIdSubtypeAgentCircuitId, true
	case 7:
		return PortIdSubtype_portIdSubtypeLocal, true
	}
	return 0, false
}

func PortIdSubtypeByName(value string) (enum PortIdSubtype, ok bool) {
	switch value {
	case "portIdSubtypeInterfaceAlias":
		return PortIdSubtype_portIdSubtypeInterfaceAlias, true
	case "portIdSubtypePortComponent":
		return PortIdSubtype_portIdSubtypePortComponent, true
	case "portIdSubtypeMacAddress":
		return PortIdSubtype_portIdSubtypeMacAddress, true
	case "portIdSubtypeNetworkAddress":
		return PortIdSubtype_portIdSubtypeNetworkAddress, true
	case "portIdSubtypeInterfaceName":
		return PortIdSubtype_portIdSubtypeInterfaceName, true
	case "portIdSubtypeAgentCircuitId":
		return PortIdSubtype_portIdSubtypeAgentCircuitId, true
	case "portIdSubtypeLocal":
		return PortIdSubtype_portIdSubtypeLocal, true
	}
	return 0, false
}

func PortIdSubtypeKnows(value uint32) bool {
	for _, typeValue := range PortIdSubtypeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastPortIdSubtype(structType any) PortIdSubtype {
	castFunc := func(typ any) PortIdSubtype {
		if sPortIdSubtype, ok := typ.(PortIdSubtype); ok {
			return sPortIdSubtype
		}
		return 0
	}
	return castFunc(structType)
}

func (m PortIdSubtype) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m PortIdSubtype) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func PortIdSubtypeParse(ctx context.Context, theBytes []byte) (PortIdSubtype, error) {
	return PortIdSubtypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func PortIdSubtypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (PortIdSubtype, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("PortIdSubtype", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading PortIdSubtype")
	}
	if enum, ok := PortIdSubtypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for PortIdSubtype")
		return PortIdSubtype(val), nil
	} else {
		return enum, nil
	}
}

func (e PortIdSubtype) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e PortIdSubtype) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("PortIdSubtype", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e PortIdSubtype) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e PortIdSubtype) PLC4XEnumName() string {
	switch e {
	case PortIdSubtype_portIdSubtypeInterfaceAlias:
		return "portIdSubtypeInterfaceAlias"
	case PortIdSubtype_portIdSubtypePortComponent:
		return "portIdSubtypePortComponent"
	case PortIdSubtype_portIdSubtypeMacAddress:
		return "portIdSubtypeMacAddress"
	case PortIdSubtype_portIdSubtypeNetworkAddress:
		return "portIdSubtypeNetworkAddress"
	case PortIdSubtype_portIdSubtypeInterfaceName:
		return "portIdSubtypeInterfaceName"
	case PortIdSubtype_portIdSubtypeAgentCircuitId:
		return "portIdSubtypeAgentCircuitId"
	case PortIdSubtype_portIdSubtypeLocal:
		return "portIdSubtypeLocal"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e PortIdSubtype) String() string {
	return e.PLC4XEnumName()
}
