/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.context;

import java.util.Collections;
import java.util.List;
import org.apache.rocketmq.auth.authentication.model.Subject;
import org.apache.rocketmq.auth.authorization.context.AuthorizationContext;
import org.apache.rocketmq.auth.authorization.model.Resource;
import org.apache.rocketmq.common.action.Action;

public class DefaultAuthorizationContext
extends AuthorizationContext {
    private Subject subject;
    private Resource resource;
    private List<Action> actions;
    private String sourceIp;

    public static DefaultAuthorizationContext of(Subject subject, Resource resource, Action action, String sourceIp) {
        DefaultAuthorizationContext context = new DefaultAuthorizationContext();
        context.setSubject(subject);
        context.setResource(resource);
        context.setActions(Collections.singletonList(action));
        context.setSourceIp(sourceIp);
        return context;
    }

    public static DefaultAuthorizationContext of(Subject subject, Resource resource, List<Action> actions, String sourceIp) {
        DefaultAuthorizationContext context = new DefaultAuthorizationContext();
        context.setSubject(subject);
        context.setResource(resource);
        context.setActions(actions);
        context.setSourceIp(sourceIp);
        return context;
    }

    public String getSubjectKey() {
        return this.subject != null ? this.subject.getSubjectKey() : null;
    }

    public String getResourceKey() {
        return this.resource != null ? this.resource.getResourceKey() : null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }
}

