/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.io.stream.InternalOptionKey;
import org.apache.sis.referencing.internal.shared.LazySet;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.system.Reflect;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;

final class DataStoreRegistry
extends LazySet<DataStoreProvider> {
    static final DataStoreRegistry INSTANCE = new DataStoreRegistry();
    private final ServiceLoader<DataStoreProvider> loader;

    public DataStoreRegistry() {
        ServiceLoader<DataStoreProvider> loader;
        try {
            loader = ServiceLoader.load(DataStoreProvider.class, Reflect.getContextClassLoader());
        }
        catch (SecurityException e) {
            Reflect.log(DataStoreRegistry.class, (String)"<init>", (SecurityException)e);
            loader = ServiceLoader.load(DataStoreProvider.class);
        }
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<DataStoreProvider> createSourceIterator() {
        ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            final Iterator<DataStoreProvider> providers = this.loader.iterator();
            return new Iterator<DataStoreProvider>(){
                final /* synthetic */ DataStoreRegistry this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ServiceLoader<DataStoreProvider> serviceLoader = this.this$0.loader;
                    synchronized (serviceLoader) {
                        return providers.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DataStoreProvider next() {
                    ServiceLoader<DataStoreProvider> serviceLoader = this.this$0.loader;
                    synchronized (serviceLoader) {
                        return (DataStoreProvider)providers.next();
                    }
                }
            };
        }
    }

    public String probeContentType(Object storage) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"storage", (Object)storage);
        ProbeProviderPair p = this.lookup(storage, Capability.READ, null, false);
        return p != null ? p.probe.getMimeType() : null;
    }

    public DataStore open(Object storage, Capability capability, Predicate<DataStoreProvider> preferred) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull((String)"storage", (Object)storage);
        return this.lookup((Object)storage, (Capability)capability, preferred, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object storage, Capability capability, Predicate<DataStoreProvider> preferred, boolean open) throws DataStoreException {
        String extension;
        boolean writable;
        StorageConnector connector;
        if (storage instanceof StorageConnector) {
            connector = (StorageConnector)storage;
            writable = capability == Capability.WRITE && connector.getOption(OptionKey.OPEN_OPTIONS) == null;
            Predicate<DataStoreProvider> filter = connector.getOption(InternalOptionKey.PREFERRED_PROVIDERS);
            if (filter != null) {
                preferred = preferred != null ? preferred.and(filter) : filter;
            }
        } else {
            connector = new StorageConnector(storage);
            boolean bl = writable = capability == Capability.WRITE;
        }
        if (writable) {
            connector.setOption(OptionKey.OPEN_OPTIONS, new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE});
        }
        if (preferred != null) {
            connector.setOption(InternalOptionKey.PREFERRED_PROVIDERS, preferred);
        }
        boolean useSuffix = !Strings.isNullOrEmpty((String)(extension = connector.getFileExtension()));
        boolean isWriteOnly = capability == Capability.WRITE && IOUtilities.isWriteOnly(connector.getStorage());
        ProbeProviderPair selected = null;
        LinkedList<ProbeProviderPair> needMoreBytes = new LinkedList<ProbeProviderPair>();
        try {
            boolean isFirstIteration = true;
            block12: for (Category category : Category.values()) {
                DataStoreProvider provider;
                Iterator<DataStoreProvider> providers;
                if (category.preferred && preferred == null || category.useSuffix && !useSuffix) continue;
                ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
                synchronized (serviceLoader) {
                    providers = this.loader.iterator();
                    provider = providers.hasNext() ? providers.next() : null;
                }
                while (provider != null) {
                    boolean accept;
                    StoreMetadata md = provider.getClass().getAnnotation(StoreMetadata.class);
                    if (md == null) {
                        accept = isFirstIteration;
                    } else {
                        boolean bl = accept = (category.preferred || md.yieldPriority() == category.yieldPriority) && ArraysExt.contains((Object[])md.capabilities(), (Object)((Object)capability));
                        if (accept & useSuffix) {
                            accept = ArraysExt.containsIgnoreCase((String[])md.fileSuffixes(), (String)extension) == category.useSuffix;
                        }
                    }
                    if (accept & preferred != null) {
                        boolean bl = accept = preferred.test(provider) == category.preferred;
                    }
                    if (accept) {
                        ProbeResult probe;
                        ProbeProviderPair candidate = new ProbeProviderPair(provider);
                        if (isWriteOnly) {
                            selected = candidate;
                            break block12;
                        }
                        ProbeProviderPair old = connector.probing;
                        try {
                            connector.probing = candidate;
                            probe = provider.probeContent(connector);
                        }
                        finally {
                            connector.probing = old;
                        }
                        candidate.probe = probe;
                        if (probe.isSupported()) {
                            selected = candidate;
                            break block12;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(probe)) {
                            needMoreBytes.add(candidate);
                        } else if (ProbeResult.UNDETERMINED.equals(probe) && selected == null) {
                            selected = candidate;
                        }
                    }
                    ServiceLoader<DataStoreProvider> serviceLoader2 = this.loader;
                    synchronized (serviceLoader2) {
                        provider = providers.hasNext() ? providers.next() : null;
                    }
                }
                while (!needMoreBytes.isEmpty() && connector.prefetch()) {
                    Iterator it = needMoreBytes.iterator();
                    while (it.hasNext()) {
                        ProbeProviderPair p = (ProbeProviderPair)it.next();
                        p.probe = p.provider.probeContent(connector);
                        if (p.probe.isSupported()) {
                            selected = p;
                            break block12;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(p.probe)) continue;
                        if (selected == null && ProbeResult.UNDETERMINED.equals(p.probe)) {
                            selected = p;
                        }
                        it.remove();
                    }
                }
                isFirstIteration = false;
            }
            if (open && selected != null) {
                selected.store = selected.provider.open(connector);
                connector = null;
            }
        }
        finally {
            if (connector != null && connector != storage) {
                connector.closeAllExcept(null);
            }
        }
        if (open && selected == null) {
            String name = connector.getStorageName();
            throw new UnsupportedStorageException(null, 14, name);
        }
        return selected;
    }

    public synchronized void reload() {
        this.loader.reload();
        super.reload();
    }

    static {
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.storage"){

            protected void classpathChanged() {
                INSTANCE.reload();
            }
        });
    }

    private static enum Category {
        PREFERRED(true, true, false),
        PREFERRED_IGNORE_SUFFIX(true, false, false),
        SUFFIX_MATCH(false, true, false),
        IGNORE_SUFFIX(false, false, false),
        DEFERRED(false, true, true),
        DEFERRED_IGNORE_SUFFIX(false, false, true);

        final boolean preferred;
        final boolean useSuffix;
        final boolean yieldPriority;

        private Category(boolean preferred, boolean useSuffix, boolean yieldPriority) {
            this.preferred = preferred;
            this.useSuffix = useSuffix;
            this.yieldPriority = yieldPriority;
        }
    }
}

