/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.image.BandedSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import javax.measure.IncommensurableException;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.UpdatableWrite;
import org.apache.sis.math.Fraction;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.base.MetadataFetcher;
import org.apache.sis.storage.geotiff.Compression;
import org.apache.sis.storage.geotiff.FormatModifier;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.IOBase;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.writer.GeoEncoder;
import org.apache.sis.storage.geotiff.writer.ReformattedImage;
import org.apache.sis.storage.geotiff.writer.TagValue;
import org.apache.sis.storage.geotiff.writer.TileMatrix;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Writer
extends IOBase
implements Flushable {
    static final short TIFF_ULONG = 16;
    private static final byte[] TYPE_SIZES = new byte[17];
    static final int COMMON_NUMBER_OF_TAGS = 16;
    private ImageProcessor processor;
    final ChannelDataOutput output;
    private final boolean isBigTIFF;
    private final boolean anyTileSize;
    int imageIndex;
    private UpdatableWrite<?> currentIFD;
    private final Deque<UpdatableWrite<?>> deferredWrites = new ArrayDeque();
    private final Queue<TagValue> largeTagData = new ArrayDeque<TagValue>();
    private int numberOfTags;

    Writer(GeoTiffStore store, ChannelDataOutput output, FormatModifier[] options) throws IOException, DataStoreException {
        super(store);
        this.output = output;
        this.isBigTIFF = ArraysExt.contains((Object[])options, (Object)((Object)FormatModifier.BIG_TIFF));
        this.anyTileSize = ArraysExt.contains((Object[])options, (Object)((Object)FormatModifier.ANY_TILE_SIZE));
        output.relocateOrigin();
        output.writeShort(output.buffer.order() == ByteOrder.LITTLE_ENDIAN ? 18761 : 19789);
        output.writeShort(this.isBigTIFF ? 43 : 42);
        if (this.isBigTIFF) {
            output.writeShort(8);
            output.writeShort(0);
            output.writeLong(16L);
        } else {
            output.writeInt(8);
        }
    }

    Writer(Reader reader) throws IOException, DataStoreException {
        super(reader.store);
        this.isBigTIFF = reader.intSizeExpansion != 0;
        this.anyTileSize = false;
        try {
            this.output = new ChannelDataOutput(reader.input);
        }
        catch (ClassCastException e) {
            throw new ReadOnlyStorageException(this.store.readOrWriteOnly(0), (Throwable)e);
        }
        this.moveAfterExisting(reader);
    }

    final void moveAfterExisting(Reader reader) throws IOException, DataStoreException {
        Class type = this.isBigTIFF ? Long.class : Integer.class;
        this.currentIFD = UpdatableWrite.ofZeroAt((long)reader.offsetOfWritableIFD(), type);
        this.imageIndex = reader.getImageCacheSize();
    }

    final void synchronize(Reader reader, boolean finish) throws IOException {
        if (reader != null) {
            if (finish) {
                this.output.yield(reader.input);
            } else {
                reader.input.yield(this.output);
            }
        }
    }

    @Override
    public final Set<FormatModifier> getModifiers() {
        return this.isBigTIFF ? Set.of(FormatModifier.BIG_TIFF) : Set.of();
    }

    private ImageProcessor processor() {
        if (this.processor == null) {
            this.processor = new ImageProcessor();
        }
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long append(RenderedImage image, GridGeometry grid, Metadata metadata) throws IOException, DataStoreException {
        ReformattedImage exportable = new ReformattedImage(image, this::processor, this.anyTileSize);
        long offsetIFD = this.output.length();
        if (this.currentIFD != null) {
            this.currentIFD.setAsLong(offsetIFD);
            this.writeOrQueue(this.currentIFD);
            this.output.seek(offsetIFD);
        }
        try {
            TileMatrix tiles;
            try {
                tiles = this.writeImageFileDirectory(exportable, grid, metadata, false);
            }
            finally {
                this.largeTagData.clear();
            }
            tiles.writeRasters(this.output);
            Writer.wordAlign(this.output);
            tiles.writeOffsetsAndLengths(this.output);
            this.flush();
            this.currentIFD = tiles.nextIFD;
        }
        catch (Throwable e) {
            try {
                this.deferredWrites.clear();
                this.output.truncate(offsetIFD);
                if (this.currentIFD != null) {
                    this.currentIFD.setAsLong(0L);
                    this.currentIFD.update(this.output);
                }
            }
            catch (Throwable more) {
                e.addSuppressed(more);
            }
            throw e;
        }
        return offsetIFD;
    }

    private TileMatrix writeImageFileDirectory(ReformattedImage image, GridGeometry grid, Metadata metadata, boolean overview) throws IOException, DataStoreException {
        Fraction xres;
        int numPlanes;
        int planarConfiguration;
        int colorInterpretation;
        SampleModel sm = image.exportable.getSampleModel();
        Compression compression = this.store.getCompression().orElse(Compression.DEFLATE);
        if (!DataType.isInteger((SampleModel)sm)) {
            compression = compression.withPredictor(1);
        }
        this.numberOfTags = 16;
        if (compression.usePredictor()) {
            ++this.numberOfTags;
        }
        if ((colorInterpretation = image.getColorInterpretation()) == 3) {
            ++this.numberOfTags;
        }
        if (image.extraSamples != null) {
            ++this.numberOfTags;
        }
        int sampleFormat = image.getSampleFormat();
        int[] bitsPerSample = sm.getSampleSize();
        int numBands = sm.getNumBands();
        if (sm instanceof BandedSampleModel) {
            planarConfiguration = 2;
            numPlanes = numBands;
        } else {
            planarConfiguration = 1;
            numPlanes = 1;
        }
        double[][] statistics = image.statistics(numBands);
        short[][] shortStats = Writer.toShorts(statistics, sampleFormat);
        MetadataFetcher<String> mf = new MetadataFetcher<String>(this.store.dataLocale){

            protected boolean accept(CitationDate info) {
                return super.accept(info) || this.creationDate != null;
            }

            protected String convertDate(Date date) {
                return Writer.this.store.getDateFormat().format(date);
            }
        };
        mf.accept(metadata);
        GeoEncoder geoKeys = null;
        if (grid != null) {
            try {
                geoKeys = new GeoEncoder(this.store.listeners());
                geoKeys.write(grid, mf);
            }
            catch (CannotEvaluateException | IncompleteGridGeometryException | TransformException e) {
                throw new IncompatibleResourceException(e.getMessage(), e).addAspect("gridGeometry");
            }
            catch (RuntimeException | IncommensurableException | FactoryException e) {
                throw new DataStoreReferencingException(e.getMessage(), e);
            }
        }
        Fraction yres = xres = new Fraction(1, 1);
        this.output.flush();
        this.largeTagData.clear();
        UpdatableWrite tagCountWriter = this.isBigTIFF ? UpdatableWrite.of((ChannelDataOutput)this.output, (long)this.numberOfTags) : UpdatableWrite.of((ChannelDataOutput)this.output, (short)((short)this.numberOfTags));
        TileMatrix tiling = new TileMatrix(image.exportable, numPlanes, bitsPerSample, compression.method, compression.level, compression.predictor);
        this.numberOfTags = 0;
        this.writeTag((short)254, (short)4, overview ? 1 : 0);
        this.writeTag((short)256, (short)4, image.exportable.getWidth());
        this.writeTag((short)257, (short)4, image.exportable.getHeight());
        this.writeTag((short)258, (short)3, bitsPerSample);
        this.writeTag((short)259, (short)3, compression.method.code);
        this.writeTag((short)262, (short)3, colorInterpretation);
        this.writeTag((short)269, mf.series);
        this.writeTag((short)270, mf.title);
        this.writeTag((short)272, mf.instrument);
        this.writeTag((short)273, tiling, true);
        this.writeTag((short)277, (short)3, numBands);
        this.writeTag((short)278, tiling, true);
        this.writeTag((short)279, tiling, true);
        this.writeTag((short)280, shortStats[0]);
        this.writeTag((short)281, shortStats[1]);
        this.writeTag((short)282, xres);
        this.writeTag((short)283, yres);
        this.writeTag((short)284, (short)3, planarConfiguration);
        this.writeTag((short)296, (short)3, 1);
        this.writeTag((short)305, mf.software);
        this.writeTag((short)306, mf.creationDate);
        this.writeTag((short)315, mf.party);
        this.writeTag((short)316, mf.procedure);
        if (compression.usePredictor()) {
            this.writeTag((short)317, (short)3, compression.predictor.code);
        }
        if (colorInterpretation == 3) {
            this.writeColorPalette((IndexColorModel)image.exportable.getColorModel(), 1L << bitsPerSample[0]);
        }
        this.writeTag((short)322, tiling, false);
        this.writeTag((short)323, tiling, false);
        this.writeTag((short)324, tiling, false);
        this.writeTag((short)325, tiling, false);
        this.writeTag((short)338, image.extraSamples);
        this.writeTag((short)339, (short)3, sampleFormat);
        this.writeTag((short)340, (short)11, statistics[0]);
        this.writeTag((short)341, (short)11, statistics[1]);
        if (geoKeys != null) {
            this.writeTag((short)-31272, (short)12, geoKeys.modelTransformation());
            this.writeTag((short)-30801, geoKeys.keyDirectory());
            this.writeTag((short)-30800, (short)12, geoKeys.doubleParams());
            this.writeTag((short)-30799, geoKeys.asciiParams());
        }
        tagCountWriter.setAsLong((long)this.numberOfTags);
        this.writeOrQueue(tagCountWriter);
        tiling.nextIFD = this.writeOffset(0L);
        for (TagValue tag : this.largeTagData) {
            UpdatableWrite<?> offset = tag.writeHere(this.output);
            if (offset == null) continue;
            this.deferredWrites.add(offset);
        }
        return tiling;
    }

    private void writeTag(short tag, TileMatrix tiling, boolean useStrips) throws IOException {
        if (tiling.useStrips() == useStrips) {
            int value;
            switch (tag) {
                case 322: {
                    value = tiling.tileWidth;
                    break;
                }
                case 278: 
                case 323: {
                    value = tiling.tileHeight;
                    break;
                }
                case 273: 
                case 324: {
                    tiling.offsetsTag = this.writeTag(tag, tiling.offsets);
                    return;
                }
                case 279: 
                case 325: {
                    tiling.lengthsTag = this.writeTag(tag, (short)4, tiling.lengths);
                    return;
                }
                default: {
                    throw new AssertionError(tag);
                }
            }
            this.writeTag(tag, (short)4, value);
        }
    }

    private UpdatableWrite<?> writeOffset(long offset) throws IOException {
        return this.isBigTIFF ? UpdatableWrite.of((ChannelDataOutput)this.output, (long)offset) : UpdatableWrite.of((ChannelDataOutput)this.output, (int)((int)offset));
    }

    private static void wordAlign(ChannelDataOutput output) throws IOException {
        if ((output.getStreamPosition() & 1L) != 0L) {
            output.writeByte(0);
        }
    }

    private static short[][] toShorts(double[][] statistics, int sampleFormat) {
        long max;
        long min;
        short[][] c = new short[statistics.length][];
        switch (sampleFormat) {
            case 1: {
                min = 0L;
                max = 65535L;
                break;
            }
            case 2: {
                min = -32768L;
                max = 32767L;
                break;
            }
            default: {
                return c;
            }
        }
        for (int j = 0; j < c.length; ++j) {
            double[] source = statistics[j];
            if (source == null) continue;
            short[] target = new short[source.length];
            for (int i = 0; i < source.length; ++i) {
                target[i] = (short)Math.max(min, Math.min(max, Math.round(source[i])));
            }
            c[j] = target;
        }
        return c;
    }

    private int writeTagHeader(short tag, short type, long count) throws IOException {
        ++this.numberOfTags;
        this.output.ensureBufferAccepts(this.isBigTIFF ? 20 : 12);
        ByteBuffer buffer = this.output.buffer;
        buffer.putShort(tag);
        buffer.putShort(type);
        if (this.isBigTIFF) {
            buffer.putLong(count);
            return 8;
        }
        if ((count & 0xFFFFFFFF00000000L) == 0L) {
            buffer.putInt((int)count);
            return 4;
        }
        throw new ArithmeticException(this.errors().getString((short)91, (Object)32));
    }

    private TagValue writeLargeTag(short tag, short type, long count, TagValue deferred) throws IOException {
        long r = (long)this.writeTagHeader(tag, type, count) - (long)TYPE_SIZES[type] * count;
        if (r >= 0L) {
            deferred.markAndWrite(this.output);
            this.output.repeat(r, (byte)0);
        } else {
            deferred.mark(this.writeOffset(0L));
            this.largeTagData.add(deferred);
        }
        return deferred;
    }

    private void writeColorPalette(final IndexColorModel cm, final long count) throws IOException {
        int numBands = 3;
        this.writeLargeTag((short)320, (short)3, count * 3L, new TagValue(this){
            final /* synthetic */ Writer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void write(ChannelDataOutput output) throws IOException {
                int n = (int)Math.min((long)cm.getMapSize(), count);
                for (int band = 0; band < 3; ++band) {
                    for (int i = 0; i < n; ++i) {
                        int c;
                        switch (band) {
                            case 0: {
                                c = cm.getRed(i);
                                break;
                            }
                            case 1: {
                                c = cm.getGreen(i);
                                break;
                            }
                            case 2: {
                                c = cm.getBlue(i);
                                break;
                            }
                            default: {
                                throw new AssertionError(band);
                            }
                        }
                        output.writeShort(c | c << 8);
                    }
                    output.repeat((count - (long)n) * 2L, (byte)0);
                }
            }
        });
    }

    private void writeTag(short tag, List<String> values) throws IOException {
        if (values == null) {
            return;
        }
        long count = 0L;
        final byte[][] chars = new byte[values.size()][];
        for (int i = 0; i < chars.length; ++i) {
            String value = values.get(i).trim();
            if (StandardCharsets.US_ASCII.equals(this.store.encoding)) {
                value = CharSequences.toASCII((CharSequence)value).toString();
            }
            byte[] ascii = value.getBytes(this.store.encoding);
            int length = 0;
            for (byte c : ascii) {
                if (c == 0) continue;
                ascii[length++] = c;
            }
            if (length == 0) continue;
            count += (long)length + 1L;
            chars[i] = ArraysExt.resize((byte[])ascii, (int)length);
        }
        if (count != 0L) {
            this.writeLargeTag(tag, (short)2, count, new TagValue(this){
                final /* synthetic */ Writer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void write(ChannelDataOutput output) throws IOException {
                    for (byte[] c : chars) {
                        if (c == null) continue;
                        output.write(c);
                        output.writeByte(0);
                        Writer.wordAlign(output);
                    }
                }
            });
        }
    }

    private void writeTag(short tag, final Fraction value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeLargeTag(tag, (short)5, 1L, new TagValue(this){
            final /* synthetic */ Writer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void write(ChannelDataOutput output) throws IOException {
                output.writeInt(value.numerator);
                output.writeInt(value.denominator);
            }
        });
    }

    private TagValue writeTag(short tag, final short type, final double[] values) throws IOException {
        if (values == null || values.length == 0) {
            return null;
        }
        return this.writeLargeTag(tag, type, values.length, new TagValue(this){
            final /* synthetic */ Writer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void write(ChannelDataOutput output) throws IOException {
                switch (type) {
                    default: {
                        throw new AssertionError(type);
                    }
                    case 12: {
                        output.writeDoubles(values);
                        break;
                    }
                    case 11: {
                        for (double value : values) {
                            output.writeFloat((float)value);
                        }
                    }
                }
            }
        });
    }

    private TagValue writeTag(short tag, final long[] values) throws IOException {
        if (values == null || values.length == 0) {
            return null;
        }
        final short type = this.isBigTIFF ? (short)16 : 4;
        return this.writeLargeTag(tag, type, values.length, new TagValue(this){
            final /* synthetic */ Writer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void write(ChannelDataOutput output) throws IOException {
                switch (type) {
                    default: {
                        throw new AssertionError(type);
                    }
                    case 16: {
                        output.writeLongs(values);
                        break;
                    }
                    case 4: {
                        for (long value : values) {
                            output.writeInt(Math.toIntExact(value));
                        }
                    }
                }
            }
        });
    }

    private TagValue writeTag(short tag, final short[] values) throws IOException {
        if (values == null || values.length == 0) {
            return null;
        }
        return this.writeLargeTag(tag, (short)3, values.length, new TagValue(this){
            final /* synthetic */ Writer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void write(ChannelDataOutput output) throws IOException {
                output.writeShorts(values);
            }
        });
    }

    private TagValue writeTag(short tag, final short type, final int[] values) throws IOException {
        if (values == null || values.length == 0) {
            return null;
        }
        return this.writeLargeTag(tag, type, values.length, new TagValue(this){
            final /* synthetic */ Writer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void write(ChannelDataOutput output) throws IOException {
                switch (type) {
                    default: {
                        throw new AssertionError(type);
                    }
                    case 4: {
                        output.writeInts(values);
                        break;
                    }
                    case 3: {
                        for (int value : values) {
                            output.writeShort(value);
                        }
                    }
                }
            }
        });
    }

    private void writeTag(short tag, short type, int value) throws IOException {
        this.writeTagHeader(tag, type, 1L);
        ByteBuffer buffer = this.output.buffer;
        switch (type) {
            case 4: {
                buffer.putInt(value);
                break;
            }
            case 3: {
                assert (value >= 0 && value <= 65535) : value;
                buffer.putShort((short)value);
                buffer.putShort((short)0);
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
        if (this.isBigTIFF) {
            buffer.putInt(0);
        }
    }

    private void writeOrQueue(UpdatableWrite<?> value) throws IOException {
        if (!value.tryUpdateBuffer(this.output)) {
            this.deferredWrites.add(value);
        }
    }

    @Override
    public void flush() throws IOException {
        UpdatableWrite<?> change;
        while ((change = this.deferredWrites.pollFirst()) != null) {
            change.update(this.output);
        }
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        try (WritableByteChannel writableByteChannel = this.output.channel;){
            this.flush();
        }
    }

    static {
        Writer.TYPE_SIZES[6] = 1;
        Writer.TYPE_SIZES[1] = 1;
        Writer.TYPE_SIZES[2] = 1;
        Writer.TYPE_SIZES[8] = 2;
        Writer.TYPE_SIZES[3] = 2;
        Writer.TYPE_SIZES[9] = 4;
        Writer.TYPE_SIZES[4] = 4;
        Writer.TYPE_SIZES[10] = 8;
        Writer.TYPE_SIZES[5] = 8;
        Writer.TYPE_SIZES[11] = 4;
        Writer.TYPE_SIZES[12] = 8;
        Writer.TYPE_SIZES[13] = 4;
        Writer.TYPE_SIZES[16] = 8;
    }
}

