/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.LinearCS;

@XmlType(name="LinearCSType")
@XmlRootElement(name="LinearCS")
public class DefaultLinearCS
extends AbstractCS
implements LinearCS {
    private static final long serialVersionUID = -6890723478287625763L;

    public DefaultLinearCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, axis);
    }

    private DefaultLinearCS(DefaultLinearCS original, String name, CoordinateSystemAxis[] axes) {
        super(original, name, axes);
    }

    protected DefaultLinearCS(LinearCS original) {
        super((CoordinateSystem)original);
    }

    public static DefaultLinearCS castOrCopy(LinearCS object) {
        return object == null || object instanceof DefaultLinearCS ? (DefaultLinearCS)object : new DefaultLinearCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(direction, false)) {
            return 1;
        }
        if (!Units.isLinear(unit) && !Units.UNITY.equals(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends LinearCS> getInterface() {
        return LinearCS.class;
    }

    @Override
    public DefaultLinearCS forConvention(AxesConvention convention) {
        return (DefaultLinearCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 1: {
                return new DefaultLinearCS(this, name, axes);
            }
        }
        throw DefaultLinearCS.unexpectedDimension(axes, 1, 1);
    }

    private DefaultLinearCS() {
    }
}

