/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.config;

import java.util.function.Supplier;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.config.LogConfigurator;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class ConfigurationServiceFactory<S extends LogConfigurator>
implements ServiceFactory<S> {
    private final LogConfigManager logConfigManager;
    private final Supplier<S> svcSupplier;
    private int useCount;
    private S service;

    public ConfigurationServiceFactory(@NotNull LogConfigManager mgr, @NotNull Supplier<S> svcSupplier) {
        this.logConfigManager = mgr;
        this.svcSupplier = svcSupplier;
    }

    @NotNull
    public S getService(@NotNull Bundle bundle, @NotNull ServiceRegistration<S> registration) {
        if (this.service == null) {
            this.useCount = 1;
            this.service = (LogConfigurator)this.svcSupplier.get();
            ((LogConfigurator)this.service).setLogConfigManager(this.logConfigManager);
        } else {
            ++this.useCount;
        }
        return this.service;
    }

    public void ungetService(@NotNull Bundle bundle, @NotNull ServiceRegistration<S> registration, @NotNull S svc) {
        --this.useCount;
        if (this.useCount <= 0) {
            this.service = null;
            this.useCount = 0;
        }
    }
}

