/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.ActivityViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsItem;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsNodeIterator;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsNodeType;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsProperty;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsPropertyIterator;

public final class FsNode
extends FsItem
implements Node {
    public FsNode(ContentFile contentFile, ResourceResolver resolver) {
        super(contentFile, resolver);
    }

    private String getPrimaryTypeName() {
        return (String)this.props.get("jcr:primaryType", String.class);
    }

    private String[] getMixinTypeNames() {
        return (String[])this.props.get("jcr:mixinTypes", (Object)new String[0]);
    }

    public String getName() throws RepositoryException {
        if (this.contentFile.getSubPath() == null) {
            return ResourceUtil.getName((String)this.contentFile.getPath());
        }
        return ResourceUtil.getName((String)this.contentFile.getSubPath());
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.getNode(ResourceUtil.getParent((String)this.getPath()));
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        String subPath;
        ContentFile referencedFile;
        if (relPath == null) {
            throw new PathNotFoundException();
        }
        String path = relPath;
        if (!StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = ResourceUtil.normalize((String)(this.getPath() + "/" + relPath));
        }
        if ((StringUtils.equals((CharSequence)path, (CharSequence)this.contentFile.getPath()) || StringUtils.startsWith((CharSequence)path, (CharSequence)(this.contentFile.getPath() + "/"))) && (referencedFile = this.contentFile.navigateToAbsolute(subPath = StringUtils.equals((CharSequence)path, (CharSequence)this.contentFile.getPath()) ? null : path.substring(this.contentFile.getPath().length() + 1))).hasContent()) {
            return new FsNode(referencedFile, this.resolver);
        }
        Node refNode = null;
        Resource resource = this.resolver.getResource(path);
        if (resource != null && (refNode = (Node)resource.adaptTo(Node.class)) != null) {
            return refNode;
        }
        throw new PathNotFoundException(relPath);
    }

    public NodeIterator getNodes() throws RepositoryException {
        return new FsNodeIterator(this.contentFile, this.resolver);
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        if (this.props.containsKey((Object)relPath)) {
            return new FsProperty(this.contentFile, this.resolver, relPath, this);
        }
        throw new PathNotFoundException(relPath);
    }

    public PropertyIterator getProperties() throws RepositoryException {
        return new FsPropertyIterator(this.props.keySet().iterator(), this.contentFile, this.resolver, this);
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        String uuid = (String)this.props.get("jcr:uuid", String.class);
        if (uuid != null) {
            return uuid;
        }
        throw new UnsupportedRepositoryOperationException();
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        try {
            this.getNode(relPath);
            return true;
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        return this.props.containsKey((Object)relPath);
    }

    public boolean hasNodes() throws RepositoryException {
        return this.getNodes().hasNext();
    }

    public boolean hasProperties() throws RepositoryException {
        return !this.props.isEmpty();
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return StringUtils.equals((CharSequence)nodeTypeName, (CharSequence)this.getPrimaryTypeName());
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        return false;
    }

    public boolean isCheckedOut() throws RepositoryException {
        return false;
    }

    public boolean holdsLock() throws RepositoryException {
        return false;
    }

    public boolean isLocked() throws RepositoryException {
        return false;
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return new FsNodeType(this.getPrimaryTypeName(), false);
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        String[] mixinTypeNames = this.getMixinTypeNames();
        NodeType[] mixinTypes = new NodeType[mixinTypeNames.length];
        for (int i = 0; i < mixinTypeNames.length; ++i) {
            mixinTypes[i] = new FsNodeType(mixinTypeNames[i], true);
        }
        return mixinTypes;
    }

    public Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getReferences() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, ActivityViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void update(String srcWorkspace) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getIdentifier() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public int getIndex() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

