/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.Gauge;
import org.apache.sling.commons.metrics.MetricsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceResolverMetrics.class})
public class ResourceResolverMetrics {
    protected static final String METRICS_PREFIX = "org.apache.sling.resourceresolver";
    @Reference
    MetricsService metricsService;
    private static final Supplier<Long> ZERO_SUPPLIER = () -> 0L;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathsGauge;
    private Supplier<Long> numberOfVanityPathsSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfResourcesWithVanityPathsOnStartupGauge;
    private Supplier<Long> numberOfResourcesWithVanityPathsOnStartupSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathLookupsGauge;
    private Supplier<Long> numberOfVanityPathLookupsSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathBloomNegativesGauge;
    private Supplier<Long> numberOfVanityPathBloomNegativesSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathBloomFalsePositivesGauge;
    private Supplier<Long> numberOfVanityPathBloomFalsePositivesSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfResourcesWithAliasedChildrenGauge;
    private Supplier<Long> numberOfResourcesWithAliasedChildrenSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfResourcesWithAliasesOnStartupGauge;
    private Supplier<Long> numberOfResourcesWithAliasesOnStartupSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfDetectedInvalidAliasesGauge;
    private Supplier<Long> numberOfDetectedInvalidAliasesSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfDetectedConflictingAliasesGauge;
    private Supplier<Long> numberOfDetectedConflictingAliasesSupplier = ZERO_SUPPLIER;
    private Counter unclosedResourceResolvers;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.numberOfVanityPathsGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPaths", () -> this.numberOfVanityPathsSupplier);
        this.numberOfResourcesWithVanityPathsOnStartupGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfResourcesWithVanityPathsOnStartup", () -> this.numberOfResourcesWithVanityPathsOnStartupSupplier);
        this.numberOfVanityPathLookupsGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPathLookups", () -> this.numberOfVanityPathLookupsSupplier);
        this.numberOfVanityPathBloomNegativesGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPathBloomNegatives", () -> this.numberOfVanityPathBloomNegativesSupplier);
        this.numberOfVanityPathBloomFalsePositivesGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPathBloomFalsePositives", () -> this.numberOfVanityPathBloomFalsePositivesSupplier);
        this.numberOfResourcesWithAliasedChildrenGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfResourcesWithAliasedChildren", () -> this.numberOfResourcesWithAliasedChildrenSupplier);
        this.numberOfResourcesWithAliasesOnStartupGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfResourcesWithAliasesOnStartup", () -> this.numberOfResourcesWithAliasesOnStartupSupplier);
        this.numberOfDetectedInvalidAliasesGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfDetectedInvalidAliases", () -> this.numberOfDetectedInvalidAliasesSupplier);
        this.numberOfDetectedConflictingAliasesGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfDetectedConflictingAliases", () -> this.numberOfDetectedConflictingAliasesSupplier);
        this.unclosedResourceResolvers = this.metricsService.counter("org.apache.sling.resourceresolver.unclosedResourceResolvers");
    }

    @Deactivate
    protected void deactivate() {
        this.numberOfVanityPathsGauge.unregister();
        this.numberOfResourcesWithVanityPathsOnStartupGauge.unregister();
        this.numberOfVanityPathLookupsGauge.unregister();
        this.numberOfVanityPathBloomNegativesGauge.unregister();
        this.numberOfVanityPathBloomFalsePositivesGauge.unregister();
        this.numberOfResourcesWithAliasedChildrenGauge.unregister();
        this.numberOfResourcesWithAliasesOnStartupGauge.unregister();
        this.numberOfDetectedInvalidAliasesGauge.unregister();
        this.numberOfDetectedConflictingAliasesGauge.unregister();
    }

    public void setNumberOfVanityPathsSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathsSupplier = supplier;
    }

    public void setNumberOfResourcesWithVanityPathsOnStartupSupplier(Supplier<Long> supplier) {
        this.numberOfResourcesWithVanityPathsOnStartupSupplier = supplier;
    }

    public void setNumberOfVanityPathLookupsSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathLookupsSupplier = supplier;
    }

    public void setNumberOfVanityPathBloomNegativesSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathBloomNegativesSupplier = supplier;
    }

    public void setNumberOfVanityPathBloomFalsePositivesSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathBloomFalsePositivesSupplier = supplier;
    }

    public void setNumberOfResourcesWithAliasedChildrenSupplier(Supplier<Long> supplier) {
        this.numberOfResourcesWithAliasedChildrenSupplier = supplier;
    }

    public void setNumberOfResourcesWithAliasesOnStartupSupplier(Supplier<Long> supplier) {
        this.numberOfResourcesWithAliasesOnStartupSupplier = supplier;
    }

    public void setNumberOfDetectedInvalidAliasesSupplier(Supplier<Long> supplier) {
        this.numberOfDetectedInvalidAliasesSupplier = supplier;
    }

    public void setNumberOfDetectedConflictingAliasesSupplier(Supplier<Long> supplier) {
        this.numberOfDetectedConflictingAliasesSupplier = supplier;
    }

    public void reportUnclosedResourceResolver() {
        this.unclosedResourceResolvers.increment();
    }

    private ServiceRegistration<Gauge<Long>> registerGauge(BundleContext context, String name, Supplier<Supplier<Long>> supplier) {
        ResourceResolverGauge gauge = new ResourceResolverGauge(supplier);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("name", name);
        return context.registerService(Gauge.class, (Object)gauge, props);
    }

    public class ResourceResolverGauge
    implements Gauge<Long> {
        Supplier<Supplier<Long>> supplier;

        public ResourceResolverGauge(Supplier<Supplier<Long>> supplier) {
            this.supplier = supplier;
        }

        public Long getValue() {
            return this.supplier.get().get();
        }
    }
}

