/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class QueryFormatter {
    public static boolean isXPath(String query, String language) {
        if (language != null) {
            return "xpath".equals(language);
        }
        if ((query = query.trim().toLowerCase(Locale.ENGLISH)).startsWith("explain") && (query = query.substring("explain".length()).trim()).startsWith("measure")) {
            query = query.substring("measure".length()).trim();
        }
        while (query.startsWith("(")) {
            query = query.substring("(".length()).trim();
        }
        return !query.startsWith("select");
    }

    public static String format(@NotNull String query, String language) {
        boolean xpath = QueryFormatter.isXPath(query, language);
        if (xpath) {
            return QueryFormatter.formatXPath(query);
        }
        return QueryFormatter.formatSQL(query);
    }

    private static String formatXPath(String query) {
        StringBuilder buff = new StringBuilder(query);
        for (int i = 0; i < buff.length(); ++i) {
            String sub;
            char c = buff.charAt(i);
            if (c == '\'' || c == '\"') {
                while (++i < buff.length() && buff.charAt(i) != c) {
                }
                continue;
            }
            if (c == '[') {
                if (i + 1 >= buff.length() || buff.charAt(i + 1) <= ' ') continue;
                buff.insert(i + 1, "\n  ");
                i += 3;
                continue;
            }
            if (c == '\n') {
                while (++i < buff.length() && buff.charAt(i) == ' ') {
                }
                --i;
                continue;
            }
            if (c != ' ' || !(sub = buff.substring(i, Math.min(i + 10, buff.length()))).startsWith(" and ") && !sub.startsWith(" or ") && !sub.startsWith(" order by ") && !sub.startsWith(" option(")) continue;
            buff.setCharAt(i, '\n');
            buff.insert(i + 1, "  ");
            i += 2;
        }
        return buff.toString();
    }

    private static String formatSQL(String query) {
        StringBuilder buff = new StringBuilder(query);
        for (int i = 0; i < buff.length(); ++i) {
            String sub;
            char c = buff.charAt(i);
            if (c == '\'' || c == '\"') {
                while (++i < buff.length() && buff.charAt(i) != c) {
                }
                continue;
            }
            if (c == '\n') {
                while (++i < buff.length() && buff.charAt(i) == ' ') {
                }
                --i;
                continue;
            }
            if (c != ' ' || !QueryFormatter.startsWithIgnoreCase(sub = buff.substring(i, Math.min(i + 10, buff.length())), " and ") && !QueryFormatter.startsWithIgnoreCase(sub, " or ") && !QueryFormatter.startsWithIgnoreCase(sub, " union ") && !QueryFormatter.startsWithIgnoreCase(sub, " from ") && !QueryFormatter.startsWithIgnoreCase(sub, " where ") && !QueryFormatter.startsWithIgnoreCase(sub, " order by ") && !QueryFormatter.startsWithIgnoreCase(sub, " option(")) continue;
            buff.setCharAt(i, '\n');
            buff.insert(i + 1, "  ");
            i += 2;
        }
        return buff.toString();
    }

    private static boolean startsWithIgnoreCase(String s, String prefix) {
        return s.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

