/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.security.authorization.restriction.GlobPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GlobsPattern
implements RestrictionPattern {
    private final GlobPattern[] patterns;

    GlobsPattern(@NotNull String path, @NotNull Iterable<String> restrictions) {
        ArrayList l = new ArrayList(IterableUtils.size(restrictions));
        restrictions.forEach(restriction -> {
            if (restriction != null) {
                l.add(GlobPattern.create(path, restriction));
            }
        });
        this.patterns = l.toArray(new GlobPattern[0]);
    }

    @Override
    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        String itemPath = property == null ? tree.getPath() : PathUtils.concat(tree.getPath(), property.getName());
        return this.matches(itemPath);
    }

    @Override
    public boolean matches(@NotNull String path) {
        for (GlobPattern gp : this.patterns) {
            if (!gp.matches(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.patterns);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GlobsPattern) {
            GlobsPattern other = (GlobsPattern)obj;
            return Arrays.equals(this.patterns, other.patterns);
        }
        return false;
    }
}

