/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutablePrivilegeDefinition
implements PrivilegeDefinition {
    private final String name;
    private final boolean isAbstract;
    private final Set<String> declaredAggregateNames;
    private final int hashcode;

    public ImmutablePrivilegeDefinition(@NotNull String name, boolean isAbstract, @Nullable Iterable<String> declaredAggregateNames) {
        this.name = name;
        this.isAbstract = isAbstract;
        this.declaredAggregateNames = declaredAggregateNames != null ? Collections.unmodifiableSet(SetUtils.toLinkedSet(declaredAggregateNames)) : Set.of();
        this.hashcode = Objects.hash(this.name, this.isAbstract, this.declaredAggregateNames);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    @NotNull
    public Set<String> getDeclaredAggregateNames() {
        return this.declaredAggregateNames;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutablePrivilegeDefinition) {
            ImmutablePrivilegeDefinition other = (ImmutablePrivilegeDefinition)o;
            return this.name.equals(other.name) && this.isAbstract == other.isAbstract && this.declaredAggregateNames.equals(other.declaredAggregateNames);
        }
        return false;
    }

    public String toString() {
        return "PrivilegeDefinition: " + this.name;
    }
}

