/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.IAdvancedFSOps;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedFSOps
implements IAdvancedFSOps {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedFSOps.class);
    protected final boolean symlinksDisabled;

    protected AdvancedFSOps(Map<String, Object> conf) {
        this.symlinksDisabled = (Boolean)conf.getOrDefault("storm.disable.symlinks", false);
    }

    public static AdvancedFSOps make(Map<String, Object> conf) {
        if (Utils.isOnWindows()) {
            return new AdvancedWindowsFSOps(conf);
        }
        if (ObjectReader.getBoolean(conf.get("supervisor.run.worker.as.user"), false)) {
            return new AdvancedRunAsUserFSOps(conf);
        }
        return new AdvancedFSOps(conf);
    }

    @Override
    public void restrictDirectoryPermissions(File dir) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE));
        Files.setPosixFilePermissions(dir.toPath(), perms);
    }

    @Override
    public void moveDirectoryPreferAtomic(File fromDir, File toDir) throws IOException {
        FileUtils.forceMkdir((File)toDir);
        Files.move(fromDir.toPath(), toDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public void moveFile(File fromFile, File toFile) throws IOException {
        Files.move(fromFile.toPath(), toFile.toPath(), new CopyOption[0]);
    }

    @Override
    public boolean supportsAtomicDirectoryMove() {
        return true;
    }

    @Override
    public void copyDirectory(File fromDir, File toDir) throws IOException {
        FileUtils.copyDirectory((File)fromDir, (File)toDir);
    }

    @Override
    public void setupBlobPermissions(File path, String user) throws IOException {
    }

    @Override
    public void deleteIfExists(File path, String user, String logPrefix) throws IOException {
        this.deleteIfExists(path);
    }

    @Override
    public void deleteIfExists(File path) throws IOException {
        LOG.info("Deleting path {}", (Object)path);
        Path p = path.toPath();
        if (Files.exists(p, new LinkOption[0])) {
            try {
                FileUtils.forceDelete((File)path);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setupStormCodeDir(String user, File path) throws IOException {
    }

    @Override
    public void setupWorkerArtifactsDir(String user, File path) throws IOException {
    }

    @Override
    public boolean doRequiredTopoFilesExist(Map<String, Object> conf, String topologyId) throws IOException {
        return ClientSupervisorUtils.doRequiredTopoFilesExist(conf, topologyId);
    }

    @Override
    public void forceMkdir(File path) throws IOException {
        FileUtils.forceMkdir((File)path);
    }

    @Override
    public void forceMkdir(Path path) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return Files.newDirectoryStream(dir, filter);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir) throws IOException {
        return Files.newDirectoryStream(dir);
    }

    @Override
    public boolean fileExists(File path) throws IOException {
        return path.exists();
    }

    @Override
    public boolean fileExists(Path path) throws IOException {
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public Writer getWriter(File file) throws IOException {
        return new FileWriter(file);
    }

    @Override
    public OutputStream getOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    @Override
    public void dump(File location, String data) throws IOException {
        File parent = location.getParentFile();
        if (!parent.exists()) {
            this.forceMkdir(parent);
        }
        try (Writer w = this.getWriter(location);){
            w.write(data);
        }
    }

    @Override
    public String slurpString(File location) throws IOException {
        return FileUtils.readFileToString((File)location, (String)"UTF-8");
    }

    @Override
    public byte[] slurp(File location) throws IOException {
        return FileUtils.readFileToByteArray((File)location);
    }

    @Override
    public void createSymlink(File link, File target) throws IOException {
        if (this.symlinksDisabled) {
            throw new IOException("Symlinks have been disabled, this should not be called");
        }
        Path plink = link.toPath().toAbsolutePath();
        Path ptarget = target.toPath().toAbsolutePath();
        LOG.debug("Creating symlink [{}] to [{}]", (Object)plink, (Object)ptarget);
        if (Files.exists(plink, new LinkOption[0])) {
            if (Files.isSameFile(plink, ptarget)) {
                return;
            }
            FileUtils.forceDelete((File)link);
        }
        Files.createSymbolicLink(plink, ptarget, new FileAttribute[0]);
    }

    private static class AdvancedWindowsFSOps
    extends AdvancedFSOps {
        AdvancedWindowsFSOps(Map<String, Object> conf) {
            super(conf);
            if (ObjectReader.getBoolean(conf.get("supervisor.run.worker.as.user"), false)) {
                throw new RuntimeException("ERROR: Windows doesn't support running workers as different users yet");
            }
        }

        @Override
        public void restrictDirectoryPermissions(File dir) throws IOException {
        }

        @Override
        public void moveDirectoryPreferAtomic(File fromDir, File toDir) throws IOException {
            FileUtils.moveDirectory((File)fromDir, (File)toDir);
        }

        @Override
        public boolean supportsAtomicDirectoryMove() {
            return false;
        }
    }

    private static class AdvancedRunAsUserFSOps
    extends AdvancedFSOps {
        private final Map<String, Object> conf;

        AdvancedRunAsUserFSOps(Map<String, Object> conf) {
            super(conf);
            if (Utils.isOnWindows()) {
                throw new UnsupportedOperationException("ERROR: Windows doesn't support running workers as different users yet");
            }
            this.conf = conf;
        }

        @Override
        public void setupBlobPermissions(File path, String user) throws IOException {
            String logPrefix = "setup blob permissions for " + String.valueOf(path);
            ClientSupervisorUtils.processLauncherAndWait(this.conf, user, Arrays.asList("blob", path.toString()), null, logPrefix);
        }

        @Override
        public void deleteIfExists(File path, String user, String logPrefix) throws IOException {
            String absolutePath = path.getAbsolutePath();
            if (Utils.checkFileExists(absolutePath)) {
                LOG.info("Deleting path (runAsUser) {}", (Object)absolutePath);
                if (user == null) {
                    user = Files.getOwner(path.toPath(), new LinkOption[0]).getName();
                }
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("rmr");
                commands.add(absolutePath);
                ClientSupervisorUtils.processLauncherAndWait(this.conf, user, commands, null, logPrefix);
                if (Utils.checkFileExists(absolutePath)) {
                    Utils.forceDelete(absolutePath);
                    if (Utils.checkFileExists(absolutePath)) {
                        throw new RuntimeException(String.valueOf(path) + " was not deleted.");
                    }
                }
            }
        }

        @Override
        public void deleteIfExists(File path) throws IOException {
            this.deleteIfExists(path, null, "UNNAMED");
        }

        @Override
        public void setupStormCodeDir(String user, File path) throws IOException {
            ClientSupervisorUtils.setupStormCodeDir(this.conf, user, path.getCanonicalPath());
        }

        @Override
        public void setupWorkerArtifactsDir(String user, File path) throws IOException {
            ClientSupervisorUtils.setupWorkerArtifactsDir(this.conf, user, path.getCanonicalPath());
        }
    }
}

