/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.normalization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ResourceNameNormalizer {
    private final Map<String, String> resourceNameMapping;

    public ResourceNameNormalizer() {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("topology.component.cpu.pcore.percent", "cpu.pcore.percent");
        tmp.put("supervisor.cpu.capacity", "cpu.pcore.percent");
        tmp.put("topology.component.resources.onheap.memory.mb", "onheap.memory.mb");
        tmp.put("topology.component.resources.offheap.memory.mb", "offheap.memory.mb");
        tmp.put("supervisor.memory.capacity.mb", "memory.mb");
        this.resourceNameMapping = Collections.unmodifiableMap(tmp);
    }

    public Map<String, Double> normalizedResourceMap(Map<String, ? extends Number> resourceMap) {
        if (resourceMap == null) {
            return new HashMap<String, Double>();
        }
        return new HashMap<String, Double>(resourceMap.entrySet().stream().collect(Collectors.toMap(e -> this.resourceNameMapping.getOrDefault(e.getKey(), (String)e.getKey()), e -> ((Number)e.getValue()).doubleValue())));
    }

    public Map<String, String> getResourceNameMapping() {
        return this.resourceNameMapping;
    }
}

