/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.ILocalCluster;
import org.apache.storm.Testing;
import org.apache.storm.Thrift;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.testing.BoltTracker;
import org.apache.storm.testing.SpoutTracker;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.utils.RegisteredGlobalState;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackedTopology {
    private static final Logger LOG = LoggerFactory.getLogger(TrackedTopology.class);
    private final StormTopology topology;
    private final AtomicInteger lastSpoutCommit;
    private final ILocalCluster cluster;

    public TrackedTopology(StormTopology origTopo, ILocalCluster cluster) {
        IRichBolt obj;
        LOG.warn("CLUSTER {} - {}", (Object)cluster, (Object)cluster.getTrackedId());
        this.cluster = cluster;
        this.lastSpoutCommit = new AtomicInteger(0);
        String id = cluster.getTrackedId();
        this.topology = origTopo.deepCopy();
        for (Bolt bolt : this.topology.get_bolts().values()) {
            obj = (IRichBolt)Thrift.deserializeComponentObject((ComponentObject)bolt.get_bolt_object());
            bolt.set_bolt_object(Thrift.serializeComponentObject((Object)new BoltTracker(obj, id)));
        }
        for (SpoutSpec spout : this.topology.get_spouts().values()) {
            obj = (IRichSpout)Thrift.deserializeComponentObject((ComponentObject)spout.get_spout_object());
            spout.set_spout_object(Thrift.serializeComponentObject((Object)new SpoutTracker((IRichSpout)obj, id)));
        }
    }

    private static int globalAmt(String id, String key) {
        LOG.warn("Reading tracked metrics for ID {}", (Object)id);
        return ((AtomicInteger)((ConcurrentHashMap)RegisteredGlobalState.getState((String)id)).get(key)).get();
    }

    public StormTopology getTopology() {
        return this.topology;
    }

    public ILocalCluster getCluster() {
        return this.cluster;
    }

    public void trackedWait() {
        this.trackedWait(1, Testing.TEST_TIMEOUT_MS);
    }

    public void trackedWait(int amt) {
        this.trackedWait(amt, Testing.TEST_TIMEOUT_MS);
    }

    public void trackedWait(int amt, int timeoutMs) {
        int target = amt + this.lastSpoutCommit.get();
        String id = this.cluster.getTrackedId();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        Testing.whileTimeout(timeoutMs, () -> {
            int se = TrackedTopology.globalAmt(id, "spout-emitted");
            int transferred = TrackedTopology.globalAmt(id, "transferred");
            int processed = TrackedTopology.globalAmt(id, "processed");
            LOG.info("emitted {} target {} transferred {} processed {}", new Object[]{se, target, transferred, processed});
            return target != se || transferred != processed;
        }, () -> {
            Time.advanceTimeSecs((long)1L);
            try {
                Thread.sleep(rand.nextInt(200));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.lastSpoutCommit.set(target);
    }

    public int globalAmt(String key) {
        return TrackedTopology.globalAmt(this.cluster.getTrackedId(), key);
    }
}

