/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class LocalizedNameGenerator
implements Iterator<String>,
Iterable<String> {
    private final int baseNameLength;
    private final String suffix;
    private final StringBuilder builder;
    private final String language;
    private final String country;
    private final String variant;
    private int state;
    private int prevState;
    private static final int INITIAL = 0;
    private static final int LCV = 1;
    private static final int LC = 2;
    private static final int LV = 3;
    private static final int L = 4;
    private static final int BARE = 5;
    private static final int EXHAUSTED = 6;

    public LocalizedNameGenerator(String path, Locale locale) {
        assert (InternalUtils.isNonBlank(path));
        assert (locale != null);
        int dotx = path.lastIndexOf(46);
        if (dotx == -1) {
            dotx = path.length();
        }
        String baseName = path.substring(0, dotx);
        this.suffix = path.substring(dotx);
        this.baseNameLength = dotx;
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
        this.variant = locale.getVariant();
        this.state = 0;
        this.prevState = 0;
        this.builder = new StringBuilder(baseName);
        this.advance();
    }

    private void advance() {
        this.prevState = this.state;
        block6: while (this.state != 6) {
            ++this.state;
            switch (this.state) {
                case 1: {
                    if (InternalUtils.isBlank(this.variant)) continue block6;
                    return;
                }
                case 2: {
                    if (InternalUtils.isBlank(this.country)) continue block6;
                    return;
                }
                case 3: {
                    if (InternalUtils.isBlank(this.variant) || InternalUtils.isBlank(this.country)) continue block6;
                    return;
                }
                case 4: {
                    if (InternalUtils.isBlank(this.language)) continue block6;
                    return;
                }
            }
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.state != 6;
    }

    @Override
    public String next() {
        if (this.state == 6) {
            throw new NoSuchElementException();
        }
        String result = this.build();
        this.advance();
        return result;
    }

    private String build() {
        this.builder.setLength(this.baseNameLength);
        if (this.state == 2 || this.state == 1 || this.state == 4 || this.state == 3) {
            this.builder.append('_');
            this.builder.append(this.language);
        }
        if (this.state == 2 || this.state == 1 || this.state == 3) {
            this.builder.append('_');
            if (this.state != 3) {
                this.builder.append(this.country);
            }
        }
        if (this.state == 3 || this.state == 1) {
            this.builder.append('_');
            this.builder.append(this.variant);
        }
        if (this.suffix != null) {
            this.builder.append(this.suffix);
        }
        return this.builder.toString();
    }

    public Locale getCurrentLocale() {
        switch (this.prevState) {
            case 1: {
                return new Locale(this.language, this.country, this.variant);
            }
            case 2: {
                return new Locale(this.language, this.country, "");
            }
            case 3: {
                return new Locale(this.language, "", this.variant);
            }
            case 4: {
                return new Locale(this.language, "", "");
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

