/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.util.ArrayList;
import opennlp.tools.langdetect.LanguageDetectorContextGenerator;
import opennlp.tools.ngram.NGramCharModel;
import opennlp.tools.util.normalizer.AggregateCharSequenceNormalizer;
import opennlp.tools.util.normalizer.CharSequenceNormalizer;

public class DefaultLanguageDetectorContextGenerator
implements LanguageDetectorContextGenerator {
    protected final int minLength;
    protected final int maxLength;
    protected final CharSequenceNormalizer normalizer;

    public DefaultLanguageDetectorContextGenerator(int minLength, int maxLength, CharSequenceNormalizer ... normalizers) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.normalizer = new AggregateCharSequenceNormalizer(normalizers);
    }

    @Override
    public String[] getContext(CharSequence document) {
        ArrayList<String> context = new ArrayList<String>();
        NGramCharModel model = new NGramCharModel();
        model.add(this.normalizer.normalize(document), this.minLength, this.maxLength);
        for (String token : model) {
            context.add(token);
        }
        return context.toArray(new String[0]);
    }
}

