/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.MessageObserver;

class ClientMessageObserver
implements MessageObserver {
    private ClientConfiguration cfg;
    private ClassLoader loader;

    ClientMessageObserver(ClientConfiguration cfg) {
        this.cfg = cfg;
        this.loader = cfg.getBus().getExtension(ClassLoader.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message m) {
        Message message = this.cfg.getConduitSelector().getEndpoint().getBinding().createMessage(m);
        message.put("org.apache.cxf.client", Boolean.TRUE);
        message.put("org.apache.cxf.message.inbound", Boolean.TRUE);
        PhaseInterceptorChain chain = AbstractClient.setupInInterceptorChain(this.cfg);
        message.setInterceptorChain(chain);
        message.getExchange().setInMessage(message);
        Bus bus = this.cfg.getBus();
        Bus origBus = BusFactory.getAndSetThreadDefaultBus(bus);
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader(this.loader);
            }
            chain.doIntercept(message);
        }
        finally {
            if (origBus != bus) {
                BusFactory.setThreadDefaultBus(origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().notifyAll();
            }
        }
    }
}

