/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gco;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.Namespaces;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.cat.CodeListUID;
import org.apache.sis.xml.bind.gco.GO_URL;
import org.apache.sis.xml.bind.gco.StringAdapter;
import org.apache.sis.xml.bind.gcx.Anchor;
import org.apache.sis.xml.bind.gcx.FileName;
import org.apache.sis.xml.bind.gcx.MimeFileType;
import org.apache.sis.xml.bind.lan.Country;
import org.apache.sis.xml.bind.lan.LanguageCode;
import org.apache.sis.xml.bind.lan.PT_FreeText;
import org.opengis.util.CodeList;
import org.w3c.dom.Element;

@XmlType(name="CharacterString_PropertyType")
@XmlSeeAlso(value={PT_FreeText.class, LanguageCode.class, Country.class})
@XmlRootElement(name="CharacterString")
public class GO_CharacterString {
    public static final byte MIME_TYPE = 1;
    public static final byte FILENAME = 3;
    public static final byte URL = 2;
    private static final byte ANCHOR = 4;
    private static final byte ENUM = 5;
    private CharSequence text;
    public byte type;

    private static String nameOf(byte type) {
        switch (type) {
            case 0: {
                return "CharacterString";
            }
            case 1: {
                return "MimeFileType";
            }
            case 3: {
                return "FileName";
            }
            case 4: {
                return "Anchor";
            }
            case 5: {
                return "ControlledVocabulary";
            }
            case 2: {
                return "URL";
            }
        }
        throw new AssertionError(type);
    }

    public GO_CharacterString() {
    }

    protected GO_CharacterString(CharSequence text) {
        this.text = text;
        if (text instanceof Anchor) {
            this.type = (byte)4;
        } else if (Types.forCodeTitle(text) != null) {
            this.type = (byte)5;
        }
    }

    private void setText(CharSequence value, byte property) {
        if ((value = CharSequences.trimWhitespaces(value)) != null && value.length() != 0) {
            if (this.text != null && !value.equals(this.text)) {
                byte discarded = this.type;
                boolean noset = false;
                if (discarded > property) {
                    discarded = property;
                    property = this.type;
                    noset = true;
                }
                Context.warningOccured(Context.current(), this.getClass(), "setText", Messages.class, (short)19, GO_CharacterString.nameOf(discarded), GO_CharacterString.nameOf(property));
                if (noset) {
                    return;
                }
            }
            this.text = value;
            this.type = property;
        }
    }

    @XmlElements(value={@XmlElement(type=String.class, name="CharacterString"), @XmlElement(type=Anchor.class, name="Anchor", namespace="http://standards.iso.org/iso/19115/-3/gcx/1.0"), @XmlElement(type=FileName.class, name="FileName", namespace="http://standards.iso.org/iso/19115/-3/gcx/1.0"), @XmlElement(type=MimeFileType.class, name="MimeFileType", namespace="http://standards.iso.org/iso/19115/-3/gcx/1.0"), @XmlElement(type=GO_URL.class, name="URL", namespace="http://www.isotc211.org/2005/gmd")})
    public Object getValue() {
        switch (this.type) {
            case 0: {
                return StringAdapter.toString(this.text);
            }
            case 2: {
                return new GO_URL(this.text.toString());
            }
            case 3: {
                return new FileName(this.text.toString());
            }
            case 1: {
                return new MimeFileType(this.text.toString());
            }
            case 4: {
                return this.text;
            }
        }
        return null;
    }

    public void setValue(Object value) {
        if (value instanceof Anchor) {
            this.setText((Anchor)value, (byte)4);
        } else if (value instanceof FileName) {
            this.setText(value.toString(), (byte)3);
        } else if (value instanceof MimeFileType) {
            this.setText(value.toString(), (byte)1);
        } else if (value instanceof GO_URL) {
            this.setText(value.toString(), (byte)2);
        } else {
            this.setText((CharSequence)value, (byte)0);
        }
    }

    @XmlAnyElement
    public Object getCodeList() {
        if (this.type != 5) {
            return null;
        }
        CodeList<?> code = Types.forCodeTitle(this.text);
        String name = Types.getListName(code);
        String namespace = Namespaces.guessForType(name);
        if (namespace == null) {
            namespace = "";
        }
        return new JAXBElement<CodeListUID>(new QName(namespace, name), CodeListUID.class, new CodeListUID(Context.current(), code));
    }

    public void setCodeList(Object value) {
        Element e = (Element)value;
        if (e.getNodeType() == 1) {
            Object[] args;
            short errorKey;
            Class resources;
            Class<?> ct = Types.forStandardName(e.getLocalName());
            if (ct != null && CodeList.class.isAssignableFrom(ct)) {
                String attribute = e.getAttribute("codeListValue").trim();
                if (!attribute.isEmpty()) {
                    Object c = Types.forCodeName(ct, attribute, true);
                    this.text = Types.getCodeTitle(c);
                    this.type = (byte)5;
                    return;
                }
                resources = Errors.class;
                errorKey = 182;
                args = new Object[2];
                args[1] = "codeListValue";
            } else {
                resources = Messages.class;
                errorKey = 33;
                args = new Object[]{e.getNodeName()};
            }
            Context.warningOccured(Context.current(), GO_CharacterString.class, "setCodeList", resources, errorKey, args);
        }
    }

    protected CharSequence toCharSequence() {
        CharSequence text = CharSequences.trimWhitespaces(this.text);
        if (text != null && (text.length() != 0 || text instanceof Anchor)) {
            return text;
        }
        return null;
    }

    public final String toString() {
        CharSequence text = this.text;
        return text != null ? text.toString() : null;
    }
}

