/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import jakarta.resource.NotSupportedException;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkAdapter;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkContextProvider;
import jakarta.resource.spi.work.WorkEvent;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkRejectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.geronimo.connector.work.WorkContextHandler;

public class WorkerContext
implements Work {
    private static final Logger log = Logger.getLogger(WorkerContext.class.getName());
    private static final List<WorkContext> NO_INFLOW_CONTEXT = Collections.emptyList();
    private static final WorkListener NULL_WORK_LISTENER = new WorkAdapter(){

        public void workRejected(WorkEvent event) {
            if (event.getException() != null) {
                if (event.getException() instanceof WorkCompletedException && event.getException().getCause() != null) {
                    log.log(Level.SEVERE, event.getWork().toString(), event.getException().getCause());
                } else {
                    log.log(Level.SEVERE, event.getWork().toString(), (Throwable)event.getException());
                }
            }
        }
    };
    private int threadPriority;
    private Work adaptee;
    private boolean isAccepted;
    private long acceptedTime;
    private int nbRetry;
    private long startTimeOut;
    private final WorkListener workListener;
    private WorkException workException;
    private CountDownLatch startLatch = new CountDownLatch(1);
    private CountDownLatch endLatch = new CountDownLatch(1);
    private final ExecutionContext executionContext;
    private final List<WorkContextHandler> workContextHandlers;

    public WorkerContext(Work work, Collection<WorkContextHandler> workContextHandlers) {
        this.adaptee = work;
        this.workContextHandlers = new ArrayList<WorkContextHandler>(workContextHandlers);
        this.executionContext = null;
        this.workListener = NULL_WORK_LISTENER;
    }

    public WorkerContext(Work aWork, long aStartTimeout, ExecutionContext execContext, WorkListener workListener, Collection<WorkContextHandler> workContextHandlers) throws WorkRejectedException {
        this.adaptee = aWork;
        this.startTimeOut = aStartTimeout;
        this.workListener = null == workListener ? NULL_WORK_LISTENER : workListener;
        if (aWork instanceof WorkContextProvider) {
            if (execContext != null) {
                throw new WorkRejectedException("Execution context provided but Work implements WorkContextProvider");
            }
            this.executionContext = null;
        } else {
            this.executionContext = execContext;
        }
        this.workContextHandlers = new ArrayList<WorkContextHandler>(workContextHandlers);
    }

    public void release() {
        this.adaptee.release();
    }

    public void setThreadPriority(int aPriority) {
        this.threadPriority = aPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void workAccepted(Object anObject) {
        this.isAccepted = true;
        this.acceptedTime = System.currentTimeMillis();
        this.workListener.workAccepted(new WorkEvent(anObject, 1, this.adaptee, null));
    }

    public synchronized long getAcceptedTime() {
        return this.acceptedTime;
    }

    public long getStartTimeout() {
        return this.startTimeOut;
    }

    public synchronized boolean isTimedOut() {
        boolean isTimeout;
        assert (this.isAccepted) : "The work is not accepted.";
        if (0L == this.startTimeOut || this.startTimeOut == Long.MAX_VALUE) {
            return false;
        }
        boolean bl = isTimeout = this.acceptedTime + this.startTimeOut > 0L && System.currentTimeMillis() > this.acceptedTime + this.startTimeOut;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this + " accepted at " + this.acceptedTime + (isTimeout ? " has timed out." : " has not timed out. ") + this.nbRetry + " retries have been performed.");
        }
        if (isTimeout) {
            this.workException = new WorkRejectedException(this + " has timed out.", "1");
            this.workListener.workRejected(new WorkEvent((Object)this, 2, this.adaptee, this.workException));
            return true;
        }
        ++this.nbRetry;
        return isTimeout;
    }

    public synchronized WorkException getWorkException() {
        return this.workException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void run() {
        if (this.isTimedOut()) {
            this.startLatch.countDown();
            this.endLatch.countDown();
            return;
        }
        this.workListener.workStarted(new WorkEvent((Object)this, 3, this.adaptee, null));
        this.startLatch.countDown();
        try {
            List<TransactionContext> workContexts = NO_INFLOW_CONTEXT;
            if (this.executionContext != null) {
                TransactionContext txWorkContext = new TransactionContext();
                try {
                    txWorkContext.setTransactionTimeout(this.executionContext.getTransactionTimeout());
                }
                catch (NotSupportedException notSupportedException) {
                    // empty catch block
                }
                txWorkContext.setXid(this.executionContext.getXid());
                workContexts = Collections.singletonList(txWorkContext);
                log.info("Translated ExecutionContext to TransactionContext");
            } else if (this.adaptee instanceof WorkContextProvider) {
                workContexts = ((WorkContextProvider)this.adaptee).getWorkContexts();
            }
            ArrayList<WorkContextHandler> sortedHandlers = new ArrayList<WorkContextHandler>(workContexts.size());
            for (WorkContext workContext : workContexts) {
                boolean bl = false;
                Iterator<WorkContextHandler> iterator = this.workContextHandlers.iterator();
                while (iterator.hasNext()) {
                    WorkContextHandler workContextHandler = iterator.next();
                    log.info("sorting WorkContextHandler: " + workContextHandler + " for work context: " + workContext);
                    if (!workContextHandler.supports(workContext.getClass())) continue;
                    iterator.remove();
                    log.info("adding sorted WorkContextHandler: " + workContextHandler);
                    sortedHandlers.add(workContextHandler);
                    bl = true;
                    break;
                }
                if (bl) continue;
                for (WorkContextHandler workContextHandler : sortedHandlers) {
                    if (!workContextHandler.supports(workContext.getClass())) continue;
                    throw new WorkCompletedException("Duplicate WorkContext: " + workContext, "2");
                }
                throw new WorkCompletedException("Unhandled WorkContext: " + workContext, "1");
            }
            Iterator<WorkContextHandler> it = this.workContextHandlers.iterator();
            while (it.hasNext()) {
                WorkContextHandler workContextHandler = it.next();
                if (workContextHandler.required()) continue;
                log.info("Removing non-required WorkContextHandler with no context: " + workContextHandler);
                it.remove();
            }
            int i = 0;
            for (WorkContext workContext : workContexts) {
                WorkContextHandler workContextHandler = (WorkContextHandler)sortedHandlers.get(i++);
                log.info("calling before on WorkContextHandler: " + workContextHandler + " with workContext: " + workContext);
                workContextHandler.before(workContext);
            }
            for (WorkContextHandler workContextHandler : this.workContextHandlers) {
                log.info("calling before on WorkContextHandler: " + workContextHandler + " with null workContext");
                workContextHandler.before(null);
            }
            try {
                this.adaptee.run();
                boolean bl = false;
            }
            catch (Throwable throwable) {
                int j = 0;
                for (WorkContext workContext : workContexts) {
                    WorkContextHandler contextHandler = (WorkContextHandler)sortedHandlers.get(j++);
                    log.info("calling after on WorkContextHandler: " + contextHandler + " with workContext: " + workContext);
                    contextHandler.after(workContext);
                }
                for (WorkContextHandler workContextHandler : this.workContextHandlers) {
                    log.info("calling after on WorkContextHandler: " + workContextHandler + " with null workContext");
                    workContextHandler.after(null);
                }
                throw throwable;
            }
            for (WorkContext workContext : workContexts) {
                void var4_13;
                WorkContextHandler contextHandler = (WorkContextHandler)sortedHandlers.get((int)(++var4_13));
                log.info("calling after on WorkContextHandler: " + contextHandler + " with workContext: " + workContext);
                contextHandler.after(workContext);
            }
            for (WorkContextHandler workContextHandler : this.workContextHandlers) {
                log.info("calling after on WorkContextHandler: " + workContextHandler + " with null workContext");
                workContextHandler.after(null);
            }
            this.workListener.workCompleted(new WorkEvent((Object)this, 4, this.adaptee, null));
        }
        catch (Throwable e) {
            this.workException = (WorkException)(e instanceof WorkCompletedException ? e : new WorkCompletedException("Unknown error", "0").initCause(e));
            this.workListener.workCompleted(new WorkEvent((Object)this, 2, this.adaptee, this.workException));
        }
        finally {
            this.endLatch.countDown();
        }
    }

    public synchronized CountDownLatch provideStartLatch() {
        return this.startLatch;
    }

    public synchronized CountDownLatch provideEndLatch() {
        return this.endLatch;
    }

    public String toString() {
        return "Work :" + this.adaptee;
    }
}

