/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.jwk;

import io.churchkey.Key;
import io.churchkey.dsa.Dsa;
import io.churchkey.ec.Curve;
import io.churchkey.ec.ECParameterSpecs;
import io.churchkey.ec.Ecdsa;
import io.churchkey.ec.UnsupportedCurveException;
import io.churchkey.jwk.InvalidJwkException;
import io.churchkey.jwk.InvalidJwkKeySpecException;
import io.churchkey.jwk.MissingKtyException;
import io.churchkey.jwk.UnknownJsonFormatFoundException;
import io.churchkey.jwk.UnsupportedKtyAlgorithmException;
import io.churchkey.shade.json.JsonArray;
import io.churchkey.shade.json.JsonBuilder;
import io.churchkey.shade.json.JsonObject;
import io.churchkey.shade.json.JsonParser;
import io.churchkey.shade.json.JsonSink;
import io.churchkey.shade.json.JsonWriter;
import io.churchkey.shade.util.IO;
import io.churchkey.util.Bytes;
import io.churchkey.util.Utils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JwkParser
implements Key.Format.Parser {
    @Override
    public List<Key> decodeSet(byte[] bytes) {
        JsonObject jsonObject;
        byte[] decoded = this.normalize(bytes);
        if (!Utils.startsWith("{", decoded)) {
            return null;
        }
        String rawJson = new String(decoded);
        try {
            jsonObject = JsonParser.object().from(IO.read(decoded));
        }
        catch (Exception e) {
            throw new InvalidJwkException(e, rawJson);
        }
        return this.getJwks(jsonObject).stream().map(this::asKey).collect(Collectors.toList());
    }

    @Override
    public Key decode(byte[] bytes) {
        JsonObject jwk;
        byte[] decoded = this.normalize(bytes);
        if (!Utils.startsWith("{", decoded)) {
            return null;
        }
        String rawJson = new String(decoded);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.apache.johnzon.buffer-strategy", "BY_INSTANCE");
        try {
            JsonObject jsonObject = JsonParser.object().from(IO.read(decoded));
            jwk = this.getJwk(jsonObject);
        }
        catch (Exception e) {
            throw new InvalidJwkException(e, rawJson);
        }
        return this.asKey(jwk);
    }

    private Key asKey(JsonObject jwk) {
        try {
            if (!jwk.containsKey("kty")) {
                throw new MissingKtyException();
            }
            String kty = jwk.getString("kty");
            if ("RSA".equalsIgnoreCase(kty)) {
                return this.asRsaKey(jwk);
            }
            if ("OCT".equalsIgnoreCase(kty)) {
                return this.asOctKey(jwk);
            }
            if ("DSA".equals(kty)) {
                return this.asDsaKey(jwk);
            }
            if ("EC".equals(kty)) {
                return this.asEcKey(jwk);
            }
            throw new UnsupportedKtyAlgorithmException(kty);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new InvalidJwkException(e, JsonWriter.string(jwk));
        }
    }

    private Key asDsaKey(JsonObject jsonObject) {
        Jwk jwk = new Jwk(jsonObject);
        BigInteger p = jwk.getBigInteger("p");
        BigInteger q = jwk.getBigInteger("q");
        BigInteger g = jwk.getBigInteger("g");
        BigInteger x = jwk.getBigInteger("x");
        BigInteger y = jwk.getBigInteger("y");
        ArrayList<String> missing = new ArrayList<String>();
        if (p == null) {
            missing.add("p");
        }
        if (q == null) {
            missing.add("q");
        }
        if (g == null) {
            missing.add("g");
        }
        if (missing.size() != 0) {
            throw new InvalidJwkKeySpecException("DSA", missing);
        }
        if (x != null) {
            Dsa.Private build = Dsa.Private.builder().p(p).q(q).g(g).x(x).build();
            DSAPrivateKey privateKey = build.toKey();
            DSAPublicKey publicKey = build.toPublic().toKey();
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "p", "q", "q", "x", "y");
            return new Key(privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.JWK, attributes);
        }
        if (y != null) {
            DSAPublicKey publicKey = Dsa.Public.builder().p(p).q(q).g(g).y(y).build().toKey();
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "p", "q", "q", "x", "y");
            return new Key((java.security.Key)publicKey, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.JWK, attributes);
        }
        throw new InvalidJwkKeySpecException("DSA", "x", "y");
    }

    private Key asEcKey(JsonObject jsonObject) {
        Jwk jwk = new Jwk(jsonObject);
        String crv = jwk.getString("crv");
        BigInteger d = jwk.getBigInteger("d");
        BigInteger x = jwk.getBigInteger("x");
        BigInteger y = jwk.getBigInteger("y");
        if (crv == null) {
            throw new InvalidJwkKeySpecException("EC", "crv");
        }
        Curve curve = Curve.resolve(crv);
        if (d != null) {
            Ecdsa.Private build = Ecdsa.Private.builder().curve(curve).d(d).x(x).y(y).build();
            ECPrivateKey privateKey = build.toKey();
            ECPublicKey publicKey = build.getX() != null && build.getY() != null ? build.toPublic().toKey() : null;
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "crv", "d");
            return new Key(privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.JWK, attributes);
        }
        ArrayList<String> missing = new ArrayList<String>();
        if (y == null) {
            missing.add("y");
        }
        if (x == null) {
            missing.add("x");
        }
        if (missing.size() != 0) {
            throw new InvalidJwkKeySpecException("EC", missing);
        }
        ECPublicKey publicKey = Ecdsa.Public.builder().curve(curve).x(x).y(y).build().toKey();
        Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "crv", "x", "y");
        return new Key((java.security.Key)publicKey, Key.Type.PUBLIC, Key.Algorithm.EC, Key.Format.JWK, attributes);
    }

    private Key asRsaKey(JsonObject jsonObject) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Jwk jwk = new Jwk(jsonObject);
        BigInteger modulus = jwk.getBigInteger("n");
        BigInteger publicExp = jwk.getBigInteger("e");
        BigInteger privateExp = jwk.getBigInteger("d");
        BigInteger primeP = jwk.getBigInteger("p");
        BigInteger primeQ = jwk.getBigInteger("q");
        BigInteger primeExponentP = jwk.getBigInteger("dp");
        BigInteger primeExponentQ = jwk.getBigInteger("dq");
        BigInteger crtCoef = jwk.getBigInteger("qi");
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExp);
        RSAPrivateCrtKeySpec rsaPrivateKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, primeP, primeQ, primeExponentP, primeExponentQ, crtCoef);
        this.checkPublicKey(rsaPublicKeySpec);
        this.checkPrivateKey(rsaPrivateKeySpec);
        KeyFactory result = KeyFactory.getInstance("RSA");
        PublicKey publicKey = result.generatePublic(rsaPublicKeySpec);
        if (privateExp != null) {
            PrivateKey privateKey = result.generatePrivate(rsaPrivateKeySpec);
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "n", "e", "d", "p", "q", "dp", "dq", "qi");
            return new Key(privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.JWK, attributes);
        }
        Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "n", "e");
        return new Key((java.security.Key)publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.JWK, attributes);
    }

    private void toRsaKey(Key key, JsonBuilder<JsonObject> jwk) {
        if (key.getKey() instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)key.getKey();
            jwk.value("n", JwkParser.encode(privateKey.getModulus()));
            jwk.value("e", JwkParser.encode(privateKey.getPublicExponent()));
            jwk.value("d", JwkParser.encode(privateKey.getPrivateExponent()));
            jwk.value("p", JwkParser.encode(privateKey.getPrimeP()));
            jwk.value("q", JwkParser.encode(privateKey.getPrimeQ()));
            jwk.value("dp", JwkParser.encode(privateKey.getPrimeExponentP()));
            jwk.value("dq", JwkParser.encode(privateKey.getPrimeExponentQ()));
            jwk.value("qi", JwkParser.encode(privateKey.getCrtCoefficient()));
        } else if (key.getKey() instanceof RSAPrivateKey) {
            RSAPrivateKey privateKey = (RSAPrivateKey)key.getKey();
            jwk.value("n", JwkParser.encode(privateKey.getModulus()));
            jwk.value("d", JwkParser.encode(privateKey.getPrivateExponent()));
        } else if (key.getKey() instanceof RSAPublicKey) {
            RSAPublicKey publicKey = (RSAPublicKey)key.getKey();
            jwk.value("n", JwkParser.encode(publicKey.getModulus()));
            jwk.value("e", JwkParser.encode(publicKey.getPublicExponent()));
        } else {
            throw new UnsupportedOperationException("Unkown RSA Key type: " + key.getKey().getClass().getName());
        }
        jwk.value("kty", "RSA");
    }

    private void toDsaKey(Key key, JsonBuilder<JsonObject> jwk) {
        if (key.getKey() instanceof DSAPrivateKey) {
            DSAPrivateKey privateKey = (DSAPrivateKey)key.getKey();
            jwk.value("x", JwkParser.encode(privateKey.getX()));
            jwk.value("p", JwkParser.encode(privateKey.getParams().getP()));
            jwk.value("q", JwkParser.encode(privateKey.getParams().getQ()));
            jwk.value("g", JwkParser.encode(privateKey.getParams().getG()));
        } else if (key.getKey() instanceof DSAPublicKey) {
            DSAPublicKey privateKey = (DSAPublicKey)key.getKey();
            jwk.value("y", JwkParser.encode(privateKey.getY()));
            jwk.value("p", JwkParser.encode(privateKey.getParams().getP()));
            jwk.value("q", JwkParser.encode(privateKey.getParams().getQ()));
            jwk.value("g", JwkParser.encode(privateKey.getParams().getG()));
        } else {
            throw new UnsupportedOperationException("Unkown DSA Key type: " + key.getKey().getClass().getName());
        }
        jwk.value("kty", "DSA");
    }

    private void toEcKey(Key key, JsonBuilder<JsonObject> jwk) {
        if (key.getKey() instanceof ECPrivateKey) {
            ECPrivateKey privateKey = (ECPrivateKey)key.getKey();
            jwk.value("d", JwkParser.encode(privateKey.getS()));
            jwk.value("crv", this.curveName(privateKey.getParams()));
            if (key.getPublicKey() != null) {
                ECPublicKey publicKey = (ECPublicKey)key.getPublicKey().getKey();
                ECPoint point = publicKey.getW();
                jwk.value("y", JwkParser.encode(point.getAffineY()));
                jwk.value("x", JwkParser.encode(point.getAffineX()));
            }
        } else if (key.getKey() instanceof ECPublicKey) {
            ECPublicKey publicKey = (ECPublicKey)key.getKey();
            ECPoint point = publicKey.getW();
            jwk.value("y", JwkParser.encode(point.getAffineY()));
            jwk.value("x", JwkParser.encode(point.getAffineX()));
            jwk.value("crv", this.curveName(publicKey.getParams()));
        } else {
            throw new UnsupportedOperationException("Unkown EC Key type: " + key.getKey().getClass().getName());
        }
        jwk.value("kty", "EC");
    }

    private String curveName(ECParameterSpec spec) {
        if (Curve.p256.isEqual(spec)) {
            return "P-256";
        }
        if (Curve.p384.isEqual(spec)) {
            return "P-384";
        }
        if (Curve.p521.isEqual(spec)) {
            return "P-521";
        }
        for (Curve curve : Curve.values()) {
            if (!curve.isEqual(spec)) continue;
            return curve.getName();
        }
        String s = ECParameterSpecs.toString(spec);
        throw new UnsupportedCurveException(String.format("The specified ECParameterSpec has no known name.  Params:%n%s", s));
    }

    private Key asOctKey(JsonObject jwkObject) {
        Jwk jwk = new Jwk(jwkObject);
        byte[] keyBytes = jwk.getBytes("k");
        String alg = jwk.getString("alg", "HS256").toUpperCase();
        String jmvAlg = alg.replace("HS", "HmacSHA");
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, jmvAlg);
        Map<String, String> attributes = this.getAttributes(jwkObject, "kty", "k");
        return new Key((java.security.Key)keySpec, Key.Type.SECRET, Key.Algorithm.OCT, Key.Format.JWK, attributes);
    }

    private void toOctKey(Key key, JsonBuilder<JsonObject> jwk) {
        if (!(key.getKey() instanceof SecretKey)) {
            throw new UnsupportedOperationException("Unkown RSA Key type: " + key.getKey().getClass().getName());
        }
        SecretKey publicKey = (SecretKey)key.getKey();
        jwk.value("k", JwkParser.encode(publicKey.getEncoded()));
        jwk.value("kty", "oct");
    }

    private Map<String, String> getAttributes(JsonObject jwkObject, String ... excludes) {
        return this.getAttributes(jwkObject, Arrays.asList(excludes));
    }

    private Map<String, String> getAttributes(JsonObject jwkObject, Collection<String> excludes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : jwkObject.entrySet()) {
            if (excludes.contains(entry.getKey())) continue;
            map.put((String)entry.getKey(), this.toString(entry.getValue()));
        }
        return map;
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            return JsonWriter.string(object);
        }
        if (value instanceof JsonArray) {
            JsonArray objects = (JsonArray)value;
            return JsonWriter.string(objects);
        }
        return value.toString();
    }

    private void checkPublicKey(RSAPublicKeySpec spec) {
        ArrayList<String> missing = new ArrayList<String>();
        if (spec.getModulus() == null) {
            missing.add("n");
        }
        if (spec.getPublicExponent() == null) {
            missing.add("e");
        }
        if (missing.size() > 0) {
            throw new InvalidJwkKeySpecException("rsa", missing);
        }
    }

    private void checkPrivateKey(RSAPrivateCrtKeySpec spec) {
        ArrayList<String> missing = new ArrayList<String>();
        if (spec.getPrivateExponent() == null) {
            missing.add("d");
        }
        if (spec.getPrimeP() == null) {
            missing.add("p");
        }
        if (spec.getPrimeQ() == null) {
            missing.add("q");
        }
        if (spec.getPrimeExponentP() == null) {
            missing.add("dp");
        }
        if (spec.getPrimeExponentQ() == null) {
            missing.add("dq");
        }
        if (spec.getCrtCoefficient() == null) {
            missing.add("qi");
        }
        if (missing.size() == 6) {
            return;
        }
        if (missing.size() == 0) {
            return;
        }
        throw new InvalidJwkKeySpecException("rsa", missing);
    }

    public static String encode(BigInteger bigInteger) {
        Base64.Encoder urlEncoder = Base64.getUrlEncoder().withoutPadding();
        byte[] bytes = Bytes.trim(bigInteger.toByteArray());
        return urlEncoder.encodeToString(bytes);
    }

    public static String encode(byte[] bytes) {
        Base64.Encoder urlEncoder = Base64.getUrlEncoder().withoutPadding();
        return urlEncoder.encodeToString(bytes);
    }

    private JsonObject getJwk(JsonObject jsonObject) {
        if (jsonObject.containsKey("keys")) {
            return this.getFirstJwk(jsonObject);
        }
        if (jsonObject.containsKey("kty")) {
            return jsonObject;
        }
        throw new UnknownJsonFormatFoundException();
    }

    private List<JsonObject> getJwks(JsonObject jsonObject) {
        if (!jsonObject.containsKey("keys")) {
            return Collections.singletonList(jsonObject);
        }
        Object keys = jsonObject.get("keys");
        if (keys == null) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is missing.");
        }
        if (keys instanceof JsonObject) {
            return Collections.singletonList((JsonObject)keys);
        }
        if (keys instanceof JsonArray) {
            JsonArray array = (JsonArray)keys;
            if (array.size() == 0) {
                throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is empty.\n" + JsonWriter.string(jsonObject));
            }
            ArrayList<JsonObject> objects = new ArrayList<JsonObject>();
            for (int i = 0; i < array.size(); ++i) {
                Object value = array.get(i);
                if (!(value instanceof JsonObject)) {
                    throw new IllegalArgumentException("Invalid JWKS; 'keys' array should contain jwk objects.  Value at index " + i + " is not a json object: " + JsonWriter.string(jsonObject));
                }
                objects.add((JsonObject)value);
            }
            return objects;
        }
        throw new IllegalArgumentException("Invalid JWKS; 'keys' entry should be an array.");
    }

    private JsonObject getFirstJwk(JsonObject jwks) {
        Object keys = jwks.get("keys");
        if (keys == null) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is missing.");
        }
        if (keys instanceof JsonObject) {
            return (JsonObject)keys;
        }
        if (keys instanceof JsonArray) {
            return this.getFirstJwk(jwks, (JsonArray)keys);
        }
        throw new IllegalArgumentException("Invalid JWKS; 'keys' entry should be an array.");
    }

    private JsonObject getFirstJwk(JsonObject jwks, JsonArray keys) {
        if (keys.size() == 0) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is empty.\n" + jwks.toString());
        }
        Object value = keys.get(0);
        if (!(value instanceof JsonObject)) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' array should contain jwk objects.  Value is not a json object: " + jwks.toString());
        }
        return (JsonObject)value;
    }

    private byte[] normalize(byte[] bytes) {
        if (!Utils.startsWith("e", bytes)) {
            return bytes;
        }
        if (Utils.startsWith("ecdsa", bytes)) {
            return bytes;
        }
        return Base64.getUrlDecoder().decode(bytes);
    }

    @Override
    public byte[] encodeSet(List<Key> keys) {
        if (keys.size() == 0) {
            throw new IllegalArgumentException("No keys to encode");
        }
        JsonBuilder<JsonObject> builder = JsonObject.builder();
        JsonSink keysArray = builder.array("keys");
        for (Key key : keys) {
            JsonObject o = this.toJsonObject(key);
            ((JsonBuilder)keysArray).value(o);
        }
        return JsonWriter.string(builder.done()).getBytes();
    }

    @Override
    public byte[] encode(Key key) {
        JsonObject build = this.toJsonObject(key);
        return JsonWriter.string(build).getBytes();
    }

    private JsonObject toJsonObject(Key key) {
        JsonBuilder<JsonObject> builder = JsonObject.builder();
        for (Map.Entry<String, String> entry : key.getAttributes().entrySet()) {
            builder.value(entry.getKey(), entry.getValue());
        }
        switch (key.getAlgorithm()) {
            case RSA: {
                this.toRsaKey(key, builder);
                break;
            }
            case DSA: {
                this.toDsaKey(key, builder);
                break;
            }
            case EC: {
                this.toEcKey(key, builder);
                break;
            }
            case OCT: {
                this.toOctKey(key, builder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot encode key type: " + (Object)((Object)key.getAlgorithm()));
            }
        }
        return builder.done();
    }

    private void encodeAttribute(JsonBuilder<JsonObject> builder, String key, String value) {
        builder.value(key, value);
    }

    private static class Jwk {
        private final JsonObject jwk;

        public Jwk(JsonObject jwk) {
            this.jwk = jwk;
        }

        public BigInteger getBigInteger(String name) {
            if (!this.jwk.containsKey(name)) {
                return null;
            }
            String string = this.jwk.getString(name);
            Base64.Decoder urlDecoder = Base64.getUrlDecoder();
            byte[] bytes = urlDecoder.decode(string);
            return new BigInteger(1, bytes);
        }

        public byte[] getBytes(String name) {
            if (!this.jwk.containsKey(name)) {
                return null;
            }
            String string = this.jwk.getString(name);
            Base64.Decoder urlDecoder = Base64.getUrlDecoder();
            return urlDecoder.decode(string);
        }

        public String getString(String s) {
            return this.jwk.getString(s);
        }

        public String getString(String s, String s1) {
            return this.jwk.getString(s, s1);
        }
    }
}

