/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.global;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NoInitialContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.apache.xbean.naming.context.ContextFlyweight;

public class GlobalContextManager
implements ObjectFactory,
InitialContextFactory {
    private static Context DEFAULT_CONTEXT = new DefaultGlobalContext();
    private static Context globalContext;

    public static synchronized Context getGlobalContext() {
        if (globalContext == null) {
            return DEFAULT_CONTEXT;
        }
        return globalContext;
    }

    public static synchronized void setGlobalContext(Context globalContext) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        GlobalContextManager.globalContext = globalContext;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null) {
            return GlobalContextManager.getGlobalContext();
        }
        throw new OperationNotSupportedException();
    }

    public Context getInitialContext(Hashtable environment) {
        return GlobalContextManager.getGlobalContext();
    }

    private static class DefaultGlobalContext
    extends ContextFlyweight {
        private DefaultGlobalContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Context getContext() throws NoInitialContextException {
            Class<GlobalContextManager> clazz = GlobalContextManager.class;
            synchronized (GlobalContextManager.class) {
                if (globalContext == null) {
                    throw new NoInitialContextException("Global context has not been set");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return globalContext;
            }
        }
    }
}

