/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import jakarta.ejb.EJBAccessException;
import jakarta.ejb.EJBException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Providers;

public class EJBExceptionMapper
implements ExceptionMapper<EJBException> {
    @Context
    private Providers providers;

    public Response toResponse(EJBException ejbException) {
        Exception cause = ejbException.getCausedByException();
        if (cause != null) {
            Class<?> causeClass = cause.getClass();
            ExceptionMapper exceptionMapper = this.providers.getExceptionMapper(causeClass);
            if (exceptionMapper == null) {
                return this.defaultResponse(cause);
            }
            return exceptionMapper.toResponse((Throwable)cause);
        }
        if (EJBAccessException.class.isInstance(ejbException)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return this.defaultResponse((Exception)ejbException);
    }

    private Response defaultResponse(Exception cause) {
        return Response.serverError().type(MediaType.TEXT_PLAIN_TYPE).entity((Object)cause.getMessage()).build();
    }
}

