/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class EndsWithCondition
extends TypeSentiveCondition {
    public EndsWithCondition(ITypeExpression type) {
        super(type);
    }

    public EndsWithCondition(AbstractTypeListExpression list) {
        super(list);
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        Type t;
        AnnotationFS annotation = context.getAnnotation();
        if (!this.isWorkingOnList()) {
            Type givenType = this.type.getType(context, stream);
            boolean result = this.check(stream, annotation, givenType);
            return new EvaluatedCondition(this, result);
        }
        boolean result = false;
        List types = this.getList().getList(context, stream);
        Iterator iterator = types.iterator();
        while (iterator.hasNext() && !(result |= this.check(stream, annotation, t = (Type)iterator.next()))) {
        }
        return new EvaluatedCondition(this, result);
    }

    private boolean check(RutaStream stream, AnnotationFS annotation, Type givenType) {
        if (annotation == null || givenType == null) {
            return false;
        }
        RutaBasic endAnchor = stream.getEndAnchor(annotation.getEnd());
        if (endAnchor != null) {
            return endAnchor.endsWith(givenType);
        }
        return false;
    }
}

