/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.vns.service.VNS;

public class WorkspaceConfig {
    protected String workspace = null;
    protected ArrayList search = new ArrayList();
    VNS parent = null;

    public WorkspaceConfig() {
        this.parent = null;
    }

    public WorkspaceConfig(VNS parent) {
        this.parent = parent;
    }

    public void save(Writer f) throws IOException {
        if (this.workspace == null) {
            throw new RuntimeException("No workspace -- cannot save");
        }
        f.write("workspace " + this.workspace + "\n");
        if (this.search.size() > 0) {
            StringBuffer searchString = new StringBuffer();
            for (int i = 0; i < this.search.size(); ++i) {
                searchString.append(this.search.get(i).toString() + " ");
            }
            f.write("search " + String.valueOf(searchString) + "\n");
        }
    }

    public void load(FileReader f) throws IOException {
        int i;
        if (f == null) {
            throw new RuntimeException("Invalid file");
        }
        BufferedReader br = new BufferedReader(f);
        String s = null;
        StringTokenizer str = null;
        String directive = null;
        ArrayList<String> args = null;
        while ((s = br.readLine()) != null) {
            if (s.charAt(0) == '#') continue;
            str = new StringTokenizer(s);
            if (str.countTokens() < 2) {
                throw new RuntimeException("Syntax error in workspace config file");
            }
            directive = str.nextToken();
            args = new ArrayList<String>(str.countTokens());
            i = 0;
            while (str.hasMoreTokens()) {
                args.add(str.nextToken());
            }
            if (directive.equals("workspace")) {
                if (this.workspace != null) {
                    throw new RuntimeException("Multiple workspace directives");
                }
                if (args.size() != 1) {
                    throw new RuntimeException("Too many args for workspace directive");
                }
                this.workspace = (String)args.get(0);
                continue;
            }
            if (directive.equals("search")) {
                this.search.addAll(args);
                continue;
            }
            throw new RuntimeException("Unknown workspace directive " + directive);
        }
        br.close();
        StringBuffer searchString = new StringBuffer();
        for (i = 0; i < this.search.size(); ++i) {
            searchString.append(this.search.get(i).toString() + " ");
        }
        if (this.parent != null) {
            Debug.p("workspace = " + this.workspace);
            Debug.p("search = " + String.valueOf(searchString));
        }
    }

    public static void main(String[] args) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Enter filename to read workspace from : ");
        String wFile = br.readLine();
        FileReader F = new FileReader(wFile);
        WorkspaceConfig WS = new WorkspaceConfig();
        WS.load(F);
        System.out.println("workspace = " + WS.workspace);
        StringBuffer searchString = new StringBuffer();
        if (WS.search.size() > 0) {
            for (int i = 0; i < WS.search.size(); ++i) {
                searchString.append(WS.search.get(i).toString() + " ");
            }
            System.out.print("search " + String.valueOf(searchString) + "\n");
        }
        F.close();
        FileWriter F2 = new FileWriter(wFile + ".txt");
        WS.save(F2);
        F2.close();
    }
}

