/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellarUtils {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(CellarUtils.class);
    public static final String MERGABLE = "MERGABLE[%s]";
    public static final String MERGABLE_REGEX = "MERGABLE\\[([^\\s]+[\\,]*[\\s]*)*\\]";
    private static final Pattern mergablePattern = Pattern.compile("MERGABLE\\[([^\\s]+[\\,]*[\\s]*)*\\]");

    public static boolean isMergable(String s) {
        Matcher matcher = mergablePattern.matcher(s);
        return matcher.matches();
    }

    public static Set<String> createSetFromString(String text) {
        String[] items;
        if (CellarUtils.isMergable(text)) {
            text = text.substring(MERGABLE.length() - 3);
            text = text.substring(0, text.length() - 1);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (text != null && (items = text.split(",")) != null && items.length > 0) {
            for (String item : items) {
                if (item == null || item.length() <= 0) continue;
                result.add(item.trim());
            }
        }
        return result;
    }

    public static String createStringFromSet(Set<String> items, boolean mergeable) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = items.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        if (mergeable) {
            return String.format(MERGABLE, builder.toString());
        }
        return builder.toString();
    }

    public static boolean collectionEquals(Collection col1, Collection col2) {
        return CellarUtils.collectionSubset(col1, col2) && CellarUtils.collectionSubset(col2, col1);
    }

    public static boolean collectionSubset(Collection source, Collection target) {
        if (source == null && target == null) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.isEmpty() && target.isEmpty()) {
            return true;
        }
        for (Object item : source) {
            if (target.contains(item)) continue;
            return false;
        }
        return true;
    }

    public static String getConfigurationProperty(ConfigurationAdmin configurationAdmin, String configurationId, String propertyKey, String defaultValue) {
        String propertyValue = null;
        try {
            Configuration configuration = configurationAdmin.getConfiguration(configurationId, null);
            Dictionary properties = configuration.getProperties();
            if (properties != null) {
                propertyValue = (String)properties.get(propertyKey);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error while retrieving the " + propertyKey + " entry from coonfiguration " + configurationId, (Throwable)e);
        }
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static boolean doCleanupResourcesNotPresentInCluster(ConfigurationAdmin configurationAdmin) {
        return Boolean.parseBoolean(CellarUtils.getConfigurationProperty(configurationAdmin, "org.apache.karaf.cellar.node", "org.apache.karaf.cellar.cleanupResourcesNotPresentInCluster", "true"));
    }

    public static enum MergeType {
        MERGA;

    }
}

