/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import jrm.profile.data.AnywareBase;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.Sample;

public final class Samples
extends AnywareBase
implements Serializable,
Iterable<Sample> {
    public HashMap<String, Sample> samples = new HashMap();

    public Samples(String name) {
        this.setName(name);
    }

    public Sample add(Sample sample) {
        if (!this.samples.containsKey(sample.name)) {
            this.samples.put(sample.name, sample);
            return sample;
        }
        return this.samples.get(sample.name);
    }

    @Override
    public AnywareBase getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getFullName(String filename) {
        return filename;
    }

    @Override
    public CharSequence getDescription() {
        return "";
    }

    @Override
    public Iterator<Sample> iterator() {
        return this.samples.values().iterator();
    }

    @Override
    public AnywareStatus getStatus() {
        AnywareStatus status = AnywareStatus.COMPLETE;
        boolean ok = false;
        for (Sample sample : this) {
            EntityStatus estatus = sample.getStatus();
            if (estatus == EntityStatus.KO) {
                status = AnywareStatus.PARTIAL;
                continue;
            }
            if (estatus == EntityStatus.OK) {
                ok = true;
                continue;
            }
            if (estatus != EntityStatus.UNKNOWN) continue;
            status = AnywareStatus.UNKNOWN;
            break;
        }
        if (status == AnywareStatus.PARTIAL && !ok) {
            status = AnywareStatus.MISSING;
        }
        return status;
    }
}

