/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.notes.DefaultNoteMerger;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteBucket;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.notes.NoteMerger;
import org.eclipse.jgit.notes.NoteParser;
import org.eclipse.jgit.notes.NotesMergeConflictException;

public class NoteMapMerger {
    private static final FanoutBucket EMPTY_FANOUT = new FanoutBucket(0);
    private static final LeafBucket EMPTY_LEAF = new LeafBucket(0);
    private final Repository db;
    private final NoteMerger noteMerger;
    private final MergeStrategy nonNotesMergeStrategy;
    private final ObjectReader reader;
    private final ObjectInserter inserter;
    private final MutableObjectId objectIdPrefix;

    public NoteMapMerger(Repository db, NoteMerger noteMerger, MergeStrategy nonNotesMergeStrategy) {
        this.db = db;
        this.reader = db.newObjectReader();
        this.inserter = db.newObjectInserter();
        this.noteMerger = noteMerger;
        this.nonNotesMergeStrategy = nonNotesMergeStrategy;
        this.objectIdPrefix = new MutableObjectId();
    }

    public NoteMapMerger(Repository db) {
        this(db, new DefaultNoteMerger(), MergeStrategy.RESOLVE);
    }

    public NoteMap merge(NoteMap base, NoteMap ours, NoteMap theirs) throws IOException {
        try {
            InMemoryNoteBucket mergedBucket = this.merge(0, base.getRoot(), ours.getRoot(), theirs.getRoot());
            this.inserter.flush();
            NoteMap noteMap = NoteMap.newMap(mergedBucket, this.reader);
            return noteMap;
        }
        finally {
            this.reader.close();
            this.inserter.close();
        }
    }

    private InMemoryNoteBucket merge(int treeDepth, InMemoryNoteBucket base, InMemoryNoteBucket ours, InMemoryNoteBucket theirs) throws IOException {
        InMemoryNoteBucket result = base instanceof FanoutBucket || ours instanceof FanoutBucket || theirs instanceof FanoutBucket ? this.mergeFanoutBucket(treeDepth, this.asFanout(base), this.asFanout(ours), this.asFanout(theirs)) : this.mergeLeafBucket(treeDepth, (LeafBucket)base, (LeafBucket)ours, (LeafBucket)theirs);
        result.nonNotes = this.mergeNonNotes(NoteMapMerger.nonNotes(base), NoteMapMerger.nonNotes(ours), NoteMapMerger.nonNotes(theirs));
        return result;
    }

    private FanoutBucket asFanout(InMemoryNoteBucket bucket) {
        if (bucket == null) {
            return EMPTY_FANOUT;
        }
        if (bucket instanceof FanoutBucket) {
            return (FanoutBucket)bucket;
        }
        return ((LeafBucket)bucket).split();
    }

    private static NonNoteEntry nonNotes(InMemoryNoteBucket b) {
        return b == null ? null : b.nonNotes;
    }

    private InMemoryNoteBucket mergeFanoutBucket(int treeDepth, FanoutBucket base, FanoutBucket ours, FanoutBucket theirs) throws IOException {
        FanoutBucket result = new FanoutBucket(treeDepth * 2);
        int i = 0;
        while (i < 256) {
            NoteBucket t;
            NoteBucket b = base.getBucket(i);
            NoteBucket o = ours.getBucket(i);
            if (NoteMapMerger.equals(o, t = theirs.getBucket(i))) {
                this.addIfNotNull(result, i, o);
            } else if (NoteMapMerger.equals(b, o)) {
                this.addIfNotNull(result, i, t);
            } else if (NoteMapMerger.equals(b, t)) {
                this.addIfNotNull(result, i, o);
            } else {
                this.objectIdPrefix.setByte(treeDepth, i);
                InMemoryNoteBucket mergedBucket = this.merge(treeDepth + 1, FanoutBucket.loadIfLazy(b, this.objectIdPrefix, this.reader), FanoutBucket.loadIfLazy(o, this.objectIdPrefix, this.reader), FanoutBucket.loadIfLazy(t, this.objectIdPrefix, this.reader));
                result.setBucket(i, mergedBucket);
            }
            ++i;
        }
        return result.contractIfTooSmall(this.objectIdPrefix, this.reader);
    }

    private static boolean equals(NoteBucket a, NoteBucket b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.getTreeId().equals(b.getTreeId());
    }

    private void addIfNotNull(FanoutBucket b, int cell, NoteBucket child) throws IOException {
        if (child == null) {
            return;
        }
        if (child instanceof InMemoryNoteBucket) {
            b.setBucket(cell, child.writeTree(this.inserter));
        } else {
            b.setBucket(cell, child.getTreeId());
        }
    }

    private InMemoryNoteBucket mergeLeafBucket(int treeDepth, LeafBucket bb, LeafBucket ob, LeafBucket tb) throws MissingObjectException, IOException {
        bb = NoteMapMerger.notNullOrEmpty(bb);
        ob = NoteMapMerger.notNullOrEmpty(ob);
        tb = NoteMapMerger.notNullOrEmpty(tb);
        InMemoryNoteBucket result = new LeafBucket(treeDepth * 2);
        int bi = 0;
        int oi = 0;
        int ti = 0;
        while (bi < bb.size() || oi < ob.size() || ti < tb.size()) {
            Note b = NoteMapMerger.get(bb, bi);
            Note o = NoteMapMerger.get(ob, oi);
            Note t = NoteMapMerger.get(tb, ti);
            Note min = NoteMapMerger.min(b, o, t);
            b = NoteMapMerger.sameNoteOrNull(min, b);
            result = NoteMapMerger.sameContent(o = NoteMapMerger.sameNoteOrNull(min, o), t = NoteMapMerger.sameNoteOrNull(min, t)) ? NoteMapMerger.addIfNotNull(result, o) : (NoteMapMerger.sameContent(b, o) ? NoteMapMerger.addIfNotNull(result, t) : (NoteMapMerger.sameContent(b, t) ? NoteMapMerger.addIfNotNull(result, o) : NoteMapMerger.addIfNotNull(result, this.noteMerger.merge(b, o, t, this.reader, this.inserter))));
            if (b != null) {
                ++bi;
            }
            if (o != null) {
                ++oi;
            }
            if (t == null) continue;
            ++ti;
        }
        return result;
    }

    private static LeafBucket notNullOrEmpty(LeafBucket b) {
        return b != null ? b : EMPTY_LEAF;
    }

    private static Note get(LeafBucket b, int i) {
        return i < b.size() ? b.get(i) : null;
    }

    private static Note min(Note b, Note o, Note t) {
        Note min = b;
        if (min == null || o != null && o.compareTo(min) < 0) {
            min = o;
        }
        if (min == null || t != null && t.compareTo(min) < 0) {
            min = t;
        }
        return min;
    }

    private static Note sameNoteOrNull(Note min, Note other) {
        return NoteMapMerger.sameNote(min, other) ? other : null;
    }

    private static boolean sameNote(Note a, Note b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && AnyObjectId.isEqual(a, b);
    }

    private static boolean sameContent(Note a, Note b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && AnyObjectId.isEqual(a.getData(), b.getData());
    }

    private static InMemoryNoteBucket addIfNotNull(InMemoryNoteBucket result, Note note) {
        if (note != null) {
            return result.append(note);
        }
        return result;
    }

    private NonNoteEntry mergeNonNotes(NonNoteEntry baseList, NonNoteEntry oursList, NonNoteEntry theirsList) throws IOException {
        if (baseList == null && oursList == null && theirsList == null) {
            return null;
        }
        ObjectId baseId = this.write(baseList);
        ObjectId oursId = this.write(oursList);
        ObjectId theirsId = this.write(theirsList);
        this.inserter.flush();
        Merger m = this.nonNotesMergeStrategy.newMerger(this.db, true);
        if (m instanceof ThreeWayMerger) {
            ((ThreeWayMerger)m).setBase(baseId);
        }
        if (!m.merge(oursId, theirsId)) {
            throw new NotesMergeConflictException(baseList, oursList, theirsList);
        }
        ObjectId resultTreeId = m.getResultTreeId();
        AbbreviatedObjectId none = AbbreviatedObjectId.fromString("");
        return NoteParser.parse((AbbreviatedObjectId)none, (ObjectId)resultTreeId, (ObjectReader)this.reader).nonNotes;
    }

    private ObjectId write(NonNoteEntry list) throws IOException {
        LeafBucket b = new LeafBucket(0);
        b.nonNotes = list;
        return b.writeTree(this.inserter);
    }
}

