
#include "config.h"

#include <QTest>

class ConfigTest: public QObject {
	Q_OBJECT
private:
	std::shared_ptr<QFile> readerFile;
	std::shared_ptr<QFile> writerFile;
private slots:
	void initTestCase();
	void cleanupTestCase();

	void desktopEntryTest();
};

// private slots:

void ConfigTest::initTestCase() {
	readerFile = std::make_shared<QFile>(QApplication::applicationDirPath() + "/configtest-reader.desktop");
	readerFile->remove();

	writerFile = std::make_shared<QFile>(QApplication::applicationDirPath() + "/configtest-writer.desktop");
	writerFile->remove();

	Config::init();
}

void ConfigTest::cleanupTestCase() {
	readerFile->remove();
	writerFile->remove();

	Config::shutDown();
}

void ConfigTest::desktopEntryTest() {
	QString expectedExec = "test-exec";
	QString expectedKeywords = "test-keywords";

	std::shared_ptr<QSettings> writer(Config::createDesktopEntry(writerFile->fileName().toStdString()));

	writer->setValue("Exec", expectedExec);
	writer->setValue("Keywords", expectedKeywords);
	writer->endGroup();

	writer->beginGroup("X-Test Group");
	writer->setValue("Foo", "Bar");
	writer->setValue("Unicode", "Żółw");
	writer->endGroup();

	writer->beginGroup("Escape");
	writer->setValue("N", "\n");
	writer->setValue("R", "\r");
	writer->setValue("S", "Foo Bar");
	writer->setValue("T", "\t");
	writer->setValue("BS", "\\");
	writer->setValue("ALL", "\\\t\t\\Foo Bar\nBaz\n\\");
	writer->setValue("X", "\\n");
	writer->endGroup();

	writer->sync();

	// HACK: read from a copy to skip QSettings cache
	QVERIFY(writerFile->copy(readerFile->fileName()));

	std::shared_ptr<QSettings> reader(Config::openDesktopEntry(readerFile->fileName().toStdString()));

	QCOMPARE(reader->value("Exec", ""), expectedExec);
	QCOMPARE(reader->value("Keywords", ""), expectedKeywords);
	reader->endGroup();

	reader->beginGroup("X-Test Group");
	QCOMPARE(reader->value("Foo", ""), "Bar");
	QCOMPARE(reader->value("Unicode", ""), "Żółw");
	reader->endGroup();

	reader->beginGroup("Escape");
	QCOMPARE(reader->value("N", ""), "\n");
	QCOMPARE(reader->value("R", ""), "\r");
	QCOMPARE(reader->value("S", ""), "Foo Bar");
	QCOMPARE(reader->value("T", ""), "\t");
	QCOMPARE(reader->value("BS", ""), "\\");
	QCOMPARE(reader->value("ALL", ""), "\\\t\t\\Foo Bar\nBaz\n\\");
	QCOMPARE(reader->value("X", ""), "\\n");
	reader->endGroup();
}

QTEST_MAIN(ConfigTest)
#include "configtest.moc"
