/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import jakarta.persistence.TemporalType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.CompositeNestedGeneratedValueGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.MutableBoolean;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.ValueMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.ManyToManyCollectionPart;
import org.hibernate.metamodel.mapping.internal.OneToManyCollectionPart;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntityDiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.query.BindableType;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortDirection;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.criteria.JpaSelectCriteria;
import org.hibernate.query.derived.AnonymousTupleEntityValuedModelPart;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.derived.CteTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.DynamicInstantiationNature;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.SqmInsertStrategyHelper;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.sql.AggregateColumnAssignmentHandler;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.StandardSqmTranslation;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.AnyDiscriminatorPathInterpretation;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DiscriminatedAssociationPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DiscriminatorPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.EmbeddableValuedExpression;
import org.hibernate.query.sqm.sql.internal.EmbeddableValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.EntityValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.NonAggregatedCompositeValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.PluralValuedSimplePathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqmMapEntryResult;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.NonAggregatedCompositeSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmCteRoot;
import org.hibernate.query.sqm.tree.domain.SqmDerivedRoot;
import org.hibernate.query.sqm.tree.domain.SqmElementAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmFkExpression;
import org.hibernate.query.sqm.tree.domain.SqmIndexAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralPartJoin;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmAnyDiscriminatorValue;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCoalesce;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpressionHelper;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmHqlNumericLiteral;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmModifiedSubQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmOver;
import org.hibernate.query.sqm.tree.expression.SqmOverflow;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmCteJoin;
import org.hibernate.query.sqm.tree.from.SqmDerivedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmTruthnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteObject;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.cte.SearchClauseSpecification;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collation;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.ModifiedSubQueryExpression;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.Overflow;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.QueryTransformer;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.expression.UnparsedNumericLiteral;
import org.hibernate.sql.ast.tree.from.CorrelatedPluralTableGroup;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.QueryPartTableGroup;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.predicate.ThruthnessPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.AbstractJdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.internal.VersionTypeSeedParameterSpecification;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParameters;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionFetch;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiation;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.BottomType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserVersionType;
import org.jboss.logging.Logger;

public abstract class BaseSqmToSqlAstConverter<T extends Statement>
extends BaseSemanticQueryWalker
implements SqmTranslator<T>,
DomainResultCreationState,
JdbcTypeIndicators {
    private static final Logger log = Logger.getLogger(BaseSqmToSqlAstConverter.class);
    private final SqlAstCreationContext creationContext;
    private final boolean jpaQueryComplianceEnabled;
    private final SqmStatement<?> statement;
    private final QueryOptions queryOptions;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final Map<SqmParameter<?>, List<List<JdbcParameter>>> jdbcParamsBySqmParam = new IdentityHashMap();
    private final JdbcParameters jdbcParameters = new JdbcParametersImpl();
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindings domainParameterBindings;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParameterMappingModelTypes = new LinkedHashMap();
    private final Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> jpaCriteriaParamResolutions;
    private final List<DomainResult<?>> domainResults;
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private String currentBagRole;
    private boolean resolvingCircularFetch;
    private boolean deduplicateSelectionItems;
    private ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide;
    private SqmStatement<?> currentSqmStatement;
    private SqmQueryPart<?> currentSqmQueryPart;
    private CteContainer cteContainer;
    private Map<String, String> cteNameMapping;
    private boolean containsCollectionFetches;
    private boolean trackSelectionsForGroup;
    private Map<NavigablePath, Map.Entry<Integer, List<SqlSelection>>> trackedFetchSelectionsForGroup = Collections.emptyMap();
    private final Map<NavigablePath, PredicateCollector> collectionFilterPredicates = new IdentityHashMap<NavigablePath, PredicateCollector>();
    private List<Map.Entry<OrderByFragment, TableGroup>> orderByFragments;
    private final SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
    private final Stack<SqlAstProcessingState> processingStateStack = new StandardStack<SqlAstProcessingState>(SqlAstProcessingState.class);
    private final Stack<FromClauseIndex> fromClauseIndexStack = new StandardStack<FromClauseIndex>(FromClauseIndex.class);
    private final Map<TableGroup, Map<String, EntityNameUse>> tableGroupEntityNameUses = new IdentityHashMap<TableGroup, Map<String, EntityNameUse>>();
    private SqlAstProcessingState lastPoppedProcessingState;
    private FromClauseIndex lastPoppedFromClauseIndex;
    private SqmJoin<?, ?> currentlyProcessingJoin;
    protected Predicate additionalRestrictions;
    private final Stack<Clause> currentClauseStack = new StandardStack<Clause>(Clause.class);
    private final Stack<Supplier> inferrableTypeAccessStack = new StandardStack<Supplier>(Supplier.class);
    private final Stack<List> queryTransformers = new StandardStack<List>(List.class);
    private boolean inTypeInference;
    private boolean inImpliedResultTypeInference;
    private boolean inNestedContext;
    private Supplier<MappingModelExpressible<?>> functionImpliedResultTypeAccess;
    private SqmByUnit appliedByUnit;
    private Expression adjustedTimestamp;
    private SqmExpressible<?> adjustedTimestampType;
    private Expression adjustmentScale;
    private boolean negativeAdjustment;
    private final Set<AssociationKey> visitedAssociationKeys = new HashSet<AssociationKey>();
    private final MappingMetamodel domainModel;

    public BaseSqmToSqlAstConverter(SqlAstCreationContext creationContext, SqmStatement<?> statement, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, boolean deduplicateSelectionItems) {
        this.inferrableTypeAccessStack.push(() -> null);
        this.creationContext = creationContext;
        this.jpaQueryComplianceEnabled = creationContext.getSessionFactory().getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled();
        this.statement = statement;
        this.currentSqmStatement = statement;
        this.deduplicateSelectionItems = deduplicateSelectionItems;
        if (statement instanceof SqmSelectStatement) {
            AppliedGraph appliedGraph;
            JpaQueryPart queryPart = ((SqmSelectStatement)statement).getQueryPart();
            this.domainResults = new ArrayList(((SqmQueryPart)queryPart).getFirstQuerySpec().getSelectClause().getSelections().size());
            if (queryPart instanceof SqmQueryGroup) {
                this.deduplicateSelectionItems = false;
            }
            this.entityGraphTraversalState = (appliedGraph = queryOptions.getAppliedGraph()) != null && appliedGraph.getSemantic() != null && appliedGraph.getGraph() != null ? new StandardEntityGraphTraversalStateImpl(appliedGraph.getSemantic(), appliedGraph.getGraph(), creationContext.getSessionFactory().getJpaMetamodel()) : null;
        } else {
            this.domainResults = null;
            this.entityGraphTraversalState = null;
        }
        this.queryOptions = queryOptions;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.domainParameterXref = domainParameterXref;
        this.domainParameterBindings = domainParameterBindings;
        this.jpaCriteriaParamResolutions = domainParameterXref.getParameterResolutions().getJpaCriteriaParamResolutions();
        this.domainModel = creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
    }

    private static Boolean stackMatchHelper(SqlAstProcessingState processingState, SqlAstProcessingState c) {
        if (!(processingState instanceof SqlAstQueryPartProcessingState)) {
            return Boolean.FALSE;
        }
        if (processingState == c) {
            return null;
        }
        QueryPart part = ((SqlAstQueryPartProcessingState)processingState).getInflightQueryPart();
        if (part instanceof QueryGroup && ((QueryGroup)part).getQueryParts().isEmpty()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private static Boolean matchSqlAstWithQueryPart(SqlAstProcessingState state, QueryPart cteQueryPartLocal) {
        if (state instanceof SqlAstQueryPartProcessingState && ((SqlAstQueryPartProcessingState)state).getInflightQueryPart() == cteQueryPartLocal) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Map<SqmParameter<?>, MappingModelExpressible<?>> getSqmParameterMappingModelExpressibleResolutions() {
        return this.sqmParameterMappingModelTypes;
    }

    protected Stack<SqlAstProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    protected void pushProcessingState(SqlAstProcessingState processingState) {
        this.pushProcessingState(processingState, new FromClauseIndex(this.getFromClauseIndex()));
    }

    protected void pushProcessingState(SqlAstProcessingState processingState, FromClauseIndex fromClauseIndex) {
        this.fromClauseIndexStack.push(fromClauseIndex);
        this.processingStateStack.push(processingState);
    }

    protected void popProcessingStateStack() {
        this.lastPoppedFromClauseIndex = this.fromClauseIndexStack.pop();
        this.lastPoppedProcessingState = this.processingStateStack.pop();
    }

    private QuerySpec currentQuerySpec() {
        return this.currentQueryPart().getLastQuerySpec();
    }

    private QueryPart currentQueryPart() {
        SqlAstQueryPartProcessingState processingState = (SqlAstQueryPartProcessingState)this.getProcessingStateStack().getCurrent();
        return processingState.getInflightQueryPart();
    }

    protected SqmAliasedNodeCollector currentSqlSelectionCollector() {
        return (SqmAliasedNodeCollector)((Object)this.getCurrentProcessingState().getSqlExpressionResolver());
    }

    protected SqmStatement<?> getStatement() {
        return this.statement;
    }

    @Override
    public Dialect getDialect() {
        return this.creationContext.getSessionFactory().getJdbcServices().getDialect();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.creationContext.getSessionFactory().getTypeConfiguration();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.creationContext.getSessionFactory().getSessionFactoryOptions().getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public int getPreferredSqlTypeCodeForDuration() {
        return this.creationContext.getSessionFactory().getSessionFactoryOptions().getPreferredSqlTypeCodeForDuration();
    }

    @Override
    public int getPreferredSqlTypeCodeForUuid() {
        return this.creationContext.getSessionFactory().getSessionFactoryOptions().getPreferredSqlTypeCodeForUuid();
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath);
    }

    @Override
    public TableGroup findTableGroupOnCurrentFromClause(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroupOnCurrentFromClause(navigablePath);
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this.processingStateStack.getCurrent();
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.getCurrentProcessingState().getSqlExpressionResolver();
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public void registerLockMode(String identificationVariable, LockMode explicitLockMode) {
        throw new UnsupportedOperationException("Registering lock modes should only be done for result set mappings");
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    public FromClauseIndex getFromClauseIndex() {
        return (FromClauseIndex)this.getFromClauseAccess();
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        if (fromClauseIndex == null) {
            return this.lastPoppedFromClauseIndex;
        }
        return fromClauseIndex;
    }

    @Override
    public Stack<Clause> getCurrentClauseStack() {
        return this.currentClauseStack;
    }

    @Override
    public SqmQueryPart<?> getCurrentSqmQueryPart() {
        return this.currentSqmQueryPart;
    }

    @Override
    public SqmTranslation<T> translate() {
        SqmStatement<?> sqmStatement = this.getStatement();
        Statement statement = (Statement)sqmStatement.accept(this);
        this.pruneTableGroupJoins();
        return new StandardSqmTranslation<Statement>(statement, this.getJdbcParamsBySqmParam(), this.sqmParameterMappingModelTypes, this.lastPoppedProcessingState.getSqlExpressionResolver(), this.getFromClauseAccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStatement visitUpdateStatement(SqmUpdateStatement<?> sqmStatement) {
        CteContainer oldCteContainer = this.cteContainer;
        CteContainer cteContainer = this.visitCteContainer(sqmStatement);
        SqmStatement<?> oldSqmStatement = this.currentSqmStatement;
        this.currentSqmStatement = sqmStatement;
        JpaRoot sqmTarget = sqmStatement.getTarget();
        String entityName = ((SqmRoot)sqmTarget).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmTarget)).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, sqmStatement.getRoot().getAlias(), null, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM UPDATE");
            }
            if (((AbstractSqmFrom)((Object)sqmTarget)).hasJoins()) {
                throw new HibernateException("SQM UPDATE does not support explicit joins");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            Object assignments = this.visitSetClause(sqmStatement.getSetClause());
            this.addVersionedAssignment(((List)assignments)::add, sqmStatement);
            FilterHelper.applyBaseRestrictions(filterPredicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, filterPredicate);
            }, entityDescriptor, rootTableGroup, this.getDialect().getDmlTargetColumnQualifierSupport() == DmlTargetColumnQualifierSupport.TABLE_ALIAS, this.getLoadQueryInfluencers(), this);
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = sqmStatement.getWhereClause();
            if (whereClause != null) {
                suppliedPredicate = this.visitWhereClause(whereClause.getPredicate());
            }
            FromClause fromClause = new FromClause();
            fromClause.addRoot(rootTableGroup);
            UpdateStatement updateStatement = new UpdateStatement(cteContainer, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), fromClause, (List<Assignment>)assignments, SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return updateStatement;
        }
        finally {
            this.popProcessingStateStack();
            this.currentSqmStatement = oldSqmStatement;
            this.cteContainer = oldCteContainer;
        }
    }

    private static void verifyManipulationImplicitJoin(TableGroup tableGroup) {
        if (tableGroup.isInitialized() && !tableGroup.isVirtual()) {
            throw new SemanticException("Mutation query may not contain joins in the SET clause");
        }
    }

    public void addVersionedAssignment(Consumer<Assignment> assignmentConsumer, SqmUpdateStatement<?> sqmStatement) {
        if (!sqmStatement.isVersioned()) {
            return;
        }
        EntityPersister persister = this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(((SqmRoot)sqmStatement.getTarget()).getEntityName());
        if (!persister.isVersioned()) {
            throw new SemanticException("Increment option specified for update of non-versioned entity");
        }
        BasicType<?> versionType = persister.getVersionType();
        if (versionType instanceof UserVersionType) {
            throw new SemanticException("User-defined version types not supported for increment option");
        }
        this.currentClauseStack.push(Clause.SET);
        EntityVersionMapping versionMapping = persister.getVersionMapping();
        List<ColumnReference> targetColumnReferences = BasicValuedPathInterpretation.from((SqmBasicValuedSimplePath)sqmStatement.getRoot().get(versionMapping.getPartName()), this, this.jpaQueryComplianceEnabled).getColumnReferences();
        this.currentClauseStack.pop();
        assert (targetColumnReferences.size() == 1);
        ColumnReference versionColumn = targetColumnReferences.get(0);
        Expression value = versionMapping.getJdbcMapping().getJdbcType().isTemporal() ? new VersionTypeSeedParameterSpecification(versionMapping) : new BinaryArithmeticExpression(versionColumn, BinaryArithmeticOperator.ADD, new QueryLiteral<Object>(persister.getVersionJavaType().next(persister.getVersionJavaType().seed(versionMapping.getLength(), versionMapping.getPrecision(), versionMapping.getScale(), null), versionMapping.getLength(), versionMapping.getPrecision(), versionMapping.getScale(), null), versionType), versionType);
        assignmentConsumer.accept(new Assignment(versionColumn, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>(setClause.getAssignments().size());
        JpaRoot target = ((SqmDmlStatement)this.currentSqmStatement).getTarget();
        String entityName = ((SqmRoot)target).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        AggregateColumnAssignmentHandler aggregateColumnAssignmentHandler = AggregateColumnAssignmentHandler.forEntityDescriptor(entityDescriptor, setClause.getAssignments().size());
        for (SqmAssignment<?> sqmAssignment : setClause.getAssignments()) {
            SqmPathInterpretation assignedPathInterpretation;
            try {
                this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent), this.getFromClauseIndex());
                this.currentClauseStack.push(Clause.SET);
                assignedPathInterpretation = (SqmPathInterpretation)sqmAssignment.getTargetPath().accept(this);
            }
            finally {
                this.currentClauseStack.pop();
                this.popProcessingStateStack();
            }
            try {
                int assignedPathJdbcCount;
                this.inferrableTypeAccessStack.push(assignedPathInterpretation::getExpressionType);
                this.currentClauseStack.push(Clause.SET_EXPRESSION);
                SqmExpression<?> assignmentValue = sqmAssignment.getValue();
                SqmParameter<?> assignmentValueParameter = this.getSqmParameter(assignmentValue);
                Expression pathSqlExpression = assignedPathInterpretation.getSqlExpression();
                List<? extends Expression> targetColumnReferences = pathSqlExpression instanceof SqlTuple ? ((SqlTuple)pathSqlExpression).getExpressions() : pathSqlExpression.getColumnReference().getColumnReferences();
                if (assignmentValueParameter != null) {
                    this.consumeSqmParameter(assignmentValueParameter, assignedPathInterpretation.getExpressionType(), (index, jdbcParameter) -> this.addAssignment((List<Assignment>)assignments, aggregateColumnAssignmentHandler, (ColumnReference)targetColumnReferences.get((int)index), (Expression)jdbcParameter));
                    continue;
                }
                if (assignmentValue instanceof SqmLiteralNull) {
                    for (ColumnReference columnReference : targetColumnReferences) {
                        this.addAssignment(assignments, aggregateColumnAssignmentHandler, columnReference, new QueryLiteral<Object>(null, (BasicValuedMapping)((Object)columnReference.getExpressionType())));
                    }
                    continue;
                }
                Expression valueExpression = (Expression)assignmentValue.accept(this);
                int n = this.getKeyExpressible(valueExpression.getExpressionType()).getJdbcTypeCount();
                if (n != (assignedPathJdbcCount = this.getKeyExpressible(assignedPathInterpretation.getExpressionType()).getJdbcTypeCount())) {
                    SqlTreeCreationLogger.LOGGER.debug((Object)"JDBC type count does not match in UPDATE assignment between the assigned-path and the assigned-value; this will likely lead to problems executing the query");
                }
                assert (assignedPathJdbcCount == n);
                if (valueExpression instanceof SqlTuple) {
                    void var18_21;
                    List<? extends Expression> expressions = ((SqlTuple)valueExpression).getExpressions();
                    assert (targetColumnReferences.size() == expressions.size());
                    boolean bl = false;
                    while (var18_21 < targetColumnReferences.size()) {
                        ColumnReference columnReference = (ColumnReference)targetColumnReferences.get((int)var18_21);
                        this.addAssignment(assignments, aggregateColumnAssignmentHandler, columnReference, expressions.get((int)var18_21));
                        ++var18_21;
                    }
                    continue;
                }
                for (ColumnReference columnReference : targetColumnReferences) {
                    this.addAssignment(assignments, aggregateColumnAssignmentHandler, columnReference, valueExpression);
                }
            }
            finally {
                this.currentClauseStack.pop();
                this.inferrableTypeAccessStack.pop();
            }
        }
        if (aggregateColumnAssignmentHandler != null) {
            aggregateColumnAssignmentHandler.aggregateAssignments(assignments);
        }
        return assignments;
    }

    private void addAssignment(List<Assignment> assignments, AggregateColumnAssignmentHandler aggregateColumnAssignmentHandler, ColumnReference columnReference, Expression valueExpression) {
        if (aggregateColumnAssignmentHandler != null) {
            aggregateColumnAssignmentHandler.addAssignment(assignments.size(), columnReference);
        }
        assignments.add(new Assignment(columnReference, valueExpression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStatement visitDeleteStatement(SqmDeleteStatement<?> statement) {
        CteContainer oldCteContainer = this.cteContainer;
        CteContainer cteContainer = this.visitCteContainer(statement);
        SqmStatement<?> oldSqmStatement = this.currentSqmStatement;
        this.currentSqmStatement = statement;
        String entityName = ((SqmRoot)statement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, statement.getRoot().getAlias(), null, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this);
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM DELETE");
            }
            FilterHelper.applyBaseRestrictions(filterPredicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, filterPredicate);
            }, entityDescriptor, rootTableGroup, this.getDialect().getDmlTargetColumnQualifierSupport() == DmlTargetColumnQualifierSupport.TABLE_ALIAS, this.getLoadQueryInfluencers(), this);
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = statement.getWhereClause();
            if (whereClause != null) {
                suppliedPredicate = this.visitWhereClause(whereClause.getPredicate());
            }
            FromClause fromClause = new FromClause();
            fromClause.addRoot(rootTableGroup);
            DeleteStatement deleteStatement = new DeleteStatement(cteContainer, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), fromClause, SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return deleteStatement;
        }
        finally {
            this.popProcessingStateStack();
            this.currentSqmStatement = oldSqmStatement;
            this.cteContainer = oldCteContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertSelectStatement(SqmInsertSelectStatement<?> sqmStatement) {
        AdditionalInsertValues additionalInsertValues;
        InsertSelectStatement insertStatement;
        CteContainer oldCteContainer = this.cteContainer;
        CteContainer cteContainer = this.visitCteContainer(sqmStatement);
        SqmStatement<?> oldSqmStatement = this.currentSqmStatement;
        this.currentSqmStatement = sqmStatement;
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        SqmQueryPart<?> selectQueryPart = sqmStatement.getSelectQueryPart();
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, r -> new SqmAliasedNodePositionTracker((SqlExpressionResolver)r, (List<? extends SqmAliasedNode<?>>)selectQueryPart.getFirstQuerySpec().getSelectClause().getSelections()), this.getCurrentClauseStack()::getCurrent));
        this.currentClauseStack.push(Clause.INSERT);
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), null, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this);
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            insertStatement = new InsertSelectStatement(cteContainer, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            additionalInsertValues = this.visitInsertionTargetPaths((assigable, references) -> insertStatement.addTargetColumnReferences((List<ColumnReference>)references), sqmStatement, entityDescriptor, rootTableGroup);
            if (BaseSqmToSqlAstConverter.hasJoins(rootTableGroup)) {
                throw new SemanticException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
        }
        finally {
            this.popProcessingStateStack();
            this.currentClauseStack.pop();
        }
        insertStatement.setSourceSelectStatement((QueryPart)this.visitQueryPart((SqmQueryPart)selectQueryPart));
        insertStatement.getSourceSelectStatement().visitQuerySpecs(querySpec -> {
            boolean appliedRowNumber = additionalInsertValues.applySelections((QuerySpec)querySpec, this.creationContext.getSessionFactory());
            assert (!appliedRowNumber);
        });
        this.currentSqmStatement = oldSqmStatement;
        this.cteContainer = oldCteContainer;
        return insertStatement;
    }

    private static boolean hasJoins(TableGroup rootTableGroup) {
        if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
            return true;
        }
        return BaseSqmToSqlAstConverter.hasJoins(rootTableGroup.getTableGroupJoins()) || BaseSqmToSqlAstConverter.hasJoins(rootTableGroup.getNestedTableGroupJoins());
    }

    private static boolean hasJoins(List<TableGroupJoin> tableGroupJoins) {
        for (TableGroupJoin tableGroupJoin : tableGroupJoins) {
            TableGroup joinedGroup = tableGroupJoin.getJoinedGroup();
            if (!joinedGroup.isInitialized()) continue;
            if (joinedGroup.isVirtual()) {
                return BaseSqmToSqlAstConverter.hasJoins(joinedGroup);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertValuesStatement(SqmInsertValuesStatement<?> sqmStatement) {
        CteContainer oldCteContainer = this.cteContainer;
        CteContainer cteContainer = this.visitCteContainer(sqmStatement);
        SqmStatement<?> oldSqmStatement = this.currentSqmStatement;
        this.currentSqmStatement = sqmStatement;
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), null, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            InsertSelectStatement insertStatement = new InsertSelectStatement(cteContainer, (NamedTableReference)rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            AdditionalInsertValues additionalInsertValues = this.visitInsertionTargetPaths((assigable, references) -> insertStatement.addTargetColumnReferences((List<ColumnReference>)references), sqmStatement, entityDescriptor, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new SemanticException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            for (SqmValues sqmValues : sqmStatement.getValuesList()) {
                Values values = this.visitValues(sqmValues);
                additionalInsertValues.applyValues(values);
                insertStatement.getValuesList().add(values);
            }
            InsertSelectStatement insertSelectStatement = insertStatement;
            return insertSelectStatement;
        }
        finally {
            this.popProcessingStateStack();
            this.currentSqmStatement = oldSqmStatement;
            this.cteContainer = oldCteContainer;
        }
    }

    public AdditionalInsertValues visitInsertionTargetPaths(BiConsumer<Assignable, List<ColumnReference>> targetColumnReferenceConsumer, SqmInsertStatement<?> sqmStatement, EntityPersister entityDescriptor, TableGroup rootTableGroup) {
        boolean needsVersionInsert;
        String versionAttributeName;
        String identifierPropertyName;
        List<SqmPath<?>> targetPaths = sqmStatement.getInsertionTargetPaths();
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        VersionTypeSeedParameterSpecification versionExpression = null;
        QueryLiteral<Object> discriminatorExpression = null;
        BasicEntityIdentifierMapping identifierMapping = null;
        Generator identifierGenerator = entityDescriptor.getGenerator();
        String string = identifierPropertyName = identifierGenerator != null ? entityDescriptor.getIdentifierPropertyName() : null;
        if (entityDescriptor.isVersioned()) {
            versionAttributeName = entityDescriptor.getVersionMapping().getVersionAttribute().getAttributeName();
            needsVersionInsert = true;
        } else {
            versionAttributeName = null;
            needsVersionInsert = false;
        }
        for (int i = 0; i < targetPaths.size(); ++i) {
            SqmPath<?> path = targetPaths.get(i);
            String localName = path.getNavigablePath().getLocalName();
            if (localName.equals(identifierPropertyName)) {
                identifierGenerator = null;
            } else if (localName.equals(versionAttributeName)) {
                needsVersionInsert = false;
            }
            Assignable assignable = (Assignable)path.accept(this);
            targetColumnReferenceConsumer.accept(assignable, assignable.getColumnReferences());
        }
        if (needsVersionInsert) {
            BasicValuedPathInterpretation versionPath = BasicValuedPathInterpretation.from((SqmBasicValuedSimplePath)((AbstractSqmPath)((Object)sqmStatement.getTarget())).get(versionAttributeName), this, this.jpaQueryComplianceEnabled);
            List<ColumnReference> targetColumnReferences = versionPath.getColumnReferences();
            assert (targetColumnReferences.size() == 1);
            targetColumnReferenceConsumer.accept(versionPath, targetColumnReferences);
            versionExpression = new VersionTypeSeedParameterSpecification(entityDescriptor.getVersionMapping());
        }
        if (discriminatorMapping != null && discriminatorMapping.hasPhysicalColumn()) {
            BasicValuedPathInterpretation discriminatorPath = new BasicValuedPathInterpretation(new ColumnReference(rootTableGroup.resolveTableReference(discriminatorMapping.getContainingTableExpression()), (SelectableMapping)discriminatorMapping), rootTableGroup.getNavigablePath().append(discriminatorMapping.getPartName()), discriminatorMapping, rootTableGroup);
            targetColumnReferenceConsumer.accept(discriminatorPath, discriminatorPath.getColumnReferences());
            discriminatorExpression = new QueryLiteral<Object>(entityDescriptor.getDiscriminatorValue(), discriminatorMapping);
        }
        if (identifierGenerator != null && identifierGenerator.generatedOnExecution() || identifierGenerator instanceof CompositeNestedGeneratedValueGenerator) {
            identifierGenerator = null;
        } else if (identifierGenerator != null) {
            Optimizer optimizer;
            boolean addIdColumn = sqmStatement instanceof SqmInsertValuesStatement ? true : (!(identifierGenerator instanceof BulkInsertionCapableIdentifierGenerator) ? false : (identifierGenerator instanceof OptimizableGenerator && (optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1 || !((BulkInsertionCapableIdentifierGenerator)identifierGenerator).supportsBulkInsertionIdentifierGeneration() ? this.creationContext.getSessionFactory().getJdbcServices().getDialect().supportsWindowFunctions() : true));
            identifierMapping = (BasicEntityIdentifierMapping)entityDescriptor.getIdentifierMapping();
            if (addIdColumn) {
                BasicValuedPathInterpretation identifierPath = new BasicValuedPathInterpretation(new ColumnReference(rootTableGroup.resolveTableReference(identifierMapping.getContainingTableExpression()), (SelectableMapping)identifierMapping), rootTableGroup.getNavigablePath().append(identifierMapping.getPartName()), identifierMapping, rootTableGroup);
                targetColumnReferenceConsumer.accept(identifierPath, identifierPath.getColumnReferences());
            }
        }
        return new AdditionalInsertValues(versionExpression, discriminatorExpression, identifierGenerator, identifierMapping);
    }

    @Override
    public Values visitValues(SqmValues sqmValues) {
        Values values = new Values();
        for (SqmExpression<?> expression : sqmValues.getExpressions()) {
            values.getExpressions().add((Expression)expression.accept(this));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement<?> statement) {
        CteContainer oldCteContainer = this.cteContainer;
        CteContainer cteContainer = this.visitCteContainer(statement);
        SqmStatement<?> oldSqmStatement = this.currentSqmStatement;
        this.currentSqmStatement = statement;
        Object queryPart = this.visitQueryPart((SqmQueryPart)statement.getQueryPart());
        List<DomainResult<?>> domainResults = ((QueryPart)queryPart).isRoot() ? this.domainResults : Collections.emptyList();
        try {
            SelectStatement selectStatement = new SelectStatement(cteContainer, (QueryPart)queryPart, domainResults);
            return selectStatement;
        }
        finally {
            this.currentSqmStatement = oldSqmStatement;
            this.cteContainer = oldCteContainer;
        }
    }

    @Override
    public DynamicInstantiation<?> visitDynamicInstantiation(SqmDynamicInstantiation<?> sqmDynamicInstantiation) {
        SqmDynamicInstantiationTarget<?> instantiationTarget = sqmDynamicInstantiation.getInstantiationTarget();
        DynamicInstantiationNature instantiationNature = instantiationTarget.getNature();
        JavaType targetTypeDescriptor = this.interpretInstantiationTarget(instantiationTarget);
        DynamicInstantiation dynamicInstantiation = new DynamicInstantiation(instantiationNature, targetTypeDescriptor);
        for (SqmDynamicInstantiationArgument<?> sqmArgument : sqmDynamicInstantiation.getArguments()) {
            SqmSelectableNode<?> selectableNode = sqmArgument.getSelectableNode();
            if (selectableNode instanceof SqmPath) {
                this.prepareForSelection((SqmPath)selectableNode);
            }
            DomainResultProducer argumentResultProducer = (DomainResultProducer)sqmArgument.accept(this);
            dynamicInstantiation.addArgument(sqmArgument.getAlias(), argumentResultProducer, this);
        }
        dynamicInstantiation.complete();
        return dynamicInstantiation;
    }

    private <X> JavaType<X> interpretInstantiationTarget(SqmDynamicInstantiationTarget<?> instantiationTarget) {
        Class targetJavaType = instantiationTarget.getNature() == DynamicInstantiationNature.LIST ? List.class : (instantiationTarget.getNature() == DynamicInstantiationNature.MAP ? Map.class : instantiationTarget.getJavaType());
        return this.getCreationContext().getMappingMetamodel().getTypeConfiguration().getJavaTypeRegistry().getDescriptor(targetJavaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CteStatement visitCteStatement(SqmCteStatement<?> sqmCteStatement) {
        SqmCteTable<?> sqmCteTable = sqmCteStatement.getCteTable();
        String cteName = this.getCteName(sqmCteTable);
        JpaSelectCriteria selectStatement = sqmCteStatement.getCteDefinition();
        JpaQueryPart queryPart = selectStatement.getQueryPart();
        Literal cycleLiteral = this.getLiteral(sqmCteStatement.getCycleLiteral());
        Literal noCycleLiteral = this.getLiteral(sqmCteStatement.getNoCycleLiteral());
        JdbcMapping cycleMarkType = cycleLiteral == null ? null : cycleLiteral.getJdbcMapping();
        BasicType<String> stringType = this.creationContext.getSessionFactory().getTypeConfiguration().getBasicTypeForJavaType(String.class);
        if (queryPart instanceof SqmQueryGroup && ((SqmQueryPart)queryPart).getSortSpecifications().isEmpty() && ((SqmQueryPart)queryPart).getFetchExpression() == null && ((SqmQueryPart)queryPart).getOffsetExpression() == null) {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            switch (queryGroup.getSetOperator()) {
                case UNION: 
                case UNION_ALL: {
                    if (queryGroup.getQueryParts().size() != 2) break;
                    CteContainer oldCteContainer = this.cteContainer;
                    CteContainer subCteContainer = this.visitCteContainer((SqmCteContainer)((Object)selectStatement));
                    try {
                        SqmQueryPart firstPart = queryGroup.getQueryParts().get(0);
                        SqmQueryPart secondPart = queryGroup.getQueryParts().get(1);
                        ArrayList<QueryPart> newQueryParts = new ArrayList<QueryPart>(2);
                        QueryGroup group = new QueryGroup(this.getProcessingStateStack().isEmpty(), queryGroup.getSetOperator(), newQueryParts);
                        SqlAstQueryPartProcessingStateImpl processingState = new SqlAstQueryPartProcessingStateImpl(group, this.getCurrentProcessingState(), this, DelegatingSqmAliasedNodeCollector::new, this.currentClauseStack::getCurrent, this.deduplicateSelectionItems);
                        DelegatingSqmAliasedNodeCollector collector = (DelegatingSqmAliasedNodeCollector)processingState.getSqlExpressionResolver();
                        SqmQueryPart<?> oldSqmQueryPart = this.currentSqmQueryPart;
                        this.currentSqmQueryPart = queryGroup;
                        this.pushProcessingState(processingState);
                        try {
                            newQueryParts.add((QueryPart)this.visitQueryPart(firstPart));
                            collector.setSqmAliasedNodeCollector((SqmAliasedNodeCollector)((Object)this.lastPoppedProcessingState.getSqlExpressionResolver()));
                            CteTable cteTable = new CteTable(cteName, (CteTupleTableGroupProducer)sqmCteTable.resolveTableGroupProducer(cteName, (List)((QueryPart)newQueryParts.get(0)).getFirstQuerySpec().getSelectClause().getSqlSelections(), (FromClauseAccess)this.lastPoppedFromClauseIndex));
                            CteStatement cteStatement = new CteStatement(cteTable, new SelectStatement(subCteContainer, group, Collections.emptyList()), sqmCteStatement.getMaterialization(), sqmCteStatement.getSearchClauseKind(), this.visitSearchBySpecifications(cteTable, sqmCteStatement.getSearchBySpecifications()), this.createCteColumn(sqmCteStatement.getSearchAttributeName(), stringType), this.visitCycleColumns(cteTable, sqmCteStatement.getCycleAttributes()), this.createCteColumn(sqmCteStatement.getCycleMarkAttributeName(), cycleMarkType), this.createCteColumn(sqmCteStatement.getCyclePathAttributeName(), stringType), cycleLiteral, noCycleLiteral);
                            oldCteContainer.addCteStatement(cteStatement);
                            newQueryParts.add((QueryPart)this.visitQueryPart(secondPart));
                            CteStatement cteStatement2 = cteStatement;
                            this.popProcessingStateStack();
                            this.currentSqmQueryPart = oldSqmQueryPart;
                            return cteStatement2;
                        }
                        catch (Throwable throwable) {
                            this.popProcessingStateStack();
                            this.currentSqmQueryPart = oldSqmQueryPart;
                            throw throwable;
                        }
                    }
                    finally {
                        this.cteContainer = oldCteContainer;
                    }
                }
            }
        }
        Object statement = selectStatement instanceof SqmSubQuery ? this.visitSubQueryExpression((SqmSubQuery)selectStatement) : this.visitSelectStatement((SqmSelectStatement)selectStatement);
        CteTable cteTable = new CteTable(cteName, (CteTupleTableGroupProducer)sqmCteTable.resolveTableGroupProducer(cteName, (List)((SelectStatement)statement).getQuerySpec().getSelectClause().getSqlSelections(), (FromClauseAccess)this.lastPoppedFromClauseIndex));
        CteStatement cteStatement = new CteStatement(cteTable, (Statement)statement, sqmCteStatement.getMaterialization(), sqmCteStatement.getSearchClauseKind(), this.visitSearchBySpecifications(cteTable, sqmCteStatement.getSearchBySpecifications()), this.createCteColumn(sqmCteStatement.getSearchAttributeName(), stringType), this.visitCycleColumns(cteTable, sqmCteStatement.getCycleAttributes()), this.createCteColumn(sqmCteStatement.getCycleMarkAttributeName(), cycleMarkType), this.createCteColumn(sqmCteStatement.getCyclePathAttributeName(), stringType), cycleLiteral, noCycleLiteral);
        this.cteContainer.addCteStatement(cteStatement);
        return cteStatement;
    }

    private String getCteName(SqmCteTable<?> sqmCteTable) {
        String key;
        String generatedCteName;
        String name = sqmCteTable.getName();
        if (this.cteNameMapping == null) {
            this.cteNameMapping = new HashMap<String, String>();
        }
        if ((generatedCteName = this.cteNameMapping.get(key = sqmCteTable.getCteName())) != null) {
            return generatedCteName;
        }
        String cteName = name != null ? this.generateCteName(name) : this.generateCteName("cte" + this.cteNameMapping.size());
        this.cteNameMapping.put(key, cteName);
        return cteName;
    }

    private String generateCteName(String baseName) {
        Object name = baseName;
        int maxTries = 5;
        for (int i = 0; i < maxTries; ++i) {
            if (!this.cteNameMapping.containsKey(name)) {
                return name;
            }
            name = baseName + "_" + i;
        }
        throw new InterpretationException(String.format("Couldn't generate CTE name for base name [%s] after %d tries", baseName, maxTries));
    }

    private Literal getLiteral(SqmLiteral<?> value) {
        return value == null ? null : (Literal)this.visitLiteral((SqmLiteral)value);
    }

    protected List<SearchClauseSpecification> visitSearchBySpecifications(CteTable cteTable, List<JpaSearchOrder> searchBySpecifications) {
        if (searchBySpecifications == null || searchBySpecifications.isEmpty()) {
            return null;
        }
        int size = searchBySpecifications.size();
        ArrayList<SearchClauseSpecification> searchClauseSpecifications = new ArrayList<SearchClauseSpecification>(size);
        for (int i = 0; i < size; ++i) {
            JpaSearchOrder specification = searchBySpecifications.get(i);
            this.forEachCteColumn(cteTable, (SqmCteTableColumn)specification.getAttribute(), cteColumn -> searchClauseSpecifications.add(new SearchClauseSpecification((CteColumn)cteColumn, specification.getSortOrder(), specification.getNullPrecedence())));
        }
        return searchClauseSpecifications;
    }

    protected CteColumn createCteColumn(String cteColumn, JdbcMapping jdbcMapping) {
        if (cteColumn == null) {
            return null;
        }
        return new CteColumn(cteColumn, jdbcMapping);
    }

    protected void forEachCteColumn(CteTable cteTable, SqmCteTableColumn cteColumn, Consumer<CteColumn> consumer) {
        List<CteColumn> cteColumns = cteTable.getCteColumns();
        int size = cteColumns.size();
        for (int i = 0; i < size; ++i) {
            String sqmName;
            CteColumn column = cteColumns.get(i);
            String columnName = column.getColumnExpression();
            if (!columnName.regionMatches(0, sqmName = cteColumn.getName(), 0, sqmName.length()) || columnName.length() != sqmName.length() && columnName.charAt(sqmName.length()) != '_') continue;
            consumer.accept(column);
        }
    }

    protected List<CteColumn> visitCycleColumns(CteTable cteTable, List<JpaCteCriteriaAttribute> cycleColumns) {
        if (cycleColumns == null || cycleColumns.isEmpty()) {
            return null;
        }
        int size = cycleColumns.size();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(size);
        for (int i = 0; i < size; ++i) {
            this.forEachCteColumn(cteTable, (SqmCteTableColumn)cycleColumns.get(i), columns::add);
        }
        return columns;
    }

    @Override
    public CteContainer visitCteContainer(SqmCteContainer consumer) {
        Collection<SqmCteStatement<?>> sqmCteStatements = consumer.getCteStatements();
        this.cteContainer = new CteContainerImpl(this.cteContainer);
        if (!sqmCteStatements.isEmpty()) {
            this.currentClauseStack.push(Clause.WITH);
            for (SqmCteStatement<?> sqmCteStatement : sqmCteStatements) {
                this.visitCteStatement((SqmCteStatement)sqmCteStatement);
            }
            this.currentClauseStack.pop();
            this.lastPoppedFromClauseIndex = null;
            this.lastPoppedProcessingState = null;
        }
        return this.cteContainer;
    }

    @Override
    public QueryPart visitQueryPart(SqmQueryPart<?> queryPart) {
        return (QueryPart)super.visitQueryPart(queryPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryGroup visitQueryGroup(SqmQueryGroup<?> queryGroup) {
        List<SqmQueryPart<?>> queryParts = queryGroup.getQueryParts();
        int size = queryParts.size();
        ArrayList<QueryPart> newQueryParts = new ArrayList<QueryPart>(size);
        QueryGroup group = new QueryGroup(this.getProcessingStateStack().isEmpty(), queryGroup.getSetOperator(), newQueryParts);
        Map<NavigablePath, Map.Entry<Integer, List<SqlSelection>>> originalTrackedFetchSelectionsForGroup = this.trackedFetchSelectionsForGroup;
        if (queryGroup.getOrderByClause() != null && queryGroup.getOrderByClause().hasPositionalSortItem()) {
            this.trackSelectionsForGroup = true;
            HashMap trackedFetchSelectionsForGroup = null;
            for (SqmSortSpecification sortSpecification : queryGroup.getOrderByClause().getSortSpecifications()) {
                SqmAliasedNodeRef nodeRef;
                if (!(sortSpecification.getExpression() instanceof SqmAliasedNodeRef) || (nodeRef = (SqmAliasedNodeRef)sortSpecification.getExpression()).getNavigablePath() == null) continue;
                if (trackedFetchSelectionsForGroup == null) {
                    trackedFetchSelectionsForGroup = new HashMap();
                }
                trackedFetchSelectionsForGroup.put(nodeRef.getNavigablePath(), new AbstractMap.SimpleEntry(nodeRef.getPosition() - 1, new ArrayList()));
            }
            this.trackedFetchSelectionsForGroup = trackedFetchSelectionsForGroup == null ? Collections.emptyMap() : trackedFetchSelectionsForGroup;
        }
        SqlAstQueryPartProcessingStateImpl processingState = new SqlAstQueryPartProcessingStateImpl(group, this.getCurrentProcessingState(), this, DelegatingSqmAliasedNodeCollector::new, this.currentClauseStack::getCurrent, this.deduplicateSelectionItems);
        DelegatingSqmAliasedNodeCollector collector = (DelegatingSqmAliasedNodeCollector)processingState.getSqlExpressionResolver();
        SqmQueryPart<?> sqmQueryPart = this.currentSqmQueryPart;
        this.currentSqmQueryPart = queryGroup;
        this.pushProcessingState(processingState);
        try {
            newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(0)));
            collector.setSqmAliasedNodeCollector((SqmAliasedNodeCollector)((Object)this.lastPoppedProcessingState.getSqlExpressionResolver()));
            this.visitOrderByOffsetAndFetch(queryGroup, group);
            this.trackSelectionsForGroup = false;
            this.trackedFetchSelectionsForGroup = originalTrackedFetchSelectionsForGroup;
            for (int i = 1; i < size; ++i) {
                newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(i)));
            }
            QueryGroup queryGroup2 = group;
            return queryGroup2;
        }
        finally {
            this.popProcessingStateStack();
            this.currentSqmQueryPart = sqmQueryPart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuerySpec visitQuerySpec(SqmQuerySpec<?> sqmQuerySpec) {
        boolean trackAliasedNodePositions;
        boolean topLevel = this.getProcessingStateStack().isEmpty();
        QuerySpec sqlQuerySpec = new QuerySpec(topLevel, sqmQuerySpec.getFromClause().getNumberOfRoots());
        SqmSelectClause selectClause = sqmQuerySpec.getSelectClause();
        Predicate originalAdditionalRestrictions = this.additionalRestrictions;
        this.additionalRestrictions = null;
        boolean oldInNestedContext = this.inNestedContext;
        this.inNestedContext = false;
        if (this.trackSelectionsForGroup) {
            trackAliasedNodePositions = true;
        } else if (sqmQuerySpec.getOrderByClause() != null && sqmQuerySpec.getOrderByClause().hasPositionalSortItem()) {
            trackAliasedNodePositions = true;
        } else if (sqmQuerySpec.hasPositionalGroupItem()) {
            trackAliasedNodePositions = true;
        } else {
            boolean bl = trackAliasedNodePositions = this.statement.getQuerySource() == SqmQuerySource.CRITERIA && (sqmQuerySpec.getOrderByClause() != null || !sqmQuerySpec.getGroupByClauseExpressions().isEmpty());
        }
        SqlAstQueryPartProcessingStateImpl processingState = trackAliasedNodePositions ? new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, this.getCurrentProcessingState(), this, r -> new SqmAliasedNodePositionTracker((SqlExpressionResolver)r, (List<? extends SqmAliasedNode<?>>)selectClause.getSelections()), this.currentClauseStack::getCurrent, this.deduplicateSelectionItems) : new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent, this.deduplicateSelectionItems);
        SqmQueryPart<?> sqmQueryPart = this.currentSqmQueryPart;
        boolean originalDeduplicateSelectionItems = this.deduplicateSelectionItems;
        this.currentSqmQueryPart = sqmQuerySpec;
        this.deduplicateSelectionItems = false;
        this.pushProcessingState(processingState);
        this.queryTransformers.push(new ArrayList());
        try {
            this.visitFromClause(sqmQuerySpec.getFromClause());
            this.visitSelectClause(selectClause);
            SqmWhereClause whereClause = sqmQuerySpec.getWhereClause();
            if (whereClause != null) {
                sqlQuerySpec.applyPredicate(this.visitWhereClause(whereClause.getPredicate()));
            }
            sqlQuerySpec.setGroupByClauseExpressions((List<Expression>)this.visitGroupByClause((List)sqmQuerySpec.getGroupByClauseExpressions()));
            if (sqmQuerySpec.getHavingClausePredicate() != null) {
                sqlQuerySpec.setHavingClauseRestrictions(this.visitHavingClause(sqmQuerySpec.getHavingClausePredicate()));
            }
            this.visitOrderByOffsetAndFetch(sqmQuerySpec, sqlQuerySpec);
            if (topLevel && this.statement instanceof SqmSelectStatement) {
                if (this.orderByFragments != null) {
                    this.orderByFragments.forEach(entry -> ((OrderByFragment)entry.getKey()).apply(sqlQuerySpec, (TableGroup)entry.getValue(), this));
                    this.orderByFragments = null;
                }
                this.applyCollectionFilterPredicates(sqlQuerySpec);
            }
            for (Map.Entry<SqmFrom<?, ?>, Boolean> entry2 : processingState.getFromRegistrations().entrySet()) {
                if (entry2.getValue() != Boolean.TRUE) continue;
                this.downgradeTreatUses(this.getFromClauseIndex().getTableGroup(entry2.getKey().getNavigablePath()));
            }
            QuerySpec finalQuerySpec = sqlQuerySpec;
            for (QueryTransformer transformer : this.queryTransformers.getCurrent()) {
                finalQuerySpec = transformer.transform(this.cteContainer, finalQuerySpec, this);
            }
            QuerySpec querySpec = finalQuerySpec;
            return querySpec;
        }
        finally {
            if (this.additionalRestrictions != null) {
                sqlQuerySpec.applyPredicate(this.additionalRestrictions);
            }
            this.additionalRestrictions = originalAdditionalRestrictions;
            this.inNestedContext = oldInNestedContext;
            this.popProcessingStateStack();
            this.queryTransformers.pop();
            this.currentSqmQueryPart = sqmQueryPart;
            this.deduplicateSelectionItems = originalDeduplicateSelectionItems;
        }
    }

    private void downgradeTreatUses(TableGroup tableGroup) {
        Map<String, EntityNameUse> entityNameUses = this.tableGroupEntityNameUses.get(tableGroup);
        if (entityNameUses != null) {
            for (Map.Entry<String, EntityNameUse> entry : entityNameUses.entrySet()) {
                if (entry.getValue().getKind() != EntityNameUse.UseKind.TREAT) continue;
                entry.setValue(EntityNameUse.EXPRESSION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOrderByOffsetAndFetch(SqmQueryPart<?> sqmQueryPart, QueryPart sqlQueryPart) {
        if (sqmQueryPart.getOrderByClause() != null) {
            this.currentClauseStack.push(Clause.ORDER);
            this.inferrableTypeAccessStack.push(() -> null);
            try {
                for (SqmSortSpecification sortSpecification : sqmQueryPart.getOrderByClause().getSortSpecifications()) {
                    SortSpecification specification = this.visitSortSpecification(sortSpecification);
                    if (specification == null) continue;
                    sqlQueryPart.addSortSpecification(specification);
                }
            }
            finally {
                this.inferrableTypeAccessStack.pop();
                this.currentClauseStack.pop();
            }
        }
        if (!this.containsCollectionFetches || !this.currentClauseStack.isEmpty()) {
            this.inferrableTypeAccessStack.push(() -> this.getTypeConfiguration().getBasicTypeForJavaType(Integer.class));
            sqlQueryPart.setOffsetClauseExpression((Expression)this.visitOffsetExpression((SqmExpression)sqmQueryPart.getOffsetExpression()));
            if (sqmQueryPart.getFetchClauseType() == FetchClauseType.PERCENT_ONLY || sqmQueryPart.getFetchClauseType() == FetchClauseType.PERCENT_WITH_TIES) {
                this.inferrableTypeAccessStack.pop();
                this.inferrableTypeAccessStack.push(() -> this.getTypeConfiguration().getBasicTypeForJavaType(Double.class));
            }
            sqlQueryPart.setFetchClauseExpression((Expression)this.visitFetchExpression((SqmExpression)sqmQueryPart.getFetchExpression()), sqmQueryPart.getFetchClauseType());
            this.inferrableTypeAccessStack.pop();
        }
    }

    private TableGroup findTableGroupByPath(NavigablePath navigablePath) {
        return this.getFromClauseAccess().getTableGroup(navigablePath);
    }

    protected void applyCollectionFilterPredicates(QuerySpec sqlQuerySpec) {
        if (CollectionHelper.isNotEmpty(this.collectionFilterPredicates)) {
            FromClauseAccess fromClauseAccess = this.getFromClauseAccess();
            block0: for (Map.Entry<NavigablePath, PredicateCollector> entry : this.collectionFilterPredicates.entrySet()) {
                TableGroup parentTableGroup = fromClauseAccess.findTableGroup(entry.getKey().getParent());
                if (parentTableGroup == null) continue;
                for (TableGroupJoin tableGroupJoin : parentTableGroup.getTableGroupJoins()) {
                    if (tableGroupJoin.getJoinedGroup().getNavigablePath() != entry.getKey()) continue;
                    tableGroupJoin.applyPredicate(entry.getValue().getPredicate());
                    continue block0;
                }
                for (TableGroupJoin tableGroupJoin : parentTableGroup.getNestedTableGroupJoins()) {
                    if (tableGroupJoin.getJoinedGroup().getNavigablePath() != entry.getKey()) continue;
                    tableGroupJoin.applyPredicate(entry.getValue().getPredicate());
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectClause visitSelectClause(SqmSelectClause selectClause) {
        this.currentClauseStack.push(Clause.SELECT);
        try {
            SelectClause sqlSelectClause = this.currentQuerySpec().getSelectClause();
            if (selectClause == null) {
                SqmFrom<?, ?> implicitSelection = this.determineImplicitSelection((SqmQuerySpec)this.currentSqmQueryPart);
                this.visitSelection(0, new SqmSelection(implicitSelection, implicitSelection.nodeBuilder()));
            } else {
                List<SqmSelection<?>> selections = selectClause.getSelections();
                for (int i = 0; i < selections.size(); ++i) {
                    this.visitSelection(i, selections.get(i));
                }
                sqlSelectClause.makeDistinct(selectClause.isDistinct());
            }
            SelectClause selectClause2 = sqlSelectClause;
            return selectClause2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    protected SqmFrom<?, ?> determineImplicitSelection(SqmQuerySpec<?> querySpec) {
        return querySpec.getFromClause().getRoots().get(0);
    }

    @Override
    public Void visitSelection(SqmSelection<?> sqmSelection) {
        return this.visitSelection(this.currentSqmQueryPart.getFirstQuerySpec().getSelectClause().getSelections().indexOf(sqmSelection), sqmSelection);
    }

    public Void visitSelection(int index, SqmSelection<?> sqmSelection) {
        boolean collectDomainResults;
        boolean needsDomainResults;
        List<Object> resultProducers;
        SqmSelectableNode<?> selectionNode;
        boolean inferTargetPath;
        boolean contributesToTopLevelSelectClause = this.currentClauseStack.depth() == 1 && this.currentClauseStack.getCurrent() == Clause.SELECT;
        boolean bl = inferTargetPath = this.statement instanceof SqmInsertSelectStatement && contributesToTopLevelSelectClause;
        if (inferTargetPath) {
            SqmPath<?> path = ((SqmInsertSelectStatement)this.statement).getInsertionTargetPaths().get(index);
            this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(path));
        }
        if ((selectionNode = sqmSelection.getSelectableNode()) instanceof SqmJpaCompoundSelection) {
            SqmJpaCompoundSelection selectableNode = (SqmJpaCompoundSelection)selectionNode;
            resultProducers = new ArrayList(selectableNode.getSelectionItems().size());
            for (SqmSelectableNode<?> selectionItem : selectableNode.getSelectionItems()) {
                if (selectionItem instanceof SqmPath) {
                    this.prepareForSelection((SqmPath)selectionItem);
                }
                resultProducers.add(new AbstractMap.SimpleEntry<String, DomainResultProducer>(selectionItem.getAlias(), (DomainResultProducer)selectionItem.accept(this)));
            }
        } else {
            if (selectionNode instanceof SqmPath) {
                this.prepareForSelection((SqmPath)selectionNode);
            }
            resultProducers = Collections.singletonList(new AbstractMap.SimpleEntry<String, DomainResultProducer>(sqmSelection.getAlias(), (DomainResultProducer)selectionNode.accept(this)));
        }
        Stack<SqlAstProcessingState> processingStateStack = this.getProcessingStateStack();
        boolean bl2 = needsDomainResults = this.domainResults != null && contributesToTopLevelSelectClause;
        if (processingStateStack.depth() == 1) {
            collectDomainResults = needsDomainResults;
        } else {
            SqlAstProcessingState current = processingStateStack.getCurrent();
            boolean bl3 = collectDomainResults = needsDomainResults && processingStateStack.findCurrentFirstWithParameter(current, BaseSqmToSqlAstConverter::stackMatchHelper) == null;
        }
        if (collectDomainResults) {
            resultProducers.forEach(entry -> {
                if (!(entry.getValue() instanceof DynamicInstantiation)) {
                    this.currentSqlSelectionCollector().next();
                }
                this.domainResults.add(((DomainResultProducer)entry.getValue()).createDomainResult((String)entry.getKey(), this));
            });
        } else if (needsDomainResults) {
            resultProducers.forEach(entry -> {
                if (!(entry.getValue() instanceof DynamicInstantiation)) {
                    this.currentSqlSelectionCollector().next();
                }
                ((DomainResultProducer)entry.getValue()).createDomainResult((String)entry.getKey(), this);
            });
        } else {
            resultProducers.forEach(entry -> {
                if (!(entry.getValue() instanceof DynamicInstantiation)) {
                    this.currentSqlSelectionCollector().next();
                }
                ((DomainResultProducer)entry.getValue()).applySqlSelections(this);
            });
        }
        if (inferTargetPath) {
            this.inferrableTypeAccessStack.pop();
        }
        return null;
    }

    protected Expression resolveGroupOrOrderByExpression(SqmExpression<?> groupByClauseExpression) {
        NavigablePath path;
        int sqmPosition;
        if (groupByClauseExpression instanceof SqmAliasedNodeRef) {
            SqmAliasedNodeRef aliasedNodeRef = (SqmAliasedNodeRef)groupByClauseExpression;
            int aliasedNodeOrdinal = aliasedNodeRef.getPosition();
            sqmPosition = aliasedNodeOrdinal - 1;
            path = aliasedNodeRef.getNavigablePath();
        } else if (this.statement.getQuerySource() == SqmQuerySource.CRITERIA && this.currentClauseStack.getCurrent() != Clause.OVER) {
            SqmQuerySpec<?> querySpec = this.currentSqmQueryPart.getFirstQuerySpec();
            sqmPosition = this.indexOfExpression(querySpec.getSelectClause().getSelections(), groupByClauseExpression);
            path = null;
        } else {
            sqmPosition = -1;
            path = null;
        }
        if (sqmPosition != -1) {
            List<SqlSelection> selections = path == null ? this.currentSqlSelectionCollector().getSelections(sqmPosition) : this.trackedFetchSelectionsForGroup.get(path).getValue();
            assert (selections != null) : String.format(Locale.ROOT, "No SqlSelections for SQM position `%s`", sqmPosition);
            ArrayList<SqlSelectionExpression> expressions = new ArrayList<SqlSelectionExpression>(selections.size());
            block0: for (int i = 0; i < selections.size(); ++i) {
                SqlSelection selection = selections.get(i);
                for (int j = 0; j < i; ++j) {
                    if (selections.get(j) == selection) continue block0;
                }
                if (this.currentSqmQueryPart instanceof SqmQueryGroup) {
                    expressions.add(new SqlSelectionExpression(new SqlSelectionImpl(selection.getJdbcResultSetIndex(), selection.getValuesArrayPosition(), new QueryLiteral<Integer>(selection.getValuesArrayPosition(), this.basicType(Integer.class)), false)));
                    continue;
                }
                expressions.add(new SqlSelectionExpression(selection));
            }
            if (expressions.size() == 1) {
                return (Expression)expressions.get(0);
            }
            return new SqlTuple(expressions, null);
        }
        return (Expression)groupByClauseExpression.accept(this);
    }

    private int indexOfExpression(List<? extends SqmAliasedNode<?>> selections, SqmExpression<?> node) {
        int result = this.indexOfExpression(0, selections, node);
        if (result < 0) {
            return -1;
        }
        return result;
    }

    private int indexOfExpression(int offset, List<? extends SqmAliasedNode<?>> selections, SqmExpression<?> node) {
        for (int i = 0; i < selections.size(); ++i) {
            SqmSelectableNode<?> selectableNode = selections.get(i).getSelectableNode();
            if (selectableNode instanceof SqmDynamicInstantiation) {
                int subResult = this.indexOfExpression(offset + i, ((SqmDynamicInstantiation)selectableNode).getArguments(), node);
                if (subResult >= 0) {
                    return subResult;
                }
                offset = -subResult - i;
                continue;
            }
            if (selectableNode instanceof SqmJpaCompoundSelection) {
                List<SqmSelectableNode<?>> selectionItems = ((SqmJpaCompoundSelection)selectableNode).getSelectionItems();
                for (int j = 0; j < selectionItems.size(); ++j) {
                    if (selectionItems.get(j) != node) continue;
                    return offset + i + j;
                }
                offset += selectionItems.size();
                continue;
            }
            if (selectableNode != node) continue;
            return offset + i;
        }
        return -(offset + selections.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Expression> visitGroupByClause(List<SqmExpression<?>> groupByClauseExpressions) {
        if (!groupByClauseExpressions.isEmpty()) {
            this.currentClauseStack.push(Clause.GROUP);
            this.inferrableTypeAccessStack.push(() -> null);
            try {
                ArrayList<Expression> expressions = new ArrayList<Expression>(groupByClauseExpressions.size());
                for (SqmExpression<?> groupByClauseExpression : groupByClauseExpressions) {
                    expressions.add(this.resolveGroupOrOrderByExpression(groupByClauseExpression));
                }
                ArrayList<Expression> arrayList = expressions;
                return arrayList;
            }
            finally {
                this.inferrableTypeAccessStack.pop();
                this.currentClauseStack.pop();
            }
        }
        return Collections.emptyList();
    }

    private Predicate visitWhereClause(SqmPredicate sqmPredicate) {
        if (sqmPredicate == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.WHERE);
        this.inferrableTypeAccessStack.push(() -> null);
        try {
            Predicate predicate = SqlAstTreeHelper.combinePredicates((Predicate)sqmPredicate.accept(this), this.consumeConjunctTreatTypeRestrictions());
            return predicate;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Predicate visitHavingClause(SqmPredicate sqmPredicate) {
        if (sqmPredicate == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.HAVING);
        this.inferrableTypeAccessStack.push(() -> null);
        try {
            Predicate predicate = SqlAstTreeHelper.combinePredicates((Predicate)sqmPredicate.accept(this), this.consumeConjunctTreatTypeRestrictions());
            return predicate;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitOrderByClause(SqmOrderByClause orderByClause) {
        super.visitOrderByClause(orderByClause);
        return null;
    }

    @Override
    public SortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
        Expression expression = this.resolveGroupOrOrderByExpression(sortSpecification.getSortExpression());
        if (expression == null) {
            return null;
        }
        return new SortSpecification(expression, sortSpecification.getSortDirection(), sortSpecification.getNullPrecedence());
    }

    @Override
    public Expression visitOffsetExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.OFFSET);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Expression visitFetchExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.FETCH);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitFromClause(SqmFromClause sqmFromClause) {
        this.currentClauseStack.push(Clause.FROM);
        try {
            sqmFromClause.visitRoots(this::consumeFromClauseCorrelatedRoot);
            sqmFromClause.visitRoots(this::consumeFromClauseRoot);
        }
        finally {
            this.currentClauseStack.pop();
        }
        return null;
    }

    protected void consumeFromClauseCorrelatedRoot(SqmRoot<?> sqmRoot) {
        log.tracef("Resolving SqmRoot [%s] to TableGroup", sqmRoot);
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        if (fromClauseIndex.isResolved(sqmRoot)) {
            log.tracef("Already resolved SqmRoot [%s] to TableGroup", sqmRoot);
        }
        QuerySpec currentQuerySpec = this.currentQuerySpec();
        if (!sqmRoot.isCorrelated()) {
            return;
        }
        SessionFactoryImplementor sessionFactory = this.creationContext.getSessionFactory();
        if (sqmRoot.containsOnlyInnerJoins()) {
            CorrelatedTableGroup tableGroup;
            SqmFrom from;
            if (sqmRoot instanceof SqmCorrelatedRootJoin) {
                assert (sqmRoot.getSqmJoins().size() == 1);
                assert (sqmRoot.getSqmJoins().get(0).isCorrelated());
                from = sqmRoot.getSqmJoins().get(0);
            } else {
                from = sqmRoot;
            }
            TableGroup parentTableGroup = fromClauseIndex.findTableGroup(from.getCorrelationParent().getNavigablePath());
            SqlAliasBase sqlAliasBase = this.sqlAliasBaseManager.createSqlAliasBase(parentTableGroup.getGroupAlias());
            if (parentTableGroup instanceof PluralTableGroup) {
                TableGroup indexTableGroup;
                PluralTableGroup pluralTableGroup = (PluralTableGroup)parentTableGroup;
                CorrelatedPluralTableGroup correlatedPluralTableGroup = new CorrelatedPluralTableGroup(parentTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                    this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                }, sessionFactory);
                TableGroup elementTableGroup = pluralTableGroup.getElementTableGroup();
                if (elementTableGroup != null) {
                    CorrelatedTableGroup correlatedElementTableGroup = new CorrelatedTableGroup(elementTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                        this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                    }, sessionFactory);
                    TableGroupJoin tableGroupJoin = new TableGroupJoin(elementTableGroup.getNavigablePath(), SqlAstJoinType.INNER, correlatedElementTableGroup);
                    correlatedPluralTableGroup.registerElementTableGroup(tableGroupJoin);
                }
                if ((indexTableGroup = pluralTableGroup.getIndexTableGroup()) != null) {
                    CorrelatedTableGroup correlatedIndexTableGroup = new CorrelatedTableGroup(indexTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                        this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                    }, sessionFactory);
                    TableGroupJoin tableGroupJoin = new TableGroupJoin(indexTableGroup.getNavigablePath(), SqlAstJoinType.INNER, correlatedIndexTableGroup);
                    correlatedPluralTableGroup.registerIndexTableGroup(tableGroupJoin);
                }
                tableGroup = correlatedPluralTableGroup;
            } else {
                tableGroup = new CorrelatedTableGroup(parentTableGroup, sqlAliasBase, currentQuerySpec, predicate -> {
                    this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                }, sessionFactory);
            }
            fromClauseIndex.register(from, tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            log.tracef("Resolved SqmRoot [%s] to correlated TableGroup [%s]", sqmRoot, (Object)tableGroup);
            this.consumeExplicitJoins(from, tableGroup);
            return;
        }
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getModel());
        TableGroup parentTableGroup = fromClauseIndex.findTableGroup(sqmRoot.getCorrelationParent().getNavigablePath());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(true, sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), null, () -> predicate -> {}, this);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        NavigablePath navigablePath = sqmRoot.getNavigablePath().append(identifierMapping.getNavigableRole().getNavigableName());
        int jdbcTypeCount = identifierMapping.getJdbcTypeCount();
        if (jdbcTypeCount == 1) {
            identifierMapping.forEachSelectable((index, selectable) -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new ColumnReference(parentTableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable), ComparisonOperator.EQUAL, new ColumnReference(tableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable)));
            });
        } else {
            ArrayList lhs = new ArrayList(jdbcTypeCount);
            ArrayList rhs = new ArrayList(jdbcTypeCount);
            identifierMapping.forEachSelectable((index, selectable) -> {
                lhs.add(new ColumnReference(parentTableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable));
                rhs.add(new ColumnReference(tableGroup.resolveTableReference(navigablePath, selectable.getContainingTableExpression()), selectable));
            });
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new SqlTuple(lhs, identifierMapping), ComparisonOperator.EQUAL, new SqlTuple(rhs, identifierMapping)));
        }
        log.tracef("Resolved SqmRoot [%s] to new TableGroup [%s]", sqmRoot, (Object)tableGroup);
        fromClauseIndex.register(sqmRoot, tableGroup);
        currentQuerySpec.getFromClause().addRoot(tableGroup);
        this.consumeJoins(sqmRoot, fromClauseIndex, tableGroup);
    }

    @Override
    protected void consumeFromClauseRoot(SqmRoot<?> sqmRoot) {
        TableGroup tableGroup;
        log.tracef("Resolving SqmRoot [%s] to TableGroup", sqmRoot);
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        if (fromClauseIndex.isResolved(sqmRoot)) {
            log.tracef("Already resolved SqmRoot [%s] to TableGroup", sqmRoot);
        }
        QuerySpec currentQuerySpec = this.currentQuerySpec();
        if (sqmRoot.isCorrelated()) {
            return;
        }
        if (sqmRoot instanceof SqmDerivedRoot) {
            SqmDerivedRoot derivedRoot = (SqmDerivedRoot)sqmRoot;
            SelectStatement statement = (SelectStatement)((SqmSubQuery)derivedRoot.getQueryPart()).accept(this);
            AnonymousTupleType tupleType = (AnonymousTupleType)sqmRoot.getNodeType();
            List<SqlSelection> sqlSelections = statement.getQueryPart().getFirstQuerySpec().getSelectClause().getSqlSelections();
            AnonymousTupleTableGroupProducer tableGroupProducer = tupleType.resolveTableGroupProducer(derivedRoot.getExplicitAlias(), sqlSelections, this.lastPoppedFromClauseIndex);
            List<String> columnNames = tupleType.determineColumnNames();
            SqlAliasBase sqlAliasBase = this.getSqlAliasBaseGenerator().createSqlAliasBase(derivedRoot.getExplicitAlias() == null ? "derived" : derivedRoot.getExplicitAlias());
            String identifierVariable = sqlAliasBase.generateNewAlias();
            tableGroup = new QueryPartTableGroup(derivedRoot.getNavigablePath(), tableGroupProducer, statement, identifierVariable, columnNames, tableGroupProducer.getCompatibleTableExpressions(), false, true, this.creationContext.getSessionFactory());
        } else if (sqmRoot instanceof SqmCteRoot) {
            SqmCteRoot cteRoot = (SqmCteRoot)sqmRoot;
            tableGroup = this.createCteTableGroup(this.getCteName(cteRoot.getCte().getCteTable()), cteRoot.getNavigablePath(), cteRoot.getExplicitAlias(), true);
        } else {
            EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getModel());
            tableGroup = entityDescriptor.createRootTableGroup(true, sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), null, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this);
            entityDescriptor.applyBaseRestrictions(currentQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
        }
        log.tracef("Resolved SqmRoot [%s] to new TableGroup [%s]", sqmRoot, (Object)tableGroup);
        this.registerSqmFromTableGroup(sqmRoot, tableGroup);
        currentQuerySpec.getFromClause().addRoot(tableGroup);
        this.consumeJoins(sqmRoot, fromClauseIndex, tableGroup);
    }

    private void registerSqmFromTableGroup(SqmFrom<?, ?> sqmFrom, TableGroup tableGroup) {
        this.getFromClauseIndex().register(sqmFrom, tableGroup);
        for (SqmFrom<?, ?> sqmTreat : sqmFrom.getSqmTreats()) {
            this.getFromClauseAccess().registerTableGroup(sqmTreat.getNavigablePath(), tableGroup);
        }
    }

    private TableGroup createCteTableGroup(String cteName, NavigablePath navigablePath, String explicitAlias, boolean canUseInnerJoins) {
        SqlAliasBase sqlAliasBase = this.getSqlAliasBaseGenerator().createSqlAliasBase(explicitAlias == null ? cteName : explicitAlias);
        String identifierVariable = sqlAliasBase.generateNewAlias();
        CteStatement cteStatement = this.cteContainer.getCteStatement(cteName);
        if (cteStatement == null) {
            throw new InterpretationException("Could not find CTE for name '" + cteName + "'!");
        }
        QueryPart cteQueryPart = ((SelectStatement)cteStatement.getCteDefinition()).getQueryPart();
        if (cteQueryPart instanceof QueryGroup && Boolean.TRUE == this.processingStateStack.findCurrentFirstWithParameter(cteQueryPart, BaseSqmToSqlAstConverter::matchSqlAstWithQueryPart)) {
            cteStatement.setRecursive();
        }
        AnonymousTupleTableGroupProducer tableGroupProducer = cteStatement.getCteTable().getTableGroupProducer();
        return new CteTableGroup(canUseInnerJoins, navigablePath, sqlAliasBase, tableGroupProducer, new NamedTableReference(cteName, identifierVariable), tableGroupProducer.getCompatibleTableExpressions());
    }

    private void consumeJoins(SqmRoot<?> sqmRoot, FromClauseIndex fromClauseIndex, TableGroup tableGroup) {
        if (sqmRoot.getOrderedJoins() == null) {
            this.consumeExplicitJoins(sqmRoot, tableGroup);
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("Visiting explicit joins for `%s`", (Object)sqmRoot.getNavigablePath());
            }
            TableGroup lastTableGroup = tableGroup;
            for (SqmJoin<?, ?> join : sqmRoot.getOrderedJoins()) {
                TableGroup ownerTableGroup = join.getLhs() == null ? tableGroup : (join.getLhs() instanceof SqmCorrelation ? fromClauseIndex.findTableGroup(((SqmCorrelation)join.getLhs()).getCorrelatedRoot().getNavigablePath()) : fromClauseIndex.findTableGroup(join.getLhs().getNavigablePath()));
                assert (ownerTableGroup != null);
                TableGroup actualTableGroup = this.getActualTableGroup(ownerTableGroup, join);
                lastTableGroup = this.consumeExplicitJoin(join, lastTableGroup, actualTableGroup, false);
            }
        }
    }

    private EntityPersister resolveEntityPersister(EntityDomainType<?> entityDomainType) {
        return this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityDomainType.getHibernateEntityName());
    }

    private void registerEntityNameProjectionUsage(SqmPath<?> projectedPath, TableGroup tableGroup) {
        if (projectedPath instanceof SqmTreatedPath) {
            EntityDomainType treatedType = ((SqmTreatedPath)projectedPath).getTreatTarget();
            this.registerEntityNameUsage(tableGroup, EntityNameUse.TREAT, treatedType.getHibernateEntityName(), true);
            if (projectedPath instanceof SqmFrom) {
                ((SqlAstQueryPartProcessingState)this.getCurrentProcessingState()).registerFromUsage((SqmFrom)((SqmTreatedPath)projectedPath).getWrappedPath(), false);
            }
        } else if (projectedPath.getNodeType().getSqmPathType() instanceof EntityDomainType) {
            EntityDomainType treatedType = (EntityDomainType)projectedPath.getNodeType().getSqmPathType();
            this.registerEntityNameUsage(tableGroup, EntityNameUse.PROJECTION, treatedType.getHibernateEntityName(), true);
            if (projectedPath instanceof SqmFrom) {
                ((SqlAstQueryPartProcessingState)this.getCurrentProcessingState()).registerFromUsage((SqmFrom)projectedPath, true);
            }
        }
    }

    private void registerPathAttributeEntityNameUsage(SqmPath<?> sqmPath, TableGroup tableGroup) {
        SqmPathSource<?> resolvedModel;
        JpaPath parentPath = sqmPath.getLhs();
        SqlAstProcessingState processingState = this.getCurrentProcessingState();
        if (processingState instanceof SqlAstQueryPartProcessingState) {
            if (parentPath instanceof SqmFrom) {
                ((SqlAstQueryPartProcessingState)processingState).registerFromUsage((SqmFrom)parentPath, true);
            }
            if (sqmPath instanceof SqmFrom) {
                ((SqlAstQueryPartProcessingState)processingState).registerFromUsage((SqmFrom)sqmPath, true);
            }
        }
        if (!(sqmPath instanceof SqmTreatedPath) && tableGroup.getModelPart().getPartMappingType() instanceof EntityMappingType && (resolvedModel = sqmPath.getResolvedModel()) instanceof PersistentAttribute) {
            EntityMappingType parentType;
            String attributeName = resolvedModel.getPathName();
            EntityMappingType entityType = (EntityMappingType)tableGroup.getModelPart().getPartMappingType();
            if (parentPath instanceof SqmTreatedPath) {
                EntityDomainType treatTarget = ((SqmTreatedPath)parentPath).getTreatTarget();
                parentType = this.creationContext.getMappingMetamodel().getEntityDescriptor(treatTarget.getHibernateEntityName());
                ModelPart subPart = parentType.findSubPart(attributeName);
                EntityNameUse entityNameUse = subPart instanceof BasicValuedModelPart ? EntityNameUse.OPTIONAL_TREAT : EntityNameUse.BASE_TREAT;
                this.registerEntityNameUsage(tableGroup, entityNameUse, treatTarget.getHibernateEntityName());
            } else {
                parentType = entityType;
            }
            AttributeMapping attributeMapping = parentType.findAttributeMapping(attributeName);
            if (attributeMapping == null) {
                if (attributeName.equals(parentType.getIdentifierMapping().getAttributeName())) {
                    if (parentType.getIdentifierMapping() instanceof EmbeddableValuedModelPart) {
                        this.registerEntityNameUsage(tableGroup, EntityNameUse.EXPRESSION, parentType.getRootEntityDescriptor().getEntityName());
                    }
                    this.registerEntityNameUsage(tableGroup, EntityNameUse.EXPRESSION, parentType.getEntityName());
                } else {
                    for (EntityMappingType subMappingType : parentType.getSubMappingTypes()) {
                        if (subMappingType.findDeclaredAttributeMapping(attributeName) == null) continue;
                        this.registerEntityNameUsage(tableGroup, EntityNameUse.EXPRESSION, subMappingType.getEntityName());
                    }
                }
            } else {
                this.registerEntityNameUsage(tableGroup, EntityNameUse.EXPRESSION, attributeMapping.findContainingEntityMapping().getEntityName());
            }
        }
    }

    @Override
    public boolean supportsEntityNameUsage() {
        return true;
    }

    @Override
    public void registerEntityNameUsage(TableGroup tableGroup, EntityNameUse entityNameUse, String hibernateEntityName) {
        this.registerEntityNameUsage(tableGroup, entityNameUse, hibernateEntityName, false);
    }

    private void registerEntityNameUsage(TableGroup tableGroup, EntityNameUse entityNameUse, String hibernateEntityName, boolean projection) {
        EntityNameUse finalEntityNameUse;
        TableGroup actualTableGroup;
        AbstractEntityPersister persister = (AbstractEntityPersister)this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(hibernateEntityName);
        if (persister == null || !persister.isPolymorphic()) {
            return;
        }
        if (tableGroup instanceof CorrelatedTableGroup) {
            actualTableGroup = ((CorrelatedTableGroup)tableGroup).getCorrelatedTableGroup();
            finalEntityNameUse = entityNameUse == EntityNameUse.EXPRESSION ? entityNameUse : EntityNameUse.PROJECTION;
        } else {
            actualTableGroup = tableGroup instanceof PluralTableGroup ? ((PluralTableGroup)tableGroup).getElementTableGroup() : tableGroup;
            finalEntityNameUse = entityNameUse == EntityNameUse.EXPRESSION || entityNameUse == EntityNameUse.PROJECTION || this.contextAllowsTreatOrFilterEntityNameUse() ? entityNameUse : EntityNameUse.EXPRESSION;
        }
        Map entityNameUses = this.tableGroupEntityNameUses.computeIfAbsent(actualTableGroup, tg -> new HashMap(1));
        entityNameUses.compute(hibernateEntityName, (s, existingUse) -> finalEntityNameUse.stronger((EntityNameUse)existingUse));
        if (actualTableGroup.isInitialized()) {
            actualTableGroup.resolveTableReference(null, persister.getTableName());
        }
        EntityNameUse.UseKind useKind = finalEntityNameUse.getKind();
        if (projection) {
            EntityMappingType superMappingType = persister;
            while ((superMappingType = superMappingType.getSuperMappingType()) != null) {
                entityNameUses.putIfAbsent(superMappingType.getEntityName(), EntityNameUse.PROJECTION);
                actualTableGroup.resolveTableReference(null, ((AbstractEntityPersister)superMappingType.getEntityPersister()).getTableName());
            }
        }
        if (useKind == EntityNameUse.UseKind.TREAT || useKind == EntityNameUse.UseKind.PROJECTION) {
            for (EntityMappingType subType : persister.getSubMappingTypes()) {
                entityNameUses.compute(subType.getEntityName(), (s, existingUse) -> finalEntityNameUse.stronger((EntityNameUse)existingUse));
                if (useKind != EntityNameUse.UseKind.PROJECTION) continue;
                actualTableGroup.resolveTableReference(null, subType.getEntityPersister().getMappedTableDetails().getTableName());
            }
        }
    }

    private boolean contextAllowsTreatOrFilterEntityNameUse() {
        Clause currentClause = this.getCurrentClauseStack().getCurrent();
        switch (currentClause) {
            case SET: 
            case FROM: 
            case GROUP: 
            case HAVING: 
            case WHERE: {
                return !this.inNestedContext;
            }
        }
        return false;
    }

    protected void registerTypeUsage(EntityDiscriminatorSqmPath path) {
        this.registerTypeUsage(this.getFromClauseAccess().getTableGroup(path.getNavigablePath().getParent()));
    }

    protected void registerTypeUsage(TableGroup tableGroup) {
        EntityMappingType mappingType = (EntityMappingType)tableGroup.getModelPart().getPartMappingType();
        AbstractEntityPersister persister = (AbstractEntityPersister)mappingType.getEntityPersister();
        if (this.getCurrentClauseStack().getCurrent() != Clause.WHERE && this.getCurrentClauseStack().getCurrent() != Clause.HAVING) {
            this.registerEntityNameUsage(tableGroup, EntityNameUse.PROJECTION, persister.getEntityName(), true);
        } else {
            if (persister instanceof SingleTableEntityPersister) {
                return;
            }
            int subclassTableSpan = persister.getSubclassTableSpan();
            for (int i = 0; i < subclassTableSpan; ++i) {
                tableGroup.resolveTableReference(null, persister.getSubclassTableName(i));
            }
        }
    }

    protected void pruneTableGroupJoins() {
        for (Map.Entry<TableGroup, Map<String, EntityNameUse>> entry : this.tableGroupEntityNameUses.entrySet()) {
            TableGroup tableGroup = entry.getKey();
            if (!tableGroup.isInitialized()) continue;
            Map<String, EntityNameUse> entityNameUses = entry.getValue();
            ModelPartContainer modelPart = tableGroup.getModelPart();
            EntityPersister tableGroupPersister = modelPart instanceof PluralAttributeMapping ? (EntityPersister)((PluralAttributeMapping)modelPart).getElementDescriptor().getPartMappingType() : (EntityPersister)modelPart.getPartMappingType();
            tableGroupPersister.pruneForSubclasses(tableGroup, entityNameUses);
        }
    }

    protected void consumeExplicitJoins(SqmFrom<?, ?> sqmFrom, TableGroup lhsTableGroup) {
        if (log.isTraceEnabled()) {
            log.tracef("Visiting explicit joins for `%s`", (Object)sqmFrom.getNavigablePath());
        }
        sqmFrom.visitSqmJoins(sqmJoin -> {
            TableGroup actualTableGroup = this.getActualTableGroup(lhsTableGroup, (SqmPath<?>)sqmJoin);
            this.registerPathAttributeEntityNameUsage((SqmPath<?>)sqmJoin, actualTableGroup);
            this.consumeExplicitJoin((SqmJoin<?, ?>)sqmJoin, actualTableGroup, actualTableGroup, true);
        });
        List<SqmFrom<?, ?>> sqmTreats = sqmFrom.getSqmTreats();
        if (!sqmTreats.isEmpty()) {
            SqlAstQueryPartProcessingState queryPartProcessingState = (SqlAstQueryPartProcessingState)this.getCurrentProcessingState();
            queryPartProcessingState.registerTreatedFrom(sqmFrom);
            if (lhsTableGroup.hasRealJoins()) {
                queryPartProcessingState.registerFromUsage(sqmFrom, true);
            }
            for (SqmFrom<?, ?> sqmTreat : sqmTreats) {
                TableGroup actualTableGroup = this.getActualTableGroup(lhsTableGroup, sqmTreat);
                this.registerEntityNameUsage(actualTableGroup, EntityNameUse.BASE_TREAT, ((SqmTreatedPath)((Object)sqmTreat)).getTreatTarget().getHibernateEntityName());
                this.consumeExplicitJoins(sqmTreat, actualTableGroup);
            }
        }
    }

    protected TableGroup consumeExplicitJoin(SqmJoin<?, ?> sqmJoin, TableGroup lhsTableGroup, TableGroup ownerTableGroup, boolean transitive) {
        if (sqmJoin instanceof SqmAttributeJoin) {
            return this.consumeAttributeJoin((SqmAttributeJoin)sqmJoin, lhsTableGroup, ownerTableGroup, transitive);
        }
        if (sqmJoin instanceof SqmCrossJoin) {
            return this.consumeCrossJoin((SqmCrossJoin)sqmJoin, lhsTableGroup, transitive);
        }
        if (sqmJoin instanceof SqmEntityJoin) {
            return this.consumeEntityJoin((SqmEntityJoin)sqmJoin, lhsTableGroup, transitive);
        }
        if (sqmJoin instanceof SqmDerivedJoin) {
            return this.consumeDerivedJoin((SqmDerivedJoin)sqmJoin, lhsTableGroup, transitive);
        }
        if (sqmJoin instanceof SqmCteJoin) {
            return this.consumeCteJoin((SqmCteJoin)sqmJoin, lhsTableGroup, transitive);
        }
        if (sqmJoin instanceof SqmPluralPartJoin) {
            return this.consumePluralPartJoin((SqmPluralPartJoin)sqmJoin, ownerTableGroup, transitive);
        }
        throw new InterpretationException("Could not resolve SqmJoin [" + sqmJoin.getNavigablePath() + "] to TableGroupJoin");
    }

    private TableGroup getActualTableGroup(TableGroup lhsTableGroup, SqmPath<?> path) {
        TableGroup elementTableGroup;
        if (lhsTableGroup instanceof PluralTableGroup && !(path instanceof SqmPluralPartJoin) && CollectionPart.Nature.fromName(path.getNavigablePath().getLocalName()) == null && (elementTableGroup = ((PluralTableGroup)lhsTableGroup).getElementTableGroup()) != null) {
            return elementTableGroup;
        }
        return lhsTableGroup;
    }

    private TableGroup consumeAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin, TableGroup lhsTableGroup, TableGroup ownerTableGroup, boolean transitive) {
        TableGroup joinedTableGroup;
        TableGroupJoin joinedTableGroupJoin;
        SqmPathSource<?> pathSource = sqmJoin.getReferencedPathSource();
        SqmJoinType sqmJoinType = sqmJoin.getSqmJoinType();
        NavigablePath sqmJoinNavigablePath = sqmJoin.getNavigablePath();
        ModelPart modelPart = ownerTableGroup.getModelPart().findSubPart(pathSource.getPathName(), SqmMappingModelHelper.resolveExplicitTreatTarget(sqmJoin, this));
        if (pathSource instanceof PluralPersistentAttribute) {
            assert (modelPart instanceof PluralAttributeMapping);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPart;
            if (sqmJoin.isFetched()) {
                this.containsCollectionFetches = true;
            }
            joinedTableGroupJoin = pluralAttributeMapping.createTableGroupJoin(sqmJoinNavigablePath, ownerTableGroup, sqmJoin.getExplicitAlias(), null, sqmJoinType.getCorrespondingSqlJoinType(), sqmJoin.isFetched(), sqmJoin.getJoinPredicate() != null, this);
            joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
        } else {
            assert (modelPart instanceof TableGroupJoinProducer);
            joinedTableGroupJoin = ((TableGroupJoinProducer)modelPart).createTableGroupJoin(sqmJoinNavigablePath, ownerTableGroup, sqmJoin.getExplicitAlias(), null, sqmJoinType.getCorrespondingSqlJoinType(), sqmJoin.isFetched(), sqmJoin.getJoinPredicate() != null, this);
            joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
            if (sqmJoin.getJoinPredicate() != null || sqmJoinType != SqmJoinType.INNER && sqmJoinType != SqmJoinType.LEFT) {
                joinedTableGroup.getPrimaryTableReference();
            }
        }
        lhsTableGroup.addTableGroupJoin(joinedTableGroupJoin);
        this.registerSqmFromTableGroup(sqmJoin, joinedTableGroup);
        this.registerPluralTableGroupParts(joinedTableGroup);
        if (sqmJoin.isFetched()) {
            this.registerEntityNameProjectionUsage(sqmJoin, this.getActualTableGroup(joinedTableGroup, sqmJoin));
        }
        this.registerPathAttributeEntityNameUsage(sqmJoin, ownerTableGroup);
        if (!sqmJoin.hasTreats() && sqmJoin.getNodeType().getSqmPathType() instanceof EntityDomainType) {
            EntityDomainType entityDomainType = (EntityDomainType)sqmJoin.getNodeType().getSqmPathType();
            TableGroup elementTableGroup = joinedTableGroup instanceof PluralTableGroup ? ((PluralTableGroup)joinedTableGroup).getElementTableGroup() : joinedTableGroup;
            EntityValuedModelPart entityModelPart = (EntityValuedModelPart)elementTableGroup.getModelPart();
            EntityPersister entityDescriptor = entityModelPart.getEntityMappingType().getEntityPersister();
            if (entityDescriptor.getSuperMappingType() != null) {
                this.registerEntityNameUsage(this.getActualTableGroup(joinedTableGroup, sqmJoin), EntityNameUse.TREAT, entityDomainType.getHibernateEntityName());
            }
        }
        TableGroupJoin joinForPredicate = !joinedTableGroup.getNestedTableGroupJoins().isEmpty() || joinedTableGroup.getTableGroupJoins().isEmpty() ? joinedTableGroupJoin : joinedTableGroup.getTableGroupJoins().get(joinedTableGroup.getTableGroupJoins().size() - 1);
        if (sqmJoin.getJoinPredicate() != null) {
            if (sqmJoin.isFetched()) {
                QueryLogging.QUERY_MESSAGE_LOGGER.debugf("Join fetch [%s] is restricted", sqmJoinNavigablePath);
            }
            SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
            this.currentlyProcessingJoin = sqmJoin;
            Predicate predicate = this.visitNestedTopLevelPredicate(sqmJoin.getJoinPredicate());
            if (joinForPredicate.getJoinedGroup().isInitialized()) {
                joinForPredicate.applyPredicate(predicate);
            } else {
                joinedTableGroupJoin.applyPredicate(predicate);
            }
            this.currentlyProcessingJoin = oldJoin;
        }
        if (sqmJoin.getLhs() instanceof SqmTreatedPath) {
            SqmTreatedPath treatedPath = (SqmTreatedPath)sqmJoin.getLhs();
            joinForPredicate.applyPredicate(this.createTreatTypeRestriction(treatedPath.getWrappedPath(), treatedPath.getTreatTarget()));
        }
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, joinedTableGroup);
        }
        return joinedTableGroup;
    }

    private TableGroup consumeCrossJoin(SqmCrossJoin<?> sqmJoin, TableGroup lhsTableGroup, boolean transitive) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(true, sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), null, () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), SqlAstJoinType.CROSS, tableGroup);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        this.registerSqmFromTableGroup(sqmJoin, tableGroup);
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        }
        return tableGroup;
    }

    private TableGroup consumeEntityJoin(SqmEntityJoin<?> sqmJoin, TableGroup lhsTableGroup, boolean transitive) {
        MutableBoolean needsTreat = new MutableBoolean(false);
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        SqlAstJoinType correspondingSqlJoinType = sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType();
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(correspondingSqlJoinType == SqlAstJoinType.INNER || correspondingSqlJoinType == SqlAstJoinType.CROSS, sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), null, () -> p -> needsTreat.setValue(true), this);
        this.registerSqmFromTableGroup(sqmJoin, tableGroup);
        if (needsTreat.getValue()) {
            this.registerEntityNameUsage(tableGroup, EntityNameUse.TREAT, entityDescriptor.getEntityName());
        }
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), correspondingSqlJoinType, tableGroup, null);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        if (sqmJoin.getJoinPredicate() != null) {
            SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
            this.currentlyProcessingJoin = sqmJoin;
            tableGroupJoin.applyPredicate(this.visitNestedTopLevelPredicate(sqmJoin.getJoinPredicate()));
            this.currentlyProcessingJoin = oldJoin;
        } else if (correspondingSqlJoinType != SqlAstJoinType.CROSS) {
            throw new SemanticException("Entity join did not specify a join condition [" + sqmJoin + "] (specify a join condition with 'on' or use 'cross join')");
        }
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        }
        return tableGroup;
    }

    private TableGroup consumeDerivedJoin(SqmDerivedJoin<?> sqmJoin, TableGroup parentTableGroup, boolean transitive) {
        SelectStatement statement = (SelectStatement)((SqmSubQuery)sqmJoin.getQueryPart()).accept(this);
        AnonymousTupleType tupleType = (AnonymousTupleType)sqmJoin.getNodeType();
        List<SqlSelection> sqlSelections = statement.getQueryPart().getFirstQuerySpec().getSelectClause().getSqlSelections();
        AnonymousTupleTableGroupProducer tableGroupProducer = tupleType.resolveTableGroupProducer(sqmJoin.getExplicitAlias(), sqlSelections, this.lastPoppedFromClauseIndex);
        List<String> columnNames = tupleType.determineColumnNames();
        SqlAliasBase sqlAliasBase = this.getSqlAliasBaseGenerator().createSqlAliasBase(sqmJoin.getExplicitAlias() == null ? "derived" : sqmJoin.getExplicitAlias());
        String identifierVariable = sqlAliasBase.generateNewAlias();
        QueryPartTableGroup queryPartTableGroup = new QueryPartTableGroup(sqmJoin.getNavigablePath(), tableGroupProducer, statement, identifierVariable, columnNames, tableGroupProducer.getCompatibleTableExpressions(), sqmJoin.isLateral(), false, this.creationContext.getSessionFactory());
        this.getFromClauseIndex().register(sqmJoin, queryPartTableGroup);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(queryPartTableGroup.getNavigablePath(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), queryPartTableGroup, null);
        parentTableGroup.addTableGroupJoin(tableGroupJoin);
        if (sqmJoin.getJoinPredicate() != null) {
            SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
            this.currentlyProcessingJoin = sqmJoin;
            tableGroupJoin.applyPredicate(this.visitNestedTopLevelPredicate(sqmJoin.getJoinPredicate()));
            this.currentlyProcessingJoin = oldJoin;
        }
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, queryPartTableGroup);
        }
        return queryPartTableGroup;
    }

    private TableGroup consumeCteJoin(SqmCteJoin<?> sqmJoin, TableGroup parentTableGroup, boolean transitive) {
        SqlAstJoinType correspondingSqlJoinType = sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType();
        TableGroup tableGroup = this.createCteTableGroup(this.getCteName(sqmJoin.getCte().getCteTable()), sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), correspondingSqlJoinType == SqlAstJoinType.INNER || correspondingSqlJoinType == SqlAstJoinType.CROSS);
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(tableGroup.getNavigablePath(), correspondingSqlJoinType, tableGroup, null);
        parentTableGroup.addTableGroupJoin(tableGroupJoin);
        if (sqmJoin.getJoinPredicate() != null) {
            SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
            this.currentlyProcessingJoin = sqmJoin;
            tableGroupJoin.applyPredicate(this.visitNestedTopLevelPredicate(sqmJoin.getJoinPredicate()));
            this.currentlyProcessingJoin = oldJoin;
        }
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, tableGroup);
        }
        return tableGroup;
    }

    private TableGroup consumePluralPartJoin(SqmPluralPartJoin<?, ?> sqmJoin, TableGroup lhsTableGroup, boolean transitive) {
        PluralTableGroup pluralTableGroup = (PluralTableGroup)lhsTableGroup;
        TableGroup tableGroup = this.getPluralPartTableGroup(pluralTableGroup, sqmJoin.getReferencedPathSource());
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        assert (sqmJoin.getJoinPredicate() == null);
        if (transitive) {
            this.consumeExplicitJoins(sqmJoin, tableGroup);
        }
        return tableGroup;
    }

    private TableGroup getPluralPartTableGroup(PluralTableGroup pluralTableGroup, SqmPathSource<?> pathSource) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(pathSource.getPathName());
        if (nature != null) {
            switch (nature) {
                case INDEX: {
                    return pluralTableGroup.getIndexTableGroup();
                }
                case ELEMENT: {
                    return pluralTableGroup.getElementTableGroup();
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported plural part join nature: " + nature);
    }

    private <X> X prepareReusablePath(SqmPath<?> sqmPath, Supplier<X> supplier) {
        return this.prepareReusablePath(sqmPath, this.fromClauseIndexStack.getCurrent(), supplier, false);
    }

    private <X> X prepareReusablePath(SqmPath<?> sqmPath, FromClauseIndex fromClauseIndex, Supplier<X> supplier, boolean allowLeftJoins) {
        TableGroup createdTableGroup;
        TableGroup existingTableGroup;
        Consumer<TableGroup> implicitJoinChecker = this.getCurrentClauseStack().getCurrent() != Clause.SET_EXPRESSION ? tg -> {} : BaseSqmToSqlAstConverter::verifyManipulationImplicitJoin;
        this.prepareReusablePath(fromClauseIndex, sqmPath, implicitJoinChecker);
        if ((sqmPath instanceof SqmEntityValuedSimplePath || sqmPath instanceof SqmEmbeddedValuedSimplePath || sqmPath instanceof SqmAnyValuedSimplePath) && (existingTableGroup = fromClauseIndex.findTableGroupForGetOrCreate(sqmPath.getNavigablePath())) == null && (createdTableGroup = this.createTableGroup(this.getActualTableGroup(fromClauseIndex.getTableGroup(sqmPath.getLhs().getNavigablePath()), sqmPath), sqmPath, allowLeftJoins)) != null && sqmPath instanceof SqmTreatedPath) {
            fromClauseIndex.register(sqmPath, createdTableGroup);
        }
        return supplier.get();
    }

    private TableGroup prepareReusablePath(FromClauseIndex fromClauseIndex, JpaPath<?> path, Consumer<TableGroup> implicitJoinChecker) {
        SqmPath sqmPath = (SqmPath)path;
        SqmPath parentPath = sqmPath instanceof SqmTreatedPath ? ((SqmTreatedPath)sqmPath).getWrappedPath() : sqmPath.getLhs();
        if (parentPath == null) {
            return null;
        }
        TableGroup parentTableGroup = this.getActualTableGroup(fromClauseIndex.findTableGroupForGetOrCreate(parentPath.getNavigablePath()), sqmPath);
        if (parentTableGroup == null) {
            TableGroup newTableGroup;
            TableGroup createdParentTableGroup = this.prepareReusablePath(fromClauseIndex, parentPath, implicitJoinChecker);
            if (createdParentTableGroup == null) {
                throw new SqlTreeCreationException("Could not locate TableGroup - " + parentPath.getNavigablePath());
            }
            if (parentPath instanceof SqmTreatedPath) {
                fromClauseIndex.register(parentPath, createdParentTableGroup);
                newTableGroup = createdParentTableGroup;
            } else if (createdParentTableGroup instanceof PluralTableGroup) {
                CollectionPart.Nature nature = CollectionPart.Nature.fromName(parentPath.getNavigablePath().getLocalName());
                assert (nature != null);
                newTableGroup = ((PluralTableGroup)createdParentTableGroup).getTableGroup(nature);
            } else {
                newTableGroup = this.getActualTableGroup(this.createTableGroup(createdParentTableGroup, parentPath, false), sqmPath);
            }
            if (newTableGroup != null) {
                implicitJoinChecker.accept(newTableGroup);
                this.registerPathAttributeEntityNameUsage(sqmPath, newTableGroup);
            }
            return newTableGroup;
        }
        if (sqmPath instanceof SqmTreatedPath) {
            fromClauseIndex.register(sqmPath, parentTableGroup);
        }
        this.upgradeToInnerJoinIfNeeded(parentTableGroup, sqmPath, parentPath, fromClauseIndex);
        this.registerPathAttributeEntityNameUsage(sqmPath, parentTableGroup);
        return parentTableGroup;
    }

    private void upgradeToInnerJoinIfNeeded(TableGroup parentTableGroup, SqmPath<?> sqmPath, SqmPath<?> parentPath, FromClauseIndex fromClauseIndex) {
        if (this.getCurrentClauseStack().getCurrent() != Clause.SELECT && parentPath instanceof SqmSimplePath && CollectionPart.Nature.fromName(parentPath.getNavigablePath().getLocalName()) == null && parentPath.getParentPath() != null && parentTableGroup.getModelPart() instanceof ToOneAttributeMapping) {
            NavigablePath parentParentPath;
            TableGroup parentParentTableGroup;
            TableGroupJoin tableGroupJoin;
            ModelPart pathPart;
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)parentTableGroup.getModelPart();
            String partName = sqmPath.getResolvedModel().getPathName();
            if (!(toOneAttributeMapping.isFkOptimizationAllowed() && (pathPart = toOneAttributeMapping.findSubPart(partName)) instanceof ValuedModelPart && toOneAttributeMapping.getForeignKeyDescriptor().isKeyPart((ValuedModelPart)pathPart) || (tableGroupJoin = (parentParentTableGroup = fromClauseIndex.findTableGroup(parentParentPath = parentPath.getParentPath().getNavigablePath())).findTableGroupJoin(parentTableGroup)) == null)) {
                tableGroupJoin.setJoinType(SqlAstJoinType.INNER);
            }
        }
    }

    private void prepareForSelection(SqmPath<?> selectionPath) {
        JpaPath<Object> path = selectionPath instanceof AbstractSqmSpecificPluralPartPath ? selectionPath.getLhs().getLhs() : selectionPath;
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        TableGroup tableGroup = fromClauseIndex.findTableGroupForGetOrCreate(path.getNavigablePath());
        if (tableGroup == null) {
            this.prepareReusablePath((SqmPath<?>)path, (Supplier)() -> null);
            if (!(path instanceof SqmEntityValuedSimplePath || path instanceof SqmEmbeddedValuedSimplePath || path instanceof SqmAnyValuedSimplePath || path instanceof SqmTreatedPath)) {
                TableGroup createdTableGroup = this.createTableGroup(this.getActualTableGroup(fromClauseIndex.getTableGroup(path.getLhs().getNavigablePath()), (SqmPath<?>)path), (SqmPath<?>)path, false);
                if (createdTableGroup != null) {
                    this.registerEntityNameProjectionUsage((SqmPath<?>)path, createdTableGroup);
                }
            } else {
                this.registerEntityNameProjectionUsage((SqmPath<?>)path, fromClauseIndex.findTableGroup(path.getNavigablePath()));
            }
        } else {
            this.registerEntityNameProjectionUsage((SqmPath<?>)path, tableGroup);
            if (path instanceof SqmSimplePath && CollectionPart.Nature.fromName(path.getNavigablePath().getLocalName()) == null) {
                fromClauseIndex.findTableGroup(path.getNavigablePath().getParent()).findTableGroupJoin(tableGroup).setJoinType(SqlAstJoinType.INNER);
            }
        }
    }

    private TableGroup createTableGroup(TableGroup parentTableGroup, SqmPath<?> joinedPath, boolean allowLeftJoins) {
        TableGroup tableGroup;
        JpaPath lhsPath = joinedPath.getLhs();
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        ModelPart subPart = parentTableGroup.getModelPart().findSubPart(joinedPath.getReferencedPathSource().getPathName(), lhsPath instanceof SqmTreatedPath ? this.resolveEntityPersister(((SqmTreatedPath)lhsPath).getTreatTarget()) : null);
        if (subPart instanceof TableGroupJoinProducer) {
            TableGroupJoinProducer joinProducer = (TableGroupJoinProducer)subPart;
            if (fromClauseIndex.findTableGroupOnCurrentFromClause(parentTableGroup.getNavigablePath()) == null && !this.isRecursiveCte(parentTableGroup)) {
                QuerySpec querySpec = this.currentQuerySpec();
                tableGroup = joinProducer.createRootTableGroupJoin(joinedPath.getNavigablePath(), parentTableGroup, null, null, null, false, querySpec::applyPredicate, this);
                querySpec.getFromClause().addRoot(tableGroup);
            } else {
                TableGroup compatibleTableGroup;
                SqlAstJoinType sqlAstJoinType;
                TableGroupJoin compatibleLeftJoin;
                if (this.isMappedByOrNotFoundToOne(joinProducer)) {
                    compatibleLeftJoin = parentTableGroup.findCompatibleJoin(joinProducer, SqlAstJoinType.LEFT);
                    sqlAstJoinType = SqlAstJoinType.LEFT;
                } else {
                    compatibleLeftJoin = null;
                    sqlAstJoinType = null;
                }
                TableGroup tableGroup2 = compatibleTableGroup = compatibleLeftJoin != null ? compatibleLeftJoin.getJoinedGroup() : parentTableGroup.findCompatibleJoinedGroup(joinProducer, SqlAstJoinType.INNER);
                if (compatibleTableGroup == null) {
                    boolean nested;
                    TableGroupJoin tableGroupJoin = joinProducer.createTableGroupJoin(joinedPath.getNavigablePath(), parentTableGroup, null, null, allowLeftJoins ? sqlAstJoinType : null, false, false, this);
                    boolean bl = nested = this.currentClauseStack.getCurrent() == Clause.FROM;
                    if (nested) {
                        parentTableGroup.addNestedTableGroupJoin(tableGroupJoin);
                    } else {
                        parentTableGroup.addTableGroupJoin(tableGroupJoin);
                    }
                    tableGroup = tableGroupJoin.getJoinedGroup();
                } else {
                    tableGroup = compatibleTableGroup;
                    fromClauseIndex.registerTableGroup(tableGroup.getNavigablePath(), tableGroup);
                    if (compatibleLeftJoin != null && !allowLeftJoins) {
                        compatibleLeftJoin.setJoinType(SqlAstJoinType.INNER);
                    }
                }
            }
            fromClauseIndex.register(joinedPath, tableGroup);
            this.registerPluralTableGroupParts(joinedPath.getNavigablePath(), tableGroup);
        } else {
            tableGroup = null;
        }
        return tableGroup;
    }

    private boolean isMappedByOrNotFoundToOne(TableGroupJoinProducer joinProducer) {
        ToOneAttributeMapping toOne;
        return joinProducer instanceof ToOneAttributeMapping && ((toOne = (ToOneAttributeMapping)joinProducer).hasNotFoundAction() || toOne.getReferencedPropertyName() != null);
    }

    private boolean isRecursiveCte(TableGroup tableGroup) {
        if (tableGroup instanceof CteTableGroup) {
            CteTableGroup cteTableGroup = (CteTableGroup)tableGroup;
            return this.cteContainer.getCteStatement(cteTableGroup.getPrimaryTableReference().getTableId()).isRecursive();
        }
        return false;
    }

    private void registerPluralTableGroupParts(TableGroup tableGroup) {
        this.registerPluralTableGroupParts(null, tableGroup);
    }

    private void registerPluralTableGroupParts(NavigablePath navigablePath, TableGroup tableGroup) {
        if (tableGroup instanceof PluralTableGroup) {
            PluralTableGroup pluralTableGroup = (PluralTableGroup)tableGroup;
            if (pluralTableGroup.getElementTableGroup() != null) {
                this.getFromClauseAccess().registerTableGroup(navigablePath == null || navigablePath == tableGroup.getNavigablePath() ? pluralTableGroup.getElementTableGroup().getNavigablePath() : navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), pluralTableGroup.getElementTableGroup());
            }
            if (pluralTableGroup.getIndexTableGroup() != null) {
                this.getFromClauseAccess().registerTableGroup(navigablePath == null || navigablePath == tableGroup.getNavigablePath() ? pluralTableGroup.getIndexTableGroup().getNavigablePath() : navigablePath.append(CollectionPart.Nature.INDEX.getName()), pluralTableGroup.getIndexTableGroup());
            }
        }
    }

    @Override
    public Expression visitRootPath(SqmRoot<?> sqmRoot) {
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(sqmRoot.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmRoot [%s] resolved to existing TableGroup [%s]", sqmRoot, (Object)resolved);
            return this.visitTableGroup(resolved, sqmRoot);
        }
        throw new InterpretationException("SqmRoot not yet resolved to TableGroup");
    }

    @Override
    public Object visitRootDerived(SqmDerivedRoot<?> sqmRoot) {
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(sqmRoot.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmDerivedRoot [%s] resolved to existing TableGroup [%s]", sqmRoot, (Object)resolved);
            return this.visitTableGroup(resolved, sqmRoot);
        }
        throw new InterpretationException("SqmDerivedRoot not yet resolved to TableGroup");
    }

    @Override
    public Object visitRootCte(SqmCteRoot<?> sqmRoot) {
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(sqmRoot.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmCteRoot [%s] resolved to existing TableGroup [%s]", sqmRoot, (Object)resolved);
            return this.visitTableGroup(resolved, sqmRoot);
        }
        throw new InterpretationException("SqmCteRoot not yet resolved to TableGroup");
    }

    @Override
    public Expression visitQualifiedAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmAttributeJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmAttributeJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitQualifiedDerivedJoin(SqmDerivedJoin<?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmDerivedJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmDerivedJoin not yet resolved to TableGroup");
    }

    @Override
    public Object visitQualifiedCteJoin(SqmCteJoin<?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmCteJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmCteJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitCrossJoin(SqmCrossJoin<?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmCrossJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmCrossJoin not yet resolved to TableGroup");
    }

    @Override
    public Object visitPluralPartJoin(SqmPluralPartJoin<?, ?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmPluralPartJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmPluralPartJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitQualifiedEntityJoin(SqmEntityJoin<?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmEntityJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return this.visitTableGroup(existing, sqmJoin);
        }
        throw new InterpretationException("SqmEntityJoin not yet resolved to TableGroup");
    }

    private Expression visitTableGroup(TableGroup tableGroup, SqmFrom<?, ?> path) {
        AbstractSqmPathInterpretation result;
        NavigablePath navigablePath;
        ModelPart actualModelPart;
        ModelPartContainer tableGroupModelPart = tableGroup.getModelPart();
        if (tableGroupModelPart instanceof PluralAttributeMapping) {
            actualModelPart = ((PluralAttributeMapping)tableGroupModelPart).getElementDescriptor();
            navigablePath = tableGroup.getNavigablePath().append(actualModelPart.getPartName());
        } else {
            actualModelPart = tableGroupModelPart;
            navigablePath = tableGroup.getNavigablePath();
        }
        if (actualModelPart instanceof EntityValuedModelPart) {
            TableGroup tableGroupToUse;
            EntityValuedModelPart interpretationModelPart;
            ModelPart resultModelPart;
            EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)actualModelPart;
            EntityValuedModelPart inferredEntityMapping = (EntityValuedModelPart)this.getInferredValueMapping();
            if (inferredEntityMapping == null) {
                if (entityValuedModelPart instanceof EntityAssociationMapping && ((EntityAssociationMapping)((Object)entityValuedModelPart)).isFkOptimizationAllowed() && SqmUtil.isFkOptimizationAllowed(path)) {
                    EntityAssociationMapping associationMapping = (EntityAssociationMapping)((Object)entityValuedModelPart);
                    ValuedModelPart targetPart = associationMapping.getForeignKeyDescriptor().getPart(associationMapping.getSideNature());
                    resultModelPart = entityValuedModelPart.getPartMappingType() == associationMapping.getPartMappingType() ? targetPart : entityValuedModelPart.findSubPart(targetPart.getPartName(), null);
                } else {
                    resultModelPart = entityValuedModelPart instanceof AnonymousTupleEntityValuedModelPart ? ((AnonymousTupleEntityValuedModelPart)entityValuedModelPart).getForeignKeyPart() : entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
                }
                interpretationModelPart = entityValuedModelPart;
                tableGroupToUse = null;
            } else if (inferredEntityMapping instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)inferredEntityMapping;
                ValuedModelPart targetPart = toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature().inverse());
                resultModelPart = entityValuedModelPart.getPartMappingType() == toOneAttributeMapping.getPartMappingType() ? targetPart : entityValuedModelPart.findSubPart(targetPart.getPartName(), null);
                interpretationModelPart = toOneAttributeMapping;
                tableGroupToUse = null;
            } else if (inferredEntityMapping instanceof EntityCollectionPart) {
                EntityCollectionPart collectionPart = (EntityCollectionPart)inferredEntityMapping;
                tableGroupToUse = tableGroup.getModelPart() instanceof CollectionPart ? this.findTableGroup(tableGroup.getNavigablePath().getParent()) : tableGroup;
                if (collectionPart.getCardinality() == EntityCollectionPart.Cardinality.ONE_TO_MANY) {
                    resultModelPart = collectionPart.getAssociatedEntityMappingType().getIdentifierMapping();
                } else {
                    assert (collectionPart.getCardinality() == EntityCollectionPart.Cardinality.MANY_TO_MANY);
                    ManyToManyCollectionPart manyToManyPart = (ManyToManyCollectionPart)collectionPart;
                    if (entityValuedModelPart == collectionPart) {
                        resultModelPart = manyToManyPart.getForeignKeyDescriptor().getKeyPart();
                    } else if (entityValuedModelPart instanceof EntityAssociationMapping) {
                        ValuedModelPart inferredTargetPart;
                        EntityAssociationMapping tableGroupAssociation = (EntityAssociationMapping)((Object)entityValuedModelPart);
                        ValuedModelPart pathTargetPart = tableGroupAssociation.getForeignKeyDescriptor().getPart(tableGroupAssociation.getSideNature().inverse());
                        resultModelPart = pathTargetPart == (inferredTargetPart = manyToManyPart.getForeignKeyDescriptor().getPart(ForeignKeyDescriptor.Nature.TARGET)) || tableGroupAssociation.isReferenceToPrimaryKey() ? tableGroupAssociation.getForeignKeyDescriptor().getKeyPart() : collectionPart.getAssociatedEntityMappingType().getIdentifierMapping();
                    } else if (entityValuedModelPart instanceof AnonymousTupleEntityValuedModelPart) {
                        resultModelPart = ((AnonymousTupleEntityValuedModelPart)entityValuedModelPart).getForeignKeyPart();
                    } else {
                        assert (entityValuedModelPart instanceof EntityMappingType);
                        resultModelPart = collectionPart.getCardinality() == EntityCollectionPart.Cardinality.ONE_TO_MANY ? collectionPart.getAssociatedEntityMappingType().getIdentifierMapping() : manyToManyPart.getForeignKeyDescriptor().getPart(manyToManyPart.getSideNature().inverse());
                    }
                }
                interpretationModelPart = inferredEntityMapping;
            } else if (entityValuedModelPart instanceof AnonymousTupleEntityValuedModelPart) {
                resultModelPart = ((AnonymousTupleEntityValuedModelPart)entityValuedModelPart).getForeignKeyPart();
                interpretationModelPart = inferredEntityMapping;
                tableGroupToUse = null;
            } else {
                assert (inferredEntityMapping instanceof EntityMappingType);
                resultModelPart = ((EntityMappingType)inferredEntityMapping).getIdentifierMapping();
                interpretationModelPart = inferredEntityMapping;
                tableGroupToUse = null;
            }
            EntityMappingType treatedMapping = path instanceof SqmTreatedPath ? this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(((SqmTreatedPath)((Object)path)).getTreatTarget().getHibernateEntityName()) : interpretationModelPart.getEntityMappingType();
            result = EntityValuedPathInterpretation.from(navigablePath, tableGroupToUse == null ? tableGroup : tableGroupToUse, resultModelPart, interpretationModelPart, treatedMapping, this);
        } else if (actualModelPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart mapping = (EmbeddableValuedModelPart)actualModelPart;
            result = new EmbeddableValuedPathInterpretation(mapping.toSqlExpression(this.findTableGroup(navigablePath.getParent()), this.currentClauseStack.getCurrent(), this, this.getSqlAstCreationState()), navigablePath, mapping, tableGroup);
        } else if (actualModelPart instanceof BasicValuedModelPart) {
            ColumnReference columnReference;
            BasicValuedModelPart mapping = (BasicValuedModelPart)actualModelPart;
            TableReference tableReference = tableGroup.resolveTableReference(navigablePath.append(actualModelPart.getPartName()), mapping, mapping.getContainingTableExpression());
            Expression expression = this.getSqlExpressionResolver().resolveSqlExpression(tableReference, mapping);
            if (expression instanceof ColumnReference) {
                columnReference = (ColumnReference)expression;
            } else if (expression instanceof SqlSelectionExpression) {
                Expression selectedExpression = ((SqlSelectionExpression)expression).getSelection().getExpression();
                assert (selectedExpression instanceof ColumnReference);
                columnReference = (ColumnReference)selectedExpression;
            } else {
                throw new UnsupportedOperationException("Unsupported basic-valued path expression : " + expression);
            }
            result = new BasicValuedPathInterpretation(columnReference, navigablePath, mapping, tableGroup);
        } else {
            if (actualModelPart instanceof AnonymousTupleTableGroupProducer) {
                throw new SemanticException("The derived SqmFrom" + ((AnonymousTupleType)path.getReferencedPathSource()).getComponentNames() + " can not be used in a context where the expression needs to be expanded to identifying parts, because a derived model part does not have identifying parts. Replace uses of the root with paths instead e.g. `derivedRoot.get(\"alias1\")` or `derivedRoot.alias1`");
            }
            throw new SemanticException("The SqmFrom node [" + path + "] can not be used in a context where the expression needs to be expanded to identifying parts, because the model part [" + actualModelPart + "] does not have identifying parts.");
        }
        return this.withTreatRestriction(result, path);
    }

    @Override
    public Expression visitBasicValuedPath(SqmBasicValuedSimplePath<?> sqmPath) {
        BasicValuedPathInterpretation path;
        Expression result = path = this.prepareReusablePath(sqmPath, () -> BasicValuedPathInterpretation.from(sqmPath, this, this.jpaQueryComplianceEnabled));
        if (TypeConfiguration.isDuration(sqmPath.getNodeType())) {
            Expression scaledExpression = this.applyScale(this.toSqlExpression(path));
            if (this.adjustedTimestamp != null) {
                if (this.appliedByUnit != null) {
                    throw new IllegalStateException();
                }
                result = this.timestampadd().expression((ReturnableType)this.adjustedTimestampType, new DurationUnit(TemporalUnit.SECOND, this.basicType(Long.class)), scaledExpression, this.adjustedTimestamp);
            } else if (this.appliedByUnit != null) {
                JdbcMappingContainer durationType = scaledExpression.getExpressionType();
                Duration duration = durationType.getSingleJdbcMapping().getJdbcType().isInterval() ? new Duration(this.extractEpoch(scaledExpression), TemporalUnit.SECOND, (BasicValuedMapping)durationType) : new Duration(scaledExpression, TemporalUnit.NANOSECOND, (BasicValuedMapping)durationType);
                TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
                BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
                result = new Conversion(duration, appliedUnit, scalarType);
            } else {
                result = scaledExpression;
            }
        }
        return this.withTreatRestriction(result, sqmPath);
    }

    private Expression extractEpoch(Expression intervalExpression) {
        BasicType<Integer> intType = this.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        PatternRenderer patternRenderer = new PatternRenderer(this.creationContext.getSessionFactory().getJdbcServices().getDialect().extractPattern(TemporalUnit.EPOCH));
        return new SelfRenderingFunctionSqlAstExpression("extract", (sqlAppender, sqlAstArguments, returnType, walker) -> patternRenderer.render(sqlAppender, sqlAstArguments, walker), Arrays.asList(new ExtractUnit(TemporalUnit.EPOCH, intType), intervalExpression), intType, intType);
    }

    @Override
    public Expression visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> EmbeddableValuedPathInterpretation.from(sqmPath, this, this.jpaQueryComplianceEnabled)), sqmPath);
    }

    @Override
    public Expression visitAnyValuedValuedPath(SqmAnyValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> DiscriminatedAssociationPathInterpretation.from(sqmPath, this)), sqmPath);
    }

    @Override
    public Expression visitNonAggregatedCompositeValuedPath(NonAggregatedCompositeSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> NonAggregatedCompositeValuedPathInterpretation.from(sqmPath, this, this)), sqmPath);
    }

    @Override
    public Expression visitEntityValuedPath(SqmEntityValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> EntityValuedPathInterpretation.from(sqmPath, this.getInferredValueMapping(), this)), sqmPath);
    }

    @Override
    public Expression visitAnyDiscriminatorTypeExpression(AnyDiscriminatorSqmPath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> AnyDiscriminatorPathInterpretation.from(sqmPath, this)), sqmPath);
    }

    @Override
    public Expression visitPluralValuedPath(SqmPluralValuedSimplePath<?> sqmPath) {
        return this.withTreatRestriction(this.prepareReusablePath(sqmPath, () -> PluralValuedSimplePathInterpretation.from(sqmPath, this)), sqmPath);
    }

    @Override
    public Object visitFkExpression(SqmFkExpression<?> fkExpression) {
        JpaPath lhs = fkExpression.getToOnePath().getLhs();
        this.prepareReusablePath((SqmPath<?>)lhs, (Supplier)() -> null);
        TableGroup tableGroup = this.getFromClauseIndex().findTableGroup(lhs.getNavigablePath());
        ModelPart subPart = tableGroup.getModelPart().findSubPart(fkExpression.getToOnePath().getModel().getPathName(), null);
        assert (subPart instanceof ToOneAttributeMapping);
        ToOneAttributeMapping toOneMapping = (ToOneAttributeMapping)subPart;
        ForeignKeyDescriptor fkDescriptor = toOneMapping.getForeignKeyDescriptor();
        TableReference tableReference = tableGroup.resolveTableReference(toOneMapping.getContainingTableExpression());
        ValuedModelPart fkKeyPart = fkDescriptor.getPart(toOneMapping.getSideNature());
        if (fkKeyPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicFkPart = (BasicValuedModelPart)fkKeyPart;
            return this.getSqlExpressionResolver().resolveSqlExpression(tableReference, basicFkPart);
        }
        assert (fkKeyPart instanceof EmbeddableValuedModelPart);
        EmbeddableValuedModelPart compositeFkPart = (EmbeddableValuedModelPart)fkKeyPart;
        int count = compositeFkPart.getJdbcTypeCount();
        ArrayList<Expression> tupleElements = new ArrayList<Expression>(count);
        for (int i = 0; i < count; ++i) {
            tupleElements.add(this.getSqlExpressionResolver().resolveSqlExpression(tableReference, compositeFkPart.getSelectable(i)));
        }
        return new SqlTuple(tupleElements, compositeFkPart);
    }

    @Override
    public Object visitDiscriminatorPath(EntityDiscriminatorSqmPath sqmPath) {
        return this.prepareReusablePath(sqmPath, () -> {
            this.registerTypeUsage(sqmPath);
            return DiscriminatorPathInterpretation.from(sqmPath, this);
        });
    }

    protected Expression createMinOrMaxIndexOrElement(AbstractSqmSpecificPluralPartPath<?> pluralPartPath, boolean index, String functionName) {
        if (this.creationContext.getSessionFactory().getJdbcServices().getDialect().supportsLateral()) {
            return this.createLateralJoinExpression(pluralPartPath, index, functionName);
        }
        return this.createCorrelatedAggregateSubQuery(pluralPartPath, index, functionName);
    }

    @Override
    public Expression visitElementAggregateFunction(SqmElementAggregateFunction<?> path) {
        return this.createMinOrMaxIndexOrElement(path, false, path.getFunctionName());
    }

    @Override
    public Expression visitIndexAggregateFunction(SqmIndexAggregateFunction<?> path) {
        return this.createMinOrMaxIndexOrElement(path, true, path.getFunctionName());
    }

    @Override
    public Expression visitCorrelation(SqmCorrelation<?, ?> correlation) {
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(correlation.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmCorrelation [%s] resolved to existing TableGroup [%s]", correlation, (Object)resolved);
            return this.visitTableGroup(resolved, correlation);
        }
        throw new InterpretationException("SqmCorrelation not yet resolved to TableGroup");
    }

    @Override
    public Expression visitTreatedPath(SqmTreatedPath<?, ?> sqmTreatedPath) {
        this.prepareReusablePath(sqmTreatedPath, () -> null);
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(sqmTreatedPath.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmTreatedPath [%s] resolved to existing TableGroup [%s]", sqmTreatedPath, (Object)resolved);
            return this.visitTableGroup(resolved, (SqmFrom)((Object)sqmTreatedPath));
        }
        throw new InterpretationException("SqmTreatedPath not yet resolved to TableGroup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression visitPluralAttributeSizeFunction(SqmCollectionSize function) {
        SqmPath<?> pluralPath = function.getPluralPath();
        this.prepareReusablePath(pluralPath, () -> null);
        TableGroup parentTableGroup = this.getFromClauseAccess().getTableGroup(pluralPath.getNavigablePath().getParent());
        assert (parentTableGroup != null);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)parentTableGroup.getModelPart().findSubPart(pluralPath.getNavigablePath().getLocalName(), null);
        assert (pluralAttributeMapping != null);
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent, false));
        try {
            TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPath.getNavigablePath(), null, null, () -> subQuerySpec::applyPredicate, this);
            pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            this.getFromClauseAccess().registerTableGroup(pluralPath.getNavigablePath(), tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            AbstractSqmSelfRenderingFunctionDescriptor functionDescriptor = this.resolveFunction("count");
            BasicType<Integer> integerType = this.creationContext.getMappingMetamodel().getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
            SelfRenderingAggregateFunctionSqlAstExpression expression = new SelfRenderingAggregateFunctionSqlAstExpression(functionDescriptor.getName(), functionDescriptor, Collections.singletonList(new QueryLiteral<Integer>(1, integerType)), null, integerType, integerType);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(expression));
            subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentTableGroup, tableGroup, (SqlAstCreationState)this));
        }
        finally {
            this.popProcessingStateStack();
        }
        return new SelectStatement(subQuerySpec);
    }

    @Override
    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath<?> path) {
        return path.getLhs().accept(this);
    }

    @Override
    public Object visitMapEntryFunction(SqmMapEntryReference<?, ?> entryRef) {
        SqmPath<?> mapPath = entryRef.getMapPath();
        this.prepareReusablePath(mapPath, () -> null);
        NavigablePath mapNavigablePath = mapPath.getNavigablePath();
        TableGroup tableGroup = this.getFromClauseAccess().resolveTableGroup(mapNavigablePath, navigablePath -> {
            TableGroup parentTableGroup = this.getFromClauseAccess().getTableGroup(mapNavigablePath.getParent());
            PluralAttributeMapping mapAttribute = (PluralAttributeMapping)parentTableGroup.getModelPart().findSubPart(mapNavigablePath.getLocalName(), null);
            TableGroupJoin tableGroupJoin = mapAttribute.createTableGroupJoin(mapNavigablePath, parentTableGroup, null, null, SqlAstJoinType.INNER, false, false, this);
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        PluralAttributeMapping mapDescriptor = (PluralAttributeMapping)tableGroup.getModelPart();
        CollectionPart indexDescriptor = mapDescriptor.getIndexDescriptor();
        NavigablePath indexNavigablePath = mapNavigablePath.append(indexDescriptor.getPartName());
        final DomainResult indexResult = indexDescriptor.createDomainResult(indexNavigablePath, tableGroup, null, this);
        this.registerProjectionUsageFromDescriptor(tableGroup, indexDescriptor);
        CollectionPart valueDescriptor = mapDescriptor.getElementDescriptor();
        NavigablePath valueNavigablePath = mapNavigablePath.append(valueDescriptor.getPartName());
        final DomainResult valueResult = valueDescriptor.createDomainResult(valueNavigablePath, tableGroup, null, this);
        this.registerProjectionUsageFromDescriptor(tableGroup, valueDescriptor);
        return new DomainResultProducer<Map.Entry<Object, Object>>(){

            @Override
            public DomainResult<Map.Entry<Object, Object>> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
                JavaType mapEntryDescriptor = BaseSqmToSqlAstConverter.this.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor((Type)((Object)Map.Entry.class));
                return new SqmMapEntryResult(indexResult, valueResult, resultVariable, mapEntryDescriptor);
            }

            @Override
            public void applySqlSelections(DomainResultCreationState creationState) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void registerProjectionUsageFromDescriptor(TableGroup tableGroup, CollectionPart descriptor) {
        if (descriptor instanceof EntityCollectionPart) {
            EntityCollectionPart entityCollectionPart = (EntityCollectionPart)descriptor;
            EntityMappingType entityMappingType = entityCollectionPart.getEntityMappingType();
            this.registerEntityNameUsage(tableGroup, EntityNameUse.PROJECTION, entityMappingType.getEntityName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression createCorrelatedAggregateSubQuery(AbstractSqmSpecificPluralPartPath<?> pluralPartPath, boolean index, String function) {
        this.prepareReusablePath((SqmPath<?>)pluralPartPath.getLhs(), (Supplier)() -> null);
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.determineValueMapping(pluralPartPath.getPluralDomainPath());
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent, false));
        try {
            ModelPart modelPart;
            CollectionPart collectionPart;
            TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPartPath.getNavigablePath(), null, null, () -> subQuerySpec::applyPredicate, this);
            pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            this.getFromClauseAccess().registerTableGroup(pluralPartPath.getNavigablePath(), tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            AbstractSqmSelfRenderingFunctionDescriptor functionDescriptor = this.resolveFunction(function);
            CollectionPart collectionPart2 = collectionPart = index ? pluralAttributeMapping.getIndexDescriptor() : pluralAttributeMapping.getElementDescriptor();
            if (collectionPart instanceof OneToManyCollectionPart) {
                OneToManyCollectionPart toManyPart = (OneToManyCollectionPart)collectionPart;
                modelPart = toManyPart.getAssociatedEntityMappingType().getIdentifierMapping();
            } else {
                modelPart = collectionPart instanceof ManyToManyCollectionPart ? ((ManyToManyCollectionPart)collectionPart).getKeyTargetMatchPart() : collectionPart;
            }
            ArrayList<SqlTuple> arguments = new ArrayList<SqlTuple>(1);
            NavigablePath navigablePath = pluralPartPath.getNavigablePath();
            int jdbcTypeCount = modelPart.getJdbcTypeCount();
            ArrayList<SqlTuple> tupleElements = jdbcTypeCount == 1 ? arguments : new ArrayList(jdbcTypeCount);
            modelPart.forEachSelectable((selectionIndex, selectionMapping) -> tupleElements.add((SqlTuple)((Object)new ColumnReference(tableGroup.resolveTableReference(navigablePath, (ValuedModelPart)modelPart, selectionMapping.getContainingTableExpression()), selectionMapping))));
            if (jdbcTypeCount != 1) {
                arguments.add(new SqlTuple(tupleElements, modelPart));
            }
            SelfRenderingAggregateFunctionSqlAstExpression expression = new SelfRenderingAggregateFunctionSqlAstExpression(functionDescriptor.getName(), functionDescriptor, arguments, null, (ReturnableType)((Object)functionDescriptor.getReturnTypeResolver().resolveFunctionReturnType(() -> null, arguments).getJdbcMapping()), (JdbcMappingContainer)modelPart);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(expression));
            NavigablePath parent = pluralPartPath.getPluralDomainPath().getNavigablePath().getParent();
            subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(parent), tableGroup, (SqlAstCreationState)this));
        }
        finally {
            this.popProcessingStateStack();
        }
        return new SelectStatement(subQuerySpec);
    }

    private AbstractSqmSelfRenderingFunctionDescriptor resolveFunction(String function) {
        return (AbstractSqmSelfRenderingFunctionDescriptor)this.creationContext.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression createLateralJoinExpression(AbstractSqmSpecificPluralPartPath<?> pluralPartPath, boolean index, String functionName) {
        ModelPart modelPart;
        CollectionPart collectionPart;
        this.prepareReusablePath((SqmPath<?>)pluralPartPath.getLhs(), (Supplier)() -> null);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.determineValueMapping(pluralPartPath.getPluralDomainPath());
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        TableGroup parentTableGroup = parentFromClauseAccess.findTableGroup(pluralPartPath.getNavigablePath().getParent());
        CollectionPart collectionPart2 = collectionPart = index ? pluralAttributeMapping.getIndexDescriptor() : pluralAttributeMapping.getElementDescriptor();
        if (collectionPart instanceof OneToManyCollectionPart) {
            OneToManyCollectionPart toManyPart = (OneToManyCollectionPart)collectionPart;
            modelPart = toManyPart.getAssociatedEntityMappingType().getIdentifierMapping();
        } else {
            modelPart = collectionPart instanceof ManyToManyCollectionPart ? ((ManyToManyCollectionPart)collectionPart).getKeyTargetMatchPart() : collectionPart;
        }
        int jdbcTypeCount = modelPart.getJdbcTypeCount();
        String pathName = functionName + (index ? "_index" : "_element");
        String identifierVariable = parentTableGroup.getPrimaryTableReference().getIdentificationVariable() + "_" + pathName;
        NavigablePath queryPath = new NavigablePath(parentTableGroup.getNavigablePath(), pathName, identifierVariable);
        TableGroup lateralTableGroup = parentFromClauseAccess.findTableGroup(queryPath);
        if (lateralTableGroup == null) {
            QuerySpec subQuerySpec = new QuerySpec(false);
            this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent, false));
            try {
                DomainResultProducer domainResultProducer;
                TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPartPath.getNavigablePath(), null, null, () -> subQuerySpec::applyPredicate, this);
                pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
                this.getFromClauseAccess().registerTableGroup(pluralPartPath.getNavigablePath(), tableGroup);
                this.registerPluralTableGroupParts(tableGroup);
                subQuerySpec.getFromClause().addRoot(tableGroup);
                ArrayList<String> columnNames = new ArrayList<String>(jdbcTypeCount);
                ArrayList<ColumnReference> resultColumnReferences = new ArrayList<ColumnReference>(jdbcTypeCount);
                NavigablePath navigablePath = pluralPartPath.getNavigablePath();
                Boolean max = functionName.equalsIgnoreCase("max") ? Boolean.TRUE : (functionName.equalsIgnoreCase("min") ? Boolean.FALSE : null);
                AbstractSqmSelfRenderingFunctionDescriptor functionDescriptor = this.resolveFunction(functionName);
                ArrayList subQueryColumns = new ArrayList(jdbcTypeCount);
                modelPart.forEachSelectable((selectionIndex, selectionMapping) -> {
                    ColumnReference columnReference = new ColumnReference(tableGroup.resolveTableReference(navigablePath, (ValuedModelPart)modelPart, selectionMapping.getContainingTableExpression()), selectionMapping);
                    Object columnName = selectionMapping.isFormula() ? "col" + columnNames.size() : selectionMapping.getSelectionExpression();
                    columnNames.add((String)columnName);
                    subQueryColumns.add(columnReference);
                    if (max != null) {
                        subQuerySpec.addSortSpecification(new SortSpecification(columnReference, max != false ? SortDirection.DESCENDING : SortDirection.ASCENDING));
                    }
                });
                if (max != null) {
                    for (int i = 0; i < subQueryColumns.size(); ++i) {
                        subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i, (Expression)subQueryColumns.get(i)));
                        resultColumnReferences.add(new ColumnReference(identifierVariable, (String)columnNames.get(i), false, null, ((ColumnReference)subQueryColumns.get(i)).getJdbcMapping()));
                    }
                    subQuerySpec.setFetchClauseExpression(new QueryLiteral<Integer>(1, this.basicType(Integer.class)), FetchClauseType.ROWS_ONLY);
                } else {
                    List<Object> arguments = jdbcTypeCount == 1 ? subQueryColumns : Collections.singletonList(new SqlTuple(subQueryColumns, modelPart));
                    SelfRenderingAggregateFunctionSqlAstExpression expression = new SelfRenderingAggregateFunctionSqlAstExpression(functionDescriptor.getName(), functionDescriptor, arguments, null, (ReturnableType)((Object)functionDescriptor.getReturnTypeResolver().resolveFunctionReturnType(() -> null, arguments).getJdbcMapping()), (JdbcMappingContainer)modelPart);
                    subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(expression));
                    resultColumnReferences.add(new ColumnReference(identifierVariable, (String)columnNames.get(0), false, null, expression.getExpressionType().getSingleJdbcMapping()));
                }
                subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPartPath.getPluralDomainPath().getNavigablePath().getParent()), tableGroup, (SqlAstCreationState)this));
                Set<String> compatibleTableExpressions = modelPart instanceof BasicValuedModelPart ? Collections.singleton(((BasicValuedModelPart)modelPart).getContainingTableExpression()) : (modelPart instanceof EmbeddableValuedModelPart ? Collections.singleton(((EmbeddableValuedModelPart)modelPart).getContainingTableExpression()) : Collections.emptySet());
                lateralTableGroup = new QueryPartTableGroup(queryPath, null, new SelectStatement(subQuerySpec), identifierVariable, columnNames, compatibleTableExpressions, true, false, this.creationContext.getSessionFactory());
                if (this.currentlyProcessingJoin == null) {
                    parentTableGroup.addTableGroupJoin(new TableGroupJoin(lateralTableGroup.getNavigablePath(), SqlAstJoinType.LEFT, lateralTableGroup));
                } else {
                    TableGroup targetTableGroup = this.currentlyProcessingJoin.getLhs() == null ? parentFromClauseAccess.getTableGroup(this.currentlyProcessingJoin.findRoot().getNavigablePath()) : parentFromClauseAccess.getTableGroup(this.currentlyProcessingJoin.getLhs().getNavigablePath());
                    targetTableGroup.prependTableGroupJoin(this.currentlyProcessingJoin.getNavigablePath(), new TableGroupJoin(lateralTableGroup.getNavigablePath(), SqlAstJoinType.LEFT, lateralTableGroup));
                }
                parentFromClauseAccess.registerTableGroup(lateralTableGroup.getNavigablePath(), lateralTableGroup);
                if (jdbcTypeCount == 1) {
                    domainResultProducer = new SelfRenderingFunctionSqlAstExpression(pathName, (sqlAppender, sqlAstArguments, returnType, walker) -> ((SqlAstNode)sqlAstArguments.get(0)).accept(walker), resultColumnReferences, (ReturnableType)((Object)((ColumnReference)resultColumnReferences.get(0)).getJdbcMapping()), (JdbcMappingContainer)((ColumnReference)resultColumnReferences.get(0)).getJdbcMapping());
                    return domainResultProducer;
                }
                domainResultProducer = new SqlTuple(resultColumnReferences, modelPart);
                return domainResultProducer;
            }
            finally {
                this.popProcessingStateStack();
            }
        }
        QueryPartTableReference tableReference = (QueryPartTableReference)lateralTableGroup.getPrimaryTableReference();
        if (jdbcTypeCount == 1) {
            List<SqlSelection> sqlSelections = tableReference.getQueryPart().getFirstQuerySpec().getSelectClause().getSqlSelections();
            return new SelfRenderingFunctionSqlAstExpression(pathName, (sqlAppender, sqlAstArguments, returnType, walker) -> ((SqlAstNode)sqlAstArguments.get(0)).accept(walker), Collections.singletonList(new ColumnReference(identifierVariable, tableReference.getColumnNames().get(0), false, null, sqlSelections.get(0).getExpressionType().getSingleJdbcMapping())), (ReturnableType)((Object)sqlSelections.get(0).getExpressionType().getSingleJdbcMapping()), sqlSelections.get(0).getExpressionType());
        }
        ArrayList resultColumnReferences = new ArrayList(jdbcTypeCount);
        modelPart.forEachSelectable((selectionIndex, selectionMapping) -> resultColumnReferences.add(new ColumnReference(identifierVariable, tableReference.getColumnNames().get(selectionIndex), false, null, selectionMapping.getJdbcMapping())));
        return new SqlTuple(resultColumnReferences, modelPart);
    }

    private Expression withTreatRestriction(Expression expression, SqmPath<?> path) {
        JpaPath<Object> lhs = path instanceof SqmTreatedPath ? path : path.getLhs();
        if (lhs instanceof SqmTreatedPath) {
            SqmPath wrappedPath;
            Class originalJavaType;
            SqmTreatedPath treatedPath = (SqmTreatedPath)lhs;
            Class treatTargetJavaType = treatedPath.getTreatTarget().getJavaType();
            if (treatTargetJavaType.isAssignableFrom(originalJavaType = (wrappedPath = treatedPath.getWrappedPath()).getJavaType())) {
                return expression;
            }
            if (!(expression.getExpressionType() instanceof BasicValuedMapping)) {
                if (lhs instanceof SqmRoot) {
                    String treatedName = treatedPath.getTreatTarget().getHibernateEntityName();
                    TableGroup tableGroup = this.getFromClauseIndex().findTableGroup(wrappedPath.getNavigablePath());
                    this.registerEntityNameUsage(tableGroup, EntityNameUse.TREAT, treatedName);
                }
                return expression;
            }
            BasicValuedPathInterpretation basicPath = (BasicValuedPathInterpretation)expression;
            TableGroup tableGroup = basicPath.getTableGroup();
            TableGroup elementTableGroup = tableGroup instanceof PluralTableGroup ? ((PluralTableGroup)tableGroup).getElementTableGroup() : tableGroup;
            AbstractEntityPersister persister = (AbstractEntityPersister)elementTableGroup.getModelPart().getPartMappingType();
            if (persister.isSharedColumn(basicPath.getColumnReference().getColumnExpression())) {
                return this.createCaseExpression(wrappedPath, treatedPath.getTreatTarget(), expression);
            }
        }
        return expression;
    }

    private Expression createCaseExpression(SqmPath<?> lhs, EntityDomainType<?> treatTarget, Expression expression) {
        Predicate treatTypeRestriction = this.createTreatTypeRestriction(lhs, treatTarget);
        if (treatTypeRestriction == null) {
            return expression;
        }
        BasicValuedMapping mappingModelExpressible = (BasicValuedMapping)expression.getExpressionType();
        ArrayList<CaseSearchedExpression.WhenFragment> whenFragments = new ArrayList<CaseSearchedExpression.WhenFragment>(1);
        whenFragments.add(new CaseSearchedExpression.WhenFragment(treatTypeRestriction, expression));
        return new CaseSearchedExpression(mappingModelExpressible, whenFragments, null);
    }

    private Predicate consumeConjunctTreatTypeRestrictions() {
        return this.consumeConjunctTreatTypeRestrictions(this.tableGroupEntityNameUses);
    }

    private Predicate consumeConjunctTreatTypeRestrictions(Map<TableGroup, Map<String, EntityNameUse>> conjunctTreatUsages) {
        if (conjunctTreatUsages == null || conjunctTreatUsages.isEmpty()) {
            return null;
        }
        Predicate predicate = null;
        for (Map.Entry<TableGroup, Map<String, EntityNameUse>> entry : conjunctTreatUsages.entrySet()) {
            TableGroup tableGroup = entry.getKey();
            Set<String> entityNames = this.determineEntityNamesForTreatTypeRestriction((EntityMappingType)tableGroup.getModelPart().getPartMappingType(), entry.getValue());
            if (entityNames.isEmpty()) continue;
            ModelPartContainer modelPart = tableGroup.getModelPart();
            EntityMappingType entityMapping = modelPart instanceof EntityValuedModelPart ? ((EntityValuedModelPart)modelPart).getEntityMappingType() : (EntityMappingType)((PluralAttributeMapping)modelPart).getElementDescriptor().getPartMappingType();
            DiscriminatorPathInterpretation typeExpression = new DiscriminatorPathInterpretation(tableGroup.getNavigablePath().append("{discriminator}"), entityMapping, tableGroup, (SqlAstCreationState)this);
            TableGroupJoin join = this.getParentTableGroupJoin(tableGroup);
            boolean allowNulls = join != null && (join.getJoinType() == SqlAstJoinType.LEFT || join.getJoinType() == SqlAstJoinType.FULL);
            this.registerTypeUsage(tableGroup);
            predicate = SqlAstTreeHelper.combinePredicates(predicate, this.createTreatTypeRestriction(typeExpression, entityNames, allowNulls));
        }
        return predicate;
    }

    private TableGroupJoin getParentTableGroupJoin(TableGroup tableGroup) {
        NavigablePath parentNavigablePath = tableGroup.getNavigablePath().getParent();
        if (parentNavigablePath != null) {
            TableGroup parentTableGroup = this.getFromClauseIndex().findTableGroup(parentNavigablePath);
            if (parentTableGroup instanceof PluralTableGroup) {
                return this.getParentTableGroupJoin(parentTableGroup);
            }
            if (parentTableGroup != null) {
                return parentTableGroup.findTableGroupJoin(tableGroup);
            }
        }
        return null;
    }

    private Set<String> determineEntityNamesForTreatTypeRestriction(EntityMappingType partMappingType, Map<String, EntityNameUse> entityNameUses) {
        String baseEntityNameToAdd;
        HashSet<String> entityNameUsesSet = new HashSet<String>(entityNameUses.size());
        for (Map.Entry<String, EntityNameUse> entry : entityNameUses.entrySet()) {
            if (entry.getValue() == EntityNameUse.PROJECTION) continue;
            entityNameUsesSet.add(entry.getKey());
        }
        if (entityNameUsesSet.containsAll(partMappingType.getSubclassEntityNames())) {
            return Collections.emptySet();
        }
        if (entityNameUses.containsValue(EntityNameUse.FILTER)) {
            return Collections.emptySet();
        }
        if (entityNameUsesSet.contains(partMappingType.getEntityName())) {
            baseEntityNameToAdd = !partMappingType.isAbstract() ? partMappingType.getEntityName() : null;
            if (entityNameUses.size() == 1) {
                return Collections.emptySet();
            }
        } else {
            baseEntityNameToAdd = null;
        }
        HashSet<String> entityNames = new HashSet<String>(entityNameUsesSet.size());
        for (Map.Entry<String, EntityNameUse> entityNameUse : entityNameUses.entrySet()) {
            if (entityNameUse.getValue() != EntityNameUse.TREAT) continue;
            String entityName = entityNameUse.getKey();
            EntityPersister entityDescriptor = this.creationContext.getMappingMetamodel().findEntityDescriptor(entityName);
            if (!entityDescriptor.isAbstract()) {
                entityNames.add(entityDescriptor.getEntityName());
            }
            for (EntityMappingType subMappingType : entityDescriptor.getSubMappingTypes()) {
                if (subMappingType.isAbstract()) continue;
                entityNames.add(subMappingType.getEntityName());
            }
        }
        do {
            entityNames.remove(partMappingType.getEntityName());
        } while ((partMappingType = partMappingType.getSuperMappingType()) != null);
        if (!entityNames.isEmpty() && baseEntityNameToAdd != null) {
            entityNames.add(baseEntityNameToAdd);
        }
        return entityNames;
    }

    private Predicate createTreatTypeRestriction(SqmPath<?> lhs, EntityDomainType<?> treatTarget) {
        AbstractEntityPersister entityDescriptor = (AbstractEntityPersister)this.domainModel.findEntityDescriptor(treatTarget.getHibernateEntityName());
        if (entityDescriptor.isPolymorphic() && lhs.getNodeType() != treatTarget) {
            Set<String> subclassEntityNames = entityDescriptor.getSubclassEntityNames();
            return this.createTreatTypeRestriction(lhs, subclassEntityNames);
        }
        return null;
    }

    private Predicate createTreatTypeRestriction(SqmPath<?> lhs, Set<String> subclassEntityNames) {
        EntityDiscriminatorSqmPath discriminatorSqmPath = (EntityDiscriminatorSqmPath)lhs.type();
        this.registerTypeUsage(discriminatorSqmPath);
        return this.createTreatTypeRestriction(DiscriminatorPathInterpretation.from(discriminatorSqmPath, this), subclassEntityNames, false);
    }

    private Predicate createTreatTypeRestriction(Expression typeExpression, Set<String> subclassEntityNames, boolean allowNulls) {
        Predicate discriminatorPredicate;
        if (subclassEntityNames.size() == 1) {
            discriminatorPredicate = new ComparisonPredicate(typeExpression, ComparisonOperator.EQUAL, new EntityTypeLiteral(this.domainModel.findEntityDescriptor(subclassEntityNames.iterator().next())));
        } else {
            ArrayList<Expression> typeLiterals = new ArrayList<Expression>(subclassEntityNames.size());
            for (String subclassEntityName : subclassEntityNames) {
                typeLiterals.add(new EntityTypeLiteral(this.domainModel.findEntityDescriptor(subclassEntityName)));
            }
            discriminatorPredicate = new InListPredicate(typeExpression, typeLiterals);
        }
        if (allowNulls) {
            return new Junction(Junction.Nature.DISJUNCTION, List.of(discriminatorPredicate, new NullnessPredicate(typeExpression)), this.getBooleanType());
        }
        return discriminatorPredicate;
    }

    private MappingModelExpressible<?> resolveInferredType() {
        Supplier inferableTypeAccess = this.inferrableTypeAccessStack.getCurrent();
        if (this.inTypeInference || inferableTypeAccess == null) {
            return null;
        }
        this.inTypeInference = true;
        MappingModelExpressible inferredType = (MappingModelExpressible)inferableTypeAccess.get();
        this.inTypeInference = false;
        return inferredType;
    }

    @Override
    public MappingModelExpressible<?> resolveFunctionImpliedReturnType() {
        if (this.inImpliedResultTypeInference || this.functionImpliedResultTypeAccess == null) {
            return null;
        }
        this.inImpliedResultTypeInference = true;
        MappingModelExpressible<?> inferredType = this.functionImpliedResultTypeAccess.get();
        this.inImpliedResultTypeInference = false;
        return inferredType;
    }

    @Override
    public Expression visitLiteral(SqmLiteral<?> literal) {
        MappingModelExpressible<?> elementExpressible;
        BasicValuedMapping basicValuedMapping;
        BasicValueConverter valueConverter;
        if (literal instanceof SqmLiteralNull) {
            MappingModelExpressible<?> keyExpressible;
            MappingModelExpressible<?> mappingModelExpressible = this.resolveInferredType();
            if (mappingModelExpressible == null) {
                mappingModelExpressible = this.determineCurrentExpressible(literal);
            }
            if (mappingModelExpressible instanceof BasicValuedMapping) {
                return new QueryLiteral<Object>(null, (BasicValuedMapping)mappingModelExpressible);
            }
            if (mappingModelExpressible instanceof EntityMappingType) {
                mappingModelExpressible = null;
            }
            if ((keyExpressible = this.getKeyExpressible(mappingModelExpressible)) == null) {
                return new QueryLiteral<Object>(null, BottomType.INSTANCE);
            }
            ArrayList expressions2 = new ArrayList(keyExpressible.getJdbcTypeCount());
            if (keyExpressible instanceof ModelPart) {
                ((ModelPart)keyExpressible).forEachSelectable((index, selectableMapping) -> expressions2.add(new QueryLiteral<Object>(null, selectableMapping instanceof BasicValuedMapping ? (BasicValuedMapping)((Object)selectableMapping) : (BasicValuedMapping)((Object)selectableMapping.getJdbcMapping()))));
            } else {
                keyExpressible.forEachJdbcType((index, jdbcMapping) -> expressions2.add(new QueryLiteral<Object>(null, (BasicValuedMapping)((Object)jdbcMapping))));
            }
            return new SqlTuple(expressions2, mappingModelExpressible);
        }
        MappingModelExpressible<?> inferableExpressible = this.getInferredValueMapping();
        if (inferableExpressible instanceof DiscriminatorMapping) {
            EntityPersister entityDescriptor;
            MappingMetamodelImplementor mappingMetamodel = this.creationContext.getSessionFactory().getMappingMetamodel();
            Object literalValue = literal.getLiteralValue();
            if (literalValue instanceof Class) {
                entityDescriptor = mappingMetamodel.findEntityDescriptor((Class)literalValue);
            } else {
                DiscriminatorValueDetails discriminatorDetails;
                DiscriminatorMapping discriminatorMapping = (DiscriminatorMapping)inferableExpressible;
                DiscriminatorConverter<?, ?> valueConverter2 = discriminatorMapping.getValueConverter();
                if (valueConverter2.getDomainJavaType().isInstance(literalValue)) {
                    discriminatorDetails = valueConverter2.getDetailsForDiscriminatorValue(literalValue);
                } else if (valueConverter2.getRelationalJavaType().isInstance(literalValue)) {
                    discriminatorDetails = valueConverter2.getDetailsForRelationalForm(literalValue);
                } else {
                    Object relationalForm = valueConverter2.getRelationalJavaType().wrap(literalValue, this.creationContext.getSessionFactory().getWrapperOptions());
                    discriminatorDetails = valueConverter2.getDetailsForRelationalForm(relationalForm);
                }
                entityDescriptor = discriminatorDetails.getIndicatedEntity().getEntityPersister();
            }
            return new EntityTypeLiteral(entityDescriptor);
        }
        if (inferableExpressible instanceof BasicValuedMapping && (valueConverter = (basicValuedMapping = (BasicValuedMapping)inferableExpressible).getJdbcMapping().getValueConverter()) != null) {
            Object sqlLiteralValue;
            Object value2 = literal.getLiteralValue();
            if (value2 == null || valueConverter.getDomainJavaType().isInstance(value2)) {
                sqlLiteralValue = valueConverter.toRelationalValue(value2);
            } else if (valueConverter.getRelationalJavaType().isInstance(value2)) {
                sqlLiteralValue = value2;
            } else if (Number.class.isAssignableFrom(valueConverter.getRelationalJavaType().getJavaTypeClass()) && value2 instanceof Number) {
                sqlLiteralValue = valueConverter.getRelationalJavaType().coerce(value2, this.creationContext.getSessionFactory()::getTypeConfiguration);
            } else {
                throw new SemanticException(String.format(Locale.ROOT, "Literal type '%s' did not match domain type '%s' nor converted type '%s'", value2.getClass(), valueConverter.getDomainJavaType().getJavaTypeClass().getName(), valueConverter.getRelationalJavaType().getJavaTypeClass().getName()));
            }
            return new QueryLiteral(sqlLiteralValue, basicValuedMapping);
        }
        MappingModelExpressible<?> localExpressible = SqmMappingModelHelper.resolveMappingModelExpressible(literal, this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel(), this.getFromClauseAccess() == null ? null : this.getFromClauseAccess()::findTableGroup);
        MappingModelExpressible expressible = localExpressible == null ? this.getElementExpressible(inferableExpressible) : ((elementExpressible = this.getElementExpressible(localExpressible)) instanceof BasicType ? InferredBasicValueResolver.resolveSqlTypeIndicators(this, (BasicType)elementExpressible, literal.getJavaTypeDescriptor()) : elementExpressible);
        if (expressible instanceof EntityIdentifierMapping && literal.getNodeType() instanceof EntityTypeImpl) {
            return new QueryLiteral<Object>(((EntityIdentifierMapping)expressible).getIdentifier(literal.getLiteralValue()), (BasicValuedMapping)expressible);
        }
        if (expressible instanceof BasicValuedMapping) {
            return new QueryLiteral(literal.getLiteralValue(), (BasicValuedMapping)expressible);
        }
        if (expressible instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)expressible;
            ArrayList list = new ArrayList(embeddableValuedModelPart.getJdbcTypeCount());
            embeddableValuedModelPart.forEachJdbcValue(literal.getLiteralValue(), list, null, (selectionIndex, expressions, noop, value, jdbcMapping) -> expressions.add(new QueryLiteral<Object>(value, (BasicValuedMapping)((Object)jdbcMapping))), null);
            return new SqlTuple(list, expressible);
        }
        if (expressible instanceof EntityValuedModelPart) {
            ValuedModelPart associationKeyPart;
            Object associationKey;
            EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)expressible;
            if (entityValuedModelPart instanceof EntityAssociationMapping) {
                EntityAssociationMapping association = (EntityAssociationMapping)((Object)entityValuedModelPart);
                ForeignKeyDescriptor foreignKeyDescriptor = association.getForeignKeyDescriptor();
                if (association.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                    associationKey = association.getAssociatedEntityMappingType().getIdentifierMapping().getIdentifier(literal.getLiteralValue());
                    associationKeyPart = association.getAssociatedEntityMappingType().getIdentifierMapping();
                } else {
                    associationKey = foreignKeyDescriptor.getAssociationKeyFromSide(literal.getLiteralValue(), association.getSideNature().inverse(), null);
                    associationKeyPart = foreignKeyDescriptor.getPart(association.getSideNature());
                }
            } else {
                EntityIdentifierMapping identifierMapping;
                associationKeyPart = identifierMapping = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
                associationKey = identifierMapping.getIdentifier(literal.getLiteralValue());
            }
            if (associationKeyPart instanceof BasicValuedMapping) {
                return new QueryLiteral<Object>(associationKey, (BasicValuedMapping)((Object)associationKeyPart));
            }
            ArrayList list = new ArrayList(associationKeyPart.getJdbcTypeCount());
            associationKeyPart.forEachJdbcValue(associationKey, list, null, (selectionIndex, expressions, noop, value, jdbcMapping) -> expressions.add(new QueryLiteral<Object>(value, (BasicValuedMapping)((Object)jdbcMapping))), null);
            return new SqlTuple(list, associationKeyPart);
        }
        return new QueryLiteral(literal.getLiteralValue(), this.creationContext.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(((BasicSqmPathSource)literal.getNodeType()).getSqmPathType().getJavaType().getName()));
    }

    @Override
    public <N extends Number> Expression visitHqlNumericLiteral(SqmHqlNumericLiteral<N> numericLiteral) {
        BasicValuedMapping inferredExpressible = (BasicValuedMapping)this.getInferredValueMapping();
        BasicValuedMapping expressible = inferredExpressible == null ? (BasicValuedMapping)this.determineCurrentExpressible(numericLiteral) : inferredExpressible;
        JdbcMapping jdbcMapping = expressible.getJdbcMapping();
        if (jdbcMapping.getValueConverter() != null) {
            return this.handleConvertedUnparsedNumericLiteral(numericLiteral, expressible);
        }
        return new UnparsedNumericLiteral(numericLiteral.getUnparsedLiteralValue(), numericLiteral.getTypeCategory(), jdbcMapping);
    }

    private <N extends Number> Expression handleConvertedUnparsedNumericLiteral(SqmHqlNumericLiteral<N> numericLiteral, BasicValuedMapping expressible) {
        Object sqlLiteralValue;
        BasicValueConverter valueConverter = expressible.getJdbcMapping().getValueConverter();
        assert (valueConverter != null);
        Object parsedValue = numericLiteral.getTypeCategory().parseLiteralValue(numericLiteral.getUnparsedLiteralValue());
        if (valueConverter.getDomainJavaType().isInstance(parsedValue)) {
            sqlLiteralValue = valueConverter.toRelationalValue(parsedValue);
        } else if (valueConverter.getRelationalJavaType().isInstance(parsedValue)) {
            sqlLiteralValue = parsedValue;
        } else if (Number.class.isAssignableFrom(valueConverter.getRelationalJavaType().getJavaTypeClass())) {
            sqlLiteralValue = valueConverter.getRelationalJavaType().coerce(parsedValue, this.creationContext.getSessionFactory()::getTypeConfiguration);
        } else {
            throw new SemanticException(String.format(Locale.ROOT, "Literal type '%s' did not match domain type '%s' nor converted type '%s'", parsedValue.getClass(), valueConverter.getDomainJavaType().getJavaTypeClass().getName(), valueConverter.getRelationalJavaType().getJavaTypeClass().getName()));
        }
        return new QueryLiteral(sqlLiteralValue, expressible);
    }

    private MappingModelExpressible<?> getKeyExpressible(JdbcMappingContainer mappingModelExpressible) {
        if (mappingModelExpressible instanceof EntityAssociationMapping) {
            return ((EntityAssociationMapping)mappingModelExpressible).getKeyTargetMatchPart();
        }
        return (MappingModelExpressible)mappingModelExpressible;
    }

    private MappingModelExpressible<?> getElementExpressible(MappingModelExpressible<?> mappingModelExpressible) {
        if (mappingModelExpressible instanceof PluralAttributeMapping) {
            return ((PluralAttributeMapping)mappingModelExpressible).getElementDescriptor();
        }
        return mappingModelExpressible;
    }

    @Override
    public Map<SqmParameter<?>, List<List<JdbcParameter>>> getJdbcParamsBySqmParam() {
        return this.jdbcParamsBySqmParam;
    }

    @Override
    public Expression visitNamedParameterExpression(SqmNamedParameter<?> expression) {
        return this.consumeSqmParameter(expression);
    }

    protected Expression consumeSqmParameter(SqmParameter<?> sqmParameter, MappingModelExpressible<?> valueMapping, BiConsumer<Integer, JdbcParameter> jdbcParameterConsumer) {
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, valueMapping, (index, jdbcParameter) -> {
            jdbcParameterConsumer.accept((Integer)index, (JdbcParameter)jdbcParameter);
            jdbcParametersForSqm.add((JdbcParameter)jdbcParameter);
        });
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParametersForSqm);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        if (binding.setType(valueMapping)) {
            this.replaceJdbcParametersType(sqmParameter, this.domainParameterXref.getSqmParameters(queryParameter), valueMapping);
        }
        return new SqmParameterInterpretation(jdbcParametersForSqm, valueMapping);
    }

    private void replaceJdbcParametersType(SqmParameter<?> sourceSqmParameter, List<SqmParameter<?>> sqmParameters, MappingModelExpressible<?> valueMapping) {
        JdbcMapping jdbcMapping = valueMapping.getSingleJdbcMapping();
        for (SqmParameter<?> sqmParameter : sqmParameters) {
            if (sqmParameter == sourceSqmParameter) continue;
            this.sqmParameterMappingModelTypes.put(sqmParameter, valueMapping);
            List<List<JdbcParameter>> jdbcParamsForSqmParameter = this.jdbcParamsBySqmParam.get(sqmParameter);
            if (jdbcParamsForSqmParameter == null) continue;
            for (List<JdbcParameter> parameters : jdbcParamsForSqmParameter) {
                assert (parameters.size() == 1);
                JdbcParameter jdbcParameter = parameters.get(0);
                if (((SqlExpressible)((Object)jdbcParameter)).getJdbcMapping() == jdbcMapping) continue;
                JdbcParameterImpl newJdbcParameter = new JdbcParameterImpl(jdbcMapping);
                parameters.set(0, newJdbcParameter);
                this.jdbcParameters.getJdbcParameters().remove(jdbcParameter);
                this.jdbcParameters.getJdbcParameters().add(newJdbcParameter);
            }
        }
    }

    protected Expression consumeSqmParameter(SqmParameter<?> sqmParameter) {
        if (sqmParameter.allowMultiValuedBinding()) {
            QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
            QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
            if (!domainParamBinding.isMultiValued()) {
                return this.consumeSingleSqmParameter(sqmParameter);
            }
            Collection<?> bindValues = domainParamBinding.getBindValues();
            ArrayList<Expression> expressions = new ArrayList<Expression>(bindValues.size());
            boolean first = true;
            for (Object bindValue : bindValues) {
                SqmParameter<?> sqmParamToConsume;
                if (first) {
                    sqmParamToConsume = sqmParameter;
                    first = false;
                } else {
                    sqmParamToConsume = sqmParameter.copy();
                    this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                }
                expressions.add(this.consumeSingleSqmParameter(sqmParamToConsume));
            }
            return new SqlTuple(expressions, null);
        }
        return this.consumeSingleSqmParameter(sqmParameter);
    }

    protected Expression consumeSingleSqmParameter(SqmParameter<?> sqmParameter) {
        return this.consumeSqmParameter(sqmParameter, this.determineValueMapping(sqmParameter), (integer, jdbcParameter) -> {});
    }

    @Override
    public MappingModelExpressible<?> determineValueMapping(SqmExpression<?> sqmExpression) {
        return this.determineValueMapping(sqmExpression, this.fromClauseIndexStack.getCurrent());
    }

    private MappingModelExpressible<?> determineValueMapping(SqmExpression<?> sqmExpression, FromClauseIndex fromClauseIndex) {
        MappingModelExpressible<?> mappingModelExpressible;
        MappingModelExpressible<?> valueMapping;
        SqmSubQuery subQuery;
        SqmSelectClause selectClause;
        MappingModelExpressible<?> mappingModelExpressible2;
        if (sqmExpression instanceof SqmParameter) {
            return this.determineValueMapping((SqmParameter)sqmExpression);
        }
        if (sqmExpression instanceof SqmPath) {
            log.debugf("Determining mapping-model type for SqmPath : %s ", sqmExpression);
            mappingModelExpressible2 = SqmMappingModelHelper.resolveMappingModelExpressible(sqmExpression, this.domainModel, fromClauseIndex::findTableGroup);
            if (mappingModelExpressible2 != null) {
                return mappingModelExpressible2;
            }
        }
        if (sqmExpression instanceof SqmBooleanExpressionPredicate) {
            SqmBooleanExpressionPredicate expressionPredicate = (SqmBooleanExpressionPredicate)sqmExpression;
            return this.determineValueMapping(expressionPredicate.getBooleanExpression(), fromClauseIndex);
        }
        if (sqmExpression instanceof SqmEnumLiteral && (mappingModelExpressible2 = this.resolveInferredType()) != null) {
            return mappingModelExpressible2;
        }
        if (sqmExpression instanceof SqmSubQuery && (selectClause = ((SqmQuerySpec)(subQuery = (SqmSubQuery)sqmExpression).getQuerySpec()).getSelectClause()).getSelections().size() == 1) {
            SqmSelection<?> subQuerySelection = selectClause.getSelections().get(0);
            SqmSelectableNode<?> selectableNode = subQuerySelection.getSelectableNode();
            if (selectableNode instanceof SqmExpression) {
                return this.determineValueMapping((SqmExpression)selectableNode, fromClauseIndex);
            }
            SqmExpressible selectionNodeType = subQuerySelection.getNodeType();
            if (selectionNodeType != null) {
                MappingModelExpressible<?> expressible = this.domainModel.resolveMappingExpressible(selectionNodeType, this::findTableGroupByPath);
                if (expressible != null) {
                    return expressible;
                }
                try {
                    MappingModelExpressible<?> mappingModelExpressible3 = this.resolveInferredType();
                    if (mappingModelExpressible3 != null) {
                        return mappingModelExpressible3;
                    }
                }
                catch (Exception ignore) {
                    return null;
                }
            }
        }
        log.debugf("Determining mapping-model type for generalized SqmExpression : %s", sqmExpression);
        SqmExpressible<?> nodeType = sqmExpression.getNodeType();
        if (nodeType == null) {
            return null;
        }
        if (nodeType instanceof EmbeddedSqmPathSource && sqmExpression instanceof SqmBinaryArithmetic) {
            SqmBinaryArithmetic binaryArithmetic = (SqmBinaryArithmetic)sqmExpression;
            if (binaryArithmetic.getLeftHandOperand().getNodeType() == nodeType) {
                return this.determineValueMapping(binaryArithmetic.getLeftHandOperand(), fromClauseIndex);
            }
            if (binaryArithmetic.getRightHandOperand().getNodeType() == nodeType) {
                return this.determineValueMapping(binaryArithmetic.getRightHandOperand(), fromClauseIndex);
            }
        }
        if ((valueMapping = this.domainModel.resolveMappingExpressible(nodeType, fromClauseIndex::getTableGroup)) == null && (mappingModelExpressible = this.resolveInferredType()) != null) {
            return mappingModelExpressible;
        }
        if (valueMapping == null) {
            if (sqmExpression instanceof SqmLiteral) {
                return null;
            }
            throw new ConversionException("Could not determine ValueMapping for SqmExpression: " + sqmExpression);
        }
        return valueMapping;
    }

    protected MappingModelExpressible<?> getInferredValueMapping() {
        MappingModelExpressible<?> inferredMapping = this.resolveInferredType();
        if (inferredMapping != null) {
            if (inferredMapping instanceof PluralAttributeMapping) {
                return ((PluralAttributeMapping)inferredMapping).getElementDescriptor();
            }
            if (!(inferredMapping instanceof JavaObjectType)) {
                return inferredMapping;
            }
        }
        return null;
    }

    protected MappingModelExpressible<?> determineValueMapping(SqmParameter<?> sqmParameter) {
        MappingModelExpressible<?> inferredValueMapping;
        boolean bindingTypeExplicit;
        log.debugf("Determining mapping-model type for SqmParameter : %s", sqmParameter);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        BindableType<Object> paramType = binding.getBindType();
        boolean bl = bindingTypeExplicit = binding.getExplicitTemporalPrecision() != null;
        if (paramType == null && (paramType = queryParameter.getHibernateType()) == null) {
            paramType = sqmParameter.getAnticipatedType();
        }
        if (paramType == null) {
            MappingModelExpressible<?> inferredValueMapping2 = this.getInferredValueMapping();
            if (inferredValueMapping2 != null) {
                return this.resolveInferredValueMappingForParameter(inferredValueMapping2);
            }
            return this.basicType(Object.class);
        }
        if (paramType instanceof MappingModelExpressible) {
            MappingModelExpressible paramModelType = (MappingModelExpressible)((Object)paramType);
            MappingModelExpressible<?> inferredValueMapping3 = this.getInferredValueMapping();
            if (inferredValueMapping3 instanceof ModelPart) {
                JdbcMapping paramJdbcMapping = paramModelType.getSingleJdbcMapping();
                JdbcMapping inferredJdbcMapping = inferredValueMapping3.getSingleJdbcMapping();
                if (inferredJdbcMapping.getMappedJavaType().isWider(paramJdbcMapping.getMappedJavaType()) && (!bindingTypeExplicit || BaseSqmToSqlAstConverter.canUseInferredType(paramJdbcMapping, inferredJdbcMapping))) {
                    return this.resolveInferredValueMappingForParameter(inferredValueMapping3);
                }
            }
            return paramModelType;
        }
        if (sqmParameter.getAnticipatedType() == null ? (inferredValueMapping = this.getInferredValueMapping()) != null : paramType instanceof EntityDomainType && (inferredValueMapping = this.getInferredValueMapping()) != null) {
            return this.resolveInferredValueMappingForParameter(inferredValueMapping);
        }
        SqmExpressible<Object> paramSqmType = paramType.resolveExpressible(this.creationContext.getSessionFactory());
        if (paramSqmType instanceof SqmPath) {
            MappingModelExpressible<?> modelPart = this.determineValueMapping((SqmPath)((Object)paramSqmType));
            if (modelPart instanceof PluralAttributeMapping) {
                return this.resolveInferredValueMappingForParameter(((PluralAttributeMapping)modelPart).getElementDescriptor());
            }
            return modelPart;
        }
        if (paramSqmType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)paramSqmType);
        }
        if (paramSqmType instanceof CompositeSqmPathSource || paramSqmType instanceof EmbeddableDomainType) {
            MappingModelExpressible<?> inferredValueMapping4 = this.getInferredValueMapping();
            if (inferredValueMapping4 != null) {
                return this.resolveInferredValueMappingForParameter(inferredValueMapping4);
            }
            throw new UnsupportedOperationException("Support for embedded-valued parameters not yet implemented");
        }
        if (paramSqmType instanceof AnyDiscriminatorSqmPathSource) {
            return ((AnyDiscriminatorSqmPathSource)paramSqmType).getSqmPathType();
        }
        if (paramSqmType instanceof SqmPathSource || paramSqmType instanceof BasicDomainType) {
            MappingModelExpressible<?> inferredMapping = this.resolveInferredType();
            if (inferredMapping != null) {
                if (inferredMapping instanceof PluralAttributeMapping) {
                    return this.resolveInferredValueMappingForParameter(((PluralAttributeMapping)inferredMapping).getElementDescriptor());
                }
                if (!(inferredMapping instanceof JavaObjectType)) {
                    return this.resolveInferredValueMappingForParameter(inferredMapping);
                }
            }
            Class<Object> parameterJavaType = paramSqmType.getExpressibleJavaType().getJavaTypeClass();
            BasicType<Object> basicTypeForJavaType = this.getTypeConfiguration().getBasicTypeForJavaType(parameterJavaType);
            if (basicTypeForJavaType == null) {
                jakarta.persistence.metamodel.Type type;
                if (paramSqmType instanceof EntityDomainType) {
                    return this.resolveEntityPersister((EntityDomainType)paramSqmType);
                }
                if (paramSqmType instanceof SingularAttribute && (type = ((SingularAttribute)paramSqmType).getType()) instanceof EntityDomainType) {
                    return this.resolveEntityPersister((EntityDomainType)type);
                }
                if (inferredMapping != null) {
                    return inferredMapping;
                }
            }
            return basicTypeForJavaType;
        }
        throw new ConversionException("Could not determine ValueMapping for SqmParameter: " + sqmParameter);
    }

    private static boolean canUseInferredType(JdbcMapping bindJdbcMapping, JdbcMapping inferredJdbcMapping) {
        JdbcType inferredJdbcType;
        JdbcType bindJdbcType = bindJdbcMapping.getJdbcType();
        return bindJdbcType == (inferredJdbcType = inferredJdbcMapping.getJdbcType()) || bindJdbcType instanceof ArrayJdbcType && inferredJdbcType instanceof ArrayJdbcType && ((ArrayJdbcType)bindJdbcType).getElementJdbcType() == ((ArrayJdbcType)inferredJdbcType).getElementJdbcType();
    }

    private MappingModelExpressible<?> resolveInferredValueMappingForParameter(MappingModelExpressible<?> inferredValueMapping) {
        if (inferredValueMapping instanceof PluralAttributeMapping) {
            inferredValueMapping = ((PluralAttributeMapping)((Object)inferredValueMapping)).getElementDescriptor();
        }
        if (inferredValueMapping instanceof EntityCollectionPart) {
            return ((EntityCollectionPart)inferredValueMapping).getAssociatedEntityMappingType();
        }
        return inferredValueMapping;
    }

    private void resolveSqmParameter(SqmParameter<?> expression, MappingModelExpressible<?> valueMapping, BiConsumer<Integer, JdbcParameter> jdbcParameterConsumer) {
        ValuedModelPart bindable;
        this.sqmParameterMappingModelTypes.put(expression, valueMapping);
        if (valueMapping instanceof EntityAssociationMapping) {
            EntityAssociationMapping mapping = (EntityAssociationMapping)((Object)valueMapping);
            bindable = mapping.getForeignKeyDescriptor().getPart(mapping.getSideNature());
        } else {
            bindable = valueMapping instanceof EntityMappingType ? ((EntityMappingType)((Object)valueMapping)).getIdentifierMapping() : valueMapping;
        }
        if (bindable instanceof SelectableMappings) {
            ((SelectableMappings)bindable).forEachSelectable((index, selectableMapping) -> jdbcParameterConsumer.accept(index, new SqlTypedMappingJdbcParameter(selectableMapping)));
        } else if (bindable instanceof SelectableMapping) {
            jdbcParameterConsumer.accept(0, new SqlTypedMappingJdbcParameter((SelectableMapping)((Object)bindable)));
        } else {
            QueryParameterBinding<?> binding;
            Object bindValue;
            int sqlTypeCode;
            SqlTypedMappingImpl sqlTypedMapping = null;
            if (bindable instanceof BasicType && ((sqlTypeCode = ((BasicType)((Object)bindable)).getJdbcType().getDdlTypeCode()) == 2 || sqlTypeCode == 3) && (bindValue = (binding = this.domainParameterBindings.getBinding(this.domainParameterXref.getQueryParameter(expression))).getBindValue()) != null) {
                if (bindValue instanceof BigInteger) {
                    int precision = bindValue.toString().length() - (((BigInteger)bindValue).signum() < 0 ? 1 : 0);
                    sqlTypedMapping = new SqlTypedMappingImpl(null, null, precision, 0, ((BasicType)((Object)bindable)).getJdbcMapping());
                } else if (bindValue instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)bindValue;
                    sqlTypedMapping = new SqlTypedMappingImpl(null, null, bigDecimal.precision(), bigDecimal.scale(), ((BasicType)((Object)bindable)).getJdbcMapping());
                }
            }
            if (sqlTypedMapping == null) {
                if (bindable == null) {
                    throw new ConversionException("Could not determine neither the SqlTypedMapping nor the Bindable value for SqmParameter: " + expression);
                }
                bindable.forEachJdbcType((index, jdbcMapping) -> jdbcParameterConsumer.accept(index, new JdbcParameterImpl((JdbcMapping)jdbcMapping)));
            } else {
                jdbcParameterConsumer.accept(0, new SqlTypedMappingJdbcParameter(sqlTypedMapping));
            }
        }
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter<?> expression) {
        return this.consumeSqmParameter(expression);
    }

    @Override
    public Object visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        return this.consumeSqmParameter(this.getSqmParameter(expression));
    }

    private SqmParameter<?> getSqmParameter(SqmExpression<?> parameter) {
        if (parameter instanceof JpaCriteriaParameter) {
            return this.getSqmParameter((JpaCriteriaParameter)parameter);
        }
        if (parameter instanceof SqmParameter) {
            return (SqmParameter)parameter;
        }
        return null;
    }

    private SqmParameter<?> getSqmParameter(JpaCriteriaParameter<?> expression) {
        if (this.jpaCriteriaParamResolutions == null) {
            throw new IllegalStateException("No JpaCriteriaParameter resolutions registered");
        }
        SqmJpaCriteriaParameterWrapper<?> supplier = this.jpaCriteriaParamResolutions.get(expression);
        if (supplier == null) {
            throw new IllegalStateException("Criteria parameter [" + expression + "] not known to be a parameter of the processing tree");
        }
        return supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitTuple(SqmTuple<?> sqmTuple) {
        SqmExpressible expressible;
        int i;
        List<SqmExpression<?>> groupedExpressions = sqmTuple.getGroupedExpressions();
        int size = groupedExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        MappingModelExpressible mappingModelExpressible = this.resolveInferredType();
        EmbeddableMappingType embeddableMappingType = mappingModelExpressible instanceof ValueMapping ? (EmbeddableMappingType)((ValueMapping)mappingModelExpressible).getMappedType() : null;
        if (embeddableMappingType == null) {
            try {
                this.inferrableTypeAccessStack.push(() -> null);
                for (i = 0; i < size; ++i) {
                    expressions.add((Expression)groupedExpressions.get(i).accept(this));
                }
            }
            finally {
                this.inferrableTypeAccessStack.pop();
            }
        } else {
            for (i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(i);
                this.inferrableTypeAccessStack.push(() -> attributeMapping);
                try {
                    expressions.add((Expression)groupedExpressions.get(i).accept(this));
                    continue;
                }
                finally {
                    this.inferrableTypeAccessStack.pop();
                }
            }
        }
        MappingModelExpressible valueMapping = mappingModelExpressible != null ? mappingModelExpressible : ((expressible = sqmTuple.getExpressible()) instanceof MappingModelExpressible ? (MappingModelExpressible)((Object)expressible) : null);
        return new SqlTuple(expressions, valueMapping);
    }

    @Override
    public Object visitCollation(SqmCollation sqmCollation) {
        return new Collation((String)sqmCollation.getLiteralValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression visitFunction(SqmFunction<?> sqmFunction) {
        boolean oldInNestedContext = this.inNestedContext;
        this.inNestedContext = true;
        Supplier<MappingModelExpressible<?>> oldFunctionImpliedResultTypeAccess = this.functionImpliedResultTypeAccess;
        this.functionImpliedResultTypeAccess = this.inferrableTypeAccessStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> null);
        try {
            Expression expression = sqmFunction.convertToSqlAst(this);
            return expression;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
            this.functionImpliedResultTypeAccess = oldFunctionImpliedResultTypeAccess;
            this.inNestedContext = oldInNestedContext;
        }
    }

    @Override
    public void registerQueryTransformer(QueryTransformer transformer) {
        this.queryTransformers.getCurrent().add(transformer);
    }

    @Override
    public Star visitStar(SqmStar sqmStar) {
        return new Star();
    }

    @Override
    public Object visitOver(SqmOver<?> over) {
        this.currentClauseStack.push(Clause.OVER);
        Expression expression = (Expression)over.getExpression().accept(this);
        ArrayList<Expression> partitions = new ArrayList<Expression>(over.getWindow().getPartitions().size());
        for (SqmExpression<?> sqmExpression : over.getWindow().getPartitions()) {
            partitions.add((Expression)sqmExpression.accept(this));
        }
        ArrayList<SortSpecification> orderList = new ArrayList<SortSpecification>(over.getWindow().getOrderList().size());
        for (SqmSortSpecification sortSpecification : over.getWindow().getOrderList()) {
            orderList.add(this.visitSortSpecification(sortSpecification));
        }
        Over over2 = new Over(expression, partitions, orderList, over.getWindow().getMode(), over.getWindow().getStartKind(), over.getWindow().getStartExpression() == null ? null : (Expression)over.getWindow().getStartExpression().accept(this), over.getWindow().getEndKind(), over.getWindow().getEndExpression() == null ? null : (Expression)over.getWindow().getEndExpression().accept(this), over.getWindow().getExclusion());
        this.currentClauseStack.pop();
        return over2;
    }

    @Override
    public Object visitDistinct(SqmDistinct<?> sqmDistinct) {
        return new Distinct((Expression)sqmDistinct.getExpression().accept(this));
    }

    @Override
    public Object visitOverflow(SqmOverflow<?> sqmOverflow) {
        return new Overflow((Expression)sqmOverflow.getSeparatorExpression().accept(this), sqmOverflow.getFillerExpression() == null ? null : (Expression)sqmOverflow.getFillerExpression().accept(this), sqmOverflow.isWithCount());
    }

    @Override
    public Object visitTrimSpecification(SqmTrimSpecification specification) {
        return new TrimSpecification(specification.getSpecification());
    }

    @Override
    public Object visitCastTarget(SqmCastTarget<?> target) {
        BasicType targetType = (BasicType)target.getType();
        if (targetType instanceof BasicType) {
            targetType = InferredBasicValueResolver.resolveSqlTypeIndicators(this, targetType, target.getNodeJavaType());
        }
        return new CastTarget(targetType.getJdbcMapping(), target.getLength(), target.getPrecision(), target.getScale());
    }

    @Override
    public Object visitExtractUnit(SqmExtractUnit<?> unit) {
        return new ExtractUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitDurationUnit(SqmDurationUnit<?> unit) {
        return new DurationUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitFormat(SqmFormat sqmFormat) {
        return new Format((String)sqmFormat.getLiteralValue());
    }

    @Override
    public Object visitCoalesce(SqmCoalesce<?> sqmCoalesce) {
        SessionFactoryImplementor sessionFactory = this.creationContext.getSessionFactory();
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("coalesce").generateSqmExpression(sqmCoalesce.getArguments(), null, queryEngine).accept(this);
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation<?> expression) {
        return new UnaryOperation(this.interpret(expression.getOperation()), this.toSqlExpression(expression.getOperand().accept(this)), (BasicValuedMapping)this.determineValueMapping(expression.getOperand()));
    }

    private UnaryArithmeticOperator interpret(UnaryArithmeticOperator operator) {
        return operator;
    }

    @Override
    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic<?> expression) {
        boolean temporalTypeSomewhereToLeft;
        SqmExpression<?> leftOperand = expression.getLeftHandOperand();
        SqmExpression<?> rightOperand = expression.getRightHandOperand();
        boolean durationToRight = TypeConfiguration.isDuration(rightOperand.getNodeType());
        TypeConfiguration typeConfiguration = this.getCreationContext().getMappingMetamodel().getTypeConfiguration();
        TemporalType temporalTypeToLeft = typeConfiguration.getSqlTemporalType(leftOperand.getNodeType());
        TemporalType temporalTypeToRight = typeConfiguration.getSqlTemporalType(rightOperand.getNodeType());
        boolean bl = temporalTypeSomewhereToLeft = this.adjustedTimestamp != null || temporalTypeToLeft != null;
        if (temporalTypeToLeft != null && durationToRight && (this.adjustmentScale != null || this.negativeAdjustment)) {
            throw new SemanticException("Scalar multiplication of temporal value");
        }
        if (durationToRight && temporalTypeSomewhereToLeft) {
            return this.transformDurationArithmetic(expression);
        }
        if (temporalTypeToLeft != null && temporalTypeToRight != null) {
            return this.transformDatetimeArithmetic(expression);
        }
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(rightOperand, fromClauseIndex));
        Expression lhs = this.toSqlExpression(leftOperand.accept(this));
        this.inferrableTypeAccessStack.pop();
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(leftOperand, fromClauseIndex));
        Expression rhs = this.toSqlExpression(rightOperand.accept(this));
        this.inferrableTypeAccessStack.pop();
        if (durationToRight && this.appliedByUnit != null) {
            return new BinaryArithmeticExpression(lhs, expression.getOperator(), rhs, (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType()));
        }
        return new BinaryArithmeticExpression(lhs, expression.getOperator(), rhs, this.getExpressionType(expression));
    }

    private BasicValuedMapping getExpressionType(SqmBinaryArithmetic<?> expression) {
        SqmExpressible nodeType = expression.getNodeType();
        if (nodeType != null) {
            if (nodeType instanceof BasicValuedMapping) {
                return (BasicValuedMapping)((Object)nodeType);
            }
            if (nodeType.getSqmType() instanceof BasicValuedMapping) {
                return (BasicValuedMapping)((Object)nodeType.getSqmType());
            }
            return this.getTypeConfiguration().getBasicTypeForJavaType(nodeType.getExpressibleJavaType().getJavaTypeClass());
        }
        return JavaObjectType.INSTANCE;
    }

    private Expression toSqlExpression(Object value) {
        return (Expression)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object transformDurationArithmetic(SqmBinaryArithmetic<?> expression) {
        operator = expression.getOperator();
        lhs = SqmExpressionHelper.getActualExpression(expression.getLeftHandOperand());
        rhs = SqmExpressionHelper.getActualExpression(expression.getRightHandOperand());
        fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        switch (2.$SwitchMap$org$hibernate$query$sqm$BinaryArithmeticOperator[operator.ordinal()]) {
            case 1: 
            case 2: {
                timestamp = this.adjustedTimestamp;
                timestampType = this.adjustedTimestampType;
                this.inferrableTypeAccessStack.push((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$transformDurationArithmetic$89(org.hibernate.query.sqm.tree.expression.SqmExpression org.hibernate.query.sqm.sql.FromClauseIndex ), ()Ljava/lang/Object;)((BaseSqmToSqlAstConverter)this, rhs, (FromClauseIndex)fromClauseIndex));
                this.adjustedTimestamp = this.toSqlExpression(lhs.accept(this));
                this.inferrableTypeAccessStack.pop();
                type = this.adjustedTimestamp.getExpressionType();
                this.adjustedTimestampType = type instanceof SqmExpressible != false ? (SqmExpressible<Object>)type : (type instanceof ValueMapping != false ? (SqmExpressible<Object>)((ValueMapping)type).getMappedType() : lhs.getNodeType());
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                try {
                    this.inferrableTypeAccessStack.push((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$transformDurationArithmetic$90(org.hibernate.query.sqm.tree.expression.SqmExpression org.hibernate.query.sqm.sql.FromClauseIndex ), ()Ljava/lang/Object;)((BaseSqmToSqlAstConverter)this, lhs, (FromClauseIndex)fromClauseIndex));
                    result = rhs.accept(this);
                    if (!(result instanceof SqlTupleContainer)) ** GOTO lbl38
                    var10_11 = result;
                    this.inferrableTypeAccessStack.pop();
                }
                catch (Throwable var14_20) {
                    this.inferrableTypeAccessStack.pop();
                    if (operator == BinaryArithmeticOperator.SUBTRACT) {
                        this.negativeAdjustment = this.negativeAdjustment == false;
                    }
                    this.adjustedTimestamp = timestamp;
                    this.adjustedTimestampType = timestampType;
                    throw var14_20;
                }
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                this.adjustedTimestamp = timestamp;
                this.adjustedTimestampType = timestampType;
                return var10_11;
lbl38:
                // 2 sources

                if (lhs == expression.getLeftHandOperand()) ** GOTO lbl43
                temporalPath = (SqmPath)expression.getLeftHandOperand();
                baseNavigablePath = temporalPath.getNavigablePath().getParent();
                offset = temporalPath.get("zoneOffset").accept(this);
                ** GOTO lbl57
lbl43:
                // 1 sources

                if (rhs == expression.getRightHandOperand()) ** GOTO lbl48
                temporalPath = (SqmPath)expression.getRightHandOperand();
                baseNavigablePath = temporalPath.getNavigablePath().getParent();
                offset = temporalPath.get("zoneOffset").accept(this);
                ** GOTO lbl57
lbl48:
                // 1 sources

                temporalPath = result;
                this.inferrableTypeAccessStack.pop();
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                this.adjustedTimestamp = timestamp;
                this.adjustedTimestampType = timestampType;
                return temporalPath;
lbl57:
                // 3 sources

                valueMapping = (EmbeddableValuedModelPart)this.determineValueMapping(expression);
                var13_19 = new EmbeddableValuedExpression<T>(baseNavigablePath, valueMapping, new SqlTuple(List.of((Expression)result, (Expression)offset), valueMapping));
                this.inferrableTypeAccessStack.pop();
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                this.adjustedTimestamp = timestamp;
                this.adjustedTimestampType = timestampType;
                return var13_19;
            }
            case 3: {
                this.inferrableTypeAccessStack.push((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$transformDurationArithmetic$91(org.hibernate.query.sqm.tree.expression.SqmExpression org.hibernate.query.sqm.sql.FromClauseIndex ), ()Ljava/lang/Object;)((BaseSqmToSqlAstConverter)this, rhs, (FromClauseIndex)fromClauseIndex));
                duration = this.toSqlExpression(lhs.accept(this));
                this.inferrableTypeAccessStack.pop();
                scale = this.adjustmentScale;
                negate = this.negativeAdjustment;
                this.adjustmentScale = this.applyScale(duration);
                this.negativeAdjustment = false;
                try {
                    this.inferrableTypeAccessStack.push((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$transformDurationArithmetic$92(org.hibernate.query.sqm.tree.expression.SqmExpression org.hibernate.query.sqm.sql.FromClauseIndex ), ()Ljava/lang/Object;)((BaseSqmToSqlAstConverter)this, lhs, (FromClauseIndex)fromClauseIndex));
                    var12_16 = rhs.accept(this);
                    return var12_16;
                }
                finally {
                    this.inferrableTypeAccessStack.pop();
                    this.adjustmentScale = scale;
                    this.negativeAdjustment = negate;
                }
            }
        }
        throw new SemanticException("Illegal operator for a duration " + operator);
    }

    private Object transformDatetimeArithmetic(SqmBinaryArithmetic<?> expression) {
        BinaryArithmeticOperator operator = expression.getOperator();
        if (operator != BinaryArithmeticOperator.SUBTRACT) {
            throw new SemanticException("Illegal operator for temporal type: " + operator);
        }
        SqmExpression<?> lhs = SqmExpressionHelper.getActualExpression(expression.getLeftHandOperand());
        SqmExpression<?> rhs = SqmExpressionHelper.getActualExpression(expression.getRightHandOperand());
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(rhs, fromClauseIndex));
        Expression left = BaseSqmToSqlAstConverter.getActualExpression(this.cleanly(() -> this.toSqlExpression(lhs.accept(this))));
        this.inferrableTypeAccessStack.pop();
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(lhs, fromClauseIndex));
        Expression right = BaseSqmToSqlAstConverter.getActualExpression(this.cleanly(() -> this.toSqlExpression(rhs.accept(this))));
        this.inferrableTypeAccessStack.pop();
        TemporalUnit baseUnit = TemporalUnit.NATIVE;
        BasicType<Long> diffResultType = this.basicType(Long.class);
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            DurationUnit unit = new DurationUnit(baseUnit, diffResultType);
            BasicValuedMapping durationType = (BasicValuedMapping)((Object)expression.getNodeType());
            Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((ReturnableType)expression.getNodeType(), durationType.getJdbcMapping().getJdbcType().isInterval() ? null : unit, right, left));
            return this.timestampadd().expression((ReturnableType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        if (this.appliedByUnit != null) {
            DurationUnit unit = (DurationUnit)this.appliedByUnit.getUnit().accept((SemanticQueryWalker<?>)this);
            return this.applyScale(this.timestampdiff().expression(null, unit, right, left));
        }
        DurationUnit unit = new DurationUnit(baseUnit, diffResultType);
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)expression.getNodeType());
        Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((ReturnableType)expression.getNodeType(), durationType.getJdbcMapping().getJdbcType().isInterval() ? null : unit, right, left));
        return new Duration(scaledMagnitude, baseUnit, durationType);
    }

    private static Expression getActualExpression(Expression expression) {
        EmbeddableValuedModelPart embeddableValuedModelPart;
        if (expression.getExpressionType() instanceof EmbeddableValuedModelPart && JavaTypeHelper.isTemporal((embeddableValuedModelPart = (EmbeddableValuedModelPart)expression.getExpressionType()).getJavaType())) {
            return ((SqlTupleContainer)((Object)expression)).getSqlTuple().getExpressions().get(0);
        }
        return expression;
    }

    private <J> BasicType<J> basicType(Class<J> javaType) {
        return this.creationContext.getMappingMetamodel().getTypeConfiguration().getBasicTypeForJavaType(javaType);
    }

    private TimestampaddFunction timestampadd() {
        return (TimestampaddFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampadd");
    }

    private TimestampdiffFunction timestampdiff() {
        return (TimestampdiffFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampdiff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> X cleanly(Supplier<X> supplier) {
        SqmByUnit byUnit = this.appliedByUnit;
        Expression timestamp = this.adjustedTimestamp;
        SqmExpressible<?> timestampType = this.adjustedTimestampType;
        Expression scale = this.adjustmentScale;
        boolean negate = this.negativeAdjustment;
        this.adjustmentScale = null;
        this.negativeAdjustment = false;
        this.appliedByUnit = null;
        this.adjustedTimestamp = null;
        this.adjustedTimestampType = null;
        try {
            X x = supplier.get();
            return x;
        }
        finally {
            this.appliedByUnit = byUnit;
            this.adjustedTimestamp = timestamp;
            this.adjustedTimestampType = timestampType;
            this.adjustmentScale = scale;
            this.negativeAdjustment = negate;
        }
    }

    Expression applyScale(Expression magnitude) {
        boolean negate = this.negativeAdjustment;
        if (magnitude instanceof UnaryOperation) {
            UnaryOperation unary = (UnaryOperation)magnitude;
            if (unary.getOperator() == UnaryArithmeticOperator.UNARY_MINUS) {
                negate = !negate;
            }
            magnitude = unary.getOperand();
        }
        if (this.adjustmentScale != null && !BaseSqmToSqlAstConverter.isOne(this.adjustmentScale)) {
            if (BaseSqmToSqlAstConverter.isOne(magnitude)) {
                magnitude = this.adjustmentScale;
            } else {
                BasicValuedMapping magnitudeType = (BasicValuedMapping)magnitude.getExpressionType();
                BasicValuedMapping expressionType = magnitudeType.getJdbcMapping().getJdbcType().isInterval() ? magnitudeType : this.widestNumeric((BasicValuedMapping)this.adjustmentScale.getExpressionType(), magnitudeType);
                magnitude = new BinaryArithmeticExpression(this.adjustmentScale, BinaryArithmeticOperator.MULTIPLY, magnitude, expressionType);
            }
        }
        if (negate) {
            magnitude = new UnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        return magnitude;
    }

    static boolean isOne(Expression scale) {
        return scale instanceof QueryLiteral && ((Number)((QueryLiteral)scale).getLiteralValue()).longValue() == 1L;
    }

    @Override
    public Object visitToDuration(SqmToDuration<?> toDuration) {
        this.inferrableTypeAccessStack.push(() -> null);
        Expression magnitude = this.toSqlExpression(toDuration.getMagnitude().accept(this));
        this.inferrableTypeAccessStack.pop();
        DurationUnit unit = (DurationUnit)toDuration.getUnit().accept((SemanticQueryWalker<?>)this);
        Expression scaledMagnitude = this.applyScale(magnitude);
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            return this.timestampadd().expression((ReturnableType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)toDuration.getNodeType());
        Duration duration = scaledMagnitude.getExpressionType().getSingleJdbcMapping().getJdbcType().isInterval() ? new Duration(this.extractEpoch(scaledMagnitude), TemporalUnit.SECOND, durationType) : new Duration(scaledMagnitude, unit.getUnit(), durationType);
        if (this.appliedByUnit != null) {
            TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
            BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
            return new Conversion(duration, appliedUnit, scalarType);
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitByUnit(SqmByUnit byUnit) {
        SqmByUnit outer = this.appliedByUnit;
        this.appliedByUnit = byUnit;
        try {
            Object object = byUnit.getDuration().accept(this);
            return object;
        }
        finally {
            this.appliedByUnit = outer;
        }
    }

    private BasicValuedMapping widestNumeric(BasicValuedMapping lhs, BasicValuedMapping rhs) {
        CastType lhsCastType = lhs.getJdbcMapping().getJdbcType().getCastType();
        CastType rhsCastType = rhs.getJdbcMapping().getJdbcType().getCastType();
        if (lhsCastType == CastType.FIXED) {
            return lhs;
        }
        if (rhsCastType == CastType.FIXED) {
            return rhs;
        }
        if (lhsCastType == CastType.DOUBLE) {
            return lhs;
        }
        if (rhsCastType == CastType.DOUBLE) {
            return rhs;
        }
        if (lhsCastType == CastType.FLOAT) {
            return lhs;
        }
        if (rhsCastType == CastType.FLOAT) {
            return rhs;
        }
        return lhs;
    }

    @Override
    public Object visitModifiedSubQueryExpression(SqmModifiedSubQueryExpression<?> expr) {
        return new ModifiedSubQueryExpression((SelectStatement)this.visitSubQueryExpression((SqmSubQuery)expr.getSubQuery()), this.convert(expr.getModifier()));
    }

    private ModifiedSubQueryExpression.Modifier convert(SqmModifiedSubQueryExpression.Modifier modifier) {
        if (modifier == SqmModifiedSubQueryExpression.Modifier.ALL) {
            return ModifiedSubQueryExpression.Modifier.ALL;
        }
        if (modifier == SqmModifiedSubQueryExpression.Modifier.ANY) {
            return ModifiedSubQueryExpression.Modifier.ANY;
        }
        if (modifier == SqmModifiedSubQueryExpression.Modifier.SOME) {
            return ModifiedSubQueryExpression.Modifier.SOME;
        }
        throw new IllegalStateException("Unrecognized SqmModifiedSubQueryExpression.Modifier : " + modifier);
    }

    @Override
    public SelectStatement visitSubQueryExpression(SqmSubQuery<?> sqmSubQuery) {
        SqmJoin<?, ?> oldJoin = this.currentlyProcessingJoin;
        CteContainer oldCteContainer = this.cteContainer;
        this.currentlyProcessingJoin = null;
        CteContainer cteContainer = this.visitCteContainer(sqmSubQuery);
        Object queryPart = this.visitQueryPart((SqmQueryPart)sqmSubQuery.getQueryPart());
        this.currentlyProcessingJoin = oldJoin;
        this.cteContainer = oldCteContainer;
        return new SelectStatement(cteContainer, (QueryPart)queryPart, Collections.emptyList());
    }

    @Override
    public CaseSimpleExpression visitSimpleCaseExpression(SqmCaseSimple<?, ?> expression) {
        ArrayList<CaseSimpleExpression.WhenFragment> whenFragments = new ArrayList<CaseSimpleExpression.WhenFragment>(expression.getWhenFragments().size());
        Supplier inferenceSupplier = this.inferrableTypeAccessStack.getCurrent();
        boolean oldInNestedContext = this.inNestedContext;
        this.inNestedContext = true;
        this.inferrableTypeAccessStack.push(() -> {
            for (SqmCaseSimple.WhenFragment whenFragment : expression.getWhenFragments()) {
                MappingModelExpressible resolved = this.determineCurrentExpressible(whenFragment.getCheckValue());
                if (resolved == null) continue;
                return resolved;
            }
            return null;
        });
        Expression fixture = (Expression)expression.getFixture().accept(this);
        MappingModelExpressible fixtureType = (MappingModelExpressible)fixture.getExpressionType();
        this.inferrableTypeAccessStack.pop();
        MappingModelExpressible resolved = this.determineCurrentExpressible(expression);
        Expression otherwise = null;
        for (SqmCaseSimple.WhenFragment<?, ?> whenFragment : expression.getWhenFragments()) {
            this.inferrableTypeAccessStack.push(() -> fixtureType);
            Expression checkValue = (Expression)whenFragment.getCheckValue().accept(this);
            this.inferrableTypeAccessStack.pop();
            MappingModelExpressible alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> BaseSqmToSqlAstConverter.lambda$visitSimpleCaseExpression$100(alreadyKnown, (Supplier)inferenceSupplier));
            Expression resultExpression = (Expression)whenFragment.getResult().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressible)BaseSqmToSqlAstConverter.highestPrecedence(resolved, resultExpression.getExpressionType());
            whenFragments.add(new CaseSimpleExpression.WhenFragment(checkValue, resultExpression));
        }
        if (expression.getOtherwise() != null) {
            MappingModelExpressible alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> BaseSqmToSqlAstConverter.lambda$visitSimpleCaseExpression$101(alreadyKnown, (Supplier)inferenceSupplier));
            otherwise = (Expression)expression.getOtherwise().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressible)BaseSqmToSqlAstConverter.highestPrecedence(resolved, otherwise.getExpressionType());
        }
        this.inNestedContext = oldInNestedContext;
        return new CaseSimpleExpression(resolved, fixture, whenFragments, otherwise);
    }

    @Override
    public CaseSearchedExpression visitSearchedCaseExpression(SqmCaseSearched<?> expression) {
        ArrayList<CaseSearchedExpression.WhenFragment> whenFragments = new ArrayList<CaseSearchedExpression.WhenFragment>(expression.getWhenFragments().size());
        Supplier inferenceSupplier = this.inferrableTypeAccessStack.getCurrent();
        boolean oldInNestedContext = this.inNestedContext;
        this.inNestedContext = true;
        MappingModelExpressible resolved = this.determineCurrentExpressible(expression);
        Expression otherwise = null;
        for (SqmCaseSearched.WhenFragment<?> whenFragment : expression.getWhenFragments()) {
            Predicate whenPredicate = this.visitNestedTopLevelPredicate(whenFragment.getPredicate());
            MappingModelExpressible alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> BaseSqmToSqlAstConverter.lambda$visitSearchedCaseExpression$102(alreadyKnown, (Supplier)inferenceSupplier));
            Expression resultExpression = (Expression)whenFragment.getResult().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressible)BaseSqmToSqlAstConverter.highestPrecedence(resolved, resultExpression.getExpressionType());
            whenFragments.add(new CaseSearchedExpression.WhenFragment(whenPredicate, resultExpression));
        }
        if (expression.getOtherwise() != null) {
            MappingModelExpressible alreadyKnown = resolved;
            this.inferrableTypeAccessStack.push(() -> BaseSqmToSqlAstConverter.lambda$visitSearchedCaseExpression$103(alreadyKnown, (Supplier)inferenceSupplier));
            otherwise = (Expression)expression.getOtherwise().accept(this);
            this.inferrableTypeAccessStack.pop();
            resolved = (MappingModelExpressible)BaseSqmToSqlAstConverter.highestPrecedence(resolved, otherwise.getExpressionType());
        }
        this.inNestedContext = oldInNestedContext;
        return new CaseSearchedExpression(resolved, whenFragments, otherwise);
    }

    private MappingModelExpressible<?> determineCurrentExpressible(SqmTypedNode<?> expression) {
        return this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().resolveMappingExpressible(expression.getNodeType(), this.getFromClauseIndex()::findTableGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> X visitWithInferredType(SqmExpression<?> expression, SqmExpression<?> inferred) {
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(inferred, fromClauseIndex));
        try {
            Object object = expression.accept(this);
            return (X)object;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitWithInferredType(SqmVisitableNode node, Supplier<MappingModelExpressible<?>> inferredTypeAccess) {
        this.inferrableTypeAccessStack.push(inferredTypeAccess);
        try {
            Object object = node.accept(this);
            return object;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    @Override
    public Object visitAny(SqmAny<?> sqmAny) {
        return new Any((SelectStatement)this.visitSubQueryExpression((SqmSubQuery)sqmAny.getSubquery()), null);
    }

    @Override
    public Object visitEvery(SqmEvery<?> sqmEvery) {
        return new Every((SelectStatement)this.visitSubQueryExpression((SqmSubQuery)sqmEvery.getSubquery()), null);
    }

    @Override
    public Object visitSummarization(SqmSummarization<?> sqmSummarization) {
        List<SqmExpression<?>> groupingExpressions = sqmSummarization.getGroupings();
        int size = groupingExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((Expression)groupingExpressions.get(i).accept(this));
        }
        return new Summarization(this.getSummarizationKind(sqmSummarization.getKind()), expressions);
    }

    private Summarization.Kind getSummarizationKind(SqmSummarization.Kind kind) {
        switch (kind) {
            case CUBE: {
                return Summarization.Kind.CUBE;
            }
            case ROLLUP: {
                return Summarization.Kind.ROLLUP;
            }
        }
        throw new UnsupportedOperationException("Unsupported summarization: " + kind);
    }

    @Override
    public Expression visitEntityTypeLiteralExpression(SqmLiteralEntityType<?> sqmExpression) {
        SqmExpressible nodeType = sqmExpression.getNodeType();
        EntityPersister mappingDescriptor = this.creationContext.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(nodeType.getHibernateEntityName());
        return new EntityTypeLiteral(mappingDescriptor);
    }

    @Override
    public Expression visitAnyDiscriminatorTypeValueExpression(SqmAnyDiscriminatorValue<?> expression) {
        BasicType<?> domainType = expression.getDomainType();
        return new QueryLiteral<Object>(domainType.convertToRelationalValue(expression.getEntityValue().getJavaType()), domainType);
    }

    @Override
    public Expression visitParameterizedEntityTypeExpression(SqmParameterizedEntityType<?> sqmExpression) {
        assert (this.resolveInferredType() instanceof EntityDiscriminatorMapping);
        return (Expression)sqmExpression.getDiscriminatorSource().accept(this);
    }

    @Override
    public Object visitEnumLiteral(SqmEnumLiteral<?> sqmEnumLiteral) {
        CollectionPart elementDescriptor;
        MappingModelExpressible<?> inferred = this.resolveInferredType();
        BasicValuedMapping inferredType = inferred instanceof PluralAttributeMapping ? ((elementDescriptor = ((PluralAttributeMapping)inferred).getElementDescriptor()) instanceof BasicValuedCollectionPart ? (BasicValuedCollectionPart)elementDescriptor : null) : (inferred instanceof BasicValuedMapping ? (BasicValuedMapping)inferred : null);
        if (inferredType != null) {
            return new QueryLiteral<Object>(inferredType.getJdbcMapping().convertToRelationalValue(sqmEnumLiteral.getEnumValue()), inferredType);
        }
        return BaseSqmToSqlAstConverter.queryLiteral(sqmEnumLiteral, this.getTypeConfiguration());
    }

    private static <T extends Enum<T>> QueryLiteral<T> queryLiteral(SqmEnumLiteral<T> sqmEnumLiteral, TypeConfiguration typeConfiguration) {
        return new QueryLiteral<T>(sqmEnumLiteral.getEnumValue(), new BasicTypeImpl(sqmEnumLiteral.getExpressibleJavaType(), typeConfiguration.getJdbcTypeRegistry().getDescriptor(5)));
    }

    @Override
    public Object visitFieldLiteral(SqmFieldLiteral<?> sqmFieldLiteral) {
        return new QueryLiteral(sqmFieldLiteral.getValue(), (BasicValuedMapping)this.determineValueMapping(sqmFieldLiteral));
    }

    @Override
    public Predicate visitNestedTopLevelPredicate(SqmPredicate predicate) {
        IdentityHashMap<TableGroup, Map<String, EntityNameUse>> originalConjunctTableGroupTreatUsages = this.tableGroupEntityNameUses.isEmpty() ? null : new IdentityHashMap<TableGroup, Map<String, EntityNameUse>>(this.tableGroupEntityNameUses);
        this.tableGroupEntityNameUses.clear();
        this.inferrableTypeAccessStack.push(this::getBooleanType);
        Predicate result = (Predicate)predicate.accept(this);
        this.inferrableTypeAccessStack.pop();
        Predicate finalPredicate = SqlAstTreeHelper.combinePredicates(result, this.consumeConjunctTreatTypeRestrictions());
        if (originalConjunctTableGroupTreatUsages != null) {
            for (Map.Entry entry : originalConjunctTableGroupTreatUsages.entrySet()) {
                Map<String, EntityNameUse> entityNameUses = this.tableGroupEntityNameUses.putIfAbsent((TableGroup)entry.getKey(), (Map)entry.getValue());
                if (entityNameUses == null || entityNameUses == entry.getValue()) continue;
                for (Map.Entry useEntry : ((Map)entry.getValue()).entrySet()) {
                    EntityNameUse currentUseKind = entityNameUses.get(useEntry.getKey());
                    if (currentUseKind == null) {
                        entityNameUses.put((String)useEntry.getKey(), (EntityNameUse)useEntry.getValue());
                        continue;
                    }
                    entityNameUses.put((String)useEntry.getKey(), ((EntityNameUse)useEntry.getValue()).stronger(currentUseKind));
                }
            }
        }
        return finalPredicate;
    }

    @Override
    public GroupedPredicate visitGroupedPredicate(SqmGroupedPredicate predicate) {
        return new GroupedPredicate((Predicate)predicate.getSubPredicate().accept(this));
    }

    /*
     * Could not resolve type clashes
     * Iterators could be improved
     */
    @Override
    public Junction visitJunctionPredicate(SqmJunctionPredicate predicate) {
        if (predicate.getOperator() == Predicate.BooleanOperator.AND) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>(predicate.getPredicates().size());
            for (SqmPredicate subPredicate : predicate.getPredicates()) {
                predicates.add((Predicate)subPredicate.accept(this));
            }
            return new Junction(Junction.Nature.CONJUNCTION, predicates, this.getBooleanType());
        }
        Junction disjunction = new Junction(Junction.Nature.DISJUNCTION, new ArrayList<Predicate>(predicate.getPredicates().size()), this.getBooleanType());
        IdentityHashMap previousTableGroupEntityNameUses = this.tableGroupEntityNameUses.isEmpty() ? null : new IdentityHashMap(this.tableGroupEntityNameUses);
        Map[] disjunctEntityNameUsesArray = null;
        Map entityNameUsesToPropagate = null;
        ArrayList<TableGroup> treatedTableGroups = null;
        ArrayList<TableGroup> filteredTableGroups = null;
        List<SqmPredicate> predicates = predicate.getPredicates();
        for (int i = 0; i < predicates.size(); ++i) {
            this.tableGroupEntityNameUses.clear();
            disjunction.add((Predicate)predicates.get(i).accept(this));
            if (!this.tableGroupEntityNameUses.isEmpty()) {
                Map entityNameUses;
                if (disjunctEntityNameUsesArray == null) {
                    disjunctEntityNameUsesArray = new Map[predicate.getPredicates().size()];
                    Map map = entityNameUsesToPropagate = previousTableGroupEntityNameUses == null ? new IdentityHashMap() : previousTableGroupEntityNameUses;
                }
                if (i == 0) {
                    for (Map.Entry<Object, Object> entry : this.tableGroupEntityNameUses.entrySet()) {
                        if (((Map)entry.getValue()).containsValue(EntityNameUse.TREAT) || ((Map)entry.getValue()).containsValue(EntityNameUse.OPTIONAL_TREAT)) {
                            if (treatedTableGroups == null) {
                                treatedTableGroups = new ArrayList<TableGroup>(1);
                            }
                            treatedTableGroups.add((TableGroup)entry.getKey());
                        }
                        if (!((Map)entry.getValue()).containsValue(EntityNameUse.FILTER)) continue;
                        if (filteredTableGroups == null) {
                            filteredTableGroups = new ArrayList<TableGroup>(1);
                        }
                        filteredTableGroups.add((TableGroup)entry.getKey());
                    }
                }
                List<Object> missingTableGroupFilters = filteredTableGroups == null || i == 0 ? Collections.emptyList() : new ArrayList(filteredTableGroups);
                List missingTableGroupTreats = treatedTableGroups == null || i == 0 ? Collections.emptyList() : new ArrayList(treatedTableGroups);
                for (Map.Entry<TableGroup, Map<String, EntityNameUse>> entry : this.tableGroupEntityNameUses.entrySet()) {
                    boolean downgradeFilterUses;
                    boolean downgradeTreatUses;
                    TableGroup tableGroup = entry.getKey();
                    Iterator<Map.Entry<String, EntityNameUse>> entityNameUses2 = entityNameUsesToPropagate.computeIfAbsent(tableGroup, k -> new HashMap());
                    if (i == 0) {
                        downgradeTreatUses = false;
                        downgradeFilterUses = false;
                    } else {
                        downgradeTreatUses = !missingTableGroupTreats.contains(tableGroup);
                        downgradeFilterUses = !missingTableGroupFilters.contains(tableGroup);
                    }
                    for (Map.Entry<String, EntityNameUse> useEntry : entry.getValue().entrySet()) {
                        EntityNameUse unionEntityNameUse;
                        EntityNameUse.UseKind useKind = useEntry.getValue().getKind();
                        EntityNameUse currentUseKind = (EntityNameUse)entityNameUses2.get(useEntry.getKey());
                        if (useKind == EntityNameUse.UseKind.TREAT) {
                            if (downgradeTreatUses) {
                                unionEntityNameUse = EntityNameUse.EXPRESSION;
                            } else {
                                unionEntityNameUse = useEntry.getValue();
                                missingTableGroupTreats.remove(tableGroup);
                            }
                        } else if (useKind == EntityNameUse.UseKind.FILTER) {
                            if (downgradeFilterUses) {
                                unionEntityNameUse = EntityNameUse.EXPRESSION;
                            } else {
                                unionEntityNameUse = useEntry.getValue();
                                missingTableGroupFilters.remove(tableGroup);
                            }
                        } else {
                            unionEntityNameUse = useEntry.getValue();
                        }
                        if (currentUseKind == null) {
                            entityNameUses2.put(useEntry.getKey(), unionEntityNameUse);
                            continue;
                        }
                        entityNameUses2.put(useEntry.getKey(), unionEntityNameUse.stronger(currentUseKind));
                    }
                }
                for (TableGroup missingTableGroupTreat : missingTableGroupTreats) {
                    treatedTableGroups.remove(missingTableGroupTreat);
                    entityNameUses = (Map)entityNameUsesToPropagate.get(missingTableGroupTreat);
                    for (Map.Entry entry : entityNameUses.entrySet()) {
                        if (((EntityNameUse)entry.getValue()).getKind() != EntityNameUse.UseKind.TREAT) continue;
                        entry.setValue(EntityNameUse.EXPRESSION);
                    }
                }
                for (TableGroup missingTableGroupFilter : missingTableGroupFilters) {
                    filteredTableGroups.remove(missingTableGroupFilter);
                    entityNameUses = (Map)entityNameUsesToPropagate.get(missingTableGroupFilter);
                    for (Map.Entry entry : entityNameUses.entrySet()) {
                        if (entry.getValue() != EntityNameUse.FILTER) continue;
                        entry.setValue(EntityNameUse.EXPRESSION);
                    }
                }
                disjunctEntityNameUsesArray[i] = new IdentityHashMap<TableGroup, Map<String, EntityNameUse>>(this.tableGroupEntityNameUses);
                continue;
            }
            if (treatedTableGroups != null) {
                treatedTableGroups = null;
                for (Map entityNameUses : entityNameUsesToPropagate.values()) {
                    for (Map.Entry<TableGroup, Map<String, EntityNameUse>> entry : entityNameUses.entrySet()) {
                        if (((EntityNameUse)((Object)entry.getValue())).getKind() != EntityNameUse.UseKind.TREAT) continue;
                        entry.setValue((Map<String, EntityNameUse>)((Object)EntityNameUse.EXPRESSION));
                    }
                }
            }
            if (filteredTableGroups == null) continue;
            filteredTableGroups = null;
            for (Map entityNameUses : entityNameUsesToPropagate.values()) {
                for (Map.Entry<TableGroup, Map<String, EntityNameUse>> entry : entityNameUses.entrySet()) {
                    if (entry.getValue() != EntityNameUse.FILTER) continue;
                    entry.setValue((Map<String, EntityNameUse>)((Object)EntityNameUse.EXPRESSION));
                }
            }
        }
        if (disjunctEntityNameUsesArray == null) {
            if (previousTableGroupEntityNameUses != null) {
                this.tableGroupEntityNameUses.putAll(previousTableGroupEntityNameUses);
            }
            return disjunction;
        }
        Iterator<Map.Entry<TableGroup, Map<String, EntityNameUse>>> iterator = this.tableGroupEntityNameUses.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TableGroup, Map<String, EntityNameUse>> entry = iterator.next();
            HashMap<String, EntityNameUse> intersected = new HashMap<String, EntityNameUse>(entry.getValue());
            entry.setValue(intersected);
            boolean remove = false;
            for (Map conjunctTreatUsages : disjunctEntityNameUsesArray) {
                Map entityNames;
                if (conjunctTreatUsages == null || (entityNames = (Map)conjunctTreatUsages.get(entry.getKey())) == null) {
                    remove = true;
                    continue;
                }
                Iterator intersectedIter = intersected.entrySet().iterator();
                while (intersectedIter.hasNext()) {
                    Map.Entry intersectedEntry = intersectedIter.next();
                    EntityNameUse intersectedUseKind = (EntityNameUse)intersectedEntry.getValue();
                    EntityNameUse useKind = (EntityNameUse)entityNames.get(intersectedEntry.getKey());
                    if (useKind == null) {
                        intersectedIter.remove();
                        continue;
                    }
                    intersectedEntry.setValue(intersectedUseKind.weaker(useKind));
                }
                if (intersected.isEmpty()) {
                    remove = true;
                    continue;
                }
                entityNames.keySet().removeAll(intersected.keySet());
                if (!entityNames.isEmpty()) continue;
                conjunctTreatUsages.remove(entry.getKey());
            }
            if (!remove) continue;
            iterator.remove();
        }
        for (int i = 0; i < disjunctEntityNameUsesArray.length; ++i) {
            void conjunctTreatUsages = disjunctEntityNameUsesArray[i];
            if (conjunctTreatUsages == null || conjunctTreatUsages.isEmpty()) continue;
            disjunction.getPredicates().set(i, SqlAstTreeHelper.combinePredicates(this.consumeConjunctTreatTypeRestrictions((Map<TableGroup, Map<String, EntityNameUse>>)conjunctTreatUsages), disjunction.getPredicates().get(i)));
        }
        for (Map.Entry<Object, Object> entry : entityNameUsesToPropagate.entrySet()) {
            Map<String, EntityNameUse> entityNameUses = this.tableGroupEntityNameUses.putIfAbsent((TableGroup)entry.getKey(), (Map)entry.getValue());
            if (entityNameUses == null || entityNameUses == entry.getValue()) continue;
            for (Map.Entry useEntry : ((Map)entry.getValue()).entrySet()) {
                EntityNameUse currentEntityNameUse = entityNameUses.get(useEntry.getKey());
                if (currentEntityNameUse == null) {
                    entityNameUses.put((String)useEntry.getKey(), (EntityNameUse)useEntry.getValue());
                    continue;
                }
                entityNameUses.put((String)useEntry.getKey(), ((EntityNameUse)useEntry.getValue()).stronger(currentEntityNameUse));
            }
        }
        return disjunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        Expression lhs;
        SqmPluralValuedSimplePath<?> pluralPath = predicate.getPluralPath();
        this.prepareReusablePath(pluralPath, () -> null);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.determineValueMapping(pluralPath);
        this.inferrableTypeAccessStack.push(() -> pluralAttributeMapping);
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        QuerySpec subQuerySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent, false));
        try {
            TableGroup tableGroup = pluralAttributeMapping.createRootTableGroup(true, pluralPath.getNavigablePath(), null, null, () -> subQuerySpec::applyPredicate, this);
            pluralAttributeMapping.applyBaseRestrictions(subQuerySpec::applyPredicate, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            this.getFromClauseAccess().registerTableGroup(pluralPath.getNavigablePath(), tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            subQuerySpec.getFromClause().addRoot(tableGroup);
            pluralAttributeMapping.getElementDescriptor().getInclusionCheckPart().applySqlSelections(pluralPath.getNavigablePath(), tableGroup, this);
            subQuerySpec.applyPredicate(pluralAttributeMapping.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPath.getNavigablePath().getParent()), tableGroup, (SqlAstCreationState)this));
        }
        finally {
            this.popProcessingStateStack();
        }
        return new InSubQueryPredicate(lhs, new SelectStatement(subQuerySpec), predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public NegatedPredicate visitNegatedPredicate(SqmNegatedPredicate predicate) {
        return new NegatedPredicate((Predicate)predicate.getWrappedPredicate().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
        Expression rhs;
        Expression lhs;
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getRightHandExpression(), fromClauseIndex));
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getLeftHandExpression(), fromClauseIndex));
        try {
            rhs = (Expression)predicate.getRightHandExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        ComparisonOperator sqmOperator = predicate.isNegated() ? predicate.getSqmOperator().negated() : predicate.getSqmOperator();
        this.handleTypeComparison(lhs, rhs, sqmOperator == ComparisonOperator.EQUAL);
        return new ComparisonPredicate(lhs, sqmOperator, rhs, this.getBooleanType());
    }

    private void handleTypeComparison(Expression lhs, Expression rhs, boolean inclusive) {
        EntityTypeLiteral literalExpression;
        DiscriminatorPathInterpretation typeExpression;
        if (lhs instanceof DiscriminatorPathInterpretation) {
            typeExpression = (DiscriminatorPathInterpretation)lhs;
            literalExpression = rhs instanceof EntityTypeLiteral ? (EntityTypeLiteral)rhs : null;
        } else if (rhs instanceof DiscriminatorPathInterpretation) {
            typeExpression = (DiscriminatorPathInterpretation)rhs;
            literalExpression = lhs instanceof EntityTypeLiteral ? (EntityTypeLiteral)lhs : null;
        } else {
            return;
        }
        if (literalExpression == null) {
            TableGroup tableGroup = this.getFromClauseIndex().getTableGroup(typeExpression.getNavigablePath().getParent());
            EntityMappingType entityMappingType = (EntityMappingType)tableGroup.getModelPart().getPartMappingType();
            this.registerEntityNameUsage(tableGroup, EntityNameUse.FILTER, entityMappingType.getEntityName());
            for (EntityMappingType subMappingType : entityMappingType.getSubMappingTypes()) {
                this.registerEntityNameUsage(tableGroup, EntityNameUse.FILTER, subMappingType.getEntityName());
            }
        } else {
            this.handleTypeComparison(typeExpression, Collections.singletonList(literalExpression), inclusive);
        }
    }

    private void handleTypeComparison(DiscriminatorPathInterpretation typeExpression, List<EntityTypeLiteral> literalExpressions, boolean inclusive) {
        TableGroup tableGroup = this.getFromClauseIndex().getTableGroup(typeExpression.getNavigablePath().getParent());
        if (inclusive) {
            for (EntityTypeLiteral literalExpr : literalExpressions) {
                this.registerEntityNameUsage(tableGroup, EntityNameUse.FILTER, literalExpr.getEntityTypeDescriptor().getEntityName());
            }
        } else {
            EntityMappingType entityMappingType = (EntityMappingType)tableGroup.getModelPart().getPartMappingType();
            HashSet<String> excludedEntityNames = new HashSet<String>(entityMappingType.getSubMappingTypes().size());
            for (EntityTypeLiteral literalExpr : literalExpressions) {
                excludedEntityNames.add(literalExpr.getEntityTypeDescriptor().getEntityName());
            }
            if (!excludedEntityNames.contains(entityMappingType.getEntityName())) {
                this.registerEntityNameUsage(tableGroup, EntityNameUse.FILTER, entityMappingType.getEntityName());
            }
            for (EntityMappingType subMappingType : entityMappingType.getSubMappingTypes()) {
                if (excludedEntityNames.contains(subMappingType.getEntityName())) continue;
                this.registerEntityNameUsage(tableGroup, EntityNameUse.FILTER, subMappingType.getEntityName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        this.prepareReusablePath(predicate.getPluralPath(), () -> null);
        QuerySpec subQuerySpec = new QuerySpec(false, 1);
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        SqlAstQueryPartProcessingStateImpl subQueryState = new SqlAstQueryPartProcessingStateImpl(subQuerySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent, true);
        this.pushProcessingState(subQueryState);
        try {
            SqmPluralValuedSimplePath<?> sqmPluralPath = predicate.getPluralPath();
            NavigablePath pluralPathNavPath = sqmPluralPath.getNavigablePath();
            NavigablePath parentNavPath = pluralPathNavPath.getParent();
            assert (parentNavPath != null);
            TableGroup parentTableGroup = parentFromClauseAccess.getTableGroup(parentNavPath);
            SqlAliasBase sqlAliasBase = this.sqlAliasBaseManager.createSqlAliasBase(parentTableGroup.getGroupAlias());
            CorrelatedTableGroup tableGroup = new CorrelatedTableGroup(parentTableGroup, sqlAliasBase, subQuerySpec, subQuerySpec::applyPredicate, this.creationContext.getSessionFactory());
            subQueryState.getSqlAstCreationState().getFromClauseAccess().registerTableGroup(parentNavPath, tableGroup);
            this.registerPluralTableGroupParts(tableGroup);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.visitPluralValuedPath((SqmPluralValuedSimplePath)sqmPluralPath).getExpressionType();
            tableGroup.addTableGroupJoin(pluralAttributeMapping.createTableGroupJoin(pluralPathNavPath, tableGroup, sqmPluralPath.getExplicitAlias(), null, SqlAstJoinType.INNER, false, false, this));
            ForeignKeyDescriptor collectionKeyDescriptor = pluralAttributeMapping.getKeyDescriptor();
            int jdbcTypeCount = collectionKeyDescriptor.getJdbcTypeCount();
            assert (jdbcTypeCount > 0);
            JdbcLiteral<Integer> jdbcLiteral = new JdbcLiteral<Integer>(1, this.basicType(Integer.class));
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(jdbcLiteral));
            ExistsPredicate existsPredicate = new ExistsPredicate(subQuerySpec, !predicate.isNegated(), this.getBooleanType());
            return existsPredicate;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BetweenPredicate visitBetweenPredicate(SqmBetweenPredicate predicate) {
        Expression upperBound;
        Expression lowerBound;
        Expression expression;
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getLowerBound(), fromClauseIndex), () -> this.determineValueMapping(predicate.getUpperBound(), fromClauseIndex)));
        try {
            expression = (Expression)predicate.getExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression(), fromClauseIndex), () -> this.determineValueMapping(predicate.getUpperBound(), fromClauseIndex)));
        try {
            lowerBound = (Expression)predicate.getLowerBound().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.inferrableTypeAccessStack.push(() -> NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression(), fromClauseIndex), () -> this.determineValueMapping(predicate.getLowerBound(), fromClauseIndex)));
        try {
            upperBound = (Expression)predicate.getUpperBound().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        return new BetweenPredicate(expression, lowerBound, upperBound, predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public LikePredicate visitLikePredicate(SqmLikePredicate predicate) {
        return new LikePredicate((Expression)this.visitWithInferredType(predicate.getMatchExpression(), predicate.getPattern()), (Expression)this.visitWithInferredType(predicate.getPattern(), predicate.getMatchExpression()), predicate.getEscapeCharacter() == null ? null : (Expression)this.visitWithInferredType(predicate.getEscapeCharacter(), () -> this.basicType(Character.class)), predicate.isNegated(), predicate.isCaseSensitive(), this.getBooleanType());
    }

    @Override
    public NullnessPredicate visitIsNullPredicate(SqmNullnessPredicate predicate) {
        Expression expression;
        SqmExpression<?> sqmExpression = predicate.getExpression();
        if (sqmExpression instanceof SqmEntityValuedSimplePath) {
            SqmEntityValuedSimplePath entityValuedPath = (SqmEntityValuedSimplePath)sqmExpression;
            this.inferrableTypeAccessStack.push(() -> this.basicType(Object.class));
            expression = this.withTreatRestriction(this.prepareReusablePath(entityValuedPath, this.fromClauseIndexStack.getCurrent(), () -> EntityValuedPathInterpretation.from(entityValuedPath, this.getInferredValueMapping(), this), true), entityValuedPath);
            this.inferrableTypeAccessStack.pop();
        } else {
            expression = (Expression)this.visitWithInferredType(predicate.getExpression(), () -> this.basicType(Object.class));
        }
        return new NullnessPredicate(expression, predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public Object visitIsTruePredicate(SqmTruthnessPredicate predicate) {
        return new ThruthnessPredicate((Expression)this.visitWithInferredType(predicate.getExpression(), () -> this.basicType(Boolean.class)), predicate.getBooleanValue(), predicate.isNegated(), this.getBooleanType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate visitInListPredicate(SqmInListPredicate<?> predicate) {
        Expression testExpression;
        InListPredicate specialCase;
        SqmParameter sqmParameter;
        SqmExpression<?> sqmExpression;
        if (predicate.getListExpressions().size() == 1 && (sqmExpression = predicate.getListExpressions().get(0)) instanceof SqmParameter && (sqmParameter = (SqmParameter)sqmExpression).allowMultiValuedBinding() && (specialCase = this.processInListWithSingleParameter(predicate, sqmParameter)) != null) {
            this.handleTypeComparison(specialCase);
            return specialCase;
        }
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        this.inferrableTypeAccessStack.push(() -> {
            for (SqmExpression listExpression : predicate.getListExpressions()) {
                MappingModelExpressible mapping = this.determineValueMapping(listExpression, fromClauseIndex);
                if (mapping == null) continue;
                return mapping;
            }
            return null;
        });
        try {
            testExpression = (Expression)predicate.getTestExpression().accept(this);
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        InListPredicate inPredicate = new InListPredicate(testExpression, predicate.isNegated(), this.getBooleanType());
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getTestExpression(), fromClauseIndex));
        try {
            for (SqmExpression<?> expression : predicate.getListExpressions()) {
                inPredicate.addExpression((Expression)expression.accept(this));
            }
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
        this.handleTypeComparison(inPredicate);
        return inPredicate;
    }

    private void handleTypeComparison(InListPredicate inPredicate) {
        Expression testExpression = inPredicate.getTestExpression();
        if (testExpression instanceof DiscriminatorPathInterpretation) {
            DiscriminatorPathInterpretation typeExpression = (DiscriminatorPathInterpretation)testExpression;
            boolean containsNonLiteral = false;
            for (Expression listExpression : inPredicate.getListExpressions()) {
                if (listExpression instanceof EntityTypeLiteral) continue;
                containsNonLiteral = true;
                break;
            }
            if (containsNonLiteral) {
                TableGroup tableGroup = this.getFromClauseIndex().getTableGroup(typeExpression.getNavigablePath().getParent());
                EntityMappingType entityMappingType = (EntityMappingType)tableGroup.getModelPart().getPartMappingType();
                this.registerEntityNameUsage(tableGroup, EntityNameUse.FILTER, entityMappingType.getEntityName());
                for (EntityMappingType subMappingType : entityMappingType.getSubMappingTypes()) {
                    this.registerEntityNameUsage(tableGroup, EntityNameUse.FILTER, subMappingType.getEntityName());
                }
            } else {
                this.handleTypeComparison(typeExpression, inPredicate.getListExpressions(), !inPredicate.isNegated());
            }
        }
    }

    private InListPredicate processInListWithSingleParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter<?> sqmParameter) {
        assert (sqmParameter.allowMultiValuedBinding());
        if (sqmParameter instanceof JpaCriteriaParameter) {
            return this.processInSingleCriteriaParameter(sqmPredicate, (JpaCriteriaParameter)sqmParameter);
        }
        return this.processInSingleHqlParameter(sqmPredicate, sqmParameter);
    }

    private InListPredicate processInSingleHqlParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter<?> sqmParameter) {
        QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        return this.processInSingleParameter(sqmPredicate, sqmParameter, domainParam, domainParamBinding);
    }

    private InListPredicate processInSingleCriteriaParameter(SqmInListPredicate<?> sqmPredicate, JpaCriteriaParameter<?> jpaCriteriaParameter) {
        assert (jpaCriteriaParameter.allowsMultiValuedBinding());
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(jpaCriteriaParameter);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        SqmJpaCriteriaParameterWrapper<?> sqmWrapper = this.jpaCriteriaParamResolutions.get(jpaCriteriaParameter);
        return this.processInSingleParameter(sqmPredicate, sqmWrapper, jpaCriteriaParameter, domainParamBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InListPredicate processInSingleParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter<?> sqmParameter, QueryParameterImplementor<?> domainParam, QueryParameterBinding<?> domainParamBinding) {
        Iterator<?> iterator = domainParamBinding.getBindValues().iterator();
        InListPredicate inListPredicate = new InListPredicate((Expression)sqmPredicate.getTestExpression().accept(this), sqmPredicate.isNegated(), this.getBooleanType());
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        if (!iterator.hasNext()) {
            domainParamBinding.setType(this.determineValueMapping(sqmPredicate.getTestExpression(), fromClauseIndex));
            return inListPredicate;
        }
        this.inferrableTypeAccessStack.push(() -> this.determineValueMapping(sqmPredicate.getTestExpression(), fromClauseIndex));
        try {
            inListPredicate.addExpression(this.consumeSingleSqmParameter(sqmParameter));
            iterator.next();
            while (iterator.hasNext()) {
                iterator.next();
                SqmParameter<?> sqmParamToConsume = sqmParameter.copy();
                this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                inListPredicate.addExpression(this.consumeSingleSqmParameter(sqmParamToConsume));
            }
            InListPredicate inListPredicate2 = inListPredicate;
            return inListPredicate2;
        }
        finally {
            this.inferrableTypeAccessStack.pop();
        }
    }

    @Override
    public InSubQueryPredicate visitInSubQueryPredicate(SqmInSubQueryPredicate<?> predicate) {
        return new InSubQueryPredicate((Expression)this.visitWithInferredType(predicate.getTestExpression(), predicate.getSubQueryExpression()), (SelectStatement)this.visitWithInferredType(predicate.getSubQueryExpression(), predicate.getTestExpression()), predicate.isNegated(), this.getBooleanType());
    }

    private JdbcMappingContainer getBooleanType() {
        return this.getTypeConfiguration().getBasicTypeForJavaType(Boolean.class);
    }

    @Override
    public Object visitBooleanExpressionPredicate(SqmBooleanExpressionPredicate predicate) {
        this.inferrableTypeAccessStack.push(this::getBooleanType);
        Expression booleanExpression = (Expression)predicate.getBooleanExpression().accept(this);
        this.inferrableTypeAccessStack.pop();
        if (booleanExpression instanceof SelfRenderingExpression) {
            SelfRenderingPredicate sqlPredicate = new SelfRenderingPredicate((SelfRenderingExpression)booleanExpression);
            if (predicate.isNegated()) {
                return new NegatedPredicate(sqlPredicate);
            }
            return sqlPredicate;
        }
        JdbcMapping jdbcMapping = booleanExpression.getExpressionType().getJdbcMapping(0);
        if (jdbcMapping.getValueConverter() != null) {
            return new ComparisonPredicate(booleanExpression, ComparisonOperator.EQUAL, new JdbcLiteral<Object>(jdbcMapping.convertToRelationalValue(!predicate.isNegated()), jdbcMapping));
        }
        return new BooleanExpressionPredicate(booleanExpression, predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public Object visitExistsPredicate(SqmExistsPredicate predicate) {
        this.inferrableTypeAccessStack.push(() -> null);
        SelectStatement selectStatement = (SelectStatement)predicate.getExpression().accept(this);
        this.inferrableTypeAccessStack.pop();
        return new ExistsPredicate(selectStatement, predicate.isNegated(), this.getBooleanType());
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public Object visitFullyQualifiedClass(Class<?> namedClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Fetch visitIdentifierFetch(EntityResultGraphNode fetchParent) {
        EntityIdentifierMapping identifierMapping = fetchParent.getReferencedMappingContainer().getIdentifierMapping();
        return this.createFetch(fetchParent, (Fetchable)((Object)identifierMapping), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fetch createFetch(FetchParent fetchParent, Fetchable fetchable, Boolean isKeyFetchable) {
        String alias;
        NavigablePath fetchablePath;
        TableGroup joinedTableGroup;
        EntityGraphTraversalState.TraversalResult traversalResult;
        boolean explicitFetch;
        boolean joined;
        FetchTiming fetchTiming;
        int sqlSelectionStartIndexForFetch;
        Map.Entry<Integer, List<SqlSelection>> sqlSelectionsToTrack;
        block26: {
            FromClauseIndex fromClauseIndex;
            Integer maxDepth;
            block27: {
                block28: {
                    NavigablePath resolvedNavigablePath;
                    block25: {
                        if (!fetchable.isSelectable()) {
                            return null;
                        }
                        resolvedNavigablePath = fetchParent.resolveNavigablePath(fetchable);
                        sqlSelectionsToTrack = this.trackedFetchSelectionsForGroup.get(resolvedNavigablePath);
                        if (sqlSelectionsToTrack != null) {
                            List<SqlSelection> selections = this.currentSqlSelectionCollector().getSelections(sqlSelectionsToTrack.getKey());
                            sqlSelectionStartIndexForFetch = selections.size();
                        } else {
                            sqlSelectionStartIndexForFetch = -1;
                        }
                        fetchTiming = fetchable.getMappedFetchOptions().getTiming();
                        joined = false;
                        maxDepth = this.getCreationContext().getMaximumFetchDepth();
                        fromClauseIndex = this.getFromClauseIndex();
                        SqmAttributeJoin fetchedJoin = fromClauseIndex.findFetchedJoinByPath(resolvedNavigablePath);
                        explicitFetch = false;
                        traversalResult = null;
                        joinedTableGroup = null;
                        if (fetchedJoin == null) break block25;
                        fetchablePath = fetchedJoin.getNavigablePath();
                        assert (fromClauseIndex.getTableGroup(fetchedJoin.getNavigablePath()) != null);
                        if (fetchedJoin.isFetched()) {
                            fetchTiming = FetchTiming.IMMEDIATE;
                        }
                        joined = true;
                        alias = fetchedJoin.getExplicitAlias();
                        explicitFetch = true;
                        break block26;
                    }
                    fetchablePath = resolvedNavigablePath;
                    alias = null;
                    if (fetchable instanceof CollectionPart) break block27;
                    if (this.entityGraphTraversalState == null) break block28;
                    traversalResult = this.entityGraphTraversalState.traverse(fetchParent, fetchable, isKeyFetchable);
                    EntityGraphTraversalState.FetchStrategy fetchStrategy = traversalResult.getFetchStrategy();
                    if (fetchStrategy == null) break block27;
                    fetchTiming = fetchStrategy.getFetchTiming();
                    joined = fetchStrategy.isJoined();
                    if (!this.shouldExplicitFetch(maxDepth, fetchable)) break block27;
                    explicitFetch = true;
                    break block27;
                }
                if (this.getLoadQueryInfluencers().hasEnabledFetchProfiles()) {
                    String fetchableRole = fetchable.getNavigableRole().getFullPath();
                    for (String fetch2 : this.getLoadQueryInfluencers().getEnabledFetchProfileNames()) {
                        CollectionClassification collectionClassification;
                        FetchProfile enabledFetchProfile = this.getCreationContext().getSessionFactory().getFetchProfile(fetch2);
                        org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                        if (profileFetch == null) continue;
                        fetchTiming = profileFetch.getTiming();
                        boolean bl = joined = joined || profileFetch.getMethod() == FetchStyle.JOIN;
                        if (this.shouldExplicitFetch(maxDepth, fetchable)) {
                            explicitFetch = true;
                        }
                        if (this.currentBagRole == null || !(fetchable instanceof PluralAttributeMapping) || (collectionClassification = ((PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics().getCollectionClassification()) != CollectionClassification.BAG) continue;
                        joined = false;
                    }
                }
            }
            if (maxDepth != null && this.fetchDepth >= maxDepth) {
                joined = false;
            }
            if (joined && fetchable instanceof TableGroupJoinProducer) {
                joinedTableGroup = fromClauseIndex.resolveTableGroup(fetchablePath, np -> {
                    TableGroup lhs = fromClauseIndex.getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)fetchable)).createTableGroupJoin(fetchablePath, lhs, alias, null, null, true, false, this);
                    lhs.addTableGroupJoin(tableGroupJoin);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
        }
        boolean incrementFetchDepth = fetchable.incrementFetchDepth();
        try {
            Fetch biDirectionalFetch;
            if (incrementFetchDepth) {
                ++this.fetchDepth;
            }
            if (!explicitFetch && !this.isResolvingCircularFetch() && (biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath, fetchParent, fetchTiming, this)) != null) {
                Fetch fetch = biDirectionalFetch;
                return fetch;
            }
            Fetch fetch = this.buildFetch(fetchablePath, fetchParent, fetchable, fetchTiming, joined, alias);
            if (sqlSelectionsToTrack != null) {
                List<SqlSelection> list = this.currentSqlSelectionCollector().getSelections(sqlSelectionsToTrack.getKey());
                sqlSelectionsToTrack.getValue().addAll(list.subList(sqlSelectionStartIndexForFetch, list.size()));
            }
            if (fetch != null && fetch.getTiming() == FetchTiming.IMMEDIATE && fetchable instanceof TableGroupJoinProducer) {
                PluralAttributeMapping pluralAttributeMapping;
                CollectionClassification collectionClassification;
                if (joinedTableGroup != null) {
                    MappingType mappingType;
                    TableGroup tableGroup = joinedTableGroup instanceof PluralTableGroup ? ((PluralTableGroup)joinedTableGroup).getElementTableGroup() : joinedTableGroup;
                    MappingType mappingType2 = mappingType = tableGroup == null ? null : tableGroup.getModelPart().getPartMappingType();
                    if (mappingType instanceof EntityMappingType) {
                        EntityMappingType entityMappingType = (EntityMappingType)mappingType;
                        this.registerEntityNameUsage(tableGroup, EntityNameUse.PROJECTION, entityMappingType.getEntityName(), true);
                        if (entityMappingType.getSuperMappingType() != null) {
                            entityMappingType.applyDiscriminator(null, null, tableGroup, this);
                        }
                    }
                }
                if (fetchable instanceof PluralAttributeMapping && (collectionClassification = (pluralAttributeMapping = (PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics().getCollectionClassification()) == CollectionClassification.BAG) {
                    if (this.currentBagRole != null) {
                        throw new MultipleBagFetchException(Arrays.asList(this.currentBagRole, fetchable.getNavigableRole().getNavigableName()));
                    }
                    this.currentBagRole = fetchable.getNavigableRole().getNavigableName();
                }
            }
            Fetch fetch2 = fetch;
            return fetch2;
        }
        finally {
            if (incrementFetchDepth) {
                --this.fetchDepth;
            }
            if (this.entityGraphTraversalState != null && traversalResult != null) {
                this.entityGraphTraversalState.backtrack(traversalResult);
            }
        }
    }

    @Override
    public ImmutableFetchList visitNestedFetches(FetchParent fetchParent) {
        SqlAstQueryPartProcessingStateImpl processingState = (SqlAstQueryPartProcessingStateImpl)this.getCurrentProcessingState();
        FetchParent nestingFetchParent = processingState.getNestingFetchParent();
        processingState.setNestingFetchParent(fetchParent);
        ImmutableFetchList fetches = this.visitFetches(fetchParent);
        processingState.setNestingFetchParent(nestingFetchParent);
        return fetches;
    }

    @Override
    public ImmutableFetchList visitFetches(FetchParent fetchParent) {
        Fetch fetch;
        int i;
        if (fetchParent instanceof EagerCollectionFetch) {
            EagerCollectionFetch collectionFetch = (EagerCollectionFetch)fetchParent;
            PluralAttributeMapping pluralAttributeMapping = collectionFetch.getFetchedMapping();
            NavigablePath fetchablePath = collectionFetch.getNavigablePath();
            TableGroup tableGroup = this.getFromClauseIndex().getTableGroup(fetchablePath);
            if (this.getFromClauseIndex().findFetchedJoinByPath(fetchablePath) == null) {
                Joinable restrictable = pluralAttributeMapping.getCollectionDescriptor().getCollectionType().getAssociatedJoinable(this.getCreationContext().getSessionFactory());
                restrictable.applyBaseRestrictions(predicate -> this.addCollectionFilterPredicate(tableGroup.getNavigablePath(), (Predicate)predicate), tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            }
            pluralAttributeMapping.applyBaseManyToManyRestrictions(predicate -> {
                TableGroup parentTableGroup = this.getFromClauseIndex().getTableGroup(collectionFetch.getFetchParent().getNavigablePath());
                TableGroupJoin pluralTableGroupJoin = parentTableGroup.findTableGroupJoin(tableGroup);
                assert (pluralTableGroupJoin != null);
                TableGroupJoin joinForPredicate = !tableGroup.getNestedTableGroupJoins().isEmpty() || tableGroup.getTableGroupJoins().isEmpty() ? pluralTableGroupJoin : tableGroup.getTableGroupJoins().get(tableGroup.getTableGroupJoins().size() - 1);
                joinForPredicate.applyPredicate((Predicate)predicate);
            }, tableGroup, true, this.getLoadQueryInfluencers().getEnabledFilters(), null, this);
            if (this.currentQuerySpec().isRoot()) {
                assert (tableGroup.getModelPart() == pluralAttributeMapping);
                this.applyOrdering(tableGroup, pluralAttributeMapping);
            }
        }
        FetchableContainer referencedMappingContainer = fetchParent.getReferencedMappingContainer();
        int keySize = referencedMappingContainer.getNumberOfKeyFetchables();
        int size = referencedMappingContainer.getNumberOfFetchables();
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(referencedMappingContainer);
        for (i = 0; i < keySize; ++i) {
            fetch = this.createFetch(fetchParent, referencedMappingContainer.getKeyFetchable(i), true);
            if (fetch == null) continue;
            fetches.add(fetch);
        }
        for (i = 0; i < size; ++i) {
            fetch = this.createFetch(fetchParent, referencedMappingContainer.getFetchable(i), false);
            if (fetch == null) continue;
            fetches.add(fetch);
        }
        return fetches.build();
    }

    private boolean shouldExplicitFetch(Integer maxDepth, Fetchable fetchable) {
        if (maxDepth == null) {
            if (fetchable instanceof ToOneAttributeMapping) {
                return !this.isAssociationKeyVisited(((ToOneAttributeMapping)fetchable).getForeignKeyDescriptor().getAssociationKey());
            }
            if (fetchable instanceof PluralAttributeMapping) {
                return !this.isAssociationKeyVisited(((PluralAttributeMapping)fetchable).getKeyDescriptor().getAssociationKey());
            }
        }
        return true;
    }

    private Fetch buildFetch(NavigablePath fetchablePath, FetchParent fetchParent, Fetchable fetchable, FetchTiming fetchTiming, boolean joined, String alias) {
        try {
            return fetchParent.generateFetchableFetch(fetchable, fetchablePath, fetchTiming, joined, alias, this);
        }
        catch (RuntimeException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not generate fetch : %s -> %s", fetchParent.getNavigablePath(), fetchable.getFetchableName()), e);
        }
    }

    private void addCollectionFilterPredicate(NavigablePath navigablePath, Predicate predicate) {
        PredicateCollector existing = this.collectionFilterPredicates.get(navigablePath);
        if (existing != null) {
            existing.applyPredicate(predicate);
        } else {
            this.collectionFilterPredicates.put(navigablePath, new PredicateCollector(predicate));
        }
    }

    private void applyOrdering(TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping) {
        if (pluralAttributeMapping.getOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getOrderByFragment());
        }
        if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getManyToManyOrderByFragment());
        }
    }

    private void applyOrdering(TableGroup tableGroup, OrderByFragment orderByFragment) {
        if (this.orderByFragments == null) {
            this.orderByFragments = new ArrayList<Map.Entry<OrderByFragment, TableGroup>>();
        }
        this.orderByFragments.add(new AbstractMap.SimpleEntry<OrderByFragment, TableGroup>(orderByFragment, tableGroup));
    }

    @Override
    public boolean isResolvingCircularFetch() {
        return this.resolvingCircularFetch;
    }

    @Override
    public void setResolvingCircularFetch(boolean resolvingCircularFetch) {
        this.resolvingCircularFetch = resolvingCircularFetch;
    }

    @Override
    public ForeignKeyDescriptor.Nature getCurrentlyResolvingForeignKeyPart() {
        return this.currentlyResolvingForeignKeySide;
    }

    @Override
    public void setCurrentlyResolvingForeignKeyPart(ForeignKeyDescriptor.Nature currentlyResolvingForeignKeySide) {
        this.currentlyResolvingForeignKeySide = currentlyResolvingForeignKeySide;
    }

    @Override
    public List<Expression> expandSelfRenderingFunctionMultiValueParameter(SqmParameter<?> sqmParameter) {
        assert (sqmParameter.allowMultiValuedBinding());
        QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
        Collection<?> bindValues = domainParamBinding.getBindValues();
        int bindValuesSize = bindValues.size();
        ArrayList<Expression> result = new ArrayList<Expression>(bindValuesSize);
        boolean first = true;
        for (int i = 0; i < bindValuesSize; ++i) {
            SqmParameter<?> sqmParamToConsume;
            if (first) {
                sqmParamToConsume = sqmParameter;
                first = false;
            } else {
                sqmParamToConsume = sqmParameter.copy();
                this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
            }
            Expression expression = this.consumeSingleSqmParameter(sqmParamToConsume);
            result.add(expression);
        }
        return result;
    }

    private static JdbcMappingContainer highestPrecedence(JdbcMappingContainer type1, JdbcMappingContainer type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1 instanceof ModelPart) {
            return type1;
        }
        if (type2 instanceof ModelPart) {
            return type2;
        }
        return type1;
    }

    @Override
    public boolean registerVisitedAssociationKey(AssociationKey associationKey) {
        return this.visitedAssociationKeys.add(associationKey);
    }

    @Override
    public void removeVisitedAssociationKey(AssociationKey associationKey) {
        this.visitedAssociationKeys.remove(associationKey);
    }

    @Override
    public boolean isAssociationKeyVisited(AssociationKey associationKey) {
        return this.visitedAssociationKeys.contains(associationKey);
    }

    @Override
    public boolean isRegisteringVisitedAssociationKeys() {
        return this.creationContext.getMaximumFetchDepth() == null && (this.entityGraphTraversalState != null || this.getLoadQueryInfluencers().hasEnabledFetchProfiles());
    }

    private static /* synthetic */ Object lambda$visitSearchedCaseExpression$103(MappingModelExpressible alreadyKnown, Supplier inferenceSupplier) {
        return alreadyKnown == null && inferenceSupplier != null ? inferenceSupplier.get() : alreadyKnown;
    }

    private static /* synthetic */ Object lambda$visitSearchedCaseExpression$102(MappingModelExpressible alreadyKnown, Supplier inferenceSupplier) {
        return alreadyKnown == null && inferenceSupplier != null ? inferenceSupplier.get() : alreadyKnown;
    }

    private static /* synthetic */ Object lambda$visitSimpleCaseExpression$101(MappingModelExpressible alreadyKnown, Supplier inferenceSupplier) {
        return alreadyKnown == null && inferenceSupplier != null ? inferenceSupplier.get() : alreadyKnown;
    }

    private static /* synthetic */ Object lambda$visitSimpleCaseExpression$100(MappingModelExpressible alreadyKnown, Supplier inferenceSupplier) {
        return alreadyKnown == null && inferenceSupplier != null ? inferenceSupplier.get() : alreadyKnown;
    }

    private /* synthetic */ Object lambda$transformDurationArithmetic$92(SqmExpression lhs, FromClauseIndex fromClauseIndex) {
        return this.determineValueMapping(lhs, fromClauseIndex);
    }

    private /* synthetic */ Object lambda$transformDurationArithmetic$91(SqmExpression rhs, FromClauseIndex fromClauseIndex) {
        return this.determineValueMapping(rhs, fromClauseIndex);
    }

    private /* synthetic */ Object lambda$transformDurationArithmetic$90(SqmExpression lhs, FromClauseIndex fromClauseIndex) {
        return this.determineValueMapping(lhs, fromClauseIndex);
    }

    private /* synthetic */ Object lambda$transformDurationArithmetic$89(SqmExpression rhs, FromClauseIndex fromClauseIndex) {
        return this.determineValueMapping(rhs, fromClauseIndex);
    }

    private static class CteContainerImpl
    implements CteContainer {
        private final CteContainer parent;
        private final Map<String, CteStatement> cteStatements;
        private final Map<String, CteObject> cteObjects;

        public CteContainerImpl(CteContainer parent) {
            this.parent = parent;
            this.cteStatements = new LinkedHashMap<String, CteStatement>();
            this.cteObjects = new LinkedHashMap<String, CteObject>();
        }

        @Override
        public Map<String, CteStatement> getCteStatements() {
            return this.cteStatements;
        }

        @Override
        public CteStatement getCteStatement(String cteLabel) {
            CteStatement cteStatement = this.cteStatements.get(cteLabel);
            if (cteStatement == null && this.parent != null) {
                return this.parent.getCteStatement(cteLabel);
            }
            return cteStatement;
        }

        @Override
        public void addCteStatement(CteStatement cteStatement) {
            if (this.cteStatements.putIfAbsent(cteStatement.getCteTable().getTableExpression(), cteStatement) != null) {
                throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getTableExpression() + " already exists");
            }
        }

        @Override
        public Map<String, CteObject> getCteObjects() {
            return this.cteObjects;
        }

        @Override
        public CteObject getCteObject(String cteObjectName) {
            CteObject cteObject = this.cteObjects.get(cteObjectName);
            if (cteObject == null && this.parent != null) {
                return this.parent.getCteObject(cteObjectName);
            }
            return cteObject;
        }

        @Override
        public void addCteObject(CteObject cteObject) {
            if (this.cteObjects.putIfAbsent(cteObject.getName(), cteObject) != null) {
                throw new IllegalArgumentException("A CTE object with the name " + cteObject.getName() + " already exists");
            }
        }
    }

    protected static class SqmAliasedNodePositionTracker
    implements SqlExpressionResolver,
    SqmAliasedNodeCollector {
        private final SqlExpressionResolver delegate;
        private final List<SqlSelection>[] sqlSelectionsForSqmSelection;
        private int index = -1;

        public SqmAliasedNodePositionTracker(SqlExpressionResolver delegate, List<? extends SqmAliasedNode<?>> selections) {
            this.delegate = delegate;
            this.sqlSelectionsForSqmSelection = new List[SqmAliasedNodePositionTracker.countIndividualSelections(selections)];
        }

        private static int countIndividualSelections(List<? extends SqmAliasedNode<?>> selections) {
            int offset = 0;
            for (int i = 0; i < selections.size(); ++i) {
                SqmSelectableNode<?> selectableNode = selections.get(i).getSelectableNode();
                if (selectableNode instanceof SqmDynamicInstantiation) {
                    offset = SqmAliasedNodePositionTracker.countIndividualSelections(((SqmDynamicInstantiation)selectableNode).getArguments()) - 1;
                    continue;
                }
                if (!(selectableNode instanceof SqmJpaCompoundSelection)) continue;
                for (SqmSelectableNode<?> node : ((SqmJpaCompoundSelection)selectableNode).getSelectionItems()) {
                    if (node instanceof SqmDynamicInstantiation) {
                        offset += SqmAliasedNodePositionTracker.countIndividualSelections(((SqmDynamicInstantiation)node).getArguments());
                        continue;
                    }
                    ++offset;
                }
                --offset;
            }
            return offset + selections.size();
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqlSelectionsForSqmSelection[position];
        }

        @Override
        public Expression resolveSqlExpression(SqlExpressionResolver.ColumnReferenceKey key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaType, FetchParent fetchParent, TypeConfiguration typeConfiguration) {
            SqlSelection selection = this.delegate.resolveSqlSelection(expression, javaType, fetchParent, typeConfiguration);
            List<SqlSelection> sqlSelectionList = this.sqlSelectionsForSqmSelection[this.index];
            if (sqlSelectionList == null) {
                this.sqlSelectionsForSqmSelection[this.index] = sqlSelectionList = new ArrayList<SqlSelection>();
            }
            sqlSelectionList.add(selection);
            return selection;
        }
    }

    protected static class DelegatingSqmAliasedNodeCollector
    implements SqlExpressionResolver,
    SqmAliasedNodeCollector {
        private final SqlExpressionResolver delegate;
        private SqmAliasedNodeCollector sqmAliasedNodeCollector;

        public DelegatingSqmAliasedNodeCollector(SqlExpressionResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        public void next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqmAliasedNodeCollector.getSelections(position);
        }

        @Override
        public Expression resolveSqlExpression(SqlExpressionResolver.ColumnReferenceKey key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaType, FetchParent fetchParent, TypeConfiguration typeConfiguration) {
            return this.delegate.resolveSqlSelection(expression, javaType, fetchParent, typeConfiguration);
        }

        public void setSqmAliasedNodeCollector(SqmAliasedNodeCollector sqmAliasedNodeCollector) {
            this.sqmAliasedNodeCollector = sqmAliasedNodeCollector;
        }
    }

    @Internal
    public static interface SqmAliasedNodeCollector {
        public void next();

        public List<SqlSelection> getSelections(int var1);
    }

    private static class IdGeneratorParameter
    extends AbstractJdbcParameter {
        private final BeforeExecutionGenerator generator;

        public IdGeneratorParameter(BasicEntityIdentifierMapping identifierMapping, BeforeExecutionGenerator generator) {
            super(identifierMapping.getJdbcMapping());
            this.generator = generator;
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
            this.getJdbcMapping().getJdbcValueBinder().bind(statement, this.generator.generate(executionContext.getSession(), null, null, EventType.INSERT), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    public static class AdditionalInsertValues {
        private final Expression versionExpression;
        private final Expression discriminatorExpression;
        private final Generator identifierGenerator;
        private final BasicEntityIdentifierMapping identifierMapping;
        private Expression identifierGeneratorParameter;
        private SqlSelection versionSelection;
        private SqlSelection discriminatorSelection;
        private SqlSelection identifierSelection;

        public AdditionalInsertValues(Expression versionExpression, Expression discriminatorExpression, Generator identifierGenerator, BasicEntityIdentifierMapping identifierMapping) {
            this.versionExpression = versionExpression;
            this.discriminatorExpression = discriminatorExpression;
            this.identifierGenerator = identifierGenerator;
            this.identifierMapping = identifierMapping;
        }

        public void applyValues(Values values) {
            List<Expression> expressions = values.getExpressions();
            if (this.versionExpression != null) {
                expressions.add(this.versionExpression);
            }
            if (this.discriminatorExpression != null) {
                expressions.add(this.discriminatorExpression);
            }
            if (this.identifierGenerator != null && !this.identifierGenerator.generatedOnExecution()) {
                if (this.identifierGeneratorParameter == null) {
                    this.identifierGeneratorParameter = new IdGeneratorParameter(this.identifierMapping, (BeforeExecutionGenerator)this.identifierGenerator);
                }
                expressions.add(this.identifierGeneratorParameter);
            }
        }

        public boolean applySelections(QuerySpec querySpec, SessionFactoryImplementor sessionFactory) {
            SelectClause selectClause = querySpec.getSelectClause();
            if (this.versionExpression != null) {
                if (this.versionSelection == null) {
                    this.versionSelection = new SqlSelectionImpl(this.versionExpression);
                }
                selectClause.addSqlSelection(this.versionSelection);
            }
            if (this.discriminatorExpression != null) {
                if (this.discriminatorSelection == null) {
                    this.discriminatorSelection = new SqlSelectionImpl(this.discriminatorExpression);
                }
                selectClause.addSqlSelection(this.discriminatorSelection);
            }
            if (this.identifierGenerator != null) {
                if (this.identifierSelection == null) {
                    Optimizer optimizer;
                    if (!(this.identifierGenerator instanceof BulkInsertionCapableIdentifierGenerator)) {
                        throw new SemanticException("SQM INSERT-SELECT without bulk insertion capable identifier generator: " + this.identifierGenerator);
                    }
                    if (this.identifierGenerator instanceof OptimizableGenerator && ((optimizer = ((OptimizableGenerator)this.identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1 || !((BulkInsertionCapableIdentifierGenerator)this.identifierGenerator).supportsBulkInsertionIdentifierGeneration())) {
                        if (!sessionFactory.getJdbcServices().getDialect().supportsWindowFunctions()) {
                            return false;
                        }
                        this.identifierSelection = new SqlSelectionImpl(SqmInsertStrategyHelper.createRowNumberingExpression(querySpec, sessionFactory));
                        selectClause.addSqlSelection(this.identifierSelection);
                        return true;
                    }
                    String fragment = ((BulkInsertionCapableIdentifierGenerator)this.identifierGenerator).determineBulkInsertionIdentifierGenerationSelectFragment(sessionFactory.getSqlStringGenerationContext());
                    this.identifierSelection = new SqlSelectionImpl(new SelfRenderingSqlFragmentExpression(fragment));
                }
                selectClause.addSqlSelection(this.identifierSelection);
            }
            return this.requiresRowNumberIntermediate();
        }

        public boolean requiresRowNumberIntermediate() {
            return this.identifierSelection != null && !(this.identifierSelection.getExpression() instanceof SelfRenderingSqlFragmentExpression);
        }
    }
}

