/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Token;

public class KerberosToken
extends Token {
    private boolean requiresKerberosV5Token;
    private boolean requiresGssKerberosV5Token;
    private boolean requiresKeyIdentifierReference;
    private String tokenVersionAndType = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";

    public String getTokenVersionAndType() {
        return this.tokenVersionAndType;
    }

    public void setTokenVersionAndType(String tokenVersionAndType) {
        this.tokenVersionAndType = tokenVersionAndType;
    }

    public boolean isRequiresKerberosV5Token() {
        return this.requiresKerberosV5Token;
    }

    public void setRequiresKerberosV5Token(boolean requiresKerberosV5Token) {
        this.requiresKerberosV5Token = requiresKerberosV5Token;
    }

    public boolean isRequiresGssKerberosV5Token() {
        return this.requiresGssKerberosV5Token;
    }

    public void setRequiresGssKerberosV5Token(boolean requiresGssKerberosV5Token) {
        this.requiresGssKerberosV5Token = requiresGssKerberosV5Token;
    }

    public boolean isRequiresKeyIdentifierReference() {
        return this.requiresKeyIdentifierReference;
    }

    public void setRequiresKeyIdentifierReference(boolean requiresKeyIdentifierReference) {
        this.requiresKeyIdentifierReference = requiresKeyIdentifierReference;
    }

    public KerberosToken(int version) {
        this.setVersion(version);
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.KERBEROS_TOKEN;
        }
        return SP11Constants.KERBEROS_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String pPrefix;
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        String inclusion = this.version == 2 ? SP12Constants.getAttributeValueFromInclusion(this.getInclusion()) : SP11Constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if ((pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI())) == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.isRequiresKerberosV5Token()) {
            writer.writeStartElement(prefix, "WssKerberosV5ApReqToken11", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequiresGssKerberosV5Token()) {
            writer.writeStartElement(prefix, "WssGssKerberosV5ApReqToken11", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequiresKeyIdentifierReference()) {
            writer.writeStartElement(prefix, "RequireKeyIdentifierReference", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

