/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.AlgorithmWrapper;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class SupportingToken
extends AbstractSecurityAssertion
implements AlgorithmWrapper,
TokenWrapper {
    private int type;
    private AlgorithmSuite algorithmSuite;
    private ArrayList<Token> tokens = new ArrayList();
    private SignedEncryptedElements signedElements;
    private SignedEncryptedElements encryptedElements;
    private SignedEncryptedParts signedParts;
    private SignedEncryptedParts encryptedParts;
    private boolean signedElementsOptional;
    private boolean encryptedElementsOptional;
    private boolean signedPartsOptional;
    private boolean encryptedPartsOptional;

    public SupportingToken(int type, int version) {
        this.type = type;
        this.setVersion(version);
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    @Override
    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public ArrayList<Token> getTokens() {
        return this.tokens;
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public int getTokenType() {
        return this.type;
    }

    public void setTokenType(int type) {
        this.type = type;
    }

    public SignedEncryptedElements getEncryptedElements() {
        return this.encryptedElements;
    }

    public void setEncryptedElements(SignedEncryptedElements encryptedElements) {
        this.encryptedElements = encryptedElements;
    }

    public SignedEncryptedParts getEncryptedParts() {
        return this.encryptedParts;
    }

    public void setEncryptedParts(SignedEncryptedParts encryptedParts) {
        this.encryptedParts = encryptedParts;
    }

    public SignedEncryptedElements getSignedElements() {
        return this.signedElements;
    }

    public void setSignedElements(SignedEncryptedElements signedElements) {
        this.signedElements = signedElements;
    }

    public SignedEncryptedParts getSignedParts() {
        return this.signedParts;
    }

    public void setSignedParts(SignedEncryptedParts signedParts) {
        this.signedParts = signedParts;
    }

    @Override
    public void setToken(Token tok) {
        this.addToken(tok);
    }

    public boolean isSignedElementsOptional() {
        return this.signedElementsOptional;
    }

    public void setSignedElementsOptional(boolean signedElementsOptional) {
        this.signedElementsOptional = signedElementsOptional;
    }

    public boolean isEncryptedElementsOptional() {
        return this.encryptedElementsOptional;
    }

    public void setEncryptedElementsOptional(boolean encryptedElementsOptional) {
        this.encryptedElementsOptional = encryptedElementsOptional;
    }

    public boolean isSignedPartsOptional() {
        return this.signedPartsOptional;
    }

    public void setSignedPartsOptional(boolean signedPartsOptional) {
        this.signedPartsOptional = signedPartsOptional;
    }

    public boolean isEncryptedPartsOptional() {
        return this.encryptedPartsOptional;
    }

    public void setEncryptedPartsOptional(boolean encryptedPartsOptional) {
        this.encryptedPartsOptional = encryptedPartsOptional;
    }

    public QName getName() {
        switch (this.type) {
            case 1: {
                return this.version == 2 ? SP12Constants.SUPPORTING_TOKENS : SP11Constants.SUPPORTING_TOKENS;
            }
            case 3: {
                return this.version == 2 ? SP12Constants.SIGNED_SUPPORTING_TOKENS : SP11Constants.SIGNED_SUPPORTING_TOKENS;
            }
            case 2: {
                return this.version == 2 ? SP12Constants.ENDORSING_SUPPORTING_TOKENS : SP11Constants.ENDORSING_SUPPORTING_TOKENS;
            }
            case 4: {
                return this.version == 2 ? SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS : SP11Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS;
            }
            case 6: {
                return SP12Constants.ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 5: {
                return SP12Constants.SIGNED_ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 7: {
                return SP12Constants.ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
            }
            case 8: {
                return SP12Constants.SIGNED_ENDORSING_ENCRYPTED_SUPPORTING_TOKENS;
            }
        }
        return null;
    }

    public boolean isEncryptedToken() {
        switch (this.type) {
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return false;
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    @Override
    public short getType() {
        return 5;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        SupportingToken.writeStartElement(writer, this.getName());
        SupportingToken.writeStartElement(writer, SPConstants.POLICY);
        for (Token token : this.getTokens()) {
            token.serialize(writer);
        }
        if (this.signedParts != null) {
            this.signedParts.serialize(writer);
        }
        if (this.signedElements != null) {
            this.signedElements.serialize(writer);
        }
        if (this.encryptedParts != null) {
            this.encryptedParts.serialize(writer);
        }
        if (this.encryptedElements != null) {
            this.encryptedElements.serialize(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

