/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.rahas.TokenCanceler;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TokenRenewer;
import org.apache.rahas.TokenValidator;
import org.apache.rahas.TrustException;
import org.apache.wss4j.common.util.Loader;

public class TokenRequestDispatcherConfig {
    public static final String CONFIG_PARAM_KEY = "token-dispatcher-configuration";
    public static final String CONFIG_FILE_KEY = "token-dispatcher-configuration-file";
    private static final QName DISPATCHER_CONFIG = new QName("token-dispatcher-configuration");
    private static final QName ISSUER = new QName("issuer");
    private static final QName CANCELER = new QName("canceler");
    private static final QName VALIDATOR = new QName("validator");
    private static final QName RENEWER = new QName("renewer");
    private static final QName TOKEN_TYPE = new QName("tokenType");
    private static final QName CLASS_ATTR = new QName("class");
    private static final QName DEFAULT_ATTR = new QName("default");
    private static final QName CONFIGURATION_ELEMENT = new QName("configuration");
    private Map issuers;
    private Map validators;
    private Map renewers;
    private Map configFiles = new Hashtable();
    private Map configElements = new Hashtable();
    private Map configParamNames = new Hashtable();
    private String defaultIssuerClassName;
    private String defaultCancelerClassName;
    private String defaultValidatorClassName;
    private String defaultRenewerClassName;

    public static TokenRequestDispatcherConfig load(OMElement configElem) throws TrustException {
        if (!DISPATCHER_CONFIG.equals(configElem.getQName())) {
            throw new TrustException("incorrectConfiguration");
        }
        TokenRequestDispatcherConfig conf = new TokenRequestDispatcherConfig();
        TokenRequestDispatcherConfig.handleIssuers(configElem, conf);
        TokenRequestDispatcherConfig.handleValidators(configElem, conf);
        TokenRequestDispatcherConfig.handleRenewers(configElem, conf);
        TokenRequestDispatcherConfig.handleCancelers(configElem, conf);
        if (conf.defaultIssuerClassName == null) {
            throw new TrustException("defaultIssuerMissing");
        }
        return conf;
    }

    private static void handleCancelers(OMElement configElem, TokenRequestDispatcherConfig conf) throws TrustException {
        OMElement cancelerEle = configElem.getFirstChildWithName(CANCELER);
        if (cancelerEle != null) {
            String cancelerClass = cancelerEle.getAttributeValue(CLASS_ATTR);
            if (cancelerClass == null) {
                throw new TrustException("missingClassName");
            }
            conf.defaultCancelerClassName = cancelerClass;
            TokenRequestDispatcherConfig.processConfiguration(cancelerEle, conf, cancelerClass);
        }
    }

    private static void handleIssuers(OMElement configElem, TokenRequestDispatcherConfig conf) throws TrustException {
        Iterator issuerElems = configElem.getChildrenWithName(ISSUER);
        while (issuerElems.hasNext()) {
            OMElement element = (OMElement)issuerElems.next();
            String issuerClass = element.getAttributeValue(CLASS_ATTR);
            if (issuerClass == null) {
                throw new TrustException("missingClassName");
            }
            String isDefault = element.getAttributeValue(DEFAULT_ATTR);
            if (isDefault != null && "true".equalsIgnoreCase(isDefault)) {
                if (conf.defaultIssuerClassName == null) {
                    conf.defaultIssuerClassName = issuerClass;
                } else {
                    throw new TrustException("badDispatcherConfigMultipleDefaultIssuers");
                }
            }
            TokenRequestDispatcherConfig.processConfiguration(element, conf, issuerClass);
            Iterator tokenTypes = element.getChildrenWithName(TOKEN_TYPE);
            while (tokenTypes.hasNext()) {
                OMElement type = (OMElement)tokenTypes.next();
                String value = type.getText();
                if (value == null || value.trim().length() == 0) {
                    throw new TrustException("invalidTokenTypeDefinition", new String[]{"Issuer", issuerClass});
                }
                if (conf.issuers == null) {
                    conf.issuers = new Hashtable();
                }
                if (conf.issuers.keySet().contains(value)) continue;
                conf.issuers.put(value, issuerClass);
            }
        }
    }

    private static void handleValidators(OMElement configElem, TokenRequestDispatcherConfig conf) throws TrustException {
        Iterator validatorElems = configElem.getChildrenWithName(VALIDATOR);
        while (validatorElems.hasNext()) {
            OMElement element = (OMElement)validatorElems.next();
            String validatorClass = element.getAttributeValue(CLASS_ATTR);
            if (validatorClass == null) {
                throw new TrustException("missingClassName");
            }
            String isDefault = element.getAttributeValue(DEFAULT_ATTR);
            if (isDefault != null && "true".equalsIgnoreCase(isDefault)) {
                if (conf.defaultValidatorClassName == null) {
                    conf.defaultValidatorClassName = validatorClass;
                } else {
                    throw new TrustException("badDispatcherConfigMultipleDefaultValidators");
                }
            }
            TokenRequestDispatcherConfig.processConfiguration(element, conf, validatorClass);
            Iterator tokenTypes = element.getChildrenWithName(TOKEN_TYPE);
            while (tokenTypes.hasNext()) {
                OMElement type = (OMElement)tokenTypes.next();
                String value = type.getText();
                if (value == null || value.trim().length() == 0) {
                    throw new TrustException("invalidTokenTypeDefinition", new String[]{"Validator", validatorClass});
                }
                if (conf.validators == null) {
                    conf.validators = new Hashtable();
                }
                if (conf.validators.keySet().contains(value)) continue;
                conf.validators.put(value, validatorClass);
            }
        }
    }

    private static void handleRenewers(OMElement configElem, TokenRequestDispatcherConfig conf) throws TrustException {
        Iterator renewerElems = configElem.getChildrenWithName(RENEWER);
        while (renewerElems.hasNext()) {
            OMElement element = (OMElement)renewerElems.next();
            String renewerClass = element.getAttributeValue(CLASS_ATTR);
            if (renewerClass == null) {
                throw new TrustException("missingClassName");
            }
            String isDefault = element.getAttributeValue(DEFAULT_ATTR);
            if (isDefault != null && "true".equalsIgnoreCase(isDefault)) {
                if (conf.defaultRenewerClassName == null) {
                    conf.defaultRenewerClassName = renewerClass;
                } else {
                    throw new TrustException("badDispatcherConfigMultipleDefaultRenewers");
                }
            }
            TokenRequestDispatcherConfig.processConfiguration(element, conf, renewerClass);
            Iterator tokenTypes = element.getChildrenWithName(TOKEN_TYPE);
            while (tokenTypes.hasNext()) {
                OMElement type = (OMElement)tokenTypes.next();
                String value = type.getText();
                if (value == null || value.trim().length() == 0) {
                    throw new TrustException("invalidTokenTypeDefinition", new String[]{"Renewer", renewerClass});
                }
                if (conf.renewers == null) {
                    conf.renewers = new Hashtable();
                }
                if (conf.renewers.keySet().contains(value)) continue;
                conf.renewers.put(value, renewerClass);
            }
        }
    }

    private static void processConfiguration(OMElement element, TokenRequestDispatcherConfig conf, String implClass) {
        Iterator configs = element.getChildrenWithName(CONFIGURATION_ELEMENT);
        while (configs.hasNext()) {
            OMElement configEle = (OMElement)configs.next();
            String configType = configEle.getAttribute(new QName("type")).getAttributeValue().trim();
            if (configType.equalsIgnoreCase("file")) {
                String issuerConfigFile = configEle.getText();
                if (issuerConfigFile == null) continue;
                conf.configFiles.put(implClass, issuerConfigFile);
                continue;
            }
            if (configType.equalsIgnoreCase("element")) {
                conf.configElements.put(implClass, configEle);
                continue;
            }
            if (!configType.equalsIgnoreCase("parameter")) continue;
            conf.configParamNames.put(implClass, configEle.getText());
        }
    }

    public static TokenRequestDispatcherConfig load(String configFilePath) throws TrustException {
        OMXMLParserWrapper builder;
        try {
            FileInputStream fis = new FileInputStream(configFilePath);
            builder = OMXMLBuilderFactory.createOMBuilder((InputStream)fis);
        }
        catch (Exception e) {
            throw new TrustException("errorLoadingConfigFile", new String[]{configFilePath}, e);
        }
        return TokenRequestDispatcherConfig.load(builder.getDocumentElement());
    }

    public TokenIssuer getDefaultIssuerInstace() throws TrustException {
        if (this.defaultIssuerClassName != null) {
            try {
                return this.createIssuer(this.defaultIssuerClassName);
            }
            catch (Exception e) {
                throw new TrustException("cannotLoadClass", new String[]{this.defaultIssuerClassName}, e);
            }
        }
        return null;
    }

    public TokenCanceler getDefaultCancelerInstance() throws TrustException {
        if (this.defaultCancelerClassName != null) {
            try {
                return this.createCanceler(this.defaultCancelerClassName);
            }
            catch (Exception e) {
                throw new TrustException("cannotLoadClass", new String[]{this.defaultCancelerClassName}, e);
            }
        }
        return null;
    }

    public TokenValidator getDefaultValidatorInstance() throws TrustException {
        if (this.defaultValidatorClassName != null) {
            try {
                return this.createValidator(this.defaultValidatorClassName);
            }
            catch (Exception e) {
                throw new TrustException("cannotLoadClass", new String[]{this.defaultValidatorClassName}, e);
            }
        }
        return null;
    }

    public TokenRenewer getDefaultRenewerInstance() throws TrustException {
        if (this.defaultRenewerClassName != null) {
            try {
                return this.createRenewer(this.defaultRenewerClassName);
            }
            catch (Exception e) {
                throw new TrustException("cannotLoadClass", new String[]{this.defaultRenewerClassName}, e);
            }
        }
        return null;
    }

    public String getDefaultIssuerName() {
        return this.defaultIssuerClassName;
    }

    public TokenIssuer getIssuer(String tokenType) throws TrustException {
        String issuerClassName = null;
        if (this.issuers != null) {
            issuerClassName = (String)this.issuers.get(tokenType);
        }
        if (issuerClassName == null) {
            issuerClassName = this.defaultIssuerClassName;
        }
        try {
            return this.createIssuer(issuerClassName);
        }
        catch (Exception e) {
            throw new TrustException("cannotLoadClass", new String[]{issuerClassName}, e);
        }
    }

    public TokenValidator getValidator(String tokenType) throws TrustException {
        String validatorClassName = null;
        if (this.validators != null) {
            validatorClassName = (String)this.validators.get(tokenType);
        }
        if (validatorClassName == null) {
            validatorClassName = this.defaultValidatorClassName;
        }
        try {
            return this.createValidator(validatorClassName);
        }
        catch (Exception e) {
            throw new TrustException("cannotLoadClass", new String[]{validatorClassName}, e);
        }
    }

    public TokenRenewer getRenewer(String tokenType) throws TrustException {
        String renewerClassName = null;
        if (this.renewers != null) {
            renewerClassName = (String)this.renewers.get(tokenType);
        }
        if (renewerClassName == null) {
            renewerClassName = this.defaultRenewerClassName;
        }
        try {
            return this.createRenewer(renewerClassName);
        }
        catch (Exception e) {
            throw new TrustException("cannotLoadClass", new String[]{renewerClassName}, e);
        }
    }

    private TokenIssuer createIssuer(String issuerClassName) throws Exception {
        TokenIssuer issuer = (TokenIssuer)Loader.loadClass((ClassLoader)this.getClass().getClassLoader(), (String)issuerClassName).newInstance();
        issuer.setConfigurationElement((OMElement)this.configElements.get(issuerClassName));
        issuer.setConfigurationFile((String)this.configFiles.get(issuerClassName));
        issuer.setConfigurationParamName((String)this.configParamNames.get(issuerClassName));
        return issuer;
    }

    private TokenCanceler createCanceler(String cancelerClassName) throws Exception {
        TokenCanceler canceler = (TokenCanceler)Loader.loadClass((ClassLoader)this.getClass().getClassLoader(), (String)cancelerClassName).newInstance();
        canceler.setConfigurationElement((OMElement)this.configElements.get(cancelerClassName));
        canceler.setConfigurationFile((String)this.configFiles.get(cancelerClassName));
        canceler.setConfigurationParamName((String)this.configParamNames.get(cancelerClassName));
        return canceler;
    }

    private TokenValidator createValidator(String validatorClassName) throws Exception {
        TokenValidator validator = (TokenValidator)Loader.loadClass((ClassLoader)this.getClass().getClassLoader(), (String)validatorClassName).newInstance();
        validator.setConfigurationElement((OMElement)this.configElements.get(validatorClassName));
        validator.setConfigurationFile((String)this.configFiles.get(validatorClassName));
        validator.setConfigurationParamName((String)this.configParamNames.get(validatorClassName));
        return validator;
    }

    private TokenRenewer createRenewer(String renewerClassName) throws Exception {
        TokenRenewer renewer = (TokenRenewer)Loader.loadClass((ClassLoader)this.getClass().getClassLoader(), (String)renewerClassName).newInstance();
        renewer.setConfigurationElement((OMElement)this.configElements.get(renewerClassName));
        renewer.setConfigurationFile((String)this.configFiles.get(renewerClassName));
        renewer.setConfigurationParamName((String)this.configParamNames.get(renewerClassName));
        return renewer;
    }
}

