/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ExceptionMessageTest {
    private static final String ARCHIVER_NULL_MESSAGE = "Archiver name must not be null.";
    private static final String INPUTSTREAM_NULL_MESSAGE = "InputStream must not be null.";
    private static final String OUTPUTSTREAM_NULL_MESSAGE = "OutputStream must not be null.";

    ExceptionMessageTest() {
    }

    @Test
    void testMessageWhenArchiverNameIsNull_1() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream(null, System.in), (String)"Should raise an IllegalArgumentException.");
        Assertions.assertEquals((Object)ARCHIVER_NULL_MESSAGE, (Object)e.getMessage());
    }

    @Test
    void testMessageWhenArchiverNameIsNull_2() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveOutputStream(null, (OutputStream)System.out), (String)"Should raise an IllegalArgumentException.");
        Assertions.assertEquals((Object)ARCHIVER_NULL_MESSAGE, (Object)e.getMessage());
    }

    @Test
    void testMessageWhenInputStreamIsNull() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", null), (String)"Should raise an IllegalArgumentException.");
        Assertions.assertEquals((Object)INPUTSTREAM_NULL_MESSAGE, (Object)e.getMessage());
    }

    @Test
    void testMessageWhenOutputStreamIsNull() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", null), (String)"Should raise an IllegalArgumentException.");
        Assertions.assertEquals((Object)OUTPUTSTREAM_NULL_MESSAGE, (Object)e.getMessage());
    }
}

