/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ZstdUtilsTest {
    ZstdUtilsTest() {
    }

    @Test
    void testMatchesSkippableFrame() {
        byte[] data = new byte[]{0, 42, 77, 24};
        Assertions.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)4));
        for (int b = 80; b < 96; b = (int)((byte)(b + 1))) {
            data[0] = b;
            Assertions.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)4));
        }
        Assertions.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)3));
        Assertions.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)5));
    }

    @Test
    void testMatchesZstandardFrame() {
        byte[] data = new byte[]{40, -75, 47, -3};
        Assertions.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)3));
        Assertions.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)4));
        Assertions.assertTrue((boolean)ZstdUtils.matches((byte[])data, (int)5));
        data[3] = 48;
        Assertions.assertFalse((boolean)ZstdUtils.matches((byte[])data, (int)4));
    }
}

