/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.inbound;

import java.util.logging.Logger;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.invoker.AbstractInvoker;

public class MDBInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(MDBInvoker.class);
    private static final int MAX_ATTEMPTS = 5;
    private static final long RETRY_SLEEP = 2000L;
    private final MessageEndpointFactory endpointFactory;

    public MDBInvoker(MessageEndpointFactory factory) {
        this.endpointFactory = factory;
    }

    public MessageEndpoint getMessageEndpoint() {
        return this.createMessageEndpoint();
    }

    protected void releaseEndpoint(MessageEndpoint mep) {
        mep.release();
    }

    public Object getServiceObject(Exchange context) {
        return this.getMessageEndpoint();
    }

    public void releaseServiceObject(Exchange context, Object obj) {
        if (obj instanceof MessageEndpoint) {
            MessageEndpoint mep = (MessageEndpoint)obj;
            this.releaseEndpoint(mep);
        }
    }

    private MessageEndpoint createMessageEndpoint() {
        MessageEndpoint ep = null;
        for (int i = 0; i < 5; ++i) {
            try {
                ep = this.endpointFactory.createEndpoint(null);
                break;
            }
            catch (UnavailableException e) {
                LOG.fine("Target endpoint activation in progress.  Will retry.");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return ep;
    }
}

