/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageTimedWriter
extends ActiveMQScheduledComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PagingStoreImpl pagingStore;
    private final StorageManager storageManager;
    protected final List<PageEvent> pageEvents = new ArrayList<PageEvent>();
    protected volatile int pendingTasks = 0;
    protected final boolean syncNonTX;
    private final Semaphore writeCredits;
    private final int maxCredits;
    private static final AtomicIntegerFieldUpdater<PageTimedWriter> pendingTasksUpdater = AtomicIntegerFieldUpdater.newUpdater(PageTimedWriter.class, "pendingTasks");
    private final ReusableLatch pendingProcessings = new ReusableLatch(0);

    public boolean hasPendingIO() {
        return pendingTasksUpdater.get(this) > 0;
    }

    public PageTimedWriter(int writeCredits, StorageManager storageManager, PagingStoreImpl pagingStore, ScheduledExecutorService scheduledExecutor, Executor executor, boolean syncNonTX, long timeSync) {
        super(scheduledExecutor, executor, timeSync, TimeUnit.NANOSECONDS, true);
        this.pagingStore = pagingStore;
        this.storageManager = storageManager;
        this.syncNonTX = syncNonTX;
        this.writeCredits = new Semaphore(writeCredits);
        this.maxCredits = writeCredits;
    }

    public int getMaxCredits() {
        return this.maxCredits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PageTimedWriter pageTimedWriter = this;
        synchronized (pageTimedWriter) {
            super.stop();
        }
        try {
            this.pendingProcessings.await(30L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public void incrementTask() {
        pendingTasksUpdater.incrementAndGet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTask(OperationContext context, PagedMessage message, Transaction tx, RouteContextList listCtx, boolean useFlowControl) {
        logger.trace("Adding paged message {} to paged writer", (Object)message);
        int credits = Math.min(message.getEncodeSize() + 6, this.maxCredits);
        PageTimedWriter pageTimedWriter = this;
        synchronized (pageTimedWriter) {
            if (!this.isStarted()) {
                throw new IllegalStateException("PageWriter Service is stopped");
            }
            if (tx != null) {
                tx.delay();
            }
            boolean replicated = this.storageManager.isReplicated();
            PageEvent event = new PageEvent(context, message, tx, listCtx, credits, replicated, useFlowControl);
            context.storeLineUp();
            if (replicated) {
                context.replicationLineUp();
            }
            this.pageEvents.add(event);
            this.delay();
        }
        return credits;
    }

    public void flowControl(int credits) {
        if (credits > 0) {
            this.writeCredits.acquireUninterruptibly(credits);
        }
    }

    private synchronized PageEvent[] extractPendingEvents() {
        if (!this.isStarted()) {
            return null;
        }
        if (this.pageEvents.isEmpty()) {
            return null;
        }
        this.pendingProcessings.countUp();
        PageEvent[] pendingsWrites = new PageEvent[this.pageEvents.size()];
        pendingsWrites = this.pageEvents.toArray(pendingsWrites);
        this.pageEvents.clear();
        return pendingsWrites;
    }

    public void run() {
        if (!this.isStarted()) {
            return;
        }
        ArtemisCloseable closeable = this.storageManager.closeableReadLock(true);
        if (closeable == null) {
            logger.trace("Delaying PagedTimedWriter as it's currently locked");
            this.delay();
        } else {
            try {
                this.processMessages();
            }
            finally {
                closeable.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processMessages() {
        block25: {
            OperationContext beforeContext;
            PageEvent[] pendingEvents;
            block24: {
                boolean wasStarted;
                PageTimedWriter pageTimedWriter = this;
                synchronized (pageTimedWriter) {
                    pendingEvents = this.extractPendingEvents();
                    if (pendingEvents == null) {
                        return;
                    }
                    wasStarted = this.isStarted();
                }
                beforeContext = OperationContextImpl.getContext();
                if (!wasStarted) break block24;
                boolean requireSync = false;
                for (PageEvent event : pendingEvents) {
                    OperationContextImpl.setContext(event.context);
                    logger.trace("writing message {}", (Object)event.message);
                    this.pagingStore.directWritePage(event.message, false, event.replicated);
                    if (event.tx == null && !this.syncNonTX) continue;
                    requireSync = true;
                }
                if (requireSync) {
                    logger.trace("performing sync");
                    this.performSync();
                }
                for (PageEvent event : pendingEvents) {
                    if (event.tx == null) continue;
                    event.tx.delayDone();
                }
                logger.trace("Completing events");
                PageEvent[] pageEventArray = pendingEvents;
                int n = pageEventArray.length;
                for (int i = 0; i < n; ++i) {
                    PageEvent event;
                    event = pageEventArray[i];
                    event.context.done();
                }
            }
            try {
                for (PageEvent event : pendingEvents) {
                    pendingTasksUpdater.decrementAndGet(this);
                    if (!event.useFlowControl) continue;
                    this.writeCredits.release(event.credits);
                }
                OperationContextImpl.setContext(beforeContext);
            }
            catch (Throwable t) {
                logger.debug(t.getMessage(), t);
            }
            this.pendingProcessings.countDown();
            break block25;
            catch (Throwable e) {
                logger.warn("Captured Exception {}", (Object)e.getMessage(), (Object)e);
                ActiveMQIllegalStateException amqException = new ActiveMQIllegalStateException(e.getMessage());
                amqException.initCause(e);
                for (PageEvent event : pendingEvents) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Error processing Message {}, tx={} ", (Object)event.message, (Object)event.tx);
                    }
                    if (event.tx == null) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace("tx.markRollbackOnly on TX {}", (Object)event.tx.getID());
                    }
                    event.tx.markAsRollbackOnly((ActiveMQException)amqException);
                }
                this.executor.execute(() -> {
                    logger.trace("onError processing for callback", e);
                    for (PageEvent event : pendingEvents) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("onError {}, error={}", (Object)event.message, (Object)e.getMessage());
                        }
                        event.context.onError(ActiveMQExceptionType.IO_ERROR.getCode(), String.valueOf(e.getClass()) + " during ioSync for paging on " + String.valueOf(this.pagingStore.getStoreName()) + ": " + e.getMessage());
                    }
                });
                try {
                    for (PageEvent event : pendingEvents) {
                        pendingTasksUpdater.decrementAndGet(this);
                        if (!event.useFlowControl) continue;
                        this.writeCredits.release(event.credits);
                    }
                    OperationContextImpl.setContext(beforeContext);
                }
                catch (Throwable t) {
                    logger.debug(t.getMessage(), t);
                }
                this.pendingProcessings.countDown();
                catch (Throwable throwable) {
                    try {
                        for (PageEvent event : pendingEvents) {
                            pendingTasksUpdater.decrementAndGet(this);
                            if (!event.useFlowControl) continue;
                            this.writeCredits.release(event.credits);
                        }
                        OperationContextImpl.setContext(beforeContext);
                    }
                    catch (Throwable t) {
                        logger.debug(t.getMessage(), t);
                    }
                    this.pendingProcessings.countDown();
                    throw throwable;
                }
            }
        }
    }

    protected void performSync() throws Exception {
        this.pagingStore.ioSync();
    }

    public int getAvailablePermits() {
        return this.writeCredits.availablePermits();
    }

    public static class PageEvent {
        final boolean replicated;
        final PagedMessage message;
        final OperationContext context;
        final RouteContextList listCtx;
        final Transaction tx;
        final int credits;
        final boolean useFlowControl;

        PageEvent(OperationContext context, PagedMessage message, Transaction tx, RouteContextList listCtx, int credits, boolean replicated, boolean useFlowControl) {
            this.context = context;
            this.message = message;
            this.listCtx = listCtx;
            this.replicated = replicated;
            this.credits = credits;
            this.tx = tx;
            this.useFlowControl = useFlowControl;
        }
    }
}

