/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.api.core.management.BrokerConnectionControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.logs.AuditLogger;

public class BrokerConnectionControlImpl
extends AbstractControl
implements BrokerConnectionControl {
    private final BrokerConnection brokerConnection;

    public BrokerConnectionControlImpl(BrokerConnection brokerConnection, StorageManager storageManager) throws NotCompliantMBeanException {
        super(BrokerConnectionControl.class, storageManager);
        this.brokerConnection = brokerConnection;
    }

    public boolean isStarted() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isStarted((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            boolean bl = this.brokerConnection.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isConnected() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isConnected((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            boolean bl = this.brokerConnection.isConnected();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void start() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.startBrokerConnection((String)this.brokerConnection.getName());
        }
        this.clearIO();
        try {
            this.brokerConnection.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void stop() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.stopBrokerConnection((String)this.brokerConnection.getName());
        }
        this.clearIO();
        try {
            this.brokerConnection.stop();
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            String string = this.brokerConnection.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getUri() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getUri((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            String string = this.brokerConnection.getConfiguration().getUri();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getUser() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getUser((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            String string = this.brokerConnection.getConfiguration().getUser();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getProtocol() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getProtocol((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            String string = this.brokerConnection.getProtocol();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getRetryInterval() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRetryInterval((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            long l = this.brokerConnection.getConfiguration().getRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getReconnectAttempts() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getReconnectAttempts((Object)this.brokerConnection);
        }
        this.clearIO();
        try {
            int n = this.brokerConnection.getConfiguration().getReconnectAttempts();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(BrokerConnectionControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(BrokerConnectionControl.class);
    }
}

